#include "lapacknames.inc"
      SUBROUTINE CTPTRS( UPLO, TRANS, DIAG, N, NRHS, AP, B, LDB, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILATRS, LSAME, XERBLA
      USE LA_XTPTS2
*
*  -- LAPACK routine --
*     Based on LAPACK version 1.0, 2-29-92
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-18-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          DIAG, TRANS, UPLO
      INTEGER            INFO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        AP( * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CTPTRS solves a triangular system of the form
*
*     A * X = B,  A**T * X = B,  or  A**H * X = B,
*
*  where A is a triangular matrix of order N stored in packed format,
*  A**T is the transpose of A, A**H is the conjugate transpose of A,
*  and B is an N-by-NRHS matrix.  A check is made to verify that A is
*  nonsingular.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies whether the matrix A is upper or lower triangular.
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  TRANS   (input) CHARACTER*1
*          Specifies the form of the system of equations:
*          = 'N':  A * X = B     (No transpose)
*          = 'T':  A**T * X = B  (Transpose)
*          = 'C':  A**H * X = B  (Conjugate transpose)
*
*  DIAG    (input) CHARACTER*1
*          Specifies whether or not the matrix A is unit triangular.
*          = 'N':  Non-unit triangular
*          = 'U':  Unit triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  AP      (input) COMPLEX array, dimension (N*(N+1)/2)
*          The upper or lower triangular matrix A, packed columnwise in
*          a linear array.  The j-th column of A is stored in the array
*          AP as follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B.
*          On exit, if INFO = 0, the solution matrix X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0: if INFO = -k, the k-th argument had an illegal value
*          > 0: if INFO = k, the k-th diagonal element of A is zero,
*               indicating that the matrix is singular and the solution
*               X has not been computed.
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            NOTRAN, NOUNIT, TRANST, UPPER
      INTEGER            IDIAG, ITRANS, IUPLO, J, JB, JC, NB
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      UPPER = LSAME( UPLO, 'U' )
      NOTRAN = LSAME( TRANS, 'N' )
      TRANST = LSAME( TRANS, 'T' )
      NOUNIT = LSAME( DIAG, 'N' )
      IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( .NOT.NOTRAN .AND. .NOT.TRANST .AND.
     $         .NOT.LSAME( TRANS, 'C' ) ) THEN
         INFO = -2
      ELSE IF( .NOT.NOUNIT .AND. .NOT.LSAME( DIAG, 'U' ) ) THEN
         INFO = -3
      ELSE IF( N.LT.0 ) THEN
         INFO = -4
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -5
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -8
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'TPTRS', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Check for singularity.
*
      IF( NOUNIT ) THEN
         IF( UPPER ) THEN
            JC = 1
            DO 10 INFO = 1, N
               IF( AP( JC+INFO-1 ).EQ.CZERO )
     $            RETURN
               JC = JC + INFO
   10       CONTINUE
         ELSE
            JC = 1
            DO 20 INFO = 1, N
               IF( AP( JC ).EQ.CZERO )
     $            RETURN
               JC = JC + N - INFO + 1
   20       CONTINUE
         END IF
      END IF
      INFO = 0
*
*     Decode UPLO, TRANS, and DIAG
*
      IF( UPPER ) THEN
         IUPLO = 1
      ELSE
         IUPLO = 0
      END IF
      IF( NOTRAN ) THEN
         ITRANS = 0
      ELSE IF( TRANST ) THEN
         ITRANS = 1
      ELSE
         ITRANS = 2
      END IF
      IF( NOUNIT ) THEN
         IDIAG = 0
      ELSE
         IDIAG = 1
      END IF
*
*     Solve  A * X = B,  A**T * X = B,  or  A**H * X = B.
*
      IF( NRHS.EQ.1 ) THEN
         NB = 1
      ELSE
         NB = MAX( 1, ILATRS( 1, CPREFIX // 'TPTRS',
     $        UPLO // TRANS // DIAG, N, NRHS, -1, -1 ) )
      END IF
*
      IF( NB.GE.NRHS ) THEN
         CALL LA_TPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB )
      ELSE
#ifdef _OPENMP
!$OMP PARALLEL DO PRIVATE(J,JB)
!$OMP CNCALL
#endif
         DO 30 J = 1, NRHS, NB
            JB = MIN( NRHS-J+1, NB )
            CALL LA_TPTS2( IUPLO, ITRANS, IDIAG, N, JB, AP( 1 ),
     $                     B( 1, J ), LDB )
   30    CONTINUE
#ifdef _OPENMP
!$OMP END PARALLEL DO
#endif
      END IF
*
      RETURN
*
*     End of CTPTRS
*
      END
