#include "lapacknames.inc"
      SUBROUTINE CSYTS2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_AXPY, LA_DOTU, LA_SCAL, LA_SWAP
      USE LA_BLAS2, ONLY: LA_GEMV, LA_GERU
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IUPLO, LDA, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      COMPLEX(WP)        A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CSYTS2 solves a system of linear equations A*X = B with a complex
*  symmetric matrix A using the factorization A = U*D*U' or A = L*D*L'
*  computed by CSYTRF.  CSYTS2 can be called concurrently from CSYTRS.
*
*  Arguments
*  =========
*
*  IUPLO   (input) INTEGER
*          Specifies whether the details of the factorization are stored
*          as an upper or lower triangular matrix.
*          = 1:  Upper triangular (form is A = U*D*U')
*          = 0:  Lower triangular (form is A = L*D*L')
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  A       (input) COMPLEX array, dimension (LDA,N)
*          The block diagonal matrix D and the multipliers used to
*          obtain the factor U or L as computed by CSYTRF.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  IPIV    (input) INTEGER array, dimension (N)
*          Details of the interchanges and the block structure of D
*          as determined by CSYTRF.
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B for the system of
*          linear equations.
*          On exit, the solution matrix, X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            J, K, KP
      COMPLEX(WP)        AK, AKM1, AKM1K, BK, BKM1, DENOM, TEMP
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 .OR. NRHS.LE.0 )
     $   RETURN
*
      IF( NRHS.EQ.1 ) THEN
         J = 1
*
*        No vectorization across right hand sides if NRHS = 1.
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve A*X = B, where A = U*D*U'.
*
*           First solve U*D*X = B, overwriting B with X.
*
*           K is the main loop index, decreasing from N to 1 in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = N
   10       CONTINUE
*
*           If K < 1, exit from loop.
*
            IF( K.LT.1 )
     $         GO TO 20
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
*
*              Multiply by inv(U(K)), where U(K) is the transformation
*              stored in column K of A.
*
               CALL LA_AXPY( K-1, -B( K, J ), A( 1, K ), 1, B( 1, J ),
     $                       1 )
*
*              Multiply by the inverse of the diagonal block.
*
               B( K, J ) = B( K, J ) / A( K, K )
               K = K - 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Interchange rows K-1 and -IPIV(K).
*
               KP = -IPIV( K )
               TEMP = B( K-1, J )
               B( K-1, J ) = B( KP, J )
               B( KP, J ) = TEMP
*
*              Multiply by inv(U(K)), where U(K) is the transformation
*              stored in columns K-1 and K of A.
*
               CALL LA_AXPY( K-2, -B( K, J ), A( 1, K ), 1, B( 1, J ),
     $                       1 )
               CALL LA_AXPY( K-2, -B( K-1, J ), A( 1, K-1 ), 1,
     $                       B( 1, J ), 1 )
*
*              Multiply by the inverse of the diagonal block.
*
               AKM1K = A( K-1, K )
               AKM1 = A( K-1, K-1 ) / AKM1K
               AK = A( K, K ) / AKM1K
               DENOM = AKM1*AK - CONE
               BKM1 = B( K-1, J ) / AKM1K
               BK = B( K, J ) / AKM1K
               B( K-1, J ) = ( AK*BKM1-BK ) / DENOM
               B( K, J ) = ( AKM1*BK-BKM1 ) / DENOM
               K = K - 2
            END IF
*
            GO TO 10
   20       CONTINUE
*
*           Next solve U'*X = B, overwriting B with X.
*
*           K is the main loop index, increasing from 1 to N in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = 1
   30       CONTINUE
*
*           If K > N, exit from loop.
*
            IF( K.GT.N )
     $         GO TO 40
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Multiply by inv(U'(K)), where U(K) is the transformation
*              stored in column K of A.
*
               B( K, J ) = B( K, J ) - LA_DOTU( K-1, A( 1, K ), 1,
     $                     B( 1, J ), 1 )
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
               K = K + 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Multiply by inv(U'(K+1)), where U(K+1) is the
*              transformation stored in columns K and K+1 of A.
*
               B( K, J ) = B( K, J ) - LA_DOTU( K-1, A( 1, K ), 1,
     $                     B( 1, J ), 1 )
               B( K+1, J ) = B( K+1, J ) - LA_DOTU( K-1, A( 1, K+1 ), 1,
     $                       B( 1, J ), 1 )
*
*              Interchange rows K and -IPIV(K).
*
               KP = -IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
               K = K + 2
            END IF
*
            GO TO 30
   40       CONTINUE
*
         ELSE
*
*           Solve A*X = B, where A = L*D*L'.
*
*           First solve L*D*X = B, overwriting B with X.
*
*           K is the main loop index, increasing from 1 to N in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = 1
   50       CONTINUE
*
*           If K > N, exit from loop.
*
            IF( K.GT.N )
     $         GO TO 60
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
*
*              Multiply by inv(L(K)), where L(K) is the transformation
*              stored in column K of A.
*
               IF( K.LT.N )
     $            CALL LA_AXPY( N-K, -B( K, J ), A( K+1, K ), 1,
     $                          B( K+1, J ), 1 )
*
*              Multiply by the inverse of the diagonal block.
*
               B( K, J ) = B( K, J ) / A( K, K )
               K = K + 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Interchange rows K+1 and -IPIV(K).
*
               KP = -IPIV( K )
               TEMP = B( K+1, J )
               B( K+1, J ) = B( KP, J )
               B( KP, J ) = TEMP
*
*              Multiply by inv(L(K)), where L(K) is the transformation
*              stored in columns K and K+1 of A.
*
               IF( K.LT.N-1 ) THEN
                  CALL LA_AXPY( N-K-1, -B( K, J ), A( K+2, K ), 1,
     $                          B( K+2, J ), 1 )
                  CALL LA_AXPY( N-K-1, -B( K+1, J ), A( K+2, K+1 ), 1,
     $                          B( K+2, J ), 1 )
               END IF
*
*              Multiply by the inverse of the diagonal block.
*
               AKM1K = A( K+1, K )
               AKM1 = A( K, K ) / AKM1K
               AK = A( K+1, K+1 ) / AKM1K
               DENOM = AKM1*AK - CONE
               BKM1 = B( K, J ) / AKM1K
               BK = B( K+1, J ) / AKM1K
               B( K, J ) = ( AK*BKM1-BK ) / DENOM
               B( K+1, J ) = ( AKM1*BK-BKM1 ) / DENOM
               K = K + 2
            END IF
*
            GO TO 50
   60       CONTINUE
*
*           Next solve L'*X = B, overwriting B with X.
*
*           K is the main loop index, decreasing from N to 1 in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = N
   70       CONTINUE
*
*           If K < 1, exit from loop.
*
            IF( K.LT.1 )
     $         GO TO 80
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Multiply by inv(L'(K)), where L(K) is the transformation
*              stored in column K of A.
*
               IF( K.LT.N )
     $            B( K, J ) = B( K, J ) - LA_DOTU( N-K, A( K+1, K ), 1,
     $                        B( K+1, J ), 1 )
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
               K = K - 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Multiply by inv(L'(K-1)), where L(K-1) is the
*              transformation stored in columns K-1 and K of A.
*
               IF( K.LT.N ) THEN
                  B( K, J ) = B( K, J ) - LA_DOTU( N-K, A( K+1, K ), 1,
     $                        B( K+1, J ), 1 )
                  B( K-1, J ) = B( K-1, J ) - LA_DOTU( N-K,
     $                          A( K+1, K-1 ), 1, B( K+1, J ), 1 )
               END IF
*
*              Interchange rows K and -IPIV(K).
*
               KP = -IPIV( K )
               TEMP = B( K, J )
               B( K, J ) = B( KP, J )
               B( KP, J ) = TEMP
               K = K - 2
            END IF
*
            GO TO 70
   80       CONTINUE
         END IF
      ELSE
*
*        Vectorize across right hand sides if NRHS > 1 (this is the
*        original code in CSYTRS).
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve A*X = B, where A = U*D*U'.
*
*           First solve U*D*X = B, overwriting B with X.
*
*           K is the main loop index, decreasing from N to 1 in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = N
   90       CONTINUE
*
*           If K < 1, exit from loop.
*
            IF( K.LT.1 )
     $         GO TO 110
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
*
*              Multiply by inv(U(K)), where U(K) is the transformation
*              stored in column K of A.
*
               CALL LA_GERU( K-1, NRHS, -CONE, A( 1, K ), 1, B( K, 1 ),
     $                       LDB, B( 1, 1 ), LDB )
*
*              Multiply by the inverse of the diagonal block.
*
               CALL LA_SCAL( NRHS, CONE / A( K, K ), B( K, 1 ), LDB )
               K = K - 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Interchange rows K-1 and -IPIV(K).
*
               KP = -IPIV( K )
               IF( KP.NE.K-1 )
     $            CALL LA_SWAP( NRHS, B( K-1, 1 ), LDB, B( KP, 1 ),
     $                          LDB )
*
*              Multiply by inv(U(K)), where U(K) is the transformation
*              stored in columns K-1 and K of A.
*
               CALL LA_GERU( K-2, NRHS, -CONE, A( 1, K ), 1, B( K, 1 ),
     $                       LDB, B( 1, 1 ), LDB )
               CALL LA_GERU( K-2, NRHS, -CONE, A( 1, K-1 ), 1,
     $                       B( K-1, 1 ), LDB, B( 1, 1 ), LDB )
*
*              Multiply by the inverse of the diagonal block.
*
               AKM1K = A( K-1, K )
               AKM1 = A( K-1, K-1 ) / AKM1K
               AK = A( K, K ) / AKM1K
               DENOM = AKM1*AK - CONE
               DO 100 J = 1, NRHS
                  BKM1 = B( K-1, J ) / AKM1K
                  BK = B( K, J ) / AKM1K
                  B( K-1, J ) = ( AK*BKM1-BK ) / DENOM
                  B( K, J ) = ( AKM1*BK-BKM1 ) / DENOM
  100          CONTINUE
               K = K - 2
            END IF
*
            GO TO 90
  110       CONTINUE
*
*           Next solve U'*X = B, overwriting B with X.
*
*           K is the main loop index, increasing from 1 to N in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = 1
  120       CONTINUE
*
*           If K > N, exit from loop.
*
            IF( K.GT.N )
     $         GO TO 130
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Multiply by inv(U'(K)), where U(K) is the transformation
*              stored in column K of A.
*
               IF( K.GT.1 ) THEN
                  CALL LA_GEMV( 'Transpose', K-1, NRHS, -CONE,
     $                          B( 1, 1 ), LDB, A( 1, K ), 1, CONE,
     $                          B( K, 1 ), LDB )
               END IF
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
               K = K + 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Multiply by inv(U'(K+1)), where U(K+1) is the
*              transformation stored in columns K and K+1 of A.
*
               IF( K.GT.1 ) THEN
                  CALL LA_GEMV( 'Transpose', K-1, NRHS, -CONE,
     $                          B( 1, 1 ), LDB, A( 1, K ), 1, CONE,
     $                          B( K, 1 ), LDB )
                  CALL LA_GEMV( 'Transpose', K-1, NRHS, -CONE,
     $                          B( 1, 1 ), LDB, A( 1, K+1 ), 1, CONE,
     $                          B( K+1, 1 ), LDB )
               END IF
*
*              Interchange rows K and -IPIV(K).
*
               KP = -IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
               K = K + 2
            END IF
*
            GO TO 120
  130       CONTINUE
*
         ELSE
*
*           Solve A*X = B, where A = L*D*L'.
*
*           First solve L*D*X = B, overwriting B with X.
*
*           K is the main loop index, increasing from 1 to N in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = 1
  140       CONTINUE
*
*           If K > N, exit from loop.
*
            IF( K.GT.N )
     $         GO TO 160
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
*
*              Multiply by inv(L(K)), where L(K) is the transformation
*              stored in column K of A.
*
               IF( K.LT.N )
     $            CALL LA_GERU( N-K, NRHS, -CONE, A( K+1, K ), 1,
     $                          B( K, 1 ), LDB, B( K+1, 1 ), LDB )
*
*              Multiply by the inverse of the diagonal block.
*
               CALL LA_SCAL( NRHS, CONE / A( K, K ), B( K, 1 ), LDB )
               K = K + 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Interchange rows K+1 and -IPIV(K).
*
               KP = -IPIV( K )
               IF( KP.NE.K+1 )
     $            CALL LA_SWAP( NRHS, B( K+1, 1 ), LDB, B( KP, 1 ),
     $                          LDB )
*
*              Multiply by inv(L(K)), where L(K) is the transformation
*              stored in columns K and K+1 of A.
*
               IF( K.LT.N-1 ) THEN
                  CALL LA_GERU( N-K-1, NRHS, -CONE, A( K+2, K ), 1,
     $                          B( K, 1 ), LDB, B( K+2, 1 ), LDB )
                  CALL LA_GERU( N-K-1, NRHS, -CONE, A( K+2, K+1 ), 1,
     $                          B( K+1, 1 ), LDB, B( K+2, 1 ), LDB )
               END IF
*
*              Multiply by the inverse of the diagonal block.
*
               AKM1K = A( K+1, K )
               AKM1 = A( K, K ) / AKM1K
               AK = A( K+1, K+1 ) / AKM1K
               DENOM = AKM1*AK - CONE
               DO 150 J = 1, NRHS
                  BKM1 = B( K, J ) / AKM1K
                  BK = B( K+1, J ) / AKM1K
                  B( K, J ) = ( AK*BKM1-BK ) / DENOM
                  B( K+1, J ) = ( AKM1*BK-BKM1 ) / DENOM
  150          CONTINUE
               K = K + 2
            END IF
*
            GO TO 140
  160       CONTINUE
*
*           Next solve L'*X = B, overwriting B with X.
*
*           K is the main loop index, decreasing from N to 1 in steps of
*           1 or 2, depending on the size of the diagonal blocks.
*
            K = N
  170       CONTINUE
*
*           If K < 1, exit from loop.
*
            IF( K.LT.1 )
     $         GO TO 180
*
            IF( IPIV( K ).GT.0 ) THEN
*
*              1 x 1 diagonal block
*
*              Multiply by inv(L'(K)), where L(K) is the transformation
*              stored in column K of A.
*
               IF( K.LT.N ) THEN
                  CALL LA_GEMV( 'Transpose', N-K, NRHS, -CONE,
     $                          B( K+1, 1 ), LDB, A( K+1, K ), 1, CONE,
     $                          B( K, 1 ), LDB )
               END IF
*
*              Interchange rows K and IPIV(K).
*
               KP = IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
               K = K - 1
            ELSE
*
*              2 x 2 diagonal block
*
*              Multiply by inv(L'(K-1)), where L(K-1) is the
*              transformation stored in columns K-1 and K of A.
*
               IF( K.LT.N ) THEN
                  CALL LA_GEMV( 'Transpose', N-K, NRHS, -CONE,
     $                          B( K+1, 1 ), LDB, A( K+1, K ), 1, CONE,
     $                          B( K, 1 ), LDB )
                  CALL LA_GEMV( 'Transpose', N-K, NRHS, -CONE,
     $                          B( K+1, 1 ), LDB, A( K+1, K-1 ), 1,
     $                          CONE, B( K-1, 1 ), LDB )
               END IF
*
*              Interchange rows K and -IPIV(K).
*
               KP = -IPIV( K )
               IF( KP.NE.K )
     $            CALL LA_SWAP( NRHS, B( K, 1 ), LDB, B( KP, 1 ), LDB )
               K = K - 2
            END IF
*
            GO TO 170
  180       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of CSYTS2
*
      END
