#include "lapacknames.inc"
      SUBROUTINE CSRSCL( N, SA, SX, INCX )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_SCAL
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     04-25-02:  LAPACK 3E version, assume you don't need to prescale
*                more than once (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, N
      REAL(WP)           SA
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        SX( * )
*     ..
*
*  Purpose
*  =======
*
*  CSRSCL multiplies an n-element complex vector x by the real scalar
*  1/a.  This is done without overflow or underflow as long as
*  the final result x/a does not overflow or underflow.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of components of the vector x.
*
*  SA      (input) REAL
*          The scalar a which is used to divide each component of x.
*          SA must be >= 0, or the subroutine will divide by zero.
*
*  SX      (input/output) COMPLEX array, dimension
*                         (1+(N-1)*abs(INCX))
*          The n-element vector x.
*
*  INCX    (input) INTEGER
*          The increment between successive values of the vector SX.
*          > 0:  SX(1) = X(1) and SX(1+(i-1)*INCX) = x(i),     1< i<= n
*
* =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           DEN, DEN1, MUL
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 )
     $   RETURN
*
*     Initialize the denominator to SA.
*
      DEN = SA
      DEN1 = ABS( SA )
*
      IF( DEN1.GT.BIGNUM ) THEN
*
*        Pre-multiply X by SMLNUM if SA is very large.
*
         CALL LA_SCAL( N, SMLNUM, SX(1), INCX )
         DEN = DEN*SMLNUM
*
      ELSE IF( DEN1.LT.SMLNUM ) THEN
*
*        Pre-multiply X by BIGNUM if SA is very small.
*
         CALL LA_SCAL( N, BIGNUM, SX(1), INCX )
         DEN = DEN*BIGNUM
      END IF
*
*     Multiply X by ONE / DEN and return.
*
      MUL = ONE / DEN
      CALL LA_SCAL( N, MUL, SX(1), INCX )
*
      RETURN
*
*     End of CSRSCL
*
      END
