#include "lapacknames.inc"
      SUBROUTINE CRSCL( N, SA, SX, INCX )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_SCAL
*
*  -- LAPACK auxiliary routine --
*     E. Anderson
*     April 25, 2002
*     09-05-02:  Fix for unsafe complex divide (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, N
      COMPLEX(WP)        SA
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        SX( * )
*     ..
*
*  Purpose
*  =======
*
*  CRSCL multiplies an n-element complex vector x by the complex scalar
*  1/a.  This is done without overflow or underflow as long as
*  the final result x/a does not overflow or underflow.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of components of the vector x.
*
*  SA      (input) COMPLEX
*          The scalar a which is used to divide each component of x.
*          |SA| must be >= 0, or the subroutine will divide by zero.
*
*  SX      (input/output) COMPLEX array, dimension
*                         (1+(N-1)*abs(INCX))
*          The n-element vector x.
*
*  INCX    (input) INTEGER
*          The increment between successive values of the vector SX.
*          > 0:  SX(1) = X(1) and SX(1+(i-1)*INCX) = x(i),     1< i<= n
*
* =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           DEN1, SCL
      COMPLEX(WP)        DEN, CSCL
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, AIMAG, REAL
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 )
     $   RETURN
*
*     Initialize the denominator to SA.
*
      DEN = SA
      DEN1 = MAX( ABS( REAL( SA ) ), ABS( AIMAG( SA ) ) )
*
      IF( DEN1.GT.RTMAX ) THEN
*
*        Pre-multiply X by a small scalar if SA is very large.
*
         IF( DEN1.LT.BIGNUM ) THEN
            SCL = ONE / DEN1
         ELSE
            SCL = SMLNUM
         END IF
         CALL LA_SCAL( N, SCL, SX(1), INCX )
         DEN = SCL*DEN
*
      ELSE IF( DEN1.LT.RTMIN ) THEN
*
*        Pre-multiply X by a large scalar if SA is very small.
*
         IF( DEN1.GT.SMLNUM ) THEN
            SCL = ONE / DEN1
         ELSE
            SCL = BIGNUM
         END IF
         CALL LA_SCAL( N, SCL, SX(1), INCX )
         DEN = SCL*DEN
      END IF
*
*     Multiply X by ONE / DEN and return.
*
      CSCL = CONE / DEN
      CALL LA_SCAL( N, CSCL, SX(1), INCX )
*
      RETURN
*
*     End of CRSCL
*
      END
