#include "lapacknames.inc"
      SUBROUTINE CPPTRS( UPLO, N, NRHS, AP, B, LDB, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILATRS, LSAME, XERBLA
      USE LA_XPPTS2
*
*  -- LAPACK routine (preliminary version) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     August 6, 1991
*     12-11-92:  call CPPTS2 to allow parallelism  (eca)
*     04-17-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            INFO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        AP( * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CPPTRS solves a system of linear equations A*X = B with a Hermitian
*  positive definite matrix A in packed storage using the Cholesky
*  factorization A = U'*U or A = L*L' computed by CPPTRF.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies whether the factor stored in A is upper or lower
*          triangular.
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  AP      (input) COMPLEX array, dimension (N*(N+1)/2)
*          The triangular factor U or L from the Cholesky factorization
*          A = U'*U or A = L*L', packed columnwise in a linear array.
*          The j-th column of U or L is stored in the array AP as
*          follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the right hand side vectors B for the system of
*          linear equations.
*          On exit, the solution vectors, X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0: if INFO = -k, the k-th argument had an illegal value
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            UPPER
      INTEGER            IUPLO, J, JB, NB
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      UPPER = LSAME( UPLO, 'U' )
      IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -6
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'PPTRS', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 .OR. NRHS.EQ.0 )
     $   RETURN
*
*     Decode UPLO
*
      IF( UPPER ) THEN
         IUPLO = 1
      ELSE
         IUPLO = 0
      END IF
*
*     Determine the number of right hand sides to solve at a time.
*
      IF( NRHS.EQ.1 ) THEN
         NB = 1
      ELSE
         NB = MAX( 1, ILATRS( 1, CPREFIX // 'PPTRS', UPLO, N, NRHS,
     $             -1, -1 ) )
      END IF
*
      IF( NB.GE.NRHS ) THEN
         CALL LA_PPTS2( IUPLO, N, NRHS, AP, B, LDB )
      ELSE
#ifdef _OPENMP
!$OMP PARALLEL DO PRIVATE(J,JB)
!$OMP CNCALL
#endif
         DO 10 J = 1, NRHS, NB
            JB = MIN( NRHS-J+1, NB )
            CALL LA_PPTS2( IUPLO, N, JB, AP(1), B(1,J), LDB )
   10    CONTINUE
#ifdef _OPENMP
!$OMP END PARALLEL DO
#endif
      END IF
*
      RETURN
*
*     End of CPPTRS
*
      END
