#include "lapacknames.inc"
      SUBROUTINE CLASWP( N, A, LDA, K1, K2, IPIV, INCX )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_SWAP
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     04-10-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, K1, K2, LDA, N
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      COMPLEX(WP)        A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  CLASWP performs a series of row interchanges on the matrix A.
*  One row interchange is initiated for each of rows K1 through K2 of A.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of columns of the matrix A.
*
*  A       (input/output) COMPLEX array, dimension (LDA,N)
*          On entry, the matrix of column dimension N to which the row
*          interchanges will be applied.
*          On exit, the permuted matrix.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*
*  K1      (input) INTEGER
*          The first element of IPIV for which a row interchange will
*          be done.
*
*  K2      (input) INTEGER
*          The last element of IPIV for which a row interchange will
*          be done.
*
*  IPIV    (input) INTEGER array, dimension (M*abs(INCX))
*          The vector of pivot indices.  Only the elements in positions
*          K1 through K2 of IPIV are accessed.
*          IPIV(K) = L implies rows K and L are to be interchanged.
*
*  INCX    (input) INTEGER
*          The increment between successive values of IPIV.  If IPIV
*          is negative, the pivots are applied in reverse order.
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            NB
      PARAMETER          ( NB = 32 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, I1, I2, INC, IP, IX, IX0, J, J2
*     ..
*     .. Executable Statements ..
*
*     Interchange row I with row IPIV(I) for each of rows K1 through K2.
*
      IF( INCX.GE.0 ) THEN
         IX0 = K1
         I1 = K1
         I2 = K2
         INC = 1
      ELSE
         IX0 = 1 + ( 1-K2 )*INCX
         I1 = K2
         I2 = K1
         INC = -1
      END IF
*
*     Apply the pivots to a block of NB columns at a time.
*
      DO 30 J = 1, N, NB
         J2 = MIN( J+NB-1, N )
         IX = IX0
         DO 20 I = I1, I2, INC
            IP = IPIV( IX )
            IF( IP.NE.I )
     $         CALL LA_SWAP( J2-J+1, A( I, J ), LDA, A( IP, J ), LDA )
            IX = IX + INCX
   20    CONTINUE
   30 CONTINUE
*
      RETURN
*
*     End of CLASWP
*
      END
