#include "lapacknames.inc"
      SUBROUTINE CLARTG( F, G, CS, SN, R )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LASGN
*
*  -- LAPACK auxiliary routine (version 2.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     1-23-02:  Make consistent with new BLAS standard (eca)
*     05-30-02:  LAPACK 3E version (eca)
*     09-05-02:  Avoid complex/real divisions (eca)
*
*     .. Scalar Arguments ..
      REAL(WP)           CS
      COMPLEX(WP)        F, G, R, SN
*     ..
*
*  Purpose
*  =======
*
*  CLARTG generates a plane rotation so that
*
*     [  CS         SN  ] . [ F ]  =  [ R ]
*     [ -conjg(SN)  CS  ]   [ G ]     [ 0 ]
*
*  where CS is real and CS**2 + |SN|**2 = 1.
*
*  The mathematical formulas used for CS and SN are
*
*     sgn(x) = {  x / |x|,   x != 0
*              {  1,         x = 0
*
*     R = sgn(F) * sqrt(|F|**2 + |G|**2)
*
*     CS = |F| / sqrt(|F|**2 + |G|**2)
*
*     SN = sgn(F) * conjg(G) / sqrt(|F|**2 + |G|**2)
*
*  When F and G are real, the formulas simplify to CS = F/R and
*  SN = G/R, and the returned values of CS, SN, and R should be
*  identical to those returned by SLARTG.
*
*  The algorithm used to compute these quantities incorporates scaling
*  to avoid overflow or underflow in computing the square root of the
*  sum of squares.
*
*  Arguments
*  =========
*
*  F       (input) COMPLEX
*          The first component of vector to be rotated.
*
*  G       (input) COMPLEX
*          The second component of vector to be rotated.
*
*  CS      (output) REAL
*          The cosine of the rotation.
*
*  SN      (output) COMPLEX
*          The sine of the rotation.
*
*  R       (output) COMPLEX
*          The nonzero component of the rotated vector.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           D, F1, F2, FN, G1, G2, GN, SFMAX2, SFMIN2
      COMPLEX(WP)        FS, FZ, GS, T
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, AIMAG, CONJG, MAX, REAL, SIGN, SQRT
*     ..
*     .. Statement Functions ..
      REAL(WP)           ABS1, ABSSQ
*     ..
*     .. Statement Function definitions ..
      ABS1( T ) = ABS(REAL(T))/2 + ABS(AIMAG(T))/2
      ABSSQ( T ) = REAL( T )**2 + AIMAG( T )**2
*     ..
*     .. Executable Statements ..
*
      SFMIN2 = TWO*SAFMIN
      SFMAX2 = HALF*SAFMAX
      IF( G.EQ.CZERO ) THEN
         CS = ONE
         SN = CZERO
         R = F
      ELSE IF( F.EQ.CZERO ) THEN
         CS = ZERO
         G1 = MAX( ABS(REAL(G)), ABS(AIMAG(G)) )
         IF( G1.GT.SFMIN2 .AND. G1.LT.SFMAX2 ) THEN
            G1 = ABS( G )
            GN = ONE / G1
            SN = CONJG( G )*GN
            R = G1
         ELSE
            SN = LA_LASGN( CONJG( G ) )
            R = G*SN
         END IF
      ELSE
         F1 = ABS1( F )
         G1 = ABS1( G )
         IF( F1.GE.G1 ) THEN
*
*           Scale by F1 or something close to that
*
            F1 = MIN( SAFMAX, MAX( F1, SAFMIN ) )
            FN = ONE / F1
            FS = F*FN
            F2 = ONE / ABSSQ( FS )
            GS = G*FN
            G2 = ABSSQ( GS )
            D = SQRT( ONE + G2*F2 )
            CS = ONE / D
            SN = CONJG( GS )*FS*( CS*F2 )
            R = F*D
         ELSE
*
*           Scale by G1
*
            G1 = MIN( SAFMAX, MAX( G1, SAFMIN ) )
            GN = ONE / G1
            FS = F*GN
            F2 = ABSSQ( FS )
            GS = G*GN
            G2 = ABSSQ( GS )
            IF( F1.GT.SFMIN2 .AND. F1.LT.SFMAX2 ) THEN
               D = G1*SQRT( F2 + G2 )
               F1 = ABS( F )
               FN = ONE / F1
               FZ = F*FN
               CS = F1 / D
               SN = ( CONJG( G ) / D )*FZ
               R = FZ*D
            ELSE
*
*              Avoid ABS(F) if F is too small or too large.
*
               D = SQRT( F2 + G2 )
               F1 = SQRT( F2 )
               FZ = LA_LASGN( FS )
               CS = F1 / D
               SN = ( CONJG( GS ) / D )*FZ
               R = FZ*( G1*D )
            END IF
         END IF
      END IF
      RETURN
*
*     End of CLARTG
*
      END
