#include "lapacknames.inc"
      SUBROUTINE CLARRV( N, D, L, ISPLIT, M, W, IBLOCK, INDEXW, GERSCH,
     $                   TOL, Z, LDZ, ISUPPZ, WORK, IWORK, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LASET
      USE LA_BLAS1, ONLY: LA_AXPY, LA_COPY, LA_DOTU, LA_NRM2, LA_SCAL
      USE LA_LAPACK, ONLY: LA_STEIN
      USE LA_XLARRX, ONLY: LA_LAR1V, LA_LARRB, LA_LARRF
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     06-11-02:  LAPACK 3E version (eca)
*     08-28-02:  Update to match Inderjit's latest SLARRV (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDZ, M, N
      REAL(WP)           TOL
*     ..
*     .. Array Arguments ..
      INTEGER            IBLOCK( * ), INDEXW( * ), ISPLIT( * ),
     $                   ISUPPZ( * ), IWORK( * )
      REAL(WP)           D( * ), GERSCH( * ), L( * ), W( * ), WORK( * )
      COMPLEX(WP)        Z( LDZ, * )
*     ..
*
*  Purpose
*  =======
*
*  CLARRV computes the eigenvectors of the tridiagonal matrix
*  T = L D L^T given L, D and the eigenvalues of L D L^T.
*  The input eigenvalues should have high relative accuracy with
*  respect to the entries of L and D. The desired accuracy of the
*  eigenvectors can be specified by the input parameter TOL.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix.  N >= 0.
*
*  D       (input/output) REAL array, dimension (N)
*          On entry, the N diagonal elements of the diagonal matrix D.
*          On exit, D may be overwritten.
*
*  L       (input/output) REAL array, dimension (N)
*          On entry, the (N-1) subdiagonal elements of the unit
*          bidiagonal matrix L are in elements 1 to N-1 of L. L(N) need
*          not be set on input, but is used internally as workspace.
*          On exit, L is overwritten.
*
*  ISPLIT  (input) INTEGER array, dimension (N)
*          The splitting points, at which T breaks up into blocks.
*          The first block consists of rows/columns 1 to
*          ISPLIT( 1 ), the second of rows/columns ISPLIT( 1 )+1
*          through ISPLIT( 2 ), etc.
*
*  M       (input) INTEGER
*          The total number of input eigenvalues.  0 <= M <= N.
*
*  W       (input) REAL array, dimension (N)
*          The first M elements of W contain the eigenvalues for
*          which eigenvectors are to be computed.  The eigenvalues
*          should be grouped by split-off block and ordered from
*          smallest to largest within the block ( The output array
*          W from SLARRE is expected here ).
*          Errors in W must be bounded by TOL (see above).
*
*  IBLOCK  (input) INTEGER array, dimension (N)
*          The indices of the blocks (submatrices) associated with the
*          corresponding eigenvalues in W; IBLOCK(i)=1 if eigenvalue
*          W(i) belongs to the first block from the top, =2 if W(i)
*          belongs to the second block, etc.
*
*  INDEXW  (input) INTEGER array, dimension (N)
*          The indices of the eigenvalues within each block (submatrix);
*          for example, INDEXW(i)= 10 and IBLOCK(i)=2 imply that the
*          i-th eigenvalue W(i) is the 10-th eigenvalue in the second
*          block.
*
*  GERSCH  (input) REAL array, dimension (2*N)
*          The N Gerschgorin intervals (the i-th Gerschgorin interval
*          is (GERSCH(2*i-1), GERSCH(2*i)).
*
*  TOL     (input) REAL
*          The absolute error tolerance for the eigenvectors.
*          The eigenvectors output have residual norms
*          bounded by TOL, and the dot products between different
*          eigenvectors are bounded by TOL. TOL must be at least
*          N*ULP*|T|, where ULP is the machine precision and |T| is
*          the 1-norm of the tridiagonal matrix.
*
*  Z       (output) COMPLEX array, dimension (LDZ, max(1,M) )
*          If INFO = 0, the first M columns of Z contain the
*          orthonormal eigenvectors of the matrix T
*          corresponding to the input eigenvalues, with the i-th
*          column of Z holding the eigenvector associated with W(i).
*          Note: the user must ensure that at least max(1,M) columns are
*          supplied in the array Z.
*
*  LDZ     (input) INTEGER
*          The leading dimension of the array Z.  LDZ >= max(1,N).
*
*  ISUPPZ  (output) INTEGER ARRAY, dimension ( 2*max(1,M) )
*          The support of the eigenvectors in Z, i.e., the indices
*          indicating the nonzero elements in Z. The I-th eigenvector
*          is nonzero only in elements ISUPPZ( 2*I-1 ) through
*          ISUPPZ( 2*I ).
*
*  WORK    (workspace) REAL array, dimension (13*N)
*
*  IWORK   (workspace) INTEGER array, dimension (7*N)
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*          > 0:  if INFO = 1, internal error in SLARRB
*                if INFO = 2, internal error in CSTEIN
*
*  Further Details
*  ===============
*
*  Based on contributions by
*     Inderjit Dhillon, University of Texas, Austin, USA
*     Osni Marques, LBNL/NERSC, USA
*     Ken Stanley, Computer Science Division, University of
*       California at Berkeley, USA
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            MAXITR, MGSSIZ
      PARAMETER          ( MAXITR = 8, MGSSIZ = 1 )
      REAL(WP)           RELTHR, TSTTOL
      PARAMETER          ( RELTHR = 0.01_WP, TSTTOL = 100.0_WP )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOMGS
      INTEGER            I, IBEGIN, IEND, IINDC1, IINDC2, IINDR, IINDWK,
     $                   IINFO, IM, IN, INDERR, INDGAP, INDIN1, INDIN2,
     $                   INDLD, INDLLD, INDWRK, ITER, ITMP1, ITMP2, J,
     $                   JBLK, K, KTOT, NCLUS, NDEPTH, NDONE, NEWCLS,
     $                   NEWFRS, NEWFTT, NEWLST, NEWSIZ, OLDCLS, OLDFST,
     $                   OLDIEN, OLDLST, OLDNCL, P, PARITY, Q, WBEGIN,
     $                   WEND, ZFROM, ZTO
      REAL(WP)           GAP, LAMBDA, MGSTOL, MINGMA, MINRGP, NRMINV,
     $                   RELGAP, RELTOL, RESID, RQCORR, SIGMA, TMP, ZTZ
      COMPLEX(WP)        CTMP1
*     ..
*     .. Local Arrays ..
      INTEGER            TEMP( 1 )
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, REAL, SQRT
*     ..
*     .. Executable Statements ..
*
      INDERR = N
      INDLD = 2*N
      INDLLD = 3*N
      INDGAP = 4*N
      INDIN1 = 5*N + 1
      INDIN2 = 6*N + 1
      INDWRK = 7*N + 1
*
      IINDR = N
      IINDC1 = 2*N
      IINDC2 = 3*N
      IINDWK = 4*N + 1
*
      DO 10 I = 1, 2*N
         IWORK( I ) = 0
   10 CONTINUE
      CALL LA_LASET( 'Full', N, N, CZERO, CZERO, Z, LDZ )
      MGSTOL = TSTTOL*ULP
*
      IBEGIN = 1
      WBEGIN = 1
      DO 170 JBLK = 1, IBLOCK( M )
         IEND = ISPLIT( JBLK )
*
*        Find the eigenvectors of the submatrix indexed IBEGIN
*        through IEND.
*
         WEND = WBEGIN - 1
  15     CONTINUE
         IF( WEND.LT.M ) THEN
            IF( IBLOCK( WEND+1 ).EQ.JBLK ) THEN
               WEND = WEND + 1
               GO TO 15
            END IF
         END IF
         IF( WEND.LT.WBEGIN ) THEN
            IBEGIN = IEND + 1
            GO TO 170
         END IF
*
         IF( IBEGIN.EQ.IEND ) THEN
            Z( IBEGIN, WBEGIN ) = ONE
            ISUPPZ( 2*WBEGIN-1 ) = IBEGIN
            ISUPPZ( 2*WBEGIN ) = IBEGIN
            IBEGIN = IEND + 1
            WBEGIN = WEND + 1
            GO TO 170
         END IF
         OLDIEN = IBEGIN - 1
         IN = IEND - OLDIEN
         RELTOL = MIN( RELTHR, ONE / REAL( IN, WP ) )
         IM = WEND - WBEGIN + 1
         CALL LA_COPY( IM, W( WBEGIN ), 1, WORK(1), 1 )
         DO 20 I = 1, IM - 1
            WORK( INDERR+I ) = ULP*ABS( WORK( I ) )
            WORK( INDGAP+I ) = WORK( I+1 ) - WORK( I )
   20    CONTINUE
         WORK( INDERR+IM ) = ULP*ABS( WORK( IM ) )
         WORK( INDGAP+IM ) = MAX( ABS( WORK( IM ) ), ULP )
         NDONE = 0
*
         NDEPTH = 0
         PARITY = 1
         NCLUS = 1
         IWORK( IINDC1+1 ) = 1
         IWORK( IINDC1+2 ) = IM
*
*        While( NDONE.LT.IM ) do
*
   30    CONTINUE
         IF( NDONE.LT.IM ) THEN
            OLDNCL = NCLUS
            NCLUS = 0
            PARITY = 1 - PARITY
            IF( PARITY.EQ.0 ) THEN
               OLDCLS = IINDC1
               NEWCLS = IINDC2
            ELSE
               OLDCLS = IINDC2
               NEWCLS = IINDC1
            END IF
            DO 150 I = 1, OLDNCL
*
*              If NDEPTH > 1, retrieve the relatively robust
*              representation (RRR) and perform limited bisection
*              (if necessary) to get approximate eigenvalues.
*
               J = OLDCLS + 2*I
               OLDFST = IWORK( J-1 )
               OLDLST = IWORK( J )
               IF( NDEPTH.GT.0 ) THEN
                  J = WBEGIN + OLDFST - 1
                  DO 35 K = 1, IN
                     D( IBEGIN+K-1 ) = REAL( Z( IBEGIN+K-1, J ) )
                     L( IBEGIN+K-1 ) = REAL( Z( IBEGIN+K-1, J+1 ) )
   35             CONTINUE
                  CALL LA_LASET( 'Full', IN, 2, CZERO, CZERO,
     $                           Z( IBEGIN, J ), LDZ )
               END IF
               K = IBEGIN
               DO 40 J = 1, IN - 1
                  TMP = D( K )*L( K )
                  WORK( INDLD+J ) = TMP
                  WORK( INDLLD+J ) = TMP*L( K )
                  K = K + 1
   40          CONTINUE
               IF( NDEPTH.GT.0 ) THEN
                  P = INDEXW( WBEGIN-1+OLDFST )
                  Q = INDEXW( WBEGIN-1+OLDLST )
                  CALL LA_LARRB( IN, D( IBEGIN ), L( IBEGIN ),
     $                           WORK( INDLD+1 ), WORK( INDLLD+1 ),
     $                           P, Q, RELTOL, FOUR*ULP, P-OLDFST,
     $                           WORK(1), WORK( INDGAP+1 ),
     $                           WORK( INDERR+1 ), WORK( INDWRK+IN ),
     $                           IWORK( IINDWK ), IINFO )
               END IF
*
*              Classify eigenvalues of the current representation (RRR)
*              as (i) isolated, (ii) loosely clustered or (iii) tightly
*              clustered
*
               NEWFRS = OLDFST
               DO 140 J = OLDFST, OLDLST
                  IF( J.EQ.OLDLST .OR. WORK( INDGAP+J ).GE.RELTOL*
     $                ABS( WORK( J ) ) ) THEN
                     NEWLST = J
                  ELSE
*
*                    continue (to the next loop)
*
                     RELGAP = WORK( INDGAP+J ) / ABS( WORK( J ) )
                     IF( J.EQ.NEWFRS ) THEN
                        MINRGP = RELGAP
                     ELSE
                        MINRGP = MIN( MINRGP, RELGAP )
                     END IF
                     GO TO 140
                  END IF
                  NEWSIZ = NEWLST - NEWFRS + 1
                  NEWFTT = WBEGIN + NEWFRS - 1
                  NOMGS = NEWSIZ.EQ.1 .OR. NEWSIZ.GT.MGSSIZ .OR.
     $                    MINRGP.LT.MGSTOL
                  IF( NOMGS ) THEN
*
*                    Find a new L D L^T representation if the cluster
*                    size is larger than MGSSIZ or the minimum
*                    relative gap within the cluster is too small.
*
                     DO 45 K = 1, IN
                        WORK( INDIN1+K-1 ) = REAL( Z( IBEGIN+K-1,
     $                                       NEWFTT ) )
                        WORK( INDIN2+K-1 ) = REAL( Z( IBEGIN+K-1,
     $                                       NEWFTT+1 ) )
   45                CONTINUE
                     CALL LA_LARRF( IN, D( IBEGIN ), L( IBEGIN ),
     $                              WORK( INDLD+1 ), WORK( INDLLD+1 ),
     $                              NEWFRS, NEWLST, WORK(1), SIGMA,
     $                              WORK( INDIN1 ), WORK( INDIN2 ),
     $                              WORK( INDWRK ), INFO )
                     IF( INFO.EQ.0 ) THEN
                        TMP = ULP*( ABS( SIGMA ) )
                        DO 50 K = NEWFRS, NEWLST
                           WORK( K ) = WORK( K ) - SIGMA
                           WORK( INDGAP+K ) = MAX( WORK( INDGAP+K ),
     $                                        TMP )
                           WORK( INDERR+K ) = WORK( INDERR+K ) + TMP
   50                   CONTINUE
                        NCLUS = NCLUS + 1
                        K = NEWCLS + 2*NCLUS
                        IWORK( K-1 ) = NEWFRS
                        IWORK( K ) = NEWLST
                     ELSE
                        INFO = 0
                        IF( MINRGP.GE.MGSTOL ) THEN
                           NOMGS = .FALSE.
                        ELSE
*
*                          Call CSTEIN to process this tight cluster.
*                          This happens only if MINRGP <= MGSTOL
*                          and SLARRF returns INFO = 1. The latter
*                          means that a new RRR to "break" the
*                          cluster could not be found.
*
                           WORK( INDWRK ) = D( IBEGIN )
                           DO 60 K = 1, IN - 1
                              WORK( INDWRK+K ) = D( IBEGIN+K ) +
     $                                           WORK( INDLLD+K )
   60                      CONTINUE
                           DO 70 K = 1, NEWSIZ
                              IWORK( IINDWK+K-1 ) = 1
   70                      CONTINUE
                           DO 80 K = NEWFRS, NEWLST
                              ISUPPZ( 2*( OLDIEN+K )-1 ) = 1
                              ISUPPZ( 2*( OLDIEN+K ) ) = IN
   80                      CONTINUE
                           TEMP( 1 ) = IN
                           CALL LA_STEIN( IN, WORK( INDWRK ),
     $                                    WORK( INDLD+1 ), NEWSIZ,
     $                                    WORK( NEWFRS ),
     $                                    IWORK( IINDWK ), TEMP( 1 ),
     $                                    Z( IBEGIN, NEWFTT ), LDZ,
     $                                    WORK( INDWRK+IN ),
     $                                    IWORK( IINDWK+IN ),
     $                                    IWORK( IINDWK+2*IN ), IINFO )
                           IF( IINFO.NE.0 ) THEN
                              INFO = 2
                              RETURN
                           END IF
                           NDONE = NDONE + NEWSIZ
                        END IF
                     END IF
                  ELSE
                     KTOT = NEWFTT
                     DO 100 K = NEWFRS, NEWLST
                        ITER = 0
   90                   CONTINUE
                        LAMBDA = WORK( K )
*
*                       Given LAMBDA, compute the eigenvector.
*
                        CALL LA_LAR1V( IN, 1, IN, LAMBDA, D( IBEGIN ),
     $                                 L( IBEGIN ), WORK( INDLD+1 ),
     $                                 WORK( INDLLD+1 ),
     $                                 W( WBEGIN+K-1 ),
     $                                 GERSCH( 2*OLDIEN+1 ),
     $                                 Z( IBEGIN, KTOT ), ZTZ, MINGMA,
     $                                 IWORK( IINDR+KTOT ),
     $                                 ISUPPZ( 2*KTOT-1 ),
     $                                 WORK( INDWRK ) )
                        TMP = ONE / ZTZ
                        NRMINV = SQRT( TMP )
                        RESID = ABS( MINGMA )*NRMINV
                        RQCORR = MINGMA*TMP
                        IF( K.EQ.IN ) THEN
                           GAP = WORK( INDGAP+K-1 )
                        ELSE IF( K.EQ.1 ) THEN
                           GAP = WORK( INDGAP+K )
                        ELSE
                           GAP = MIN( WORK( INDGAP+K-1 ),
     $                           WORK( INDGAP+K ) )
                        END IF
                        ITER = ITER + 1
                        IF( RESID.GT.TOL*GAP .AND. ABS( RQCORR ).GT.
     $                      FOUR*ULP*ABS( LAMBDA ) ) THEN
                           WORK( K ) = LAMBDA + RQCORR
                           IF( ITER.LT.MAXITR ) THEN
                              GO TO 90
                           END IF
                        END IF
                        IWORK( KTOT ) = 1
                        IF( NEWSIZ.EQ.1 )
     $                     NDONE = NDONE + 1
                        ZFROM = ISUPPZ( 2*KTOT-1 )
                        ZTO = ISUPPZ( 2*KTOT )
                        CALL LA_SCAL( ZTO-ZFROM+1, NRMINV,
     $                                Z( IBEGIN+ZFROM-1, KTOT ), 1 )
                        KTOT = KTOT + 1
  100                CONTINUE
                     IF( NEWSIZ.GT.1 ) THEN
                        ITMP1 = ISUPPZ( 2*NEWFTT-1 )
                        ITMP2 = ISUPPZ( 2*NEWFTT )
                        KTOT = OLDIEN + NEWLST
                        DO 120 P = NEWFTT + 1, KTOT
                           DO 110 Q = NEWFTT, P - 1
                              CTMP1 = -LA_DOTU( IN, Z( IBEGIN, P ), 1,
     $                                Z( IBEGIN, Q ), 1 )
                              CALL LA_AXPY( IN, CTMP1, Z( IBEGIN, Q ),
     $                                      1, Z( IBEGIN, P ), 1 )
  110                      CONTINUE
                           TMP = ONE / LA_NRM2( IN, Z( IBEGIN, P ), 1 )
                           CALL LA_SCAL( IN, TMP, Z( IBEGIN, P ), 1 )
                           ITMP1 = MIN( ITMP1, ISUPPZ( 2*P-1 ) )
                           ITMP2 = MAX( ITMP2, ISUPPZ( 2*P ) )
  120                   CONTINUE
                        DO 130 P = NEWFTT, KTOT
                           ISUPPZ( 2*P-1 ) = ITMP1
                           ISUPPZ( 2*P ) = ITMP2
  130                   CONTINUE
                        NDONE = NDONE + NEWSIZ
                     END IF
                  END IF
                  NEWFRS = J + 1
  140          CONTINUE
  150       CONTINUE
            NDEPTH = NDEPTH + 1
            GO TO 30
         END IF
         J = 2*WBEGIN
         DO 160 I = WBEGIN, WEND
            ISUPPZ( J-1 ) = ISUPPZ( J-1 ) + OLDIEN
            ISUPPZ( J ) = ISUPPZ( J ) + OLDIEN
            J = J + 2
  160    CONTINUE
         IBEGIN = IEND + 1
         WBEGIN = WEND + 1
  170 CONTINUE
*
      RETURN
*
*     End of CLARRV
*
      END
