#include "lapacknames.inc"
      FUNCTION CLADIV( X, Y )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LADV2
      COMPLEX(WP) CLADIV
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*     04-11-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      COMPLEX(WP)        X, Y
*     ..
*
*  Purpose
*  =======
*
*  CLADIV := X / Y, where X and Y are complex.  The computation of X / Y
*  will not overflow on an intermediary step unless the results
*  overflows.
*
*  Arguments
*  =========
*
*  X       (input) COMPLEX
*  Y       (input) COMPLEX
*          The complex scalars X and Y.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           ZI, ZR
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          AIMAG, CMPLX, REAL
*     ..
*     .. Executable Statements ..
*
      CALL LA_LADV2( REAL( X ), AIMAG( X ), REAL( Y ), AIMAG( Y ), ZR,
     $               ZI )
      CLADIV = CMPLX( ZR, ZI, WP )
*
      RETURN
*
*     End of CLADIV
*
      END
