#include "lapacknames.inc"
      SUBROUTINE CGEGS( JOBVSL, JOBVSR, N, A, LDA, B, LDB, ALPHA, BETA,
     $                  VSL, LDVSL, VSR, LDVSR, WORK, LWORK, RWORK,
     $                  INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILAENV, LSAME, XERBLA, LA_LACPY, LA_LANGE,
     $                        LA_LASCL, LA_LASET
      USE LA_LAPACK, ONLY: LA_GEQRF, LA_GGBAK, LA_GGBAL, LA_GGHRD,
     $                     LA_HGEQZ, LA_UNGQR, LA_UNMQR
*
*  -- LAPACK driver routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     04-26-01:  Documentation improvement
*     06-26-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          JOBVSL, JOBVSR
      INTEGER            INFO, LDA, LDB, LDVSL, LDVSR, LWORK, N
*     ..
*     .. Array Arguments ..
      REAL(WP)           RWORK( * )
      COMPLEX(WP)        A( LDA, * ), ALPHA( * ), B( LDB, * ),
     $                   BETA( * ), VSL( LDVSL, * ), VSR( LDVSR, * ),
     $                   WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  This routine is deprecated and has been replaced by routine CGGES.
*
*  CGEGS computes the eigenvalues, Schur form, and, optionally, the
*  left and or/right Schur vectors of a complex matrix pair (A,B).
*  Given two square matrices A and B, the generalized Schur
*  factorization has the form
*  
*     A = Q*S*Z**H,  B = Q*T*Z**H
*  
*  where Q and Z are unitary matrices and S and T are upper triangular.
*  The columns of Q are the left Schur vectors
*  and the columns of Z are the right Schur vectors.
*  
*  If only the eigenvalues of (A,B) are needed, the driver routine
*  CGEGV should be used instead.  See CGEGV for a description of the
*  eigenvalues of the generalized nonsymmetric eigenvalue problem
*  (GNEP).
*
*  Arguments
*  =========
*
*  JOBVSL  (input) CHARACTER*1
*          = 'N':  do not compute the left Schur vectors;
*          = 'V':  compute the left Schur vectors (returned in VSL).
*
*  JOBVSR  (input) CHARACTER*1
*          = 'N':  do not compute the right Schur vectors;
*          = 'V':  compute the right Schur vectors (returned in VSR).
*
*  N       (input) INTEGER
*          The order of the matrices A, B, VSL, and VSR.  N >= 0.
*
*  A       (input/output) COMPLEX array, dimension (LDA, N)
*          On entry, the matrix A.
*          On exit, the upper triangular matrix S from the generalized
*          Schur factorization.
*
*  LDA     (input) INTEGER
*          The leading dimension of A.  LDA >= max(1,N).
*
*  B       (input/output) COMPLEX array, dimension (LDB, N)
*          On entry, the matrix B.
*          On exit, the upper triangular matrix T from the generalized
*          Schur factorization.
*
*  LDB     (input) INTEGER
*          The leading dimension of B.  LDB >= max(1,N).
*
*  ALPHA   (output) COMPLEX array, dimension (N)
*          The complex scalars alpha that define the eigenvalues of
*          GNEP.  ALPHA(j) = S(j,j), the diagonal element of the Schur
*          form of A.
*
*  BETA    (output) COMPLEX array, dimension (N)
*          The non-negative real scalars beta that define the
*          eigenvalues of GNEP.  BETA(j) = T(j,j), the diagonal element
*          of the triangular factor T.
*
*          Together, the quantities alpha = ALPHA(j) and beta = BETA(j)
*          represent the j-th eigenvalue of the matrix pair (A,B), in
*          one of the forms lambda = alpha/beta or mu = beta/alpha.
*          Since either lambda or mu may overflow, they should not,
*          in general, be computed.
*
*  VSL     (output) COMPLEX array, dimension (LDVSL,N)
*          If JOBVSL = 'V', the matrix of left Schur vectors Q.
*          Not referenced if JOBVSL = 'N'.
*
*  LDVSL   (input) INTEGER
*          The leading dimension of the matrix VSL. LDVSL >= 1, and
*          if JOBVSL = 'V', LDVSL >= N.
*
*  VSR     (output) COMPLEX array, dimension (LDVSR,N)
*          If JOBVSR = 'V', the matrix of right Schur vectors Z.
*          Not referenced if JOBVSR = 'N'.
*
*  LDVSR   (input) INTEGER
*          The leading dimension of the matrix VSR. LDVSR >= 1, and
*          if JOBVSR = 'V', LDVSR >= N.
*
*  WORK    (workspace/output) COMPLEX array, dimension (LWORK)
*          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
*
*  LWORK   (input) INTEGER
*          The dimension of the array WORK.  LWORK >= max(1,2*N).
*          For good performance, LWORK must generally be larger.
*          To compute the optimal value of LWORK, call ILAENV to get
*          blocksizes (for CGEQRF, CUNMQR, and CUNGQR.)  Then compute:
*          NB  -- MAX of the blocksizes for CGEQRF, CUNMQR, and CUNGQR;
*          the optimal LWORK is N*(NB+1).
*
*          If LWORK = -1, then a workspace query is assumed; the routine
*          only calculates the optimal size of the WORK array, returns
*          this value as the first entry of the WORK array, and no error
*          message related to LWORK is issued by XERBLA.
*
*  RWORK   (workspace) REAL array, dimension (3*N)
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value.
*          = 1,...,N:
*                The QZ iteration failed.  (A,B) are not in Schur
*                form, but ALPHA(j) and BETA(j) should be correct for
*                j=INFO+1,...,N.
*          > N:  errors that usually indicate LAPACK problems:
*                =N+1: error return from CGGBAL
*                =N+2: error return from CGEQRF
*                =N+3: error return from CUNMQR
*                =N+4: error return from CUNGQR
*                =N+5: error return from CGGHRD
*                =N+6: error return from CHGEQZ (other than failed
*                                               iteration)
*                =N+7: error return from CGGBAK (computing VSL)
*                =N+8: error return from CGGBAK (computing VSR)
*                =N+9: error return from CLASCL (various places)
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            ILASCL, ILBSCL, ILVSL, ILVSR, LQUERY
      INTEGER            ICOLS, IHI, IINFO, IJOBVL, IJOBVR, ILEFT,
     $                   ILO, IRIGHT, IROWS, IRWORK, ITAU, IWORK,
     $                   LOPT, LWKMIN, LWKOPT, NB, NB1, NB2, NB3
      REAL(WP)           ANRM, ANRMTO, BNRM, BNRMTO
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          INT, MAX
*     ..
*     .. Executable Statements ..
*
*     Decode the input arguments
*
      IF( LSAME( JOBVSL, 'N' ) ) THEN
         IJOBVL = 1
         ILVSL = .FALSE.
      ELSE IF( LSAME( JOBVSL, 'V' ) ) THEN
         IJOBVL = 2
         ILVSL = .TRUE.
      ELSE
         IJOBVL = -1
         ILVSL = .FALSE.
      END IF
*
      IF( LSAME( JOBVSR, 'N' ) ) THEN
         IJOBVR = 1
         ILVSR = .FALSE.
      ELSE IF( LSAME( JOBVSR, 'V' ) ) THEN
         IJOBVR = 2
         ILVSR = .TRUE.
      ELSE
         IJOBVR = -1
         ILVSR = .FALSE.
      END IF
*
*     Test the input arguments
*
      LWKMIN = MAX( 2*N, 1 )
      LWKOPT = LWKMIN
      WORK( 1 ) = LWKOPT
      LQUERY = ( LWORK.EQ.-1 )
      INFO = 0
      IF( IJOBVL.LE.0 ) THEN
         INFO = -1
      ELSE IF( IJOBVR.LE.0 ) THEN
         INFO = -2
      ELSE IF( N.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -5
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -7
      ELSE IF( LDVSL.LT.1 .OR. ( ILVSL .AND. LDVSL.LT.N ) ) THEN
         INFO = -11
      ELSE IF( LDVSR.LT.1 .OR. ( ILVSR .AND. LDVSR.LT.N ) ) THEN
         INFO = -13
      ELSE IF( LWORK.LT.LWKMIN .AND. .NOT.LQUERY ) THEN
         INFO = -15
      END IF
*
      IF( INFO.EQ.0 ) THEN
         NB1 = ILAENV( 1, CPREFIX // 'GEQRF', ' ', N, N, -1, -1 )
         NB2 = ILAENV( 1, CPREFIX // 'UNMQR', ' ', N, N, N, -1 )
         NB3 = ILAENV( 1, CPREFIX // 'UNGQR', ' ', N, N, N, -1 )
         NB = MAX( NB1, NB2, NB3 )
         LOPT = N*(NB+1)
         WORK( 1 ) = LOPT
      END IF
*
      IF( LQUERY .OR. INFO.NE.0 ) THEN
         IF( INFO.NE.0 ) CALL XERBLA( CPREFIX // 'GEGS ', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Scale A if max element outside range [SMLNUM,BIGNUM]
*
      ANRM = LA_LANGE( 'M', N, N, A, LDA, RWORK )
      ILASCL = .FALSE.
      IF( ANRM.GT.ZERO .AND. ANRM.LT.SMLNUM ) THEN
         ANRMTO = SMLNUM
         ILASCL = .TRUE.
      ELSE IF( ANRM.GT.BIGNUM ) THEN
         ANRMTO = BIGNUM
         ILASCL = .TRUE.
      END IF
*
      IF( ILASCL ) THEN
         CALL LA_LASCL( 'G', -1, -1, ANRM, ANRMTO, N, N, A, LDA, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
      END IF
*
*     Scale B if max element outside range [SMLNUM,BIGNUM]
*
      BNRM = LA_LANGE( 'M', N, N, B, LDB, RWORK )
      ILBSCL = .FALSE.
      IF( BNRM.GT.ZERO .AND. BNRM.LT.SMLNUM ) THEN
         BNRMTO = SMLNUM
         ILBSCL = .TRUE.
      ELSE IF( BNRM.GT.BIGNUM ) THEN
         BNRMTO = BIGNUM
         ILBSCL = .TRUE.
      END IF
*
      IF( ILBSCL ) THEN
         CALL LA_LASCL( 'G', -1, -1, BNRM, BNRMTO, N, N, B, LDB, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
      END IF
*
*     Permute the matrix to make it more nearly triangular
*
      ILEFT = 1
      IRIGHT = N + 1
      IRWORK = IRIGHT + N
      IWORK = 1
      CALL LA_GGBAL( 'P', N, A(1,1), LDA, B(1,1), LDB, ILO, IHI,
     $               RWORK( ILEFT ), RWORK( IRIGHT ), RWORK( IRWORK ),
     $               IINFO )
      IF( IINFO.NE.0 ) THEN
         INFO = N + 1
         GO TO 10
      END IF
*
*     Reduce B to triangular form, and initialize VSL and/or VSR
*
      IROWS = IHI + 1 - ILO
      ICOLS = N + 1 - ILO
      ITAU = IWORK
      IWORK = ITAU + IROWS
      CALL LA_GEQRF( IROWS, ICOLS, B( ILO, ILO ), LDB, WORK( ITAU ),
     $               WORK( IWORK ), LWORK+1-IWORK, IINFO )
      IF( IINFO.GE.0 )
     $   LWKOPT = MAX( LWKOPT, INT( WORK( IWORK ) )+IWORK-1 )
      IF( IINFO.NE.0 ) THEN
         INFO = N + 2
         GO TO 10
      END IF
*
      CALL LA_UNMQR( 'L', 'C', IROWS, ICOLS, IROWS, B( ILO, ILO ), LDB,
     $               WORK( ITAU ), A( ILO, ILO ), LDA, WORK( IWORK ),
     $               LWORK+1-IWORK, IINFO )
      IF( IINFO.GE.0 )
     $   LWKOPT = MAX( LWKOPT, INT( WORK( IWORK ) )+IWORK-1 )
      IF( IINFO.NE.0 ) THEN
         INFO = N + 3
         GO TO 10
      END IF
*
      IF( ILVSL ) THEN
         CALL LA_LASET( 'Full', N, N, CZERO, CONE, VSL, LDVSL )
         CALL LA_LACPY( 'L', IROWS-1, IROWS-1, B( ILO+1, ILO ), LDB,
     $                  VSL( ILO+1, ILO ), LDVSL )
         CALL LA_UNGQR( IROWS, IROWS, IROWS, VSL( ILO, ILO ), LDVSL,
     $                  WORK( ITAU ), WORK( IWORK ), LWORK+1-IWORK,
     $                  IINFO )
         IF( IINFO.GE.0 )
     $      LWKOPT = MAX( LWKOPT, INT( WORK( IWORK ) )+IWORK-1 )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 4
            GO TO 10
         END IF
      END IF
*
      IF( ILVSR )
     $   CALL LA_LASET( 'Full', N, N, CZERO, CONE, VSR, LDVSR )
*
*     Reduce to generalized Hessenberg form
*
      CALL LA_GGHRD( JOBVSL, JOBVSR, N, ILO, IHI, A, LDA, B, LDB, VSL,
     $               LDVSL, VSR, LDVSR, IINFO )
      IF( IINFO.NE.0 ) THEN
         INFO = N + 5
         GO TO 10
      END IF
*
*     Perform QZ algorithm, computing Schur vectors if desired
*
      IWORK = ITAU
      CALL LA_HGEQZ( 'S', JOBVSL, JOBVSR, N, ILO, IHI, A, LDA, B, LDB,
     $               ALPHA, BETA, VSL, LDVSL, VSR, LDVSR, WORK( IWORK ),
     $               LWORK+1-IWORK, RWORK( IRWORK ), IINFO )
      IF( IINFO.GE.0 )
     $   LWKOPT = MAX( LWKOPT, INT( WORK( IWORK ) )+IWORK-1 )
      IF( IINFO.NE.0 ) THEN
         IF( IINFO.GT.0 .AND. IINFO.LE.N ) THEN
            INFO = IINFO
         ELSE IF( IINFO.GT.N .AND. IINFO.LE.2*N ) THEN
            INFO = IINFO - N
         ELSE
            INFO = N + 6
         END IF
         GO TO 10
      END IF
*
*     Apply permutation to VSL and VSR
*
      IF( ILVSL ) THEN
         CALL LA_GGBAK( 'P', 'L', N, ILO, IHI, RWORK( ILEFT ),
     $                  RWORK( IRIGHT ), N, VSL(1,1), LDVSL, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 7
            GO TO 10
         END IF
      END IF
      IF( ILVSR ) THEN
         CALL LA_GGBAK( 'P', 'R', N, ILO, IHI, RWORK( ILEFT ),
     $                  RWORK( IRIGHT ), N, VSR(1,1), LDVSR, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 8
            GO TO 10
         END IF
      END IF
*
*     Undo scaling
*
      IF( ILASCL ) THEN
         CALL LA_LASCL( 'U', -1, -1, ANRMTO, ANRM, N, N, A, LDA, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
         CALL LA_LASCL( 'G', -1, -1, ANRMTO, ANRM, N, 1, ALPHA, N,
     $                  IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
      END IF
*
      IF( ILBSCL ) THEN
         CALL LA_LASCL( 'U', -1, -1, BNRMTO, BNRM, N, N, B, LDB, IINFO )
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
         CALL LA_LASCL( 'G', -1, -1, BNRMTO, BNRM, N, 1, BETA, N, IINFO)
         IF( IINFO.NE.0 ) THEN
            INFO = N + 9
            RETURN
         END IF
      END IF
*
   10 CONTINUE
      WORK( 1 ) = LWKOPT
*
      RETURN
*
*     End of CGEGS
*
      END
