#include "lapacknames.inc"
      SUBROUTINE CGEBAL( JOB, N, A, LDA, ILO, IHI, SCALE, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA, LA_LANGE
      USE LA_BLAS1, ONLY: LA_IAMAX, LA_SCAL, LA_SWAP
*
*  -- LAPACK routine --
*     Based on LAPACK version 1.1, 3-31-93
*     E. Anderson, Cray Research Inc.
*     May 11, 1995
*     1-31-01:  Change SCLFAC to 1/8, test for overflow or underflow
*               of SCALE(I)*F before computing it  (eca)
*     09-06-02:  LAPACK 3E version (eca)
*     09-18-02:  Avoid overflow or underflow in CA*F or RA*G (eca)
*     11-13-02:  Estimate max norms CA and RA for performance (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          JOB
      INTEGER            IHI, ILO, INFO, LDA, N
*     ..
*     .. Array Arguments ..
      REAL(WP)           SCALE( * )
      COMPLEX(WP)        A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  CGEBAL balances a general real matrix A.  This involves, first,
*  permuting A by a similarity transformation to isolate eigenvalues
*  in the first 1 to ILO-1 and last IHI+1 to N elements on the
*  diagonal; and second, applying a diagonal similarity transformation
*  to rows and columns ILO to IHI to make the rows and columns as
*  close in norm as possible.  Both steps are optional.
*
*  Balancing may reduce the 1-norm of the matrix, and improve the
*  accuracy of the computed eigenvalues and/or eigenvectors.
*
*  Arguments
*  =========
*
*  JOB     (input) CHARACTER*1
*          Specifies the operations to be performed on A:
*          = 'N':  none:  simply set ILO = 1, IHI = N, SCALE(I) = 1.0
*                  for i = 1,...,N;
*          = 'P':  permute only;
*          = 'S':  scale only;
*          = 'B':  both permute and scale.
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  A       (input/output) COMPLEX array, dimension (LDA,N)
*          On entry, the input matrix A.
*          On exit,  A is overwritten by the balanced matrix.
*          If JOB = 'N', A is not referenced.
*          See Further Details.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  ILO     (output) INTEGER
*  IHI     (output) INTEGER
*          ILO and IHI are set to integers such that on exit
*          A(i,j) = 0 if i > j and j = 1,...,ILO-1 or I = IHI+1,...,N.
*          If JOB = 'N' or 'S', ILO = 1 and IHI = N.
*
*  SCALE   (output) REAL array, dimension (N)
*          Details of the permutations and scaling factors applied to
*          A.  If P(j) is the index of the row and column interchanged
*          with row and column j and D(j) is the scaling factor
*          applied to row and column j, then
*          SCALE(j) = P(j)    for j = 1,...,ILO-1
*                   = D(j)    for j = ILO,...,IHI
*                   = P(j)    for j = IHI+1,...,N.
*          The order in which the interchanges are made is N to IHI+1,
*          then 1 to ILO-1.
*
*  INFO    (output) INTEGER
*          = 0:  successful exit.
*          < 0:  if INFO = -i, the i-th argument had an illegal value.
*
*  Further Details
*  ===============
*
*  The permutations consist of row and column interchanges which put
*  the matrix in the form
*
*             ( T1   X   Y  )
*     P A P = (  0   B   Z  )
*             (  0   0   T2 )
*
*  where T1 and T2 are upper triangular matrices whose eigenvalues lie
*  along the diagonal.  The column indices ILO and IHI mark the starting
*  and ending columns of the submatrix B. Balancing consists of applying
*  a diagonal similarity transformation inv(D) * B * D to make the
*  1-norms of each row of B and its corresponding column nearly equal.
*  The output matrix is
*
*     ( T1     X*D          Y    )
*     (  0  inv(D)*B*D  inv(D)*Z ).
*     (  0      0           T2   )
*
*  Information about the permutations P and the diagonal matrix D is
*  returned in the vector SCALE.
*
*  This subroutine is based on the EISPACK routine CBAL.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL(WP)           SCL, SCL2
      PARAMETER          ( SCL = 0.125_WP, SCL2 = SCL*SCL )
      REAL(WP)           FACTOR, HUNDRD
      PARAMETER          ( FACTOR = 0.95_WP, HUNDRD = 100._WP )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOCONV, PERMUT, SCALEA
      INTEGER            I, ICA, IRA, J, K
      REAL(WP)           ANORM, C, CA, F, G, R, RA, SFMAX, SFMIN
      REAL(WP)           DUMMY( 1 )
      COMPLEX(WP)        Z
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, AIMAG, MAX, REAL
*     ..
*     .. Statement Functions ..
      REAL(WP)           CABS1
*     ..
*     .. Statement Function definitions ..
      CABS1( Z ) = ABS( REAL( Z ) ) + ABS( AIMAG( Z ) )
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters
*
      INFO = 0
      SCALEA = LSAME( JOB, 'B' )
      PERMUT = SCALEA .OR. LSAME( JOB, 'P' )
      SCALEA = SCALEA .OR. LSAME( JOB, 'S' )
      IF( .NOT.( LSAME( JOB, 'N' ) .OR. PERMUT .OR. SCALEA ) )
     $   THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -4
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( CPREFIX // 'GEBAL', -INFO )
         RETURN
      END IF
*
*     Quick return if N = 0 or if JOB = 'N'
*
      ILO = 1
      IHI = N
      IF( N.EQ.0 ) RETURN
      IF( LSAME( JOB, 'N' ) ) THEN
         DO 10 I = 1, N
            SCALE( I ) = ONE
   10    CONTINUE
         RETURN
      END IF
*
*     Limit scaling factors to 100X the 1-norm of A.
*
      ANORM = LA_LANGE( '1', N, N, A, LDA, DUMMY )
      SFMAX = HUNDRD*MIN( BIGNUM, MAX( SMLNUM, ANORM ) )
      SFMIN = ONE / SFMAX
*
*     Permute the matrix to isolate eigenvalues if possible.
*
      IF( PERMUT ) THEN
*
*        Search for rows isolating an eigenvalue and push them down.
*
         DO 40 K = N, 2, -1
            DO 30 I = K, 1, -1
*
*              See if any row has zeros in columns 1:K, not counting
*              the diagonal element.
*
               DO 20 J = 1, K
                  IF( I.NE.J .AND. A( I, J ).NE.ZERO ) GO TO 30
   20          CONTINUE
               SCALE( K ) = I
*
*              Interchange rows and columns I and K of A.
*
               IF( I.NE.K ) THEN
                  CALL LA_SWAP( K, A( 1, I ), 1, A( 1, K ), 1 )
                  CALL LA_SWAP( N, A( I, 1 ), LDA, A( K, 1 ), LDA )
               END IF
               GO TO 40
   30       CONTINUE
            GO TO 50
   40    CONTINUE
         SCALE( 1 ) = 1
   50    CONTINUE
         IHI = K
*
*        Search for columns isolating an eigenvalue and push them left.
*
*        Note that we don't want to move columns IHI+1:N, and we only
*        need to examine rows 1:IHI of the other columns because they
*        are zero in rows IHI+1:N.
*
         DO 80 K = 1, IHI-1
            DO 70 J = K, IHI
*
*              See if any column has zeros in rows K:IHI, not counting
*              the diagonal element.
*
               DO 60 I = K, IHI
                  IF( I.NE.J .AND. A( I, J ).NE.ZERO ) GO TO 70
   60          CONTINUE
               SCALE( K ) = J
*
*              Interchange rows and columns J and K of A.
*
               IF( J.NE.K ) THEN
                  CALL LA_SWAP( IHI, A( 1, J ), 1, A( 1, K ), 1 )
                  CALL LA_SWAP( N-K+1, A( J, K ), LDA, A( K, K ), LDA )
               END IF
               GO TO 80
   70       CONTINUE
            GO TO 90
   80    CONTINUE
         SCALE( IHI ) = IHI
   90    CONTINUE
         ILO = K
      END IF
*
*     Initialize SCALE(ILO:IHI) to 1.
*
      DO 100 I = ILO, IHI
         SCALE( I ) = ONE
  100 CONTINUE
*
*     Balance the submatrix in rows ILO to IHI.
*
      IF( SCALEA ) THEN
*
*        Iterative loop for norm reduction
*
  110    CONTINUE
         NOCONV = .FALSE.
*
         DO 120 I = ILO, IHI
            F = CABS1( A( I, I ) )
            C = ZERO
            R = ZERO
            DO J = ILO, IHI
               C = C + CABS1( A( J, I ) )
               R = R + CABS1( A( I, J ) )
            END DO
            C = C - F
            R = R - F
*
*           No need to scale if |A(I,I)| dominates the row or column.
*
            IF( C.EQ.ZERO .OR. R.EQ.ZERO )
     $         GO TO 120
*
*           Watch for overflow in A(1:IHI,I) and A(I,ILO:N)
*
            CA = MAX( C, F )
            RA = MAX( R, F )
            IF( ILO.GT.1 ) THEN
               ICA = LA_IAMAX( ILO-1, A( 1, I ), 1 )
               CA = MAX( CA, CABS1( A( ICA, I ) ) )
            END IF
            IF( IHI.LT.N ) THEN
               IRA = IHI + LA_IAMAX( N-IHI, A( I, IHI+1 ), LDA )
               RA = MAX( RA, CABS1( A( I, IRA ) ) )
            END IF
*
            IF( C.LE.R ) THEN
*
*              If C <= R, compute a scaling constant G for the row.
*
               CA = MAX( CA, SCALE( I ) )
               RA = MIN( RA, SCALE( I ) )
               F = R*SCL
               G = ONE
               DO WHILE( C.LT.F .AND. CA.LT.G*SFMAX .AND.
     $                   RA*G.GT.SFMIN )
                  F = F*SCL2
                  G = G*SCL
               END DO
               F = ONE / G
            ELSE
*
*              If C > R, compute a scaling constant F for the column.
*
               CA = MIN( CA, SCALE( I ) )
               RA = MAX( RA, SCALE( I ) )
               G = C*SCL
               F = ONE
               DO WHILE( R.LT.G .AND. RA.LT.F*SFMAX .AND.
     $                   CA*F.GT.SFMIN )
                  G = G*SCL2
                  F = F*SCL
               END DO
               G = ONE / F
            END IF
*
*           Balance if C+R is reduced by at least 5%.
*
            IF( ( C*F+R*G ).LT.FACTOR*( C+R ) ) THEN
               SCALE( I ) = SCALE( I )*F
               NOCONV = .TRUE.
!eca           CALL LA_SCAL( N-ILO+1, G, A( I, ILO ), LDA )
!eca           CALL LA_SCAL( IHI, F, A( 1, I ), 1 )
*
*              Order of scaling shouldn't matter here
*
               DO J = 1, IHI
                  A(J,I) = F*A(J,I)
               END DO
               DO J = ILO, N
                  A(I,J) = G*A(I,J)
               END DO
            END IF
  120    CONTINUE
*
*        Compute the scaling factors again if any were changed.
*
         IF( NOCONV )
     $      GO TO 110
      END IF
*
      RETURN
*
*     End of CGEBAL
*
      END
