#include "lapacknames.inc"
      FUNCTION SLAMCH( CMACH )
      USE LA_CONSTANTS, ONLY: WP, ONE
      REAL(WP) :: SLAMCH
!
!  -- LAPACK auxiliary routine --
!     E. Anderson, Cray Research Inc.
!     April 30, 1996
!     07-23-02:  LAPACK 3E version (eca)
!
!     .. Scalar Arguments ..
      CHARACTER          CMACH
!     ..
!
!  Purpose
!  =======
!
!  SLAMCH determines single precision machine parameters via inquiry
!  functions in Fortran 90, plus a C function to determine the rounding
!  mode.
!
!  Arguments
!  =========
!
!  CMACH   (input) CHARACTER*1
!          Specifies the value to be returned by SLAMCH:
!          = 'E' or 'e',   SLAMCH := eps
!          = 'S' or 's ,   SLAMCH := sfmin
!          = 'B' or 'b',   SLAMCH := base
!          = 'P' or 'p',   SLAMCH := eps*base
!          = 'N' or 'n',   SLAMCH := t
!          = 'R' or 'r',   SLAMCH := rnd
!          = 'M' or 'm',   SLAMCH := emin
!          = 'U' or 'u',   SLAMCH := rmin
!          = 'L' or 'l',   SLAMCH := emax
!          = 'O' or 'o',   SLAMCH := rmax
!
!          where
!
!          eps   = relative machine precision
!          sfmin = safe minimum, such that 1/sfmin does not overflow
!          base  = base of the machine
!          prec  = eps*base
!          t     = number of (base) digits in the mantissa
!          rnd   = 1.0 when rounding occurs in addition, 0.0 otherwise
!          emin  = minimum exponent before (gradual) underflow
!          rmin  = underflow threshold - base**(emin-1)
!          emax  = largest exponent before overflow
!          rmax  = overflow threshold  - (base**emax)*(1-eps)
!
!  =====================================================================
!
!     .. Local Scalars ..
      INTEGER            IC
      REAL(WP)           RMACH
!     ..
!     .. External Functions ..
      INTEGER            ROUNDING_MODE
      EXTERNAL           ROUNDING_MODE
!     ..
!     .. Intrinsic Functions ..
      INTRINSIC          DIGITS, EPSILON, HUGE, ICHAR, MAXEXPONENT,
     &                   MINEXPONENT, RADIX, TINY
!     ..
!     .. Executable Statements ..
!
      IC = ICHAR( CMACH )
!
!     Assume ASCII character set and map to upper case.
!
      IF( IC.GE.97 .AND. IC.LE.122 ) IC = IC - 32
!
!     ICHAR( 'E' ) = 69     ICHAR( 'R' ) = 82
!     ICHAR( 'S' ) = 83     ICHAR( 'M' ) = 77
!     ICHAR( 'B' ) = 66     ICHAR( 'U' ) = 85
!     ICHAR( 'P' ) = 80     ICHAR( 'L' ) = 76
!     ICHAR( 'N' ) = 78     ICHAR( 'O' ) = 79
!
      IF( IC.EQ.69 ) THEN
         RMACH = EPSILON( ONE )
!
      ELSE IF( IC.EQ.83 ) THEN
         RMACH = TINY( ONE )
!
      ELSE IF( IC.EQ.66 ) THEN
         RMACH = RADIX( ONE )
!
      ELSE IF( IC.EQ.80 ) THEN
         RMACH = EPSILON( ONE )*RADIX( ONE )
!
      ELSE IF( IC.EQ.78 ) THEN
         RMACH = DIGITS( ONE )
!
      ELSE IF( IC.EQ.82 ) THEN
         RMACH = ROUNDING_MODE()
!
      ELSE IF( IC.EQ.77 ) THEN
         RMACH = MINEXPONENT( ONE )
!
      ELSE IF( IC.EQ.85 ) THEN
         RMACH = TINY( ONE )
!
      ELSE IF( IC.EQ.76 ) THEN
         RMACH = MAXEXPONENT( ONE )
!
      ELSE IF( IC.EQ.79 ) THEN
         RMACH = HUGE( ONE )
      END IF
!
      SLAMCH = RMACH
      RETURN
!
!     End of SLAMCH
!
      END
