/*
 * Expression parsing routines.
 * Included by Mathomatic and Mathomatic Graph.
 */

/*
 * This is a simple mathematical expression parser.
 * It needs to be made recursive, if functions are to be implemented.
 */
char	*
parse_section(equation, np, cp)
token_type	*equation;
int		*np;
char		*cp;
{
	int		n;
	int		cur_level;
	int		operand;
	int		period_flag;
	int		found_digit;
	int		equals_flag;
	char		*startp, tmpc;
	char		*cp_start;
	char		*cp1;
	double		d;
	int		abs_count;
	int		abs_array[10];

	cp_start = cp;
	equals_flag = false;
	n = 0;
	*np = 0;
	cur_level = 1;
	abs_count = 0;
	operand = false;
	for (;; cp++) {
		switch (*cp) {
		case ' ':
		case '\t':
			continue;
		case '(':
			cur_level++;
			if (operand) {
				goto syntax_error;
			}
			continue;
		case ')':
			cur_level--;
			if (cur_level <= 0
			    || (abs_count > 0 && cur_level < abs_array[abs_count-1])) {
#if	!GRAPH
				put_up_arrow((int) (cp - cp_start));
				printf("Too many right parentheses.\n");
#endif
				return(NULL);
			}
			if (!operand) {
				goto syntax_error;
			}
			continue;
		case '=':
			equals_flag = true;
		case 0:
		case '\n':
			goto p_out;
		}
		if (n > (N_TOKENS - 6)) {
			error_huge();
		}
		operand = !operand;
		switch (*cp) {
		case '|':
			if (operand) {
				if (abs_count >= ARR_CNT(abs_array)) {
#if	!GRAPH
					printf("Too many nested absolute values.\n");
#endif
					return(NULL);
				}
				cur_level += 2;
				abs_array[abs_count++] = cur_level;
				operand = false;
			} else {
				if (abs_count <= 0
				    || cur_level != abs_array[--abs_count]) {
					goto syntax_error;
				}
				cur_level--;
				equation[n].level = cur_level;
				equation[n].kind = OPERATOR;
				equation[n].token.operatr = POWER;
				n++;
				equation[n].level = cur_level;
				equation[n].kind = CONSTANT;
				equation[n].token.constant = 2.0;
				n++;
				equation[n].level = cur_level;
				equation[n].kind = OPERATOR;
				equation[n].token.operatr = POWER;
				n++;
				equation[n].level = cur_level;
				equation[n].kind = CONSTANT;
				equation[n].token.constant = 0.5;
				n++;
				cur_level--;
				operand = true;
			}
			break;
		case '!':
			if (operand) {
				goto syntax_error;
			}
			equation[n].level = cur_level;
			equation[n].kind = OPERATOR;
			equation[n].token.operatr = FACTORIAL;
			n++;
			equation[n].level = cur_level;
			equation[n].kind = CONSTANT;
			equation[n].token.constant = 0.0;
			n++;
			operand = true;
			break;
		case '^':
			if (operand) {
				goto syntax_error;
			}
			equation[n].level = cur_level;
			equation[n].kind = OPERATOR;
			equation[n].token.operatr = POWER;
			n++;
			break;
		case '*':
		case '/':
			if (operand) {
				goto syntax_error;
			}
			equation[n].level = cur_level;
			equation[n].kind = OPERATOR;
			equation[n].token.operatr = ((*cp == '*') ? TIMES : DIVIDE);
			n++;
			break;
		case '+':
		case '-':
			if (!operand) {
				equation[n].level = cur_level;
				equation[n].kind = OPERATOR;
				equation[n].token.operatr = ((*cp == '+') ? PLUS : MINUS);
				n++;
			}
#if	!GRAPH
			if (strncmp(cp, "+/-", 3) == 0) {
				equation[n].level = cur_level;
				equation[n].kind = VARIABLE;
				next_sign(&equation[n].token.variable);
				n++;
				equation[n].level = cur_level;
				equation[n].kind = OPERATOR;
				if (operand) {
					equation[n].token.operatr = NEGATE;
				} else {
					equation[n].token.operatr = TIMES;
				}
				n++;
				cp += 2;
				operand = false;
				break;
			}
#endif
			if (!operand)
				break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '.':
			if (!operand) {
				goto syntax_error;
			}
			if (*cp == '-' && (isalpha(cp[1]) || cp[1] == '('
			    || cp[1] == '|')) {
				equation[n].kind = CONSTANT;
				equation[n].token.constant = -1.0;
				equation[n].level = cur_level;
				n++;
				equation[n].kind = OPERATOR;
				equation[n].token.operatr = NEGATE;
				equation[n].level = cur_level;
				n++;
				operand = false;
				continue;
			}
			period_flag = (*cp == '.');
			found_digit = isdigit(*cp);
			startp = cp;
			for (;; cp++) {
				switch (*(cp + 1)) {
				case '.':
					if (period_flag)
						break;
					period_flag = true;
					continue;
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					found_digit = true;
					continue;
				case 'E':
				case 'e':
					if (!found_digit) {
#if	!GRAPH
						put_up_arrow((int) (startp - cp_start));
						printf("Syntax error.\n");
#endif
						return(NULL);
					}
					cp1 = cp;
					found_digit = false;
					cp++;
					switch (*(cp + 1)) {
					case '-':
					case '+':
						cp++;
						break;
					}
					for (;; cp++) {
						if (isdigit(*(cp + 1))) {
							found_digit = true;
							continue;
						}
						break;
					}
					if (!found_digit) {
						cp = cp1;
						found_digit = true;
					}
					break;
				}
				break;
			}
			if (!found_digit) {
#if	!GRAPH
				put_up_arrow((int) (startp - cp_start));
				printf("Syntax error.\n");
#endif
				return(NULL);
			}
			tmpc = cp[1];
			cp[1] = '\0';
			errno = 0;
			d = strtod(startp, &cp1);
			cp[1] = tmpc;
			if (errno) {
#if	!GRAPH
				put_up_arrow((int) (startp - cp_start));
				printf("Constant out of range.\n");
#endif
				return(NULL);
			}
			if (cp1 != &cp[1]) {
#if	!GRAPH
				put_up_arrow((int) (startp - cp_start));
				printf("Error parsing constant.\n");
#endif
				return(NULL);
			}
			equation[n].kind = CONSTANT;
			equation[n].token.constant = d;
			equation[n].level = cur_level;
			n++;
			break;
		default:
			if (!isalpha(*cp)) {
				goto syntax_error;
			}
			if (!operand) {
				operand = true;
				equation[n].level = cur_level;
				equation[n].kind = OPERATOR;
				equation[n].token.operatr = TIMES;
				n++;
			}
			if (strncmp(cp, "inf", 3) == 0) {
#if	UNIX
				equation[n].kind = CONSTANT;
				equation[n].token.constant = HUGE_VAL;
				if (strncmp(cp, "infinity", 8) == 0) {
					cp += 8;
				} else {
					cp += 3;
				}
#else
#if	!GRAPH
				printf("Infinity not supported.\n");
#endif
				return(NULL);
#endif
			} else {
				equation[n].kind = VARIABLE;
				cp1 = cp;
				cp = parse_var(&equation[n].token.variable, cp);
				if (cp == NULL) {
#if	!GRAPH
					put_up_arrow((int) (cp1 - cp_start));
					printf("Invalid variable.\n");
#endif
					return(NULL);
				}
			}
			cp--;
			equation[n].level = cur_level;
			n++;
			break;
		}
	}
p_out:
	if (abs_count != 0 || (n && !operand)) {
		goto syntax_error;
	}
	if (cur_level != 1) {
#if	!GRAPH
		put_up_arrow((int) (cp - cp_start));
		printf("Missing right parenthesis.\n");
#endif
		return(NULL);
	}
	if (equals_flag)
		cp++;
	*np = n;
	handle_negate(equation, *np);
#if	!GRAPH
	prior_sub(equation, *np);
#endif
	return cp;

syntax_error:
#if	!GRAPH
	put_up_arrow((int) (cp - cp_start));
	printf("Syntax error.\n");
#endif
	return(NULL);
}

/*
 * Parse variable pointed to by "cp".
 * Variable name is converted to Mathomatic format and stored in "*vp".
 * Return new string position, or NULL on failure.
 */
char	*
parse_var(vp, cp)
long	*vp;
char	*cp;
{
	int	j;
	long	l;

	if (strncmp(cp, "sign", 4) == 0) {
		l = SIGN;
		cp += 4;
	} else {
		if (strncmp(cp, "i#", 2) == 0) {
			*vp = IMAGINARY;
			return(cp + 2);
		}
		if (strncmp(cp, "e#", 2) == 0) {
			*vp = V_E;
			return(cp + 2);
		}
		if (strncmp(cp, "p#", 2) == 0 || strncmp(cp, "pi", 2) == 0) {
			*vp = V_PI;
			return(cp + 2);
		}
		if (!isalpha(*cp)) {
			return(NULL);
		}
		l = *cp++;
		if (*cp == '_' && strncmp(cp, "_percent_change", 15) != 0) {
			cp++;
			if (!isalpha(*cp)) {
				return(NULL);
			}
			l <<= 7;
			l += *cp++;
		}
	}
	if (isdigit(*cp)) {
		j = atoi(cp);
		if (j < 0 || j > MAX_SUBSCRIPT) {
			return(NULL);
		}
#if	!GRAPH
		if (l == SIGN) {
			sign_array[j+1] = true;
		}
#endif
		l += ((long) (j + 1)) << VAR_SHIFT;
		while (*cp && isdigit(*cp))
			cp++;
	}
	while (*cp == '\'') {
		cp++;
		l = (unsigned long) l + (unsigned long) PRIME_INCREMENT;
		if (l < 0) {
			return(NULL);
		}
	}
	if (strncmp(cp, "_percent_change", 15) == 0) {
		l |= PERCENT_CHANGE;
		cp += 15;
	}
	*vp = l;
	return cp;
}

/*
 * Return true if passed variable is a constant.
 * Return value of constant in "*dp".
 */
int
var_is_const(v, dp)
long	v;
double	*dp;
{
	if (v == V_E) {
		*dp = E;
		return true;
	} else if (v == V_PI) {
		*dp = PI;
		return true;
	}
	return false;
}

/*
 * Substitute E and PI variables with their respective constants.
 */
int
subst_constants(equation, np)
token_type	*equation;
int		*np;
{
	int	i;
	int	modified;
	double	d;

	modified = false;
	for (i = 0; i < *np; i += 2) {
		if (equation[i].kind == VARIABLE) {
			if (var_is_const(equation[i].token.variable, &d)) {
				equation[i].kind = CONSTANT;
				equation[i].token.constant = d;
				modified = true;
			}
		}
	}
	return modified;
}

binary_parenthesize(equation, n, i)
token_type	*equation;
int		n, i;
{
	register int	j;
	int		level;

	level = equation[i].level++;
	if (equation[i-1].level++ > level) {
		for (j = i - 2; j >= 0; j--) {
			if (equation[j].level <= level)
				break;
			equation[j].level++;
		}
	}
	if (equation[i+1].level++ > level) {
		for (j = i + 2; j < n; j++) {
			if (equation[j].level <= level)
				break;
			equation[j].level++;
		}
	}
}

handle_negate(equation, n)
token_type	*equation;
int		n;
{
	int	i;

	for (i = 1; i < n; i += 2) {
		if (equation[i].token.operatr == NEGATE) {
			equation[i].token.operatr = TIMES;
			binary_parenthesize(equation, n, i);
		}
	}
}
