/*
 * Algebraic manipulator help command and parsing routines.
 *
 * Copyright (c) 1996 George Gesslein II.
 */

#include "am.h"
#include "externs.h"

/* The Mathomatic command list follows.  It must be in alphabetical order. */
com_type	com_list[] = {
	"calculate",	calculate,	"[<equation number>]",				"Temporarily plug values into the right side of an eq. and display.",
	"clear",	clear,		"[<equation number range>]",			"Delete equations so equation space can be reused.",
	"compare",	compare,	"<equation number> [with <equation number>]",	"Compare two equations to see if they are the same.",
	"copy",		copy,		"[<equation number range>]",			"Duplicate the specified or current equations.",
	"debug",	debug,		"[<debug level number>]",			"Display intermediate equations (levels 1 and 2).",
	"derivative",	derivative,	"<variable or \"all\">",			"Compute the derivative of the Right Hand Side of the current eq.",
	"divide",	polydivide,	"[<variable>]",					"Prompt for 2 polynomials/numbers and divide.  Display result and GCD.",
	"edit",		edit,		"[<file name>]",				"Edit your equations or an input file.",
	"eliminate",	eliminate,	"<variables> [using <equation number>]",	"Substitute the specified variables with solved equations.",
	"factor",	factor,		"[<equation number range>] [<variables>]",	"Factor equations.  For polynomial factoring, use \"simplify\".",
#if	!UNIX
	"graph",	graph,		"[<equation number>]",				"Graph the current or specified equation.  Runs \"graph.exe\".",
#endif
	"group",	group,		"[factor] [<equation number range>]",		"Display equations in fraction format.  Option to factor integers.",
	"help",		help,		"[<command name or \"equations\" or \"all\" or \"geometry\">]",	"Help with syntax, etc.",
	"imaginary",	imaginary,	"[<equation number>]",				"Copy the imaginary part of an equation (see the \"real\" command).",
	"integrate",	integrate,	"<variable> [trapezoidal]",			"Approximate the definite integral with respect to variable.",
	"list",		list,		"[<equation number range>]",			"Display equations.",
	"pause",	pause_cmd,	"",						"Wait for user to press the Enter key.",
	"print",	print,		"[factor] <equation number range> [\">\"<file name>]",	"Output equations in fraction format to the printer or a file.",
	"quit",		quit,		"",						"Terminate this program.  All equations in memory are lost.",
	"read",		read_in,	"<file name>",					"Read in a file as if it was typed in.",
	"real",		real,		"[<equation number>]",				"Copy the real part of an equation (see the \"imaginary\" command).",
	"remark",	remark,		"[<comment>]",					"Comment (ignored).  You can also use a semi-colon (;) for comments.",
	"replace",	replace,	"[temp] [<variable> [with <expression>]]",	"Substitute variables in both sides of an equation with expressions.",
	"save",		save,		"<file name>",					"Save all equations in a file (restore with the \"read\" command).",
	"sensitivity",	sensitivity,	"<variables>",					"Compute the sensitivity equation for variables.",
	"simplify",	simplify,	"[<\"symbolic\" or \"quick\">] [<equation number range>]",	"Completely simplify equations.",
	"tally",	tally,		"",						"Prompt for and add numerical entries.  Show running total.",
	"taylor",	taylor,		"<variable>",					"Compute the Taylor series expansion with respect to variable.",
	"unfactor",	unfactor,	"[<equation number range>]",			"Expand equations."
};

int	point_flag;	/* point to error if true */

/*
 * Process a line of input to Mathomatic.
 * It may be a command, an equation, etc.
 * Return true if successful.
 */
int
process(cp)
char	*cp;
{
	char	*cp1, *cp2;
	char	*cp_start;
	int	i, j;
	int	n;
	int	simp_flag;
	int	rv;
	char	buf2[200];

	usage_flag = true;
	set_sign_array();
	cp_start = cp;
	simp_flag = true;
	set_error_level(cp);
	cp = skip_space(cp);
#if	UNIX
	if (!case_sensitive_flag) {
		for (cp1 = cp; *cp1 && isascii(*cp1) && isalpha(*cp1); cp1++) {
			if (isupper(*cp1))
				*cp1 += 'a' - 'A';
		}
		if (strncmp(cp, "read", 4) && strncmp(cp, "save", 4)
		    && strncmp(cp, "prin", 4) && strncmp(cp, "edit", 4)) {
			str_tolower(cp);
		}
	}
#else
	if (!case_sensitive_flag) {
		str_tolower(cp);
	}
#endif
	if (*cp == '#') {
		cp++;
		if (isdigit(*cp)) {
			i = atoi(cp) - 1;
			if (i < 0 || i >= n_equations) {
				put_up_arrow((int) (cp - cp_start));
				printf("Equation number out of range.\n");
				return false;
			}
			while (*cp && isdigit(*cp))
				cp++;
			if (*cp == ':') {
				simp_flag = false;
				cp++;
			}
			cp = skip_space(cp);
			if (*cp) {
				for (cp1 = cp; *cp1; cp1++) {
					if (*cp1 == '=') {
						n = i;
						goto e_parse;
					}
				}
				put_up_arrow((int) (cp - cp_start));
				printf("Not a valid equation!\n");
				return false;
			}
			cur_equation = i;
			list("");
			return true;
		}
		put_up_arrow((int) (cp - cp_start));
		printf("Missing equation number to select.\n");
		return false;
	}
/* See if the string pointed to by "cp" is a command. */
/* If so, execute it. */
	cp1 = cp;
	while (*cp1 && isascii(*cp1) && isalpha(*cp1))
		cp1++;
	for (i = 0; i < ARR_CNT(com_list); i++) {
		if (strlen(com_list[i].name) < 4) {
			if ((cp1 - cp) != strlen(com_list[i].name))
				continue;
		} else {
			if ((cp1 - cp) < 4)
				continue;
		}
		if (strncmp(cp, com_list[i].name, cp1 - cp) == 0) {
/*
			if (i + 1 < ARR_CNT(com_list)) {
				if (strncmp(cp, com_list[i+1].name, cp1 - cp) == 0) {
					printf("Ambiguous command.\n");
					return false;
				}
			}
*/
			cp1 = skip_space(cp1);
			usage_flag = false;
			input_column += (cp1 - cp_start);
			for (cp2 = cp1, j = 0; *cp2; cp2++, j++) {
				if (j >= (sizeof(buf2) - 1)) {
					printf("Error: Command line too long.\n");
					return false;
				}
				buf2[j] = *cp2;
			}
			buf2[j] = '\0';
			cp2 = &buf2[0];
			rv = (*com_list[i].func)(cp2);
			if (usage_flag) {
				printf("Usage: %s %s\n", com_list[i].name, com_list[i].usage);
			}
			return rv;
		}
	}
/* "cp" is not a command, so parse the expression or equation. */
	n = next_espace();
e_parse:
	input_column += (cp - cp_start);
	cp_start = cp;
	if ((cp = parse_section(&lhs[n][0], &n_lhs[n], cp)) != NULL) {
		input_column += (cp - cp_start);
		if ((cp = parse_section(&rhs[n][0], &n_rhs[n], cp)) != NULL) {
			if (n_lhs[n] == 0 && n_rhs[n] == 0)
				return true;
			if (n_lhs[n] == 0 || n_rhs[n] == 0) {
				if ((n_lhs[n] == 1 && (lhs[n][0].kind != CONSTANT || lhs[n][0].token.constant == 0.0))
				    || (n_rhs[n] == 1 && (rhs[n][0].kind != CONSTANT || rhs[n][0].token.constant == 0.0))) {
					if (solve(n, cur_equation)) {
						list("");
						return true;
					}
					usage_flag = false;
					return false;
				}
				if (n_lhs[n]) {
					blt(&rhs[n][0], &lhs[n][0], n_lhs[n] * sizeof(token_type));
					n_rhs[n] = n_lhs[n];
				}
				lhs[n][0].level = 1;
				lhs[n][0].kind = VARIABLE;
				lhs[n][0].token.variable = SPECIAL;
				n_lhs[n] = 1;
				for (i = 0; i < n_rhs[n]; i += 2) {
					if (rhs[n][i].kind == VARIABLE
					    && (rhs[n][i].token.variable & VAR_MASK) > SIGN) {
						printf("You may enter a numerical expression, or an algebraic equation,\n");
						printf("or a variable to solve for, or a command (like \"help\").\n");
						n_lhs[n] = 0;
						return false;
					}
				}
				i = cur_equation;
				cur_equation = n;
				calculate("");
				cur_equation = i;
				n_lhs[n] = 0;
				return true;
			}
			cur_equation = n;
			if (simp_flag)
				simp_sub(n);
			else {
				organize(&lhs[n][0], &n_lhs[n]);
				organize(&rhs[n][0], &n_rhs[n]);
			}
			list("");
			return true;
		}
	}
	n_lhs[n] = 0;
	return false;
}

#include "parse.h"

char	*
parse_var2(vp, cp)
long	*vp;
char	*cp;
{
	char	*cp1;

	cp = skip_space(cp);
	cp = parse_var(vp, cp);
	if (cp == NULL) {
		printf("Invalid variable.\n");
		usage_flag = true;
		return NULL;
	}
	if (*cp) {
		cp1 = skip_space(cp);
		if (cp == cp1) {
			printf("Please separate variables with spaces.\n");
			usage_flag = true;
			return NULL;
		}
		return cp1;
	}
	return cp;
}

set_error_level(cp)
char	*cp;
{
	char	*cp1;

	point_flag = true;
	for (cp1 = cp; *cp1; cp1++) {
		*cp1 &= 0x7f;
	}
	while (cp1 != cp) {
		cp1--;
		if (*cp1 == '\n' || *cp1 == '\r') {
			*cp1 = '\0';
		} else
			break;
	}
#if	false
	if ((input_column + strlen(cp)) >= SCREEN_COLUMNS) {
		point_flag = false;
	}
#endif
	for (cp1 = cp; *cp1; cp1++) {
		if (isspace(*cp1) && *cp1 != ' ') {
			point_flag = false;
			break;
		}
	}
	for (cp1 = cp; *cp1; cp1++) {
		if (*cp1 == ';') {
			*cp1 = '\0';
			break;
		}
	}
}

put_up_arrow(cnt)
int	cnt;
{
	int	 i;

	if (!point_flag)
		return;
	for (i = 0; i < (input_column + cnt); i++) {
		putchar(' ');
	}
	printf("^ ");
}

int
is_all(cp)
char	*cp;
{
	if (strncmp(cp, "all", 3) == 0) {
		return true;
	}
	return false;
}

/*
 * Process an equation number range.
 * Return true if successful,
 * with the starting equation number in "*ip"
 * and ending equation number in "*jp".
 */
int
get_range(cpp, ip, jp)
char	**cpp;
int	*ip, *jp;
{
	int	i;

	if (is_all(*cpp)) {
		*cpp = skip_param(*cpp);
		*ip = 0;
		*jp = n_equations - 1;
		goto test_range;
	}
	if (isascii(**cpp) && isdigit(**cpp)) {
		*ip = atoi(*cpp) - 1;
	} else {
		*ip = cur_equation;
	}
	if (*ip < 0 || *ip >= n_equations) {
		printf("Invalid equation number.\n");
		usage_flag = true;
		return false;
	}
	*cpp = skip_num(*cpp);
	if (**cpp != '-') {
		if (n_lhs[*ip] <= 0) {
			printf("Undefined equation.\n");
			return false;
		}
		*jp = *ip;
		return true;
	}
	(*cpp)++;
	*cpp = skip_space(*cpp);
	if (isascii(**cpp) && isdigit(**cpp)) {
		*jp = atoi(*cpp) - 1;
	} else {
		*jp = cur_equation;
	}
	if (*jp < 0 || *jp >= n_equations) {
		printf("Invalid equation number.\n");
		usage_flag = true;
		return false;
	}
	if (*jp < *ip) {
		i = *ip;
		*ip = *jp;
		*jp = i;
	}
	*cpp = skip_num(*cpp);
test_range:
	for (i = *ip; i <= *jp; i++) {
		if (n_lhs[i] > 0) {
			return true;
		}
	}
	printf("No equations defined in specified range.\n");
	return false;
}

int
extra_garbage(cp)
char	*cp;
{
	cp = skip_space(cp);
	if (*cp) {
		usage_flag = true;
		printf("ERROR: Extra characters on command line.\n");
		return true;
	}
	return false;
}

char	*
skip_num(cp)
char	*cp;
{
	while (*cp && isascii(*cp) && isdigit(*cp))
		cp++;
	return skip_space(cp);
}

char	*
skip_space(cp)
char	*cp;
{
	while (*cp && isascii(*cp) && isspace(*cp))
		cp++;
	return cp;
}

char	*
skip_param(cp)
char	*cp;
{
	while (*cp && (!isascii(*cp) || !isspace(*cp)))
		cp++;
	return skip_space(cp);
}

char	*
skip_alpha(cp)
char	*cp;
{
	while (*cp && isascii(*cp) && isalpha(*cp))
		cp++;
	return skip_space(cp);
}

str_tolower(cp)
char	*cp;
{
	for (; *cp; cp++) {
		if (isascii(*cp) && isupper(*cp))
			*cp += 'a' - 'A';
	}
}

help(cp)
char	*cp;
{
	int	i, j;
	char	*cp1;
	int	flag;

	cp1 = cp;
	while (*cp1 && !isspace(*cp1))
		cp1++;
	if (cp1 != cp) {
		flag = false;
		for (i = 0; i < ARR_CNT(com_list); i++) {
			if (strncmp(cp, com_list[i].name, cp1 - cp) == 0) {
				printf("%s - %s\n", com_list[i].name, com_list[i].info);
				printf("Usage: %s %s\n\n", com_list[i].name, com_list[i].usage);
				flag = true;
			}
		}
		if (flag)
			return true;
		if (strncmp(cp, "geometry", cp1 - cp) == 0) {
			printf("Commonly used geometric formulas:\n\n");
			printf("Triangle of base 'b' and height 'h':\n");
			printf("     Area = b*h/2\n");
			printf("Rectangle of length 'l' and width 'w':\n");
			printf("     Area = l*w                  Perimeter = 2l + 2w\n");
			printf("Trapezoid of height 'h' and parallel sides 'a' and 'b':\n");
			printf("     Area = h*(a+b)/2\n");
			printf("Circle of radius 'r':\n");
			printf("     Area = pi*r^2               Perimeter = 2*pi*r\n");
			printf("Sphere of radius 'r':\n");
			printf("     Volume = 4/3*pi*r^3         Surface area = 4*pi*r^2\n");
			printf("Right circular cylinder of radius 'r' and height 'h':\n");
			printf("     Volume = pi*r^2*h           Surface area = 2*pi*r*(h+r)\n");
			return true;
		}
		if (strncmp(cp, "equations", cp1 - cp) == 0) {
equation_help:
			printf("To enter an equation, simply type it in at the prompt.\n");
			printf("Operators have precedence decreasing as indicated:\n\n");
			printf("    - negate                                    (highest precedence)\n");
			printf("    ! factorial                                 (higher precedence)\n");
			printf("    ^ power                                     (high precedence)\n");
			printf("    * multiply            / divide              (lower precedence)\n");
			printf("    + add                 - subtract            (lowest precedence)\n\n");
			printf("Variables consist of a letter (a-z) that may be followed by a number (0-62)\n");
			printf("and up to 7 primes (').  Two letter variables may be specified\n");
			printf("by separating the two letters with an underscore (_).  All upper case\n");
			printf("letters are converted to lower case.\n\n");
			printf("Predefined constants and variables:\n\n");
			printf("    e# - The universal constant e (2.718281828...).\n");
			printf("    p# or pi - The universal constant pi (3.1415926...).\n");
			printf("    i# - Imaginary Number (square root of -1).\n");
			printf("    sign, sign1, sign2, sign3, ... - may be +1 or -1.\n\n");
			printf("Each equation must have one, and only one, equals sign (=).\n");
			return true;
		}
		if (is_all(cp)) {
			for (i = 0;; i++) {
				if (i && (i % 7) == 0) {
					pause_cmd("");
					printf("\n");
				}
				if (i >= ARR_CNT(com_list))
					break;
				printf("%s - %s\n", com_list[i].name, com_list[i].info);
				printf("Usage: %s %s\n\n", com_list[i].name, com_list[i].usage);
			}
			printf("#<equation number to select>[[:] <equation>] - Select and enter equation.\n");
			printf("To solve the current equation for a single variable or for zero,\n");
			printf("simply type the variable name or \"0\" in at the prompt.\n");
			return true;
		}
		if ((cp1 - cp) == 1) {
			switch (*cp) {
			case '#':
				printf("#<equation number to select>[[:] <equation>] - Select and enter equation.\n");
				return true;
			case '+':
			case '-':
			case '*':
			case '/':
			case '^':
			case '!':
			case '=':
				goto equation_help;
			}
		}
	}
	printf("This \"help\" command is provided as a quick reference.\n");
	printf("Type \"help all\" for a summary of the all available commands.\n");
	printf("Type \"help equations\" for help with variables, constants, and operators.\n");
	printf("Type \"help <command name>\" for help on a particular command.\n");
	printf("Type \"help geometry\" for some commonly used geometric formulas.\n\n");
	printf("The following is a list of available commands:\n\n");
	for (i = 0; i < ARR_CNT(com_list); i++) {
		if (i && (i % 4) == 0)
			printf("\n");
		printf("%s", com_list[i].name);
		j = 19 - strlen(com_list[i].name);
		for (; j > 0; j--)
			putchar(' ');
	}
	printf("\n\n");
	printf("To select an equation in memory, enter \"#\" followed by the\n");
	printf("equation number.  For example, to select equation number 2, enter\n");
	printf("\"#2\" at the Mathomatic prompt.\n");
	return true;
}
