
/* If no fast blt() routine exists use this one. */

/*
 * This is a memory copy function that allows overlapping
 * of the source and destination areas.
 */
blt(dst, src, cnt)
register char	*dst;	/* Destination address */
register char	*src;	/* Source address */
register int	cnt;	/* Number of bytes to copy */
{
#if	UNIX
	bcopy(src, dst, cnt);
#else
	if (dst > src) {
		dst += cnt;
		src += cnt;
		while (--cnt >= 0)
			*--dst = *--src;
	} else {
		while (--cnt >= 0)
			*dst++ = *src++;
	}
#endif
}
