#include "tools.h"

/* ---------------------------------------------------------------------
*
*  -- PBLAS routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     March 17, 1995
*
*  ---------------------------------------------------------------------
*/

char * ptop( op, scope, top )
/*
*  .. Scalar Arguments ..
*/
   char        * op, * scope, * top;
{
/*
*  Purpose
*  =======
*
*  ptop get or set the row, column or all broadcast or combine
*  topologies.
*
*  =====================================================================
*
*  .. Local Scalars ..
*/
   static char rowbtop = ' ';         /* Default broadcast topologies */
   static char colbtop = ' ';
   static char allbtop = ' ';

   static char rowctop = ' ';           /* Default combine topologies */
   static char colctop = ' ';
   static char allctop = ' ';

   if( *op == 'B' )
   {
      if( *top == '!' )
      {
         if( *scope == 'R' )
         {
            return &rowbtop;
         }
         else if( *scope == 'C' )
         {
            return &colbtop;
         }
         else
         {
            return &allbtop;
         }
      }
      else
      {
         if( *scope == 'R' )
         {
            rowbtop = *top;
            return &rowbtop;
         }
         else if( *scope == 'C' )
         {
            colbtop = *top;
            return &colbtop;
         }
         else
         {
            allbtop = *top;
            return &allbtop;
         }
      }
   }
   else
   {
      if( *top == '!' )
      {
         if( *scope == 'R' )
         {
            return &rowctop;
         }
         else if( *scope == 'C' )
         {
            return &colctop;
         }
         else
         {
            return &allctop;
         }
      }
      else
      {
         if( *scope == 'R' )
         {
            rowctop = *top;
            return &rowctop;
         }
         else if( *scope == 'C' )
         {
            colctop = *top;
            return &colctop;
         }
         else
         {
            allctop = *top;
            return &allctop;
         }
      }
   }
}
