
/* Copyright (c) 1998 Regents of the University of California.
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *       This product includes software developed by the Imaging and
 *       Distributed Collaboration Group at Lawrence Berkeley 
 *       National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: serialport.cpp,v 0.4.1 98/04/09 10:28:31 mperry Exp $ (LBL)
*/

#include "serialport.h"

Serialport::Serialport(int id, short d)
{
	portid = id;
	debugLevel = d;
	fd = (HANDLE)-1;
}

Serialport::~Serialport()
{
	if (fd != (HANDLE)-1)
		CloseHandle(fd);
}

void Serialport::openPort(const char *p)
{
	fd = CreateFile(p, GENERIC_READ | GENERIC_WRITE, 0,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fd == (HANDLE)-1)
	{
		if (debugLevel > 0)
		   fprintf(stderr,"Devserv: can't open serial port %s\n",p);
        return;
	}
}

int Serialport::setupPort(DWORD baud, BYTE bytesize, BYTE par, BYTE stopbits)
{
	COMMTIMEOUTS commTimeOuts;
	DCB  dcb;
	int x;

	SetCommMask(fd, 0);
	SetupComm(fd, QSIZE, QSIZE);
	commTimeOuts.ReadIntervalTimeout = 0xFFFFFFFF;
	commTimeOuts.ReadTotalTimeoutMultiplier = 0;
	// This is like timed select() in Unix -- values are in
	// milliseconds.
	commTimeOuts.ReadTotalTimeoutConstant = 1000;
	commTimeOuts.WriteTotalTimeoutMultiplier = 0;
	commTimeOuts.WriteTotalTimeoutConstant = 1000;
	SetCommTimeouts(fd, &commTimeOuts);

	// Set up device control block--this is termios struct in Unix.
	dcb.DCBlength = sizeof(DCB);

	// This is like ioctl(fd, TCGETA,..) in UNIX.
	GetCommState(fd, &dcb);

	dcb.BaudRate = baud;
	dcb.ByteSize = bytesize;
	dcb.Parity = par;
	dcb.StopBits = stopbits;

	dcb.fBinary = TRUE;
	dcb.fOutxDsrFlow = 0;
	dcb.fDtrControl = DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity = 0;
	dcb.fOutX = dcb.fInX = 0;
	dcb.fErrorChar = 0;
	dcb.fRtsControl = RTS_CONTROL_HANDSHAKE;

	// Like ioctl(...,TCSETA,..) in Unix
	x = SetCommState(fd, &dcb);
	if (!x)
	{
		if (debugLevel>0)
			fprintf(stderr,"SetCommState() err: %ul\n",GetLastError());
		CloseHandle(fd);
		fd = (HANDLE)-1;
		return (-1);
	}
	return 0;
}


