
/* Copyright (c) 1998 Regents of the University of California.
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *       This product includes software developed by the Imaging and
 *       Distributed Collaboration Group at Lawrence Berkeley 
 *       National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: Device.h,v 0.4.1 98/04/09 10:33:47 mperry Exp $ (LBL)

*/// Device.h:  Base class for devices

#ifndef Device_h
#define Device_h

#include <stdio.h>
#include <windows.h>

class Device {
public:
	Device(int num=1, short d=1);
	virtual ~Device();
	virtual int move(char *) = 0;
	virtual int doPower() = 0;
	virtual int shutDown() = 0;
	virtual int goHome() = 0;
	virtual void getDesc(char *) = 0;
	inline void setDevnum(int n) { devnum = n; }
	virtual void setAvail(int);
protected:
	/* fd: handle for serial port;  id: device identifier
	   These are assigned on the basis of one per port;
	   values are obtained from a Serialport object.
	   devnum:  device number--used for daisy chaining,
	          when supported.  Devnum 1 is device closest
	          to the computer (directly attached to the port. 
	*/
			  	
	HANDLE fd;
	int id, devnum;
	static short debugLevel;  // if > 2, display device communication info
	int power;		 // 0 = 'off'; 1 = 'on'
	// keep track of which devices are responding (available).
	short initialized;
	int avail;
	char type[2];   // A=absolute, R=relative, F=fractional

};

#endif
