/*
 * $Id: strxor.c 10105 2009-01-26 16:13:57Z vszakats $
 */

/*
 * Harbour Project source code:
 * HB_STRXOR()
 *
 * Copyright 2009 Mindaugas Kavaliauskas <dbtopas at dbtopas.lt>
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

#include "hbapi.h"
#include "hbapierr.h"
#include "hbapiitm.h"

HB_FUNC( HB_STRXOR )
{
   PHB_ITEM pItem = hb_param( 1, HB_IT_STRING );

   if( pItem )
   {
      PHB_ITEM     pItem2;
      ULONG        ulLen1, ulLen2, ul, ul2;
      const char * pStr1;
      const char * pStr2;
      char *       pRet;

      pStr1 = hb_itemGetCPtr( pItem );
      ulLen1 = hb_itemGetCLen( pItem );

      if( ( pItem2 = hb_param( 2, HB_IT_STRING ) ) != NULL )
      {
         ulLen2 = hb_itemGetCLen( pItem2 );
         if( ulLen2 )
         {
            pStr2 = hb_itemGetCPtr( pItem2 );

            pRet = ( char * ) hb_xgrab( ulLen1 + 1 );
            memcpy( pRet, pStr1, ulLen1 + 1 );
            ul2 = 0;
            for( ul = 0; ul < ulLen1; ul++ )
            {
               pRet[ ul ] ^= pStr2[ ul2 ];
               if( ++ul2 == ulLen2 )
                  ul2 = 0;
            }
            hb_retclen_buffer( pRet, ulLen1 );
         }
         else
            hb_itemReturn( pItem );

         return;
      }
      else if( ( pItem2 = hb_param( 2, HB_IT_NUMERIC ) ) != NULL )
      {
         char bChar = ( char ) hb_itemGetNI( pItem2 );

         if( bChar )
         {
            pRet = ( char * ) hb_xgrab( ulLen1 + 1 );
            memcpy( pRet, pStr1, ulLen1 + 1 );
            for( ul = 0; ul < ulLen1; ul++ )
               pRet[ ul ] ^= bChar;

            hb_retclen_buffer( pRet, ulLen1 );
         }
         else
            hb_itemReturn( pItem );

         return;
      }
   }

   hb_errRT_BASE_SubstR( EG_ARG, 3012, NULL, HB_ERR_FUNCNAME, HB_ERR_ARGS_BASEPARAMS );
}
