/*
 * $Id: msgskwin.c 13174 2009-12-09 14:33:48Z druzus $
 */

/*
 * Harbour Project source code:
 * Language Support Module (SKWIN) WIN1250
 *
 * Copyright 2008 Gyula Bartal <bartal@tauris-danubius.sk> (from msgcswin.c)
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

/* Language name: Slovak */
/* ISO language code (2 chars): SK */
/* Codepage: 1250 */

#include "hbapilng.h"

static HB_LANG s_lang =
{
   {
      /* Identification */

      "SKWIN",                     /* ID */
      "Slovak",                    /* Name (in English) */
      "Slovensky",                 /* Name (in native language) */
      "SK",                        /* RFC ID */
      "1250",                      /* Codepage */
      "",                          /* Version */

      /* Month names */

      "janur",
      "februr",
      "marec",
      "aprl",
      "mj",
      "jn",
      "jl",
      "august",
      "september",
      "oktber",
      "november",
      "december",

      /* Day names */

      "nedea",
      "pondelok",
      "utorok",
      "streda",
      "tvrtok",
      "piatok",
      "sobota",

      /* CA-Cl*pper compatible natmsg items */

      "Dtabze          #  Vety      Aktualizcia Vekos",
      "Chcete viac prkladov?",
      "Strana",
      "** Medziset **",
      "* Medzimedziset *",
      "*** Set ***",
      "Ins",
      "   ",
      "Chybn dtum",
      "Rozsah: ",
      " - ",
      "A/N",
      "CHYBN VRAZ",

      /* Error description names */

      "Neznm chyba",
      "Chyba argumentu",
      "Chyba medz",
      "Preplnenie reazca",
      "Preplnenie sla",
      "Delenie nulou",
      "Numerick chyba",
      "Chyba syntaxe",
      "Opercia prli komplexn",
      "",
      "",
      "Nedostatok pamte",
      "Nedefinovan funkcia",
      "Neznm metda",
      "Premenn neexistuje",
      "Oblas neexistuje",
      "Neznma premenn",
      "Nepovolen znaky v oblasti",
      "Oblas u pouit",
      "",
      "Chyba vytvorenia",
      "Chyba otvorenia",
      "Chyba zatvorenia",
      "Chyba tania",
      "Chyba zpisu",
      "Chyba tlae",
      "",
      "",
      "",
      "",
      "Nepodporovna opercia",
      "Prekroen limit",
      "Index pokoden",
      "Chyba typu dt",
      "Chyba dky dt",
      "Nepouit pracovn oblas ",
      "Nezoraden pracovn oblas",
      "Nutn vhradn prstup",
      "Uzamknutie nutn",
      "Zlyhanie zmka pri pridvnie",
      "Zlyhanie zmka",
      "",
      "",
      "",
      "",
      "prstup k polom",
      "priradenie k pole",
      "zmena dimenze pole",
      "nie je polom",
      "podmienka",

       /* Internal error names */

      "Unrecoverable error %d: ",
      "Error recovery failure",
      "No ERRORBLOCK() for error",
      "Too many recursive error handler calls",
      "RDD invalid or failed to load",
      "Invalid method type from %s",
      "hb_xgrab can't allocate memory",
      "hb_xrealloc called with a NULL pointer",
      "hb_xrealloc called with an invalid pointer",
      "hb_xrealloc can't reallocate memory",
      "hb_xfree called with an invalid pointer",
      "hb_xfree called with a NULL pointer",
      "Can\'t locate the starting procedure: \'%s\'",
      "No starting procedure",
      "Unsupported VM opcode",
      "Symbol item expected from %s",
      "Invalid symbol type for self from %s",
      "Codeblock expected from %s",
      "Incorrect item type on the stack trying to pop from %s",
      "Stack underflow",
      "An item was going to be copied to itself from %s",
      "Invalid symbol item passed as memvar %s",
      "Memory buffer overflow",
      "hb_xgrab requested to allocate zero bytes",
      "hb_xrealloc requested to resize to zero bytes",
      "hb_xalloc requested to allocate zero bytes",

      /* Texts */

      "DD.MM.YYYY",
      "A",
      "N"
   }
};

#define HB_LANG_ID      SKWIN
#include "hbmsgreg.h"
