/*
 * $Id: strasint.c 11712 2009-07-11 05:46:08Z vszakats $
 */

/*****************************************************************************
* Function: _GT_Internal_StringAsInt()                                       *
* Syntax..: int _GT_Internal_StringAsInt(char *String, int Start, int End)   *
* Usage...: Convert a numeric value in a string to an int value.             *
* By......: David A Pearson                                                  *
*****************************************************************************/

#include "hbapi.h"

int _GT_Internal_StringAsInt(char *String, int Start, int End)
{
   int  Decimal = 1;
   int  Digit;
   int  Value   = 0;

   HB_TRACE(HB_TR_DEBUG, ("_GT_Internal_StringAsInt(%s, %d, %d)", String, Start, End));

   for (Digit = End; Digit >= Start; Digit--)
     {
       if (HB_ISDIGIT(String[Digit]))
         {
           Value   += (String[Digit] - 0x30) * Decimal;
           Decimal *= 0xA;
         }
     }
   return Value;
}
