/*
 *  $Id: misc3.c 10217 2009-02-10 03:10:57Z druzus $
 */

/*
 * Harbour Project source code:
 *   CT3 Miscellaneous functions: - KBDSTAT()
 *
 * Copyright 2005 Pavel Tsarenko <tpe2@mail.ru>
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

#include "hbapi.h"
#include "hbapigt.h"
#include "hbapiitm.h"

HB_FUNC( KBDSTAT )
{
   int iRet = 0;
   HB_GT_INFO gtInfo;

   memset( &gtInfo, 0, sizeof( gtInfo ) );

   hb_gtInfo( HB_GTI_KBDSHIFTS, &gtInfo );

   if( gtInfo.pResult )
   {
      int iState = hb_itemGetNI( gtInfo.pResult );

      hb_itemRelease( gtInfo.pResult );
      if( iState & HB_GTI_KBD_SHIFT )
         iRet |= 0x01;
      if( iState & HB_GTI_KBD_CTRL )
         iRet |= 0x04;
      if( iState & HB_GTI_KBD_ALT )
         iRet |= 0x08;
      if( iState & HB_GTI_KBD_SCROLOCK )
         iRet |= 0x10;
      if( iState & HB_GTI_KBD_NUMLOCK )
         iRet |= 0x20;
      if( iState & HB_GTI_KBD_CAPSLOCK )
         iRet |= 0x40;
      if( iState & HB_GTI_KBD_INSERT )
         iRet |= 0x80;
   }

   hb_retni( iRet );
}
