/*
 *  $Id: misc1.c 11685 2009-07-09 21:22:22Z vszakats $
 */

/*
 * Harbour Project source code:
 *   CT3 Miscellaneous functions: - XTOC()
 *
 * Copyright 2002 Walter Negro - FOEESITRA" <waltern@foeesitra.org.ar>
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

#include "ct.h"


/*  $DOC$
 *  $FUNCNAME$
 *      XTOC()
 *  $CATEGORY$
 *      CT3 miscellaneous functions
 *  $ONELINER$
 *  $SYNTAX$
 *      XTOC( <expValue> ) --> cValue
 *
 *  $ARGUMENTS$
 *      <expValue> Designate an expression of some of the following data
 *      type: NUMBER, CHARACTER, DATE, LOGICAL.
 *
 *  $RETURNS$
 *      XTOC() return a string with the representation of data type of
 *      expValue.
 *
 *  $DESCRIPTION$
 *      Each data type always returns a string with a particular fixed length:
 *
 *      -----------------------------------------------------------
 *      Data Type    Result Length      Similar function
 *      -----------------------------------------------------------
 *      Numeric      sizeof( DOUBLE )   FTOC()
 *      Logical      1
 *      Date         8                  DTOS()
 *      String       Unchanged
 *      -----------------------------------------------------------
 *
 *      TODO: add documentation
 *  $EXAMPLES$
 *  $TESTS$
 *  $STATUS$
 *      Started
 *  $COMPLIANCE$
 *  $PLATFORMS$
 *      All
 *  $FILES$
 *      Source is misc1.c, library is libct.
 *  $SEEALSO$
 *      CTOF(), FTOC()
 *  $END$
 */

HB_FUNC( XTOC )
{
   if( HB_ISCHAR( 1 ) )
      hb_retc( hb_parc( 1 ) );
   else if( HB_ISDATE( 1 ) )
      hb_retc( hb_pards( 1 ) );
   else if( HB_ISTIMESTAMP( 1 ) )
   {
      char szDateTime[ 18 ];
      hb_retc( hb_itemGetTS( hb_param( 1, HB_IT_TIMESTAMP ), szDateTime ) );
   }
   else if( HB_ISNUM( 1 ) )
   {
      char buf[ sizeof( double ) ];
      double d = hb_parnd( 1 );

      HB_PUT_LE_DOUBLE( buf, d );
      hb_retclen( buf, sizeof( buf ) );
   }
   else if( HB_ISLOG( 1 ) )
      hb_retclen( hb_parl( 1 ) ? "T" : "F", 1 );
   else
      hb_itemReturn( hb_param( 1, HB_IT_ANY ) );
}
