Ro=300; Rs=4; Co=.12 10^-12; gm=1/20; Cgs=.7 10^-12; Zo=50;        
BeginPackage["RF`"]

p::usage="p[x,y] gives the impedance of x in parallel with y"

ToReal::usage="ToReal[x] gives the real and imageing parts of x"

AttenuationOfButterworth::usage="AttenuationOfButterworth[f, fc, k] gives
the attenuation of a Butterworth filter with k elements, at f, if the -3.01dB
frequency is fc"

Coax::usage = "Coax[r,R, Er] Gives the capacitance per metre, inductance
per metre and characteristic impedance, of a coaxial cable of inner radius r,
outer radius R, with a relative dielectric permittivity Er." 

InductanceOfCoil::usage="InductanceOfCoil[diameter, turns, length]
calculates the inductance (in H) of a coil. Dimensions in mm, adapted 
from ARRL manual, 1991, pp2-17"

InductanceOfStrip::usage="InductanceOfStrip[length, width, thickness]
calculates the inductance (in H) of a flat strip. Dimensions in mm, adapted 
from ARRL manual, 1991, pp2-20."


InductanceOfWire::usage="InducatanceOfWire[radius, length] calculates the 
inductance (in H) of a straight wire at low frequencies. Dimensions in mm.
From 1991 ARRL manual."

MatchToFifty::usage="MatchToFifty[R, X] makes  a 50 resistor look like a given
reactance R + I X. This designs a network that looks like R + i X. If the 
circuit (say drain of FET) presents a + I b, then you will need a network that
looks like a - I b for maximum power transfer.\n
-----------X1-----------------\n
|                 |\n
|                 |\n
50                X2         <- R + i X\n
|                 |\n
|                 |\n
-----------------------------\n"

ComplexLoad::usage="ComplexLoad[R0 (source) , X0 (source), r (load), r (load)] 
matches a complex source to a complex load, where source < load, but see below. 
Use a series reactance (X1) from source to load, and a parallel
reactance (X2) across the load. I'm not sure of exactly what loads can 
be matched. Note: This designs a network that looks like R + i X. If the
circuit presents this, you probably want to enter R - i X. "


RectangularCoax::usage="RectangularCoax[diameter,width,height,Er] calculates the 
characteristic impedance of a rectangular coaxial line with a circular inner
conductor. Uncertainty said to 0.5% for diameter/height <= 0.65. Source Handbook
of Microwave and Optical Components, Volume 1, edited by K. Chang, 1989."

StripLine::usage ="StripLine[w,h,Er] gives the characteristic impedance of a
stripline (double sided PCB, one side ground plane), given the width 'w' (m), height
'h' (m) and 'Er'  of the material. Source of data from 'The UHF Compendium'
K. Weiner, Part 1 and 2, Verlag Rudolf Schmidt; correction marked in my copy.
Note: As long as 'w' and 'h' are given in the same units, they can be mm,
m, inches etc."

SMESFET::usage="SMESFET[freq,Zo,Rs,Cgs,Ro,Co,gm] gives the 4 S parameters
S11, S12, S21 and S22 of a unilateral MESFET (hence S12=0), using the 
equivalent circuit in my MSc notes. All units are SI"


TerminatedLine::usage ="TerminatedLine[Zo,Zl,B,l] calculates the impedance of a 
terminated line, length l (m), propagation constant B, of characteristic impedance
Zo terminated in Zl"

TwinWire::usage = "TwinWire[d,s,Er] Gives the capacitance per metre, inductance
per metre and characteristic impedance of  two parallel wires, of diameter d,
spaced s apart, with a relative dielectric permittivity Er."

UnknownC::usage="UnknownC[freq, Zo, length, type] gives the capacitance (in pF)
required to resonate a line of length 'length' (m) with characteristic impedance
'Zo' of 'type'  'Short' or 'Open' at a frequency of 'freq' (MHz)."


Begin["`Private`"] 

p[x_, y_]:= (x y )/(x + y)

AttenuationOfButterworth[f_, fc_, k_]:=10 Log[10, (1+ (f/fc)^(2 k) )] //N 
Coax[r_, R_, Er_] := 
     Block[{c, l,z},
        c = N[2 Pi  8.8542 10^-12 Er/ Log[R/r]];
        l = N[2 10^-7 Log[R/r]];
        z = Sqrt[l/c];
        Return[{c "F/m",l "H/m",z "Ohms"}]
       ]
InductanceOfStrip[B_, W_, H_]:=
      Block[{},
           b=B/25.4; (* Original formula assumes inches *)
           w=W/25.4;
           h=H/25.4;
           N[0.00505 10^-6  b (Log[2 b / (w + h)] + .5 + .2235(w + h) / b)]
      ]

ToReal[x_]:=
        Block[ {a,b,c},
        a=Numerator[x] * Conjugate[ Denominator[x]];
        b=Expand[ Denominator[x] * Conjugate[ Denominator[x]]];
        Print[a];
        Print[b];
        c=a/b;
        Return[c]
        ]

InductanceOfCoil[D_, n_, L_]:=
      Block[{},
           d=D/25.4;
           l=L/25.4;
           If[ l < 0.4 d, Print["Formulae may show significant errors"]];
           N[ 10^-6 d^2 n^2 / (18 d + 40 l)]
      ]

InductanceOfWire[a_, b_]:=N[10^-6 0.0002 b ( Log[2 b / a] - .75)]

MatchToFifty[r_, x_]:=
      Block[{d},
      d=50^2 + (X1+X2)^2;
      NSolve[{r==50 X2^2  / d, x== (2500 X2 + X1^2 X2 + X1 X2^2) /d },{X1,X2}]
      ]

ComplexLoad[R0_, X0_, r_, x_]:=
      Block[{d},
      d=R0^2 +(X0+X1+X2)^2;
      NSolve[{r==-(X0 X2+X1 X2)  / d, x== (R0 X2) /d },{X1,X2}]
      ]

RectangularCoax[d_Positive, ww_, bb_, Er_]:= 
     Block[{A,B,w,b},
      If[ ww < bb,
           temp=bb; b=ww; w=temp; 
      ,w=ww;b=bb;
      ];
      B=Tanh[2.2 (w/b - 1.0)];
      A=(10 - 2.1(d/b)^3) B;
      Return[N[  ( 60 Log[1.0787 b / d] + A)/Sqrt[Er]  ] ]
     ] /; NumberQ[N[d]] && NumberQ[N[ww]] && NumberQ[N[bb]] && NumberQ[N[Er]] 

Coax[r_, R_, Er_] := 
     Block[{c, l,z},
        c = N[2 Pi  8.8542 10^-12 Er/ Log[R/r]];
        l = N[2 10^-7 Log[R/r]];
        z = Sqrt[l/c];
        Return[{c "F/m",l "H/m",z "Ohms"}]
       ]
       
TwinWire[d_, s_, Er_] :=
      Block[{c,l,z},
      c = N[Pi 8.8542 10^-12 Er / ArcCosh[s/d]];
      l = N[4 10^-7 ArcCosh[s/d]];
      z = Sqrt[l/c];
      Return[{c "F/m",l "H/m", z "Ohms"}]
      ]

StripLine[w_, h_, er_] :=
      Block[{z, eeff, f},
      If [w/h <= 1, f = (1 + 12 h /w) ^ -0.5 + 0.04 ((1 - w/h) ^ 2)];
      If [w/h > 1, f = (1 + 12 h /w ) ^ -0.5];
      eeff=0.5 (er + 1) + 0.5 (er - 1 ) f;   (* the effective Er, tacking into account the two
permittivities *)
      If[ w/h < 1, z = N[60*Log[8*(h/w) + 0.25 * (w/h) ] /Sqrt[eeff] ]  ];
      If[ w/h >= 1, z = N[(120 * Pi/ Sqrt[eeff]) * 1/( (w/h + 1.393 + .667 * Log[ w/h + 1.44]))
]];
      Return[z]
      ]

UnknownC[freq_, ZL_, length_, type_]:=
      Block[{c}, 
      If[ ToString[type] == "Short", 
      c = 10^12 Cot[  2 Pi length/ (300/freq)]  / (2 Pi freq 10^6 ZL) ];
      If[ ToString[type] == "Open", 
      c = - 10^12 Tan[  2 Pi length/ (300/freq)]  / (2 Pi freq 10^6 ZL) ];
      Return[N[c]]
      ]

TerminatedLine[Zo_,Zl_,B_,l_]:=
      Return[Zo*(Zl Cos[B l] + I Zo Sin[B l])/(Zo Cos[B l] + I Zl Sin[B l])]//N

SMESFET[freq_,Zo_,Rs_,Cgs_,Ro_,Co_,gm_]:=
      Block[{w,s11,s12,s21,s22,s, S11, S12, S21, S22},
      w = 2 Pi freq //N;

      s11=(w Cgs (Rs-Zo) -I)/(w Cgs (Rs + Zo) -I);
      s12=0;  
      s21=(gm Ro Zo (1+s11))/((1 + I w Cgs Rs)(Zo + Ro + I w Co Zo Ro));
      s22=(Ro-Zo - I w Co Ro Zo)/(Ro + Zo + I w Co Ro Zo);
      
puff={freq/10^9,Abs[s11],Arg[s11]/Degree//N,Abs[s21],Arg[s21]/Degree//N,Abs[s12],Arg[s12]
/Degree//N,Abs[s22],Arg[s22]/Degree//N};
      Return[puff]
      ]
End[]
EndPackage[]
           
