;====================================================================
;	Out message to the RS-232
;
Msg:
                push    PSW
                push    ACC
                push    DPH
                push    DPL
                mov	A,R0
                push	ACC

                mov     R0,SP
                dec     R0
                dec     R0
                dec     R0
                dec     R0
                dec     R0
                mov     DPH,@R0
                dec     R0
                mov     DPL,@R0
Msg_L:
		clr     A
                movc    A,@A+DPTR
                jz      MsgEnd

		lcall	SymOut
                inc     DPTR
                sjmp    Msg_L
MsgEnd:
		mov     @R0,DPL
                inc     R0
                mov     @R0,DPH

                pop     ACC
                mov	R0,A
                pop     DPL
                pop     DPH
                pop     ACC
                pop     PSW
                ret
;====================================================================
;       Output low nibble of ACC to the RS-232
;
NibbleOut:
		push	ACC
		push	PSW
		anl     A,#00001111b
                clr     C
                subb    A,#10
                jc      NibbleOut_1
                add     A,#'A'-'0'-10
NibbleOut_1:
		add     A,#'0'+10
                sjmp    SymOut_1
;---------------------------------------------------------------------
;       Output Symbol from ACC to the RS-232 via Tx_Buffer
;
SymOut:
		push	ACC
		push	PSW
SymOut_1:

SymOut_Wait:

                jb      Tx_FULL,SymOut_Wait

		push	IE
		clr	ES

                jnb     Tx_EMPTY,SymOut_Queue

                clr     Tx_EMPTY	; Queue is not empty now
                mov	SBUF,A		; put to the Tx shift register
                sjmp	Sym_Out_End
SymOut_Queue:

                push    B
                mov     B,R0
                push    B

                mov     R0,Out_Head
                mov     @R0,A
                inc     R0
                cjne    R0,#Tx_Buffer_End,Sym_Out_Q0

                mov     R0,#Tx_Buffer_Begin
Sym_Out_Q0:
                mov     Out_Head,R0

                inc     R0
                cjne    R0,#Tx_Buffer_End,Sym_Out_Q1

                mov     R0,#Tx_Buffer_Begin
Sym_Out_Q1:
                mov     A,R0
                cjne    A,Out_Tail,Sym_Out_Q3

                setb    Tx_FULL
Sym_Out_Q3:
                pop     B
                mov     R0,B
                pop     B
Sym_Out_End:
		pop	IE
		pop	PSW
		pop	ACC
                ret
;====================================================================
;  Out A as a hexadecimal
;
HexOutA:
                swap    A
                lcall   NibbleOut
                swap    A
                lcall   NibbleOut
                ret
;====================================================================
;  Out A as a decimal
;
DecOutA:
		push    PSW

                push	B
                mov	B,R0
                push	B
                mov	B,R1
                push	B
                mov	B,R2
                push	B

                mov     R0,#8
                mov     R1,#0
                mov     R2,#0

Dec_L           rlc     A
                xch     A,R1
                addc    A,ACC
                da      A
                xch     A,R1
                xch     A,R2
                addc    A,ACC
                xch     A,R2
                djnz    R0,Dec_L

                mov     A,R2
                lcall   NibbleOut

                mov     A,R1
                swap    A
                lcall   NibbleOut

                mov     A,R1
                lcall   NibbleOut

                pop     B
                mov	R2,B
                pop     B
                mov	R1,B
                pop     B
                mov	R0,B
                pop     B
                pop     PSW
                ret
;====================================================================
;	Translate latin symbols into upper register /Work/
;
ToUpper:
		clr	ACC.7
		clr	C
		subb	A,#60h
		jc	ToUpper_001

		subb	A,#20h
ToUpper_001:
		add	A,#60h
		ret
;====================================================================
; Convert symbols "0..9,A..F,a..f" to lower nibble
;
;	CY = 1 if not hex digit
;
Ascii_to_Hex:
		clr     C
                subb    A,#'0'
                jc      A_to_Hex_End

                subb    A,#10
                jc      A_to_Hex_add10

                subb    A,#'A'-'9'-1
                jc      A_to_Hex_End

                subb    A,#6
                jc      A_to_Hex_add16

                subb    A,#'a'-'F'-1
                jc      A_to_Hex_End

                subb    A,#6
                cpl     C
                jc      A_to_Hex_End

A_to_Hex_add16:
		add     A,#6
A_to_Hex_add10:
		add     A,#10
                clr     C
A_to_Hex_End:
		ret
;====================================================================
; Convert symbols "0..9" to lower nibble
;
;	CY = 1 if not decimal digit
;
Ascii_to_Dec:
		clr     C
                subb    A,#'0'
                jc      A_to_Dec_End

                subb    A,#10
                cpl	C
                jc      A_to_Dec_End

		add     A,#10
		clr	C
A_to_Dec_End:
		ret
;====================================================================
Is_FS:
		push	ACC
		mov	A,Rx_Buf+0
		cjne	A,#FS_0,IF_Not_Idle
		mov	A,Rx_Buf+1
		cjne	A,#FS_1,IF_Not_Idle
		mov	A,Rx_Buf+2
		cjne	A,#FS_2,IF_Not_Idle
		mov	A,Rx_Buf+3
		cjne	A,#FS_3,IF_Not_Idle
		setb	C
		sjmp	IF_Idle
IF_Not_Idle:
		clr	C
IF_Idle:
		pop	ACC
		ret
;====================================================================
Is_Idle:
		push	ACC
		mov	A,Rx_Buf+0
		cjne	A,#Idle_0,II_Not_Idle
		mov	A,Rx_Buf+1
		cjne	A,#Idle_1,II_Not_Idle
		mov	A,Rx_Buf+2
		cjne	A,#Idle_2,II_Not_Idle
		mov	A,Rx_Buf+3
		cjne	A,#Idle_3,II_Not_Idle
		setb	C
		sjmp	II_Idle
II_Not_Idle:
		clr	C
II_Idle:
		pop	ACC
		ret
;====================================================================