;=====================================================================
Intr_0:
		ljmp	Cool_Reset
;=====================================================================
Intr_1:
		ljmp	Cool_Reset
;=====================================================================
Timer_0:
		reti
;=====================================================================
Timer_1:	; used as a baud rate generator
		reti
;=====================================================================
; Used in Rx-ing POCSAG
;
Timer_2:
		clr	TF2			; 1
		jb	Timer2_Rx,T0_Receiving	; 2
;-------------------------------
; Correlator	 (Freq = 9600 baud)
;
		inc	Cnt104mks		; 1
                push    PSW                     ; 2
                push    ACC                     ; 2
                mov     A,R0                    ; 1
                push    ACC                     ; 2
                push    DPH                     ; 2
                push    DPL                     ; 2

                mov     C,DIN                   ; 1
                mov     A,Rx_Byte               ; 1
                rlc     A                       ; 1
                mov     Rx_Byte,A               ; 1

                mov     A,#Koeff_Current        ; 1
		add	A,Rx_Bit_Count		; 1
		mov	R0,A			; 1 ; R0 - address of current coeff

                mov     DPTR,#Corr_Table        ; 2
                mov     A,Bytes_Count           ; 1
                movc    A,@A+DPTR               ; 2 ; A - corr_coeff
                xrl     A,Rx_Byte_Rcvd          ; 1
                mov     DPTR,#Quontity_Ones     ; 2
                movc    A,@A+DPTR               ; 2
                add     A,@R0                   ; 1
                mov     @R0,A                   ; 1

                inc     Rx_Bit_Count            ; 1
		mov	A,Rx_Bit_Count		; 1
		cjne	A,#8,T0_Not_Full_Byte	; 2

                mov     Rx_Byte_Rcvd,Rx_Byte    ; 2
                mov     Rx_Bit_Count,#0         ; 2
T0_Not_Full_Byte:

		inc	Bytes_Count		; 1 total bytes
                mov     A,Bytes_Count           ; 1
                cjne    A,#150,T0_Correlate     ; 2

                setb    Corr_Complete           ; 1
                mov     Koeff_Derived+0,Koeff_Current+0
                mov     Koeff_Derived+1,Koeff_Current+1
                mov     Koeff_Derived+2,Koeff_Current+2
                mov     Koeff_Derived+3,Koeff_Current+3
                mov     Koeff_Derived+4,Koeff_Current+4
                mov     Koeff_Derived+5,Koeff_Current+5 ; 12
                clr     A                       ; 1
		mov	Bytes_Count,A		; 1
		mov	Rx_Bit_Count,A		; 1
                mov     Koeff_Current+0,A
                mov     Koeff_Current+1,A
                mov     Koeff_Current+2,A
                mov     Koeff_Current+3,A
                mov     Koeff_Current+4,A
                mov     Koeff_Current+5,A	; 6
T0_Correlate:

                pop     DPL                     ; 2
                pop     DPH                     ; 2
		pop	ACC			; 2
                mov     R0,A                    ; 1
		pop	ACC			; 2
		pop	PSW			; 2
		reti				; 2 ; Total = 80 ticks
;================================================
; Used in Rx-ing POCSAG (Freq = 4096,9600,19200 baud)
;
T0_Receiving:
		push	PSW			;2
		mov	Keep_ACC,A		;1

		mov	C,DIN			;1
		mov	A,Rx_Byte		;1
		rlc	A			;1
		mov	Rx_Byte,A		;1
                anl     A,#00111100b            ;1

		add	A,#Quontity_Ones-T0_tbl1;1
		movc	A,@A+PC			;2
T0_tbl1:
		xch	A,DIN_Keep		;1
		xrl	A,DIN_Keep		;1
                jnb     ACC.1,T0_No_Trans       ;2

                jb      Track_Count.1,T0_Track_0;2

		inc	Track_Count		;1
T0_No_Trans:
		inc	Track_Count		;1
T0_Track_0:
		jbc	Track_Count.3,Bit_Rxd	;1
T0_End:
		mov	A,Keep_ACC		;1
		pop	PSW			;2
		reti				;2 = 26 (+6)
						; TOTAL = 33
						; 19200 - 80 ticks
						; free = 45 ticks *6 = 270 ticks
Bit_Rxd:
		ljmp	Bit_Received	;2
;----------------------------------------------
; Quantity of 1 in binary code
;
Quontity_Ones:
	db	0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4
	db	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
	db	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
	db	1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
	db	2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6
	db	3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
	db	3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7
	db	4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8
;----------------------------------------------
Bit_Received:
		mov	A,Keep_ACC		;1
		push	ACC			;2
		lcall	Virtual_RETI		;2+2 ; Reset IRQ system

		mov	A,DIN_Keep		;1
		xrl	A,Rx_Complement		;1
		mov	C,ACC.2			;1

		mov	A,Rx_DWord+3		;1
		rlc	A			;1
		mov	Rx_DWord+3,A		;1
		mov	A,Rx_DWord+2
		rlc	A
		mov	Rx_DWord+2,A		;=3
		mov	A,Rx_DWord+1
		rlc	A
		mov	Rx_DWord+1,A		;=3
		mov	A,Rx_DWord+0
		rlc	A
		mov	Rx_DWord+0,A		;=3
		inc	Rx_Bit_Count		;1
		mov	A,Rx_Bit_Count		;1
		cjne	A,Rx_Bit_Capture,BR_End	;2 => 26(+2) = 28
;---------------
		mov	Rx_Buf+3,Rx_DWord+3	;2
		mov	Rx_Buf+2,Rx_DWord+2	;2
		mov	Rx_Buf+1,Rx_DWord+1	;2
		mov	Rx_Buf+0,Rx_DWord+0	;2

		mov	Rx_Bit_Count,#0		;2
		setb	Rx_Buf_Ready		;1 => 11
;---------------
BR_End:
		pop	ACC			;2
		pop	PSW			;2
		ret				;2 => 34(+11)
;=====================================================================
;  SIO Tx and Rx Interrupr handler
;
Int_SIO:
		push	PSW
		push	ACC
		mov	A,R0
		push	ACC

		jnb	TI,Int_SIO_If_Rx
;-----------------------------------------------
; SIO Tx handler : - Work with Tx_Buffer in IRAM
;
Int_SIO_Tx:
		clr	TI

		mov	R0,Out_Tail
		mov	A,R0
		cjne	A,Out_Head,Int_SIO_Tx_01

		setb	Tx_EMPTY
		sjmp	Int_SIO_Tx_03
Int_SIO_Tx_01:
		mov	A,@R0
		mov	SBUF,A
		inc	R0
		cjne	R0,#Tx_Buffer_End,Int_SIO_Tx_02

		mov	R0,#Tx_Buffer_Begin
Int_SIO_Tx_02:
		mov	Out_Tail,R0
Int_SIO_Tx_03:

Int_SIO_Tx_End:

                clr     C
                mov     A,Out_Tail
                subb    A,Out_Head
                jnc     Int_SIO_Tx_001

                add     A,#(Tx_Buffer_Begin - Tx_Buffer_End)
Int_SIO_Tx_001:
                clr     C
                subb    A,#4
                jc      Int_SIO_Tx_002

                clr     Tx_FULL ; if 4 free bytes
Int_SIO_Tx_002
;-----------------------------------------------
Int_SIO_If_Rx:
		jnb	RI,Int_SIO_End
;-----------------------------------------------
; SIO Rx handler : - Work with Rx_Buffer in RAM
;
Int_SIO_Rx:
		clr	RI

		mov	A,SBUF
                mov     R0,In_Head
                mov	@R0,A
                inc     R0
                cjne    R0,#Rx_Buffer_End,Int_SIO_Rx_01

                mov     R0,#Rx_Buffer_Begin
Int_SIO_Rx_01:
                mov     In_Head,R0
Int_SIO_End:
                pop	ACC
		mov	R0,A
		pop	ACC
		pop	PSW
		reti
;=====================================================================
Virtual_RETI
		reti
;=====================================================================