//
//    Copyright 2004, Thomas C. McDermott, N5EG
//    This file is part of VNAR - the Vector Network Analyzer program.
//
//    VNAR is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    VNAR is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with VNAR, if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#pragma once
#include "DisplayRoutines.h"
#include "USB_EZ_interface.h"
#include <math.h>

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;


namespace VNAR2
{
	/// <summary> 
	/// Summary for Calibration
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class Calibration : public System::Windows::Forms::Form
	{
	public: 
		Calibration(CalDataSet* CalDS, VNADevice* VNADev)
		{
			InitializeComponent();
			VNA = VNADev;			// VNA hardware device
			Cal = CalDS;			// Calibration Dataset
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::Button *  shortCal;
	private: System::Windows::Forms::Button *  openCal;
	private: System::Windows::Forms::Button *  termCal;
	private: System::Windows::Forms::Button *  thruCal;
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::Button *  CancelButton;
	private: System::Windows::Forms::Label *  label2;
	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::Label *  label4;
	private: System::Windows::Forms::Label *  label5;
	private: System::Windows::Forms::Label *  statShort;



	private: System::Windows::Forms::Button *  calSave;
	private: System::Windows::Forms::Label *  label6;
	private: System::Windows::Forms::Label *  statOpen;
	private: System::Windows::Forms::Label *  statTerm;
	private: System::Windows::Forms::Label *  statThru;
	private: System::Windows::Forms::ProgressBar *  calProgressBar;




	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container* components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			System::Resources::ResourceManager *  resources = new System::Resources::ResourceManager(__typeof(VNAR2::Calibration));
			this->shortCal = new System::Windows::Forms::Button();
			this->openCal = new System::Windows::Forms::Button();
			this->termCal = new System::Windows::Forms::Button();
			this->thruCal = new System::Windows::Forms::Button();
			this->label1 = new System::Windows::Forms::Label();
			this->CancelButton = new System::Windows::Forms::Button();
			this->label2 = new System::Windows::Forms::Label();
			this->label3 = new System::Windows::Forms::Label();
			this->label4 = new System::Windows::Forms::Label();
			this->label5 = new System::Windows::Forms::Label();
			this->statShort = new System::Windows::Forms::Label();
			this->calSave = new System::Windows::Forms::Button();
			this->label6 = new System::Windows::Forms::Label();
			this->statOpen = new System::Windows::Forms::Label();
			this->statTerm = new System::Windows::Forms::Label();
			this->statThru = new System::Windows::Forms::Label();
			this->calProgressBar = new System::Windows::Forms::ProgressBar();
			this->SuspendLayout();
			// 
			// shortCal
			// 
			this->shortCal->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->shortCal->Location = System::Drawing::Point(408, 80);
			this->shortCal->Name = S"shortCal";
			this->shortCal->Size = System::Drawing::Size(184, 40);
			this->shortCal->TabIndex = 0;
			this->shortCal->Text = S"\"Short\" Calibration";
			this->shortCal->Click += new System::EventHandler(this, shortCal_Click);
			// 
			// openCal
			// 
			this->openCal->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->openCal->Location = System::Drawing::Point(408, 136);
			this->openCal->Name = S"openCal";
			this->openCal->Size = System::Drawing::Size(184, 40);
			this->openCal->TabIndex = 1;
			this->openCal->Text = S"\"Open\" Calibration";
			this->openCal->Click += new System::EventHandler(this, openCal_Click);
			// 
			// termCal
			// 
			this->termCal->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->termCal->Location = System::Drawing::Point(408, 192);
			this->termCal->Name = S"termCal";
			this->termCal->Size = System::Drawing::Size(184, 40);
			this->termCal->TabIndex = 2;
			this->termCal->Text = S"\"50-ohm Term\" Calibration";
			this->termCal->Click += new System::EventHandler(this, termCal_Click);
			// 
			// thruCal
			// 
			this->thruCal->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->thruCal->Location = System::Drawing::Point(408, 248);
			this->thruCal->Name = S"thruCal";
			this->thruCal->Size = System::Drawing::Size(184, 40);
			this->thruCal->TabIndex = 3;
			this->thruCal->Text = S"\"Through\" Calibration";
			this->thruCal->Click += new System::EventHandler(this, thruCal_Click);
			// 
			// label1
			// 
			this->label1->Font = new System::Drawing::Font(S"Verdana", 15.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label1->Location = System::Drawing::Point(192, 24);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(248, 23);
			this->label1->TabIndex = 4;
			this->label1->Text = S"Fixture Calibration";
			this->label1->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
			// 
			// CancelButton
			// 
			this->CancelButton->DialogResult = System::Windows::Forms::DialogResult::Cancel;
			this->CancelButton->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->CancelButton->Location = System::Drawing::Point(384, 320);
			this->CancelButton->Name = S"CancelButton";
			this->CancelButton->Size = System::Drawing::Size(96, 23);
			this->CancelButton->TabIndex = 6;
			this->CancelButton->Text = S"Cancel";
			// 
			// label2
			// 
			this->label2->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label2->ImageAlign = System::Drawing::ContentAlignment::MiddleLeft;
			this->label2->Location = System::Drawing::Point(112, 88);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(272, 32);
			this->label2->TabIndex = 7;
			this->label2->Text = S"1. Connect \'short\' to TX at measurement plane.";
			// 
			// label3
			// 
			this->label3->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label3->ImageAlign = System::Drawing::ContentAlignment::MiddleLeft;
			this->label3->Location = System::Drawing::Point(112, 144);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(272, 32);
			this->label3->TabIndex = 8;
			this->label3->Text = S"2. Connect \'open\' to TX at measurement plane.";
			// 
			// label4
			// 
			this->label4->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label4->ImageAlign = System::Drawing::ContentAlignment::MiddleLeft;
			this->label4->Location = System::Drawing::Point(112, 200);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(272, 32);
			this->label4->TabIndex = 9;
			this->label4->Text = S"3. Connect \'50-ohm termination\' to TX at measurement plane.";
			// 
			// label5
			// 
			this->label5->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label5->Location = System::Drawing::Point(112, 256);
			this->label5->Name = S"label5";
			this->label5->Size = System::Drawing::Size(280, 32);
			this->label5->TabIndex = 10;
			this->label5->Text = S"4. Connect TX through to RX at measurement plane.";
			// 
			// statShort
			// 
			this->statShort->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"statShort.Image")));
			this->statShort->Location = System::Drawing::Point(32, 88);
			this->statShort->Name = S"statShort";
			this->statShort->Size = System::Drawing::Size(32, 32);
			this->statShort->TabIndex = 11;
			this->statShort->Visible = false;
			// 
			// calSave
			// 
			this->calSave->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->calSave->Location = System::Drawing::Point(184, 320);
			this->calSave->Name = S"calSave";
			this->calSave->Size = System::Drawing::Size(152, 24);
			this->calSave->TabIndex = 15;
			this->calSave->Text = S"Save Cal Results...";
			this->calSave->Click += new System::EventHandler(this, calSave_Click);
			// 
			// label6
			// 
			this->label6->Font = new System::Drawing::Font(S"Verdana", 9.75F, System::Drawing::FontStyle::Underline, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			this->label6->Location = System::Drawing::Point(24, 56);
			this->label6->Name = S"label6";
			this->label6->Size = System::Drawing::Size(56, 23);
			this->label6->TabIndex = 16;
			this->label6->Text = S"Status";
			// 
			// statOpen
			// 
			this->statOpen->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"statOpen.Image")));
			this->statOpen->Location = System::Drawing::Point(32, 144);
			this->statOpen->Name = S"statOpen";
			this->statOpen->Size = System::Drawing::Size(32, 32);
			this->statOpen->TabIndex = 17;
			this->statOpen->Visible = false;
			// 
			// statTerm
			// 
			this->statTerm->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"statTerm.Image")));
			this->statTerm->Location = System::Drawing::Point(32, 200);
			this->statTerm->Name = S"statTerm";
			this->statTerm->Size = System::Drawing::Size(32, 32);
			this->statTerm->TabIndex = 18;
			this->statTerm->Visible = false;
			// 
			// statThru
			// 
			this->statThru->Image = (__try_cast<System::Drawing::Image *  >(resources->GetObject(S"statThru.Image")));
			this->statThru->Location = System::Drawing::Point(32, 256);
			this->statThru->Name = S"statThru";
			this->statThru->Size = System::Drawing::Size(32, 32);
			this->statThru->TabIndex = 19;
			this->statThru->Visible = false;
			// 
			// calProgressBar
			// 
			this->calProgressBar->Location = System::Drawing::Point(112, 368);
			this->calProgressBar->Maximum = 1024;
			this->calProgressBar->Name = S"calProgressBar";
			this->calProgressBar->Size = System::Drawing::Size(472, 16);
			this->calProgressBar->TabIndex = 20;
			// 
			// Calibration
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(640, 412);
			this->Controls->Add(this->calProgressBar);
			this->Controls->Add(this->statThru);
			this->Controls->Add(this->statTerm);
			this->Controls->Add(this->statOpen);
			this->Controls->Add(this->label6);
			this->Controls->Add(this->calSave);
			this->Controls->Add(this->statShort);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->CancelButton);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->thruCal);
			this->Controls->Add(this->termCal);
			this->Controls->Add(this->openCal);
			this->Controls->Add(this->shortCal);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::Fixed3D;
			this->Name = S"Calibration";
			this->Text = S"Calibration";
			this->ResumeLayout(false);

		}		

		private: VNADevice* VNA;				// Vector Network Analyzer hardware object
		private: CalDataSet* Cal;				// Calibration Data Set

	private: System::Void shortCal_Click(System::Object *  sender, System::EventArgs *  e)
			 {
				VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
				VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
				double fmagnitude;			// 0 to 1
				double fphase;				// -180 to +180	
				double& rmag = fmagnitude;
				double& rphs = fphase;
				unsigned short oldPI, oldPQ, oldMQ;

				// run a sweep of 1024 points, collecting S11 data 'short'

				for (long i=0; i<1024; i++)
				{
					// Compute spot frequency

					long long int Fdesired;
					Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

					TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;		
					TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
					TxBuf->ReplyType = 0;
					TxBuf->IntegrationCount = 1;
					TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level


					VNA->WriteRead(TxBuf, RxBuf);

					if (i==0)
					{
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}					
					else							// If 'glitch' detected during read, then re-read once
					{
						bool glitch = false;
						if (abs(oldPI - RxBuf->ReflPI) > 100) glitch = true;
						if (abs(oldPQ - RxBuf->ReflPQ) > 100) glitch = true;
						if (abs(oldMQ - RxBuf->ReflMQ) > 100) glitch = true;
						if (glitch)
							VNA->WriteRead(TxBuf, RxBuf);
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}


					// get reflection coefficient as mag/phase
					Cal->ResolveReflPolar(RxBuf->ReflPI, RxBuf->ReflPQ, RxBuf->ReflMQ, (int)Fdesired, rmag, rphs);

					// convert it to rectangular
					double fx = fmagnitude * cos(fphase * DEGR2RAD);
					double fy = fmagnitude * sin(fphase * DEGR2RAD);

					// save it as S11-meas-short
					Cal->S11shortReal[i] = fx; Cal->S11shortImag[i] = fy;

					calProgressBar->Value = i;
				}

				statShort->Visible = true;
			 }

	private: System::Void openCal_Click(System::Object *  sender, System::EventArgs *  e)
			{
				VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
				VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
				double fmagnitude;			// 0 to 1
				double fphase;				// -180 to +180	
				double& rmag = fmagnitude;
				double& rphs = fphase;
				unsigned short oldPI, oldPQ, oldMQ;

				 // run a sweep of 1024 points, collecting S11 data 'short'

				for (long i=0; i<1024; i++)
				{
					// Compute spot frequency

					long long int Fdesired;
					Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

					TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;		
					TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
					TxBuf->ReplyType = 0;
					TxBuf->IntegrationCount = 1;
					TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level


					VNA->WriteRead(TxBuf, RxBuf);

					if (i==0)
					{
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}					
					else							// If 'glitch' detected during read, then re-read once
					{
						bool glitch = false;
						if (abs(oldPI - RxBuf->ReflPI) > 100) glitch = true;
						if (abs(oldPQ - RxBuf->ReflPQ) > 100) glitch = true;
						if (abs(oldMQ - RxBuf->ReflMQ) > 100) glitch = true;
						if (glitch)
							VNA->WriteRead(TxBuf, RxBuf);
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}

					// get reflection coefficient as mag/phase
					Cal->ResolveReflPolar(RxBuf->ReflPI, RxBuf->ReflPQ, RxBuf->ReflMQ, (int)Fdesired, rmag, rphs);

					// convert it to rectangular
					double fx = fmagnitude * cos(fphase * DEGR2RAD);
					double fy = fmagnitude * sin(fphase * DEGR2RAD);

					// save it as S11-meas-short
					Cal->S11openReal[i] = fx; Cal->S11openImag[i] = fy;

					calProgressBar->Value = i;
				}

				statOpen->Visible = true;
			}

	private: System::Void termCal_Click(System::Object *  sender, System::EventArgs *  e)
			{
				VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
				VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
				double fmagnitude;			// 0 to 1
				double fphase;				// -180 to +180	
				double& rmag = fmagnitude;
				double& rphs = fphase;
				unsigned short oldPI, oldPQ, oldMQ;

				 // run a sweep of 1024 points, collecting S11 data 'short'

				for (long i=0; i<1024; i++)
				{
					// Compute spot frequency

					long long int Fdesired;
					Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

					TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;		
					TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
					TxBuf->ReplyType = 0;
					TxBuf->IntegrationCount = 1;
					TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level

					VNA->WriteRead(TxBuf, RxBuf);

					if (i==0)
					{
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}					
					else							// If 'glitch' detected during read, then re-read once
					{
						bool glitch = false;
						if (abs(oldPI - RxBuf->ReflPI) > 100) glitch = true;
						if (abs(oldPQ - RxBuf->ReflPQ) > 100) glitch = true;
						if (abs(oldMQ - RxBuf->ReflMQ) > 100) glitch = true;
						if (glitch)
							VNA->WriteRead(TxBuf, RxBuf);
						oldPI = RxBuf->ReflPI;			
						oldPQ = RxBuf->ReflPQ;
						oldMQ = RxBuf->ReflMQ;
					}

					// get reflection coefficient as mag/phase
					Cal->ResolveReflPolar(RxBuf->ReflPI, RxBuf->ReflPQ, RxBuf->ReflMQ, (int)Fdesired, rmag, rphs);

					// convert it to rectangular
					double fx = fmagnitude * cos(fphase * DEGR2RAD);
					double fy = fmagnitude * sin(fphase * DEGR2RAD);

					// save it as S11-meas-short
					Cal->S11termReal[i] = fx; Cal->S11termImag[i] = fy;

					calProgressBar->Value = i;
				}

				statTerm->Visible = true;
			}

	private: System::Void thruCal_Click(System::Object *  sender, System::EventArgs *  e)
			{
				VNA_RXBUFFER *RxBuf = new VNA_RXBUFFER;
				VNA_TXBUFFER *TxBuf = new VNA_TXBUFFER;
				double fmagnitude;			// 0 to 1
				double fphase;				// -180 to +180	
				double& rmag = fmagnitude;
				double& rphs = fphase;
				unsigned short oldPI, oldPQ, oldMQ;

				// run a sweep of 1024 points, collecting S11 data 'short'

				for (long i=0; i<1024; i++)
				{
					// Compute spot frequency

					long long int Fdesired;
					Fdesired = Convert::ToInt64(200000.0+( i*(120000000.0-200000.0)/1024.0));

					TxBuf->TxAccum = Fdesired * VNA_XTAL_CONST;		
					TxBuf->IDAClevel = MAX_DDS_LEVEL;		// Max transmit level
					TxBuf->ReplyType = 0;
					TxBuf->IntegrationCount = 1;
					TxBuf->QDAClevel = THREE_FIVEDB_LEVEL;	// Reference level


					VNA->WriteRead(TxBuf, RxBuf);

					if (i==0)
					{
						oldPI = RxBuf->TranPI;			
						oldPQ = RxBuf->TranPQ;
						oldMQ = RxBuf->TranMQ;
					}					
					else							// If 'glitch' detected during read, then re-read once
					{
						bool glitch = false;
						if (abs(oldPI - RxBuf->TranPI) > 100) glitch = true;
						if (abs(oldPQ - RxBuf->TranPQ) > 100) glitch = true;
						if (abs(oldMQ - RxBuf->TranMQ) > 100) glitch = true;
						if (glitch)
							VNA->WriteRead(TxBuf, RxBuf);
						oldPI = RxBuf->TranPI;			
						oldPQ = RxBuf->TranPQ;
						oldMQ = RxBuf->TranMQ;
					}


					// get transmission coefficient as mag/phase
					Cal->ResolveTranPolar(RxBuf->TranPI, RxBuf->TranPQ, RxBuf->TranMQ, (int)Fdesired, rmag, rphs);

					// convert it to rectangular
					double fx = fmagnitude * cos(fphase * DEGR2RAD);
					double fy = fmagnitude * sin(fphase * DEGR2RAD);

					// save it as S11-meas-short
					Cal->ThReal[i] = fx; Cal->ThImag[i] = fy;

					calProgressBar->Value = i;
				}

				statThru->Visible = true;
			}

	private: System::Void calSave_Click(System::Object *  sender, System::EventArgs *  e)
			{
				// Compute Error Terms
				CalToErrorTerms(Cal);

				// Save results to file
				SaveFileDialog* outfile = new SaveFileDialog();
				outfile->Filter = "calibration files (*.cal)|*.cal";
				outfile->AddExtension = true;
				if (outfile->ShowDialog() == DialogResult::OK)
					SaveCalDataSet(outfile, Cal);
				else
					DialogResult = DialogResult::Cancel;

				// Close window
				DialogResult = DialogResult::OK;
            }


};
}