 REM $DYNAMIC
 SHELL "BREAK ON"

 DEFINT C-D, K-N
 DEFLNG Z
 SCREEN 12

 T = 2 ^ 15 - 1
 KMOD = 37
 LIMIT = 6
 PI = 3.1415926#
 SFACTOR = 3
 PROT = -7 * PI / 32
 TROT = 3 * PI / 32
 MAXSIZE = 15000

 DEF FNA (X) = 2 * 3.1415926# * X / 360
 DEF FNY (X) = 320 * (1 + SFACTOR * X / T) - 50
 DEF FNZ (X) = 240 * (1 - SFACTOR * X / T) - 80

 DEF FNMAX (A, B, C, D)
  IF A >= B AND A >= C AND A >= D THEN X = A
  IF B >= A AND B >= C AND B >= D THEN X = B
  IF C >= A AND C >= B AND C >= D THEN X = C
  IF D >= A AND D >= B AND D >= C THEN X = D
  FNMAX = X
  END DEF

 DEF FNMIN (A, B, C, D)
  IF A <= B AND A <= C AND A <= D THEN X = A
  IF B <= A AND B <= C AND B <= D THEN X = B
  IF C <= A AND C <= B AND C <= D THEN X = C
  IF D <= A AND D <= B AND D <= C THEN X = D
  FNMIN = X
  END DEF

 DIM DX(MAXSIZE), DY(MAXSIZE), DZ(MAXSIZE), DA(MAXSIZE), DR(MAXSIZE)
 DIM A(70, 70)
 DIM X(1440), Y(1440), Z(1440)
 DX(MAXSIZE) = 32767

 INPUT "FILE TO PLOT"; F$
 OPEN F$ FOR INPUT AS #1
 REM FIND START OF DATA
 CLS
 LOCATE 1, 1
 PRINT "Reading point number:";
 DRMAX = 0

LOOP1: INPUT #1, A$
 IF MID$(A$, 1, 5) = "ANGLE" THEN GOTO LOOP2
 IF EOF(1) THEN GOTO FAILURE
 GOTO LOOP1

LOOP2: KCOUNT = 1

LOOP25: INPUT #1, A$: REM DATA POINT
 KZEN = VAL(MID$(A$, 1, 10))
 KAZI = VAL(MID$(A$, 15, 5))
 VERT = VAL(MID$(A$, 28, 11))
 HORIZ = VAL(MID$(A$, 42, 8))
 TOTAL = VAL(MID$(A$, 56, 8))

 IF KZEN >= 0 THEN KZEN = (90 - KZEN) ELSE KZEN = KZEN - 90
 B = (10 ^ (TOTAL / 20)) / LIMIT
 KRHO = T * B
 PHI = FNA(KZEN)
 THETA = FNA(KAZI) + TROT

 DX(KCOUNT) = KRHO * COS(THETA) * COS(PHI)
 DY(KCOUNT) = KRHO * SIN(THETA) * COS(PHI)
 DZ(KCOUNT) = KRHO * SIN(PHI)
 DA(KCOUNT) = MAXSIZE
 DR(KCOUNT) = KRHO: IF KRHO > DRMAX THEN DRMAX = KRHO
 DTEMP = DX(KCOUNT)
 DX(KCOUNT) = DX(KCOUNT) * COS(PROT) - DZ(KCOUNT) * SIN(PROT)
 DZ(KCOUNT) = DTEMP * SIN(PROT) + DZ(KCOUNT) * COS(PROT)

 LOCATE 1, 22
 PRINT KCOUNT
 KCOUNT = KCOUNT + 1

LOOP3: IF EOF(1) THEN GOTO FAILURE
 GOTO LOOP25

FAILURE: CLOSE #1
 
 REM SORT THE DATA
 LOCATE 2, 1
 PRINT "Sorting data point:";
 KRANKED = 2: REM # ALREADY RANKED
 IF DX(1) > DX(2) THEN DA(1) = 2: DZ(2) = 1 ELSE DA(1) = 1: DA(2) = 2

 FOR K = 3 TO KCOUNT - 1
  KTRY = KRANKED / 2
  KSTEP = KTRY
  
KIX: IF DX(K) > DX(DA(KTRY)) THEN GOTO GOUP
      IF DX(K) < DX(DA(KTRY)) THEN GOTO GODOWN
       GOTO FITIN: REM THEY ARE EQUAL

GOUP: IF KSTEP * .5 < 1 THEN GOTO FITIN
  KSTEP = (2 * KSTEP) * .25
  KTRY = KTRY + KSTEP
  GOTO KIX

GODOWN: IF KSTEP * .5 < 1 THEN GOTO FITIN
  KSTEP = (2 * KSTEP) * .25
  IF KTRY <= KSTEP THEN GOTO FITIN
  KTRY = KTRY - KSTEP
  GOTO KIX

FITIN: REM LOCATION HAS BEEN FOUND, MAKE ROOM
  
FIXIT: IF KTRY > 1 THEN IF DX(K) < DX(DA(KTRY)) THEN KTRY = KTRY - 1: GOTO FIXIT
  
FILEIT: IF KTRY < MAXSIZE THEN IF DX(K) > DX(DA(KTRY)) THEN KTRY = KTRY + 1: GOTO FILEIT

HOOP:  FOR J = KRANKED + 1 TO KTRY STEP -1
   DA(J + 1) = DA(J)
  NEXT J
  DA(KTRY) = K
  KRANKED = KRANKED + 1
  LOCATE 2, 22
  PRINT KRANKED
  NEXT K
 
  REM PLOT THE DATA
  CLS
 
  FOR J = 6 TO 15
   Z = 257 * 63: REM INT(((J - 5) / 40 + .75) * 63): REM GOLDENROD SHADES
   PALETTE J, Z
  NEXT J
  Z = 2 ^ 16 * 63 + 256 * 63 + 63: REM BRIGHT WHITE
  PALETTE 3, Z
 
  FOR J = 4 TO KRANKED
  K = DA(J)
    IF (K - 1) MOD KMOD = 0 THEN GOTO LOOP5
    IF K - (KMOD + 1) < 1 THEN GOTO LOOP5
    KY0 = FNY(DY(K))
    KZ0 = FNZ(DZ(K))
    KY1 = FNY(DY(K - 1))
    KZ1 = FNZ(DZ(K - 1))
    KY2 = FNY(DY(K - (KMOD)))
    KZ2 = FNZ(DZ(K - (KMOD)))
    KY3 = FNY(DY(K - (KMOD + 1)))
    KZ3 = FNZ(DZ(K - (KMOD + 1)))
  
    KYMIN = FNMIN(KY0, KY1, KY2, KY3)
    KYMAX = FNMAX(KY0, KY1, KY2, KY3)
    KZMIN = FNMIN(KZ0, KZ1, KZ2, KZ3)
    KZMAX = FNMAX(KZ0, KZ1, KZ2, KZ3)
    KYOFFSET = -KYMIN + 2
    KZOFFSET = 480 - KZMAX - 2

    YMID1 = KY0 / 2 + KY1 / 2
    YMID2 = KY2 / 2 + KY3 / 2
    KYMID = YMID1 / 2 + YMID2 / 2
    ZMID1 = KZ0 / 2 + KZ1 / 2
    ZMID2 = KZ2 / 2 + KZ3 / 2
    KZMID = ZMID1 / 2 + ZMID2 / 2
   
    LINE (KY0 + KYOFFSET, KZ0 + KZOFFSET)-(KY1 + KYOFFSET, KZ1 + KZOFFSET), 3
    LINE -(KY3 + KYOFFSET, KZ3 + KZOFFSET), 3
    LINE -(KY2 + KYOFFSET, KZ2 + KZOFFSET), 3
    LINE -(KY0 + KYOFFSET, KZ0 + KZOFFSET), 3
  
HOOLA: LINE (0, KZMIN + KZOFFSET - 2)-(KYMAX + KYOFFSET + 2, 479), 3, B
    KCOLOR = INT((DR(K) / DRMAX) ^ 4 * 10) + 6
    PAINT (KYMID + KYOFFSET, KZMID + KZOFFSET), KCOLOR, 3
    PAINT (KYMAX + KYOFFSET - 1, KZMIN + KZOFFSET - 1), 0, 3
    LINE (0, KZMIN + KZOFFSET - 2)-(KYMAX + KYOFFSET + 2, 479), 0, B

    GET (0, KZMIN + KZOFFSET)-(KYMAX + KYOFFSET, 479), A
    PUT (KYMIN, KZMIN + 20), A, OR

ROOF: LINE (KY0 + 2, KZ0 + 20)-(KY1 + 2, KZ1 + 20), 1
  LINE -(KY3 + 2, KZ3 + 20), 1
  LINE -(KY2 + 2, KZ2 + 20), 1
  LINE -(KY0 + 2, KZ0 + 20), 1
  LINE (0, KZMIN + KZOFFSET - 2)-(KYMAX + KYOFFSET + 2, 479), 0, BF

LOOP5:  NEXT J
   DCOLOR = 0
   PAINT (1, 1), DCOLOR, 1
 
  REM DRAW THE REFERENCE GRID ELLIPSES
  RADIUS = 1
 
  FOR R = 0 TO SFACTOR STEP .025
   RADI = RADIUS * R ^ 3
   K = 1: CCOLOR = 1: REM STEP #
 
   FOR ANGLE = 0 TO 2 * PI STEP PI / 720
    X(K) = RADI * T * COS(ANGLE + TROT)
    Y(K) = RADI * T * SIN(ANGLE + TROT)
    Z(K) = 0
    REM APPLY ROTATION OF AXES
    TEMP = X(K)
     X(K) = X(K) * COS(PROT) - Z(K) * SIN(PROT)
     Z(K) = TEMP * SIN(PROT) + Z(K) * COS(PROT)
     KY0 = FNY(Y(K))
     KZ0 = FNZ(Z(K))
     IF POINT(KY0, KZ0) <> DCOLOR THEN GOTO OPAL
     PSET (KY0, KZ0), CCOLOR
 
OPAL:  IF K / 60 <> INT(K / 60) THEN GOTO POOL
       DCY = FNY(0)
       DCZ = FNZ(0)
       DRY = KY0 - DCY
       DRZ = KZ0 - DCZ

         FOR RJ = 0 TO .99 STEP .01
          IF POINT(DCY + RJ * DRY, DCZ + RJ * DRZ) <> DCOLOR THEN GOTO OOPS
          PSET (DCY + RJ * DRY, DCZ + RJ * DRZ), CCOLOR
  
OOPS:    NEXT RJ

POOL:  K = K + 1
  NEXT ANGLE, R

  PAINT (1, 1), 0, 1
  LOCATE 23, 1
  REM PRINT "Hit a key to quit"
  F$ = INKEY$

LOOP7:  IF INKEY$ = "" THEN GOTO LOOP7

LOOP8: STOP: RESET: SYSTEM

 END

