// --------------------------------------------------------------------
//             Header file for use with user interface    
//
//          "An Adaptive 100/200 Baud DSP Modem for HF Using a                }
//               DSP-based PC Sound Card". QEX xxx  1994.		     
//									     
//                    (c) Johan Forrer, KC7WW				     
//		                     26553 Priceview Drive                               
//                         Monroe, OR 97456				     
// ---------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <dos.h>

#define IRQ7		0x0018
#define INT       0x0F		// INT7=0x0F

/* WSS register address offsets from WSS base address. */
#define WSS_STATUS			   0x0003
#define WSS_CODECINDEXADDR		0x0004
#define WSS_CODECINDEXDATA		0x0005
#define WSS_CODECSTATUS			0x0006
#define WSS_CODECDATA			0x0007

/* PSS registers' io port address offsets from pssbase. */
#define PSS_CONFIG    0x0010

#define PSS_DATA      0x0000
#define PSS_STATUS    0x0002
#define PSS_CONTROL   0x0002
#define PSS_ID_VERS   0x0004
#define PSS_IRQ_ACK   0x0004
#define PSS_RESET		 0x2000

// External function prototypes

extern unsigned int read_data(unsigned int);
extern void write_data(unsigned int, unsigned int);
extern unsigned long read_prog(unsigned int);
extern void write_prog(unsigned int, unsigned long);
extern int load_DSP_mem(char *);
extern void checkdsptestprog(void);
extern int checkDSPcard(int, int);
extern int bootdsp(char *, char *, unsigned);
extern void set1848state(unsigned char *);
extern int putdspword(unsigned);


// --------------------------------------------------------------------
// NOTE: for this application the card base is assumed at 220h
//       and the  Windows sound system base is assumed at 530h
// --------------------------------------------------------------------
extern unsigned int pssbase, wssbase;	// ports



