*--------------------------------------------
*	68HC05 Version.			    -
*	THE WEEKEND PORTAPEATER		    -
*	(April 1997 QST Magazine)	    -
*	Simplex repeater control	    -
*	Using the ISD 1000A or 25120	    -
*--------------------------------------------
*	Dover Research Corporation	    -
*	March 27th 1996			    -
*	All rights reserved		    -
*	(612) 492-3913			    -
*					    -
*	Date: 30-June-1996		    -
*	Author: Lt. James J. Craswell	    -
*	WB0VNE/AAV5TH/SF432		    -
*--------------------------------------------
*	I S D				    -
*	2045 Hamilton Avenue		    -
*	San Jose, California 95125	    -
*	(408) 369-2400			    -
*--------------------------------------------
* This is a commercial product so this code -
*	  Is NOT Public Domain		    -
*--------------------------------------------
* 1.0 Mode-less First run   5-July-1996     -
* 2.0 Two Mode 1st release  1997-Apr-13     -
*     Supports ISD 25120 (120 second Chip)  -
* 2.1 Fixed up for non 4Mhz clock CPUs	    -
* BUGS: None?!	(a tiny voice says "yet")   -
*--------------------------------------------
*	       JAY's ETHIC                  -
* Promote fair exchange of information.     -
* Question Authority. (and learn from it!)  -
* Promote Decentralization.		    -
* Programers should be judged by their work -
* not bogus criteria such as degrees, age,  -
* race or position.			    -
* You can create art, beauty and complete   -
* and total crap (like this) on a computer. -
* Computers can change / screw up your life.-
*--------------------------------------------
*    W A T C H	  O U T    A S A M O !	    -
*--------------------------------------------



	org	$00c0		;Start of user ram.



*****************************
* Ram locations for different
* routines.
*****************************
tmp	db	0		;Scratch location.
sec	db	0		;Seconds.
sec2	db	0		;Aux seconds.
min	db	0		;Minutes.
hrs	db	0		;Hours.

*********************
* Scratch locations :
*********************
tempa	db	0
tempx	db	0

cos	equ	5		;This bit indicates a received signal.
ptt	equ	4		;This bit turns on the transmitter.
modsel	equ	3		;User wants to switch to the "other" mode.
led2	equ	2
led1	equ	1
led0	equ	0

********************************
* To measure time with different
* CPU clocks we need to measure
* the ticks per second.
********************************
;ctick	 equ	!61		 ;Ticks for 4MHz CPU clock.
ctick	equ	!37		;Ticks for 2.4576MHz CPU clock.

idce	equ	7		;Chip enable for ID sound chip.
idpd	equ	6		;"Rewind" on ID sound chip.
ideom	equ	5		;E.nd O.f M.essage for ID chip.
idrec	equ	4		;User "Record" button for ID chip.
rpce	equ	3		;Chip enable for replay chip.
rppd	equ	2		;"Rewind" on replay sound chip.
rpeom	equ	1		;E.nd O.f M.essage for replay chip.
rppr	equ	0		;P.lay R.ecord* for replay sound chip.
timeout equ	!114		;Force Replay if chip runs out of time.
				;*Note a few secs missing so it works right.
timeid	equ	8		;ID every "X" minutes.
timebcn equ	1		;Beacons ID every minute.

*************************************************************
*	     S T A R T	  O F	 P R O G R A M		    *
*************************************************************



	org	$0300		;Start of 68HC705j1A EPROM.



start:	clrx
	clra
	clr	(tmp)		;Clear everything.
	clr	(sec)
	clr	(sec2)
	clr	(min)
	clr	(hrs)


************************
* P O R T   B	       *
*----------------------*
*	 PTT MODE SEL  *
*      COS : : LED     *
*    RES : : : : LED   *
*  RES : : : : : : LED *
*    7 6 5 4 3 2 1 0   *
************************
	lda	#%00010111	;PORTA=Bottom 3 bits are output.
	sta	ddrb		;Set it that way now.
	lda	#%00000111	;Turn off all leds and PTT.
	sta	portb

***************************
* P O R T   A		  *
*-------------------------*
* Manual R* | CE*	  *
*     EOM : | : PD	  *
*    PD : : | : : EOM	  *
* CE* : : : | : : : P/R*  *
*-------------------------*
*   7 6 5 4 | 3 2 1 0	  *
*   IDER    | REPLAY CHIP *
***************************
	lda	#%11001101	;Set direction on port a.
	sta	ddra
	lda	#%11001101
	sta	porta

**************************************************
* T S C R TIMER INTERRUPT CONTROL REGISTER.	 *
*------------------------------------------------*
* 7 6 5 4 3 2 1 0				 *
* : : : : : : : :				 *
* : : : : : : 0 0 = 8.2ms			 *
* : : : : : : 0 1 = 16.4ms			 *
* : : : : : : 1 0 = 32.8ms			 *
* : : : : : : 1 1 = 65.5ms			 *
* : : : : : Real Time int Flag reset (Write only)*
* : : : : Timer Overflor Flag Reset (Write only) *
* : : : Real Time Int 1=Enable 0=disable.	 *
* : : Timer Overflow Int 1=Enable 0=disable.	 *
* : Real Time Int Flag (Read only)		 *
* Timer Overflow Flag (Read only)		 *
**************************************************
	lda	#%00010001	;Load A with control info for timer.
	sta	tscr		;Write to control register.
	cli			;Turn on timer interrupts.
	jsr	id		;Force id on initial start/reset.

**************
* MAIN LOOP. *
**************
main:	jsr	replay		;Check to Record and replay routine.
	jsr	idtime		;Id every "X" minutes routine.
	jsr	recid		;Check and Record new ID routine.
	bclr	ptt,portb	;Turn off transmitter now just in case!
	jmp	main


********************************************************************
*		  S U B R O U T I N E S				   *
********************************************************************



************************
* RECORD IDER MESSAGE. *
************************
recid:	brset	idrec,porta,riexit	;Is the user record bit on or not?
recnow: bclr	idpd,porta		;Rewind sound chip by 0...
	jsr	dly50			;wait a sec.
	bset	idpd,porta		;1...
	jsr	dly50			;wait a sec.
	bclr	idpd,porta		;Zeroing the pd line.
	jsr	dly50			;wait a sec.
	bclr	idce,porta		;Start recording!
ckrec:	brset	idrec,porta,stopid	;If P/R* in play jump.
	brset	ideom,porta,ckrec	;Else, check for EOM.
stopid: bset	idce,porta		;Stop playback now.
	jsr	dly50			;wait a sec.
	bset	idpd,porta		;Sleep mode on.
riexit: rts				;Go back to main loop.



********************************
* READ AND RECORD.	       *
*------------------------------*
* cos=Carrier operated squelch *
********************************
replay: brset	cos,portb,rrexit	;If no message just return to main loop.
	clr	(sec2)			;Clear aux seconds register.
	bclr	rppr,porta		;Record mode.
	jsr	dly50
	bset	rppd,porta		;switch from high...
	jsr	dly50
	bclr	rppd,porta		;to low to rewind chip to zero.
	jsr	dly50
	brset	cos,portb,idend		;glitch?  Return before we goof up.
	bclr	rpce,porta		;Start recording.
	jsr	dly50
*****************************
* Record until cos goes away.
*****************************
rplp:	lda	(sec2)			;Get current seconds recorded.
	cmp	#timeout		;Are we timed out yet?
	bhi	echo			;Chip full!  So, force replay!
	brset	cos,portb,echo		;If COS went away then echo.
	brset	rpeom,porta,rplp	;If EOM is off (=1) then...
					; keep checking cos.

*****************************
* ECHO WHAT WE HAVE RECORDED.
*****************************
echo:	bset	rpce,porta		;Disable chip for a moment.
	jsr	dly50
	bset	rppr,porta		;Playback mode.
	jsr	dly50			;Wait?	Sure...
	bclr	rppd,porta		;low
	jsr	dly50
	bset	rppd,porta		;high
	jsr	dly50
	bclr	rppd,porta		;Rewind chip to zero.
	jsr	dly50
	bset	ptt,portb		;Turn on transmitter.
	bclr	rpce,porta		;Enable sound on replay chip.
	jsr	dly50			;waste time.
	bset	rpce,porta		;Disable snd chip.
*********************
* Playback until EOM.
*********************
rlp2:	brset	rpeom,porta,rlp2	;Wait for E.nd O.f M.essage.
	bclr	ptt,portb		;Turn off transmitter now.
	clr	(sec2)			;Clear 120 second buffer.
	jsr	dly50
rrexit: rts				;And return.



***********************
* ID EVERY X MINUTES. *
***********************
idtime: lda	(min)			;Get the current minute count.
	brset	modsel,portb,bcn	;If set in beacon mode.
	cmp	#timeid			;Compare against regular ID.
	blo	idend			;If < timeout return to main loop.
	jmp	id			;Else start the ID process.
bcn:	cmp	#timebcn		;Are we at the timeout or more?
	blo	idend			;If < timeout return to main loop.
id:	bclr	idpd,porta		;low...
	jsr	dly50
	bset	idpd,porta		;high...
	jsr	dly50
	bclr	idpd,porta		;low, rewinds chip to start.
	jsr	dly50
	bset	ptt,portb		;Activate transmitter.
	bclr	idce,porta		;Toggle CE* to...
	jsr	dly50
	bset	idce,porta		;Start playback.
idlp:	brset	ideom,porta,idlp	;Loop until EOM is discovered.
	bclr	ptt,portb		;Shut off transmitter.
	bset	idce,porta		;deselect id snd chip.
	bset	idpd,porta		;low pwr snd chip.
	clr	(sec)			;reset main clock...
	clr	(min)			;to...
	clr	(hrs)			;zero.
idend:	rts				;and return to main loop.



**************
* DELAY 50 ms.
**************
dly50:
	sta	tempa			;Save accumulator.
	stx	tempx			;Save X.
	lda	#32			;32=50ms ff=250ms
olp:	clrx
ilp:	decx
	bne	ilp
	deca
	bne	olp
	lda	tempa			;Restore accumulator.
	ldx	tempx			;Restore X.
	rts



****************************
* SYSTEM HEARTBEAT / CLOCK *
****************************
clock:	sta	(tempa)			;Save registers.
	stx	(tempx)
	lda	#%00010101		;Clear overflow flag for next go around.
	sta	tscr
	inc	(tmp)			;Add one more 0.0164 (for 4Mhz) second.
	lda	#ctick			;61 for 4MHz clks, 99 for 2.4576MHz.
	cmp	(tmp)			;Check it for 1 full second.
	beq	onesec			;If = one second goto sec routine.
	jmp	clkx			;Done.

***********
* SECONDS *
***********
onesec: clr	(tmp)			;reset tmp to zero.
	inc	(sec)			;Add a second.
	inc	(sec2)			;Add a second to the aux sec counter.
	lda	#!60			;60 seconds in one minute.
	cmp	(sec)			;Are we at one minute yet?
	beq	onemin			;Yes so go add one minute.
	jmp	clkx			;Done.

***********
* MINUTES *
***********
onemin: clr	(sec)			;60th second so clear to zero
	inc	(min)			;Add one minute.
	lda	portb			;Read current status of port B.
	and	#%00010000		;isolate the PTT bit.
	sta	(tmp)			;write to scratch.
	lda	(min)			;Get current time.
	coma				;invert (for driving led array)
	and	#%00000111		;Isolate the bottom three bits.
	ora	(tmp)
	sta	portb			;Write current min in binary to leds.
	cmp	(min)			;Are we at one hour yet?
	beq	onehr			;Yes, so add one hour.
	clr	(tmp)
	jmp	clkx			;Done.

*********
* HOURS *
*********
onehr:	clr	(min)			;60th Minute so clear to zero
	inc	(hrs)			;Add one hour.

**************
* CLOCK EXIT *
**************
clkx:
	lda	(tempa)			;Restore A.
	ldx	(tempx)			;Restore X.
	rti				;Return from this interrupt.


last:	db	''

tim_vec:jmp	clock
int_vec:rti





***************
* VECTOR SPACE.
***************


	org	$7F8		;Start of Reset/Interrupt vectors.




	dw	tim_vec		;If timer ints were enabled it would go here.
	dw	int_vec		;If IRQ was unmasked it would go here.
	dw	start		;So 6805 knows where to start on pwr up.
	dw	start		;So 6805 knows where to go on reset.



	end			;NUFF SAID!
