10 PRINT "   ***NOISE FIGURE, TEMPERATURE AND SENSITIVITY RELATIONSHIPS***"
15 PRINT
20 PRINT "            ***MENU OF CONVERSIONS***"
25 PRINT
30 PRINT "(1) DBM TO MICROVOLTS (uV)"
40 PRINT "(2) MICROVOLTS (uV) TO DBM"
50 PRINT "(3) NOISE FIGURE (NF) TO MICROVOLTS (uV)"
60 PRINT "(4) NOISE VOLTAGE (EN) IN MICROVOLTS (uV)"
70 PRINT "(5) NOISE POWER (PN) IN WATTS AND DBM"
80 PRINT "(6) NOISE FIGURE (NF) TO NOISE TEMPERATURE (TE) IN DEGREES KELVIN"
90 PRINT "(7) NOISE TEMPERATURE (TE) TO NOISE FIGURE (NF)"
100 PRINT "(8) NOISE FIGURE (NF) TO NOISE FLOOR (FL)"
110 PRINT "(9) NOISE FLOOR (FL) TO NOISE FIGURE (NF)"
120 PRINT "(10) (NF) FOR uV INPUT WITH (S + N)/N = 3 DB"
122 PRINT
124 PRINT "      ***SELECT CONVERSION DESIRED BY NUMBER***"
126 PRINT
130 INPUT "ENTER DESIRED NUMBER"; D
140 ON D GOTO 150,220,280,370,460,540,600,640,700,760
150 INPUT "ENTER THE SENSITIVITY (DM) IN -DBM"; DM
180 INPUT "ENTER THE INPUT RESISTANCE (R) IN OHMS"; R
190 X = (90 + 4.343 * LOG(R) + DM)/20
200 ES = 10^X
210 PRINT ES, "SENSITIVITY (ES) IN MICROVOLTS (uV)"
215 GOTO 850
220 INPUT "ENTER THE SENSITIVITY (ES) IN MICROVOLTS (uV)"; ES
250 INPUT "ENTER THE INPUT RESISTANCE (R) IN OHMS"; R
260 DM = -90 - 4.343 * LOG(R) + 8.686 * LOG(ES)
270 PRINT DM, "SENSITIVITY (DM) IN DBM"
275 GOTO 850
280 INPUT "ENTER THE NOISE FIGURE (NF) IN DB"; NF
310 INPUT "ENTER THE INPUT RESISTANCE (R) IN OHMS"; R
320 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
340 X = NF/10
350 ES = (6/10^3) * ((10^X * R * B)^.5)
360 PRINT ES, "SENSITIVITY (ES) IN MICROVOLTS (uV)"
365 GOTO 850
370 K = 1.37/10^23
390 INPUT "ENTER THE TEMPERATURE (TE) IN DEGREES KELVIN"; TE
410 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
430 INPUT "ENTER THE INPUT RESISTANCE (R) IN OHMS"; R
440 EN = ((4 * 1.37 * TE * B * R)/10^8)^.5
450 PRINT EN, "NOISE VOLTAGE (EN) IN MICROVOLTS (uV)"
455 GOTO 850
460 INPUT "ENTER THE NOISE TEMPERATURE (TE) IN DEGREES KELVIN"; TE
490 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
500 PN = (1.37/10^20) * TE * B
510 PRINT PN, "NOISE POWER (PN) IN WATTS"
520 DM = -4.343 * LOG(.001/PN)
530 PRINT DM, "NOISE POWER (DM) IN DBM"
535 GOTO 850
540 INPUT "ENTER THE NOISE FIGURE (NF) IN DB"; NF
560 X = NF/10
570 F = 10^X
580 TE = (F - 1) * 290
590 PRINT TE, "NOISE TEMPERATURE (TE) IN DEGREES KELVIN"
595 GOTO 850
600 INPUT "ENTER THE NOISE TEMPERATURE (TE) IN DEGREES KELVIN"; TE
620 NF = 4.343 * LOG((TE + 290)/290)
630 PRINT NF, "NOISE FIGURE (NF) IN DB"
635 GOTO 850
640 INPUT "ENTER THE NOISE FIGURE (NF) IN DB"; NF
670 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
680 FL = -144 + 4.343 * LOG(B) + NF
690 PRINT FL, "NOISE FLOOR (FL) IN DBM"
695 GOTO 850
700 INPUT "ENTER THE NOISE FLOOR (FL) IN -DBM"; FL
730 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
740 NF = FL + 144 - (4.343 * LOG(B))
750 PRINT NF, "NOISE FIGURE (NF) IN DB"
755 GOTO 850
760 INPUT "ENTER THE SENSITIVITY (ES) IN MICROVOLTS (uV)"; ES
790 INPUT "ENTER THE INPUT RESISTANCE (R) IN OHMS"; R
810 INPUT "ENTER THE BANDWIDTH (B) IN KHz"; B
820 NF = 4.343 * LOG((ES^2 * 10^6)/(4 * R * B))
830 PRINT NF, "NOISE FIGURE (NF) IN DB"
840 PRINT
845 PRINT "PREPARED BY I.L.McNALLY K6WX"
850 END
