REM quick program to input power and antenna gain and get S, E and H

CLS

REM INPUT "Transmitter Power"; p:
p = 1500
p = p * 1000: REM convert to milliwatts

REM INPUT "Antenna Gain (not in dB)"; G
G = 15.8

here:
INPUT "Distance between antenna and area of exposure in meters"; D
REM D = 4.7
D = D * 100: REM convert to centimeters

REM INPUT "Frequency"; F
F = 14.35

S = (p * G) / (4 * 3.141 * (D * D))
E = SQR(S * 3770)
H = SQR(S / 37.7)

PRINT "Power = "; p / 1000; " watts,       "; p; " milliwatts"

PRINT "Far-field power density = "; S; "milliwatts/square centimeter"
PRINT "Far-field E field = "; E; " Volts/meter"
PRINT "Far=field H field = "; H; " Amperes/meter"

SLIMIT = 180 / (F * F)
ELIMIT = 824 / F
HLIMIT = 2.19 / F

PRINT "FCC S limit = "; SLIMIT; " mw/square centimeter"
PRINT "FCC E limit = "; ELIMIT; " volts/meter"
PRINT "FCC H limit = "; HLIMIT; " amperes/meter"

GOTO here:

