      SUBROUTINE RDPAT
C     COMPUTE RADIATION PATTERN, GAIN, NORMALIZED GAIN
      INCLUDE 'MAX.PAR'
      CHARACTER*6 IGNTP,IGAX,IGTP,HCIR,HBLK,HPOL,HCLIF,ISENS
C     INTEGER HPOL,HBLK,HCIR,HCLIF
      COMPLEX ETH,EPH,ERD,ZRATI,ZRATI2,T1,FRATI
      INCLUDE 'DATA.PAR'
      INCLUDE 'SAVE.PAR'
      INCLUDE 'SCRATM.PAR'
      COMMON /GND/ZRATI,ZRATI2,FRATI,CL,CH,SCRWL,SCRWR,NRADL,KSYMP,IFAR,
     1IPERF,T1,T2
      COMMON /FPAT/ NTH,NPH,IPD,IAVP,INOR,IAX,THETS,PHIS,DTH,DPH,RFLD,GN
     1OR,CLT,CHT,EPSR2,SIG2,IXTYP,XPR6,PINR,PNLR,PLOSS,NEAR,NFEH,NRX,NRY
     2,NRZ,XNR,YNR,ZNR,DXNR,DYNR,DZNR
C***
      COMMON /PLOT/ IPLP1,IPLP2,IPLP3,IPLP4
C***
      DIMENSION IGTP(4), IGAX(4), IGNTP(10), HPOL(3)
      DATA HPOL/'LINEAR','RIGHT','LEFT'/,HBLK,HCIR/' ','CIRCLE'/
      DATA IGTP/'    - ','POWER ','- DIRE','CTIVE '/
      DATA IGAX/' MAJOR',' MINOR',' VERT.',' HOR. '/
      DATA IGNTP/' MAJOR',' AXIS ',' MINOR',' AXIS ','   VER','TICAL ',
     1           ' HORIZ','ONTAL ','      ','TOTAL '/
      DATA PI,TA,TD/3.141592654,1.745329252E-02,57.29577951/
      DATA NORMAX/1200/
      IF (IFAR.LT.2) GO TO 2
      WRITE(6,35)
      IF (IFAR.LE.3) GO TO 1
      WRITE(6,36)  NRADL,SCRWLT,SCRWRT
      IF (IFAR.EQ.4) GO TO 2
1     IF (IFAR.EQ.2.OR.IFAR.EQ.5) HCLIF=HPOL(1)
      IF (IFAR.EQ.3.OR.IFAR.EQ.6) HCLIF=HCIR
      CL=CLT/WLAM
      CH=CHT/WLAM
      ZRATI2=CSQRT(1./CMPLX(EPSR2,-SIG2*WLAM*59.96))
      WRITE(6,37)  HCLIF,CLT,CHT,EPSR2,SIG2
2     IF (IFAR.NE.1) GO TO 3
      WRITE(6,41)
      GO TO 5
3     I=2*IPD+1
      J=I+1
      ITMP1=2*IAX+1
      ITMP2=ITMP1+1
      WRITE(6,38)
      IF (RFLD.LT.1.E-20) GO TO 4
      EXRM=1./RFLD
      EXRA=RFLD/WLAM
      EXRA=-360.*(EXRA-AINT(EXRA))
      WRITE(6,39)  RFLD,EXRM,EXRA
4     WRITE(6,40)  IGTP(I),IGTP(J),IGAX(ITMP1),IGAX(ITMP2)
5     IF (IXTYP.EQ.0.OR.IXTYP.EQ.5) GO TO 7
      IF (IXTYP.EQ.4) GO TO 6
      PRAD=0.
      GCON=4.*PI/(1.+XPR6*XPR6)
      GCOP=GCON
      GO TO 8
6     PINR=394.51*XPR6*XPR6*WLAM*WLAM
7     GCOP=WLAM*WLAM*2.*PI/(376.73*PINR)
      PRAD=PINR-PLOSS-PNLR
      GCON=GCOP
      IF (IPD.NE.0) GCON=GCON*PINR/PRAD
8     I=0
      GMAX=-1.E10
      PINT=0.
      TMP1=DPH*TA
      TMP2=.5*DTH*TA
      PHI=PHIS-DPH
      DO 29 KPH=1,NPH
      PHI=PHI+DPH
      PHA=PHI*TA
      THET=THETS-DTH
      DO 29 KTH=1,NTH
      THET=THET+DTH
      IF (KSYMP.EQ.2.AND.THET.GT.90.01.AND.IFAR.NE.1) GO TO 29
      THA=THET*TA
      IF (IFAR.EQ.1) GO TO 9
      CALL FFLD (THA,PHA,ETH,EPH)
      GO TO 10
9     CALL GFLD (RFLD/WLAM,PHA,THET/WLAM,ETH,EPH,ERD,ZRATI,KSYMP)
      ERDM=CABS(ERD)
      ERDA=CANG(ERD)
10    ETHM2=REAL(ETH*CONJG(ETH))
      ETHM=SQRT(ETHM2)
      ETHA=CANG(ETH)
      EPHM2=REAL(EPH*CONJG(EPH))
      EPHM=SQRT(EPHM2)
      EPHA=CANG(EPH)
      IF (IFAR.EQ.1) GO TO 28
C     ELLIPTICAL POLARIZATION CALC.
      IF (ETHM2.GT.1.E-20.OR.EPHM2.GT.1.E-20) GO TO 11
      TILTA=0.
      EMAJR2=0.
      EMINR2=0.
      AXRAT=0.
      ISENS=HBLK
      GO TO 16
11    DFAZ=EPHA-ETHA
      IF (EPHA.LT.0.) GO TO 12
      DFAZ2=DFAZ-360.
      GO TO 13
12    DFAZ2=DFAZ+360.
13    IF (ABS(DFAZ).GT.ABS(DFAZ2)) DFAZ=DFAZ2
      CDFAZ=COS(DFAZ*TA)
      TSTOR1=ETHM2-EPHM2
      TSTOR2=2.*EPHM*ETHM*CDFAZ
      TILTA=.5*ATGN2(TSTOR2,TSTOR1)
      STILTA=SIN(TILTA)
      TSTOR1=TSTOR1*STILTA*STILTA
      TSTOR2=TSTOR2*STILTA*COS(TILTA)
      EMAJR2=-TSTOR1+TSTOR2+ETHM2
      EMINR2=TSTOR1-TSTOR2+EPHM2
      IF (EMINR2.LT.0.) EMINR2=0.
      AXRAT=SQRT(EMINR2/EMAJR2)
      TILTA=TILTA*TD
      IF (AXRAT.GT.1.E-5) GO TO 14
      ISENS=HPOL(1)
      GO TO 16
14    IF (DFAZ.GT.0.) GO TO 15
      ISENS=HPOL(2)
      GO TO 16
15    ISENS=HPOL(3)
16    GNMJ=DB10(GCON*EMAJR2)
      GNMN=DB10(GCON*EMINR2)
      GNV=DB10(GCON*ETHM2)
      GNH=DB10(GCON*EPHM2)
      GTOT=DB10(GCON*(ETHM2+EPHM2))
      IF (INOR.LT.1) GO TO 23
      I=I+1
      IF (I.GT.NORMAX) GO TO 23
      GO TO (17,18,19,20,21), INOR
17    TSTOR1=GNMJ
      GO TO 22
18    TSTOR1=GNMN
      GO TO 22
19    TSTOR1=GNV
      GO TO 22
20    TSTOR1=GNH
      GO TO 22
21    TSTOR1=GTOT
22    GAIN(I)=TSTOR1
      IF (TSTOR1.GT.GMAX) GMAX=TSTOR1
23    IF (IAVP.EQ.0) GO TO 24
      TSTOR1=GCOP*(ETHM2+EPHM2)
      TMP3=THA-TMP2
      TMP4=THA+TMP2
      IF (KTH.EQ.1) TMP3=THA
      IF (KTH.EQ.NTH) TMP4=THA
      DA=ABS(TMP1*(COS(TMP3)-COS(TMP4)))
      IF (KPH.EQ.1.OR.KPH.EQ.NPH) DA=.5*DA
      PINT=PINT+TSTOR1*DA
      IF (IAVP.EQ.2) GO TO 29
24    IF (IAX.EQ.1) GO TO 25
      TMP5=GNMJ
      TMP6=GNMN
      GO TO 26
25    TMP5=GNV
      TMP6=GNH
26    ETHM=ETHM*WLAM
      EPHM=EPHM*WLAM
      IF (RFLD.LT.1.E-20) GO TO 27
      ETHM=ETHM*EXRM
      ETHA=ETHA+EXRA
      EPHM=EPHM*EXRM
      EPHA=EPHA+EXRA
27    WRITE(6,42)  THET,PHI,TMP5,TMP6,GTOT,AXRAT,TILTA,ISENS,ETHM,ETHA
     1,EPHM,EPHA
C      GO TO 29
C***
C28    WRITE(6,43)  RFLD,PHI,THET,ETHM,ETHA,EPHM,EPHA,ERDM,ERDA
      IF(IPLP1 .NE. 3) GO TO 299
      IF(IPLP3 .EQ. 0) GO TO 290
      IF(IPLP2 .EQ. 1 .AND. IPLP3 .EQ. 1)
     1WRITE(8,*) THET,ETHM,ETHA
      IF(IPLP2 .EQ. 1 .AND. IPLP3 .EQ. 2)
     1WRITE(8,*) THET,EPHM,EPHA
      IF(IPLP2 .EQ. 2 .AND. IPLP3 .EQ. 1)
     1WRITE(8,*) PHI,ETHM,ETHA
      IF(IPLP2 .EQ. 2 .AND. IPLP3 .EQ. 2)
     1WRITE(8,*) PHI,EPHM,EPHA
      IF(IPLP4 .EQ. 0) GO TO 299
290   IF(IPLP2 .EQ. 1 .AND. IPLP4 .EQ. 1)
     1WRITE(8,*) THET,TMP5
      IF(IPLP2 .EQ. 1 .AND. IPLP4 .EQ. 2)
     1WRITE(8,*) THET,TMP6
      IF(IPLP2 .EQ. 1 .AND. IPLP4 .EQ. 3)
     1WRITE(8,*) THET,GTOT
      IF(IPLP2 .EQ. 2 .AND. IPLP4 .EQ. 1)
     1WRITE(8,*) PHI,TMP5
      IF(IPLP2 .EQ. 2 .AND. IPLP4 .EQ. 2)
     1WRITE(8,*) PHI,TMP6
      IF(IPLP2 .EQ. 2 .AND. IPLP4 .EQ. 3)
     1WRITE(8,*) PHI,GTOT
      GO TO 299
28    WRITE(6,43)  RFLD,PHI,THET,ETHM,ETHA,EPHM,EPHA,ERDM,ERDA
299   CONTINUE
C***
29    CONTINUE
      IF (IAVP.EQ.0) GO TO 30
      TMP3=THETS*TA
      TMP4=TMP3+DTH*TA*FLOAT(NTH-1)
      TMP3=ABS(DPH*TA*FLOAT(NPH-1)*(COS(TMP3)-COS(TMP4)))
      PINT=PINT/TMP3
      TMP3=TMP3/PI
      WRITE(6,44)  PINT,TMP3
30    IF (INOR.EQ.0) GO TO 34
      IF (ABS(GNOR).GT.1.E-20) GMAX=GNOR
      ITMP1=(INOR-1)*2+1
      ITMP2=ITMP1+1
      WRITE(6,45)  IGNTP(ITMP1),IGNTP(ITMP2),GMAX
      ITMP2=NPH*NTH
      IF (ITMP2.GT.NORMAX) ITMP2=NORMAX
      ITMP1=(ITMP2+2)/3
      ITMP2=ITMP1*3-ITMP2
      ITMP3=ITMP1
      ITMP4=2*ITMP1
      IF (ITMP2.EQ.2) ITMP4=ITMP4-1
      DO 31 I=1,ITMP1
      ITMP3=ITMP3+1
      ITMP4=ITMP4+1
      J=(I-1)/NTH
      TMP1=THETS+FLOAT(I-J*NTH-1)*DTH
      TMP2=PHIS+FLOAT(J)*DPH
      J=(ITMP3-1)/NTH
      TMP3=THETS+FLOAT(ITMP3-J*NTH-1)*DTH
      TMP4=PHIS+FLOAT(J)*DPH
      J=(ITMP4-1)/NTH
      TMP5=THETS+FLOAT(ITMP4-J*NTH-1)*DTH
      TMP6=PHIS+FLOAT(J)*DPH
      TSTOR1=GAIN(I)-GMAX
      IF (I.EQ.ITMP1.AND.ITMP2.NE.0) GO TO 32
      TSTOR2=GAIN(ITMP3)-GMAX
      PINT=GAIN(ITMP4)-GMAX
31    WRITE(6,46)  TMP1,TMP2,TSTOR1,TMP3,TMP4,TSTOR2,TMP5,TMP6,PINT
      GO TO 34
32    IF (ITMP2.EQ.2) GO TO 33
      TSTOR2=GAIN(ITMP3)-GMAX
      WRITE(6,46)  TMP1,TMP2,TSTOR1,TMP3,TMP4,TSTOR2
      GO TO 34
33    WRITE(6,46)  TMP1,TMP2,TSTOR1
34    RETURN
C
35    FORMAT (///, 31X, '- - - FAR FIELD GROUND PARAMETERS - - -', //)
36    FORMAT (40X, 'RADIAL WIRE GROUND SCREEN', /, 40X, I5,
     1        'WIRES', /, 40X, 'WIRE LENGTH=', F8.2, ' METERS', /,
     2        40X, 'WIRE RADIUS=', 1P, E10.3, ' METERS')
37    FORMAT (40X, A6, ' CLIFF', /, 40X, 'EDGE DISTANCE=', F9.2,
     1        'METERS', /, 40X, 'HEIGHT=', F8.2, ' METERS', /, 40X,
     2        'SECOND MEDIUM -', /, 40X, 'RELATIVE DIELECTRIC CONST.=',
     3        F7.3, /, 40X, 'CONDUCTIVITY=', 1P, E10.3, ' MHOS')
38    FORMAT (///, 48X, '- - - RADIATION PATTERNS - - -')
39    FORMAT (54X, 'RANGE=', 1P, E13.6,' METERS', /, 54X, 'EXP',
     1       '(-JKR)/R=', E12.5, ' AT PHASE', 0P, F7.2, ' DEGREES', /)
40    FORMAT (/, 2X, '- - ANGLES - -', 7X, 2A6, 'GAINS -', 7X,
     1        '- - - POLARIZATION - - -', 4X, '- - - E(THETA) - - -',
     2        4X, '- - - E(PHI) - - -', /, 2X, 'THETA', 5X, 'PHI',
     3        7X, A6, 2X, A6, 3X,'TOTAL', 6X, 'AXIAL', 5X,'TILT', 3X,
     4        'SENSE', 2 (5X, 'MAGNITUDE', 4X, 'PHASE '), /, 2(1X,
     5        'DEGREES', 1X), 3 (6X, 'DB'), 8X, 'RATIO', 5X, 'DEG.',
     6        8X, 2 (6X, 'VOLTS/M', 4X, 'DEGREES'))
41    FORMAT (///, 28X, ' - - - RADIATED FIELDS NEAR GROUND - - -', //,
     1        8X, '- - - LOCATION - - -', 10X, '- - E(THETA) - -', 8X,
     2        '- - E(PHI) - -', 8X, '- - E(RADIAL) - -', /, 7X, 'RHO',
     3        6X, 'PHI', 9X, 'Z', 12X, 'MAG', 6X, 'PHASE', 9X, 'MAG',
     4        6X, 'PHASE', 9X, 'MAG', 6X, 'PHASE', /, 5X, 'METERS', 3X,
     5        'DEGREES', 4X, 'METERS', 8X, 'VOLTS/M', 3X, 'DEGREES', 6X,
     6        'VOLTS/M', 3X, 'DEGREES', 6X, 'VOLTS/M', 3X, 'DEGREES', /)
42    FORMAT (1X, F7.2, F9.2, 3X, 3F8.2, F11.5, F9.2, 2X, A6,
     1        2(1P,E15.5,0P,F9.2))
43    FORMAT (3X, F9.2, 2X, F7.2, 2X, F9.2, 1X, 3(3X, 1P, E11.4, 2X,
     1        0P, F7.2))
44    FORMAT (//, 3X, 'AVERAGE POWER GAIN=', 1P, E12.5, 7X,
     1        'SOLID ANGLE USED IN AVERAGING=(', 0P, F7.4,
     2        ')*PI STERADIANS.', //)
45    FORMAT (//, 37X, '- - - - NORMALIZED GAIN - - - -', //, 37X,
     1        2A6, 'GAIN', /, 38X, 'NORMALIZATION FACTOR =', F9.2,
     2        ' DB', //, 3(4X, '- - ANGLES - -', 6X, 'GAIN', 7X), /,
     3        3(4X, 'THETA', 5X, 'PHI', 8X, 'DB', 8X), /,
     4        3(3X, 'DEGREES', 2X, 'DEGREES', 16X))
46    FORMAT (3 (1X,  2F9.2,  1X,  F9.2,  6X))
      END
