      SUBROUTINE NETWK (CM,CMB,CMC,CMD,IP,EINC)
C
C     SUBROUTINE NETWK SOLVES FOR STRUCTURE CURRENTS FOR A GIVEN
C     EXCITATION INCLUDING THE EFFECT OF NON-RADIATING NETWORKS IF
C     PRESENT.
C
      INCLUDE 'MAX.PAR'
      COMPLEX CMN,RHNT,YMIT,RHS,ZPED,EINC,VSANT,VLT,CUR,VSRC,RHNX,VQD,VQ
     1DS,CUX,CM,CMB,CMC,CMD
      INCLUDE 'DATA.PAR'
      INCLUDE 'CRNT.PAR'
      COMMON /VSORC/ VQD(30),VSANT(30),VQDS(30),IVQD(30),ISANT(30),IQDS(
     130),NVQD,NSANT,NQDS
      INCLUDE 'NETCX.PAR'
      DIMENSION EINC(1), IP(1),CM(1),CMB(1),CMC(1),CMD(1)
      DIMENSION CMN(NNET,NNET), RHNT(NNET), IPNT(NNET), NTEQA(NNET),
     1          NTSCA(NNET), RHS(MWS+3*MSP), VSRC(30),
     2          RHNX(NNET)                              ! CCS 6/87
      DATA NDIMN /NNET/, TP/6.283185308/                ! CCS 6/87
      NDIMNP = NDIMN + 1                                ! CCS 6/87
      NEQZ2=NEQ2
      IF(NEQZ2.EQ.0)NEQZ2=1
      PIN=0.
      PNLS=0.
      NEQT=NEQ+NEQ2
      IF (NTSOL.NE.0) GO TO 42
      NOP=NEQ/NPEQ
      IF (MASYM.EQ.0) GO TO 14
C
C     COMPUTE RELATIVE MATRIX ASYMMETRY
C
      IROW1=0
      IF (NONET.EQ.0) GO TO 5
      DO 4 I=1,NONET
      NSEG1=ISEG1(I)
      DO 3 ISC1=1,2
      IF (IROW1.EQ.0) GO TO 2
      DO 1 J=1,IROW1
      IF (NSEG1.EQ.IPNT(J)) GO TO 3
1     CONTINUE
2     IROW1=IROW1+1
      IPNT(IROW1)=NSEG1
3     NSEG1=ISEG2(I)
4     CONTINUE
5     IF (NSANT.EQ.0) GO TO 9
      DO 8 I=1,NSANT
      NSEG1=ISANT(I)
      IF (IROW1.EQ.0) GO TO 7
      DO 6 J=1,IROW1
      IF (NSEG1.EQ.IPNT(J)) GO TO 8
6     CONTINUE
7     IROW1=IROW1+1
      IPNT(IROW1)=NSEG1
8     CONTINUE
9     IF (IROW1.LT.NDIMNP) GO TO 10
      WRITE(6,59)
      STOP
10    IF (IROW1.LT.2) GO TO 14
      DO 12 I=1,IROW1
      ISC1=IPNT(I)
      ASM=SI(ISC1)
      DO 11 J=1,NEQT
11    RHS(J)=(0.,0.)
      RHS(ISC1)=(1.,0.)
      CALL SOLGF (CM,CMB,CMC,CMD,RHS,IP,NP,N1,N,MP,M1,M,NEQ,NEQ2,NEQZ2)
      CALL CABC (RHS)
      DO 12 J=1,IROW1
      ISC1=IPNT(J)
12    CMN(J,I)=RHS(ISC1)/ASM
      ASM=0.
      ASA=0.
      DO 13 I=2,IROW1
      ISC1=I-1
      DO 13 J=1,ISC1
      CUX=CMN(I,J)
      PWR=CABS((CUX-CMN(J,I))/CUX)
      ASA=ASA+PWR*PWR
      IF (PWR.LT.ASM) GO TO 13
      ASM=PWR
      NTEQ=IPNT(I)
      NTSC=IPNT(J)
13    CONTINUE
      ASA=SQRT(ASA*2./FLOAT(IROW1*(IROW1-1)))
      WRITE(6,58)  ASM,NTEQ,NTSC,ASA
14    IF (NONET.EQ.0) GO TO 48
C
C     SOLUTION OF NETWORK EQUATIONS
C
      DO 15 I=1,NDIMN
      RHNX(I)=(0.,0.)
      DO 15 J=1,NDIMN
15    CMN(I,J)=(0.,0.)
      NTEQ=0
      NTSC=0
C
C     SORT NETWORK AND SOURCE DATA AND ASSIGN EQUATION NUMBERS TO
C     SEGMENTS.
C
      DO 38 J=1,NONET
      NSEG1=ISEG1(J)
      NSEG2=ISEG2(J)
      IF (NTYP(J).GT.1) GO TO 16
      Y11R=X11R(J)
      Y11I=X11I(J)
      Y12R=X12R(J)
      Y12I=X12I(J)
      Y22R=X22R(J)
      Y22I=X22I(J)
      GO TO 17
16    Y22R=TP*X11I(J)/WLAM
      Y12R=0.
      Y12I=1./(X11R(J)*SIN(Y22R))
      Y11R=X12R(J)
      Y11I=-Y12I*COS(Y22R)
      Y22R=X22R(J)
      Y22I=Y11I+X22I(J)
      Y11I=Y11I+X12I(J)
      IF (NTYP(J).EQ.2) GO TO 17
      Y12R=-Y12R
      Y12I=-Y12I
17    IF (NSANT.EQ.0) GO TO 19
      DO 18 I=1,NSANT
      IF (NSEG1.NE.ISANT(I)) GO TO 18
      ISC1=I
      GO TO 22
18    CONTINUE
19    ISC1=0
      IF (NTEQ.EQ.0) GO TO 21
      DO 20 I=1,NTEQ
      IF (NSEG1.NE.NTEQA(I)) GO TO 20
      IROW1=I
      GO TO 25
20    CONTINUE
21    NTEQ=NTEQ+1
      IROW1=NTEQ
      NTEQA(NTEQ)=NSEG1
      GO TO 25
22    IF (NTSC.EQ.0) GO TO 24
      DO 23 I=1,NTSC
      IF (NSEG1.NE.NTSCA(I)) GO TO 23
      IROW1=NDIMNP-I
      GO TO 25
23    CONTINUE
24    NTSC=NTSC+1
      IROW1=NDIMNP-NTSC
      NTSCA(NTSC)=NSEG1
      VSRC(NTSC)=VSANT(ISC1)
25    IF (NSANT.EQ.0) GO TO 27
      DO 26 I=1,NSANT
      IF (NSEG2.NE.ISANT(I)) GO TO 26
      ISC2=I
      GO TO 30
26    CONTINUE
27    ISC2=0
      IF (NTEQ.EQ.0) GO TO 29
      DO 28 I=1,NTEQ
      IF (NSEG2.NE.NTEQA(I)) GO TO 28
      IROW2=I
      GO TO 33
28    CONTINUE
29    NTEQ=NTEQ+1
      IROW2=NTEQ
      NTEQA(NTEQ)=NSEG2
      GO TO 33
30    IF (NTSC.EQ.0) GO TO 32
      DO 31 I=1,NTSC
      IF (NSEG2.NE.NTSCA(I)) GO TO 31
      IROW2=NDIMNP-I
      GO TO 33
31    CONTINUE
32    NTSC=NTSC+1
      IROW2=NDIMNP-NTSC
      NTSCA(NTSC)=NSEG2
      VSRC(NTSC)=VSANT(ISC2)
33    IF (NTSC+NTEQ.LT.NDIMNP) GO TO 34
      WRITE(6,59)
      STOP
C
C     FILL NETWORK EQUATION MATRIX AND RIGHT HAND SIDE VECTOR WITH
C     NETWORK SHORT-CIRCUIT ADMITTANCE MATRIX COEFFICIENTS.
C
34    IF (ISC1.NE.0) GO TO 35
      CMN(IROW1,IROW1)=CMN(IROW1,IROW1)-CMPLX(Y11R,Y11I)*SI(NSEG1)
      CMN(IROW1,IROW2)=CMN(IROW1,IROW2)-CMPLX(Y12R,Y12I)*SI(NSEG1)
      GO TO 36
35    RHNX(IROW1)=RHNX(IROW1)+CMPLX(Y11R,Y11I)*VSANT(ISC1)/WLAM
      RHNX(IROW2)=RHNX(IROW2)+CMPLX(Y12R,Y12I)*VSANT(ISC1)/WLAM
36    IF (ISC2.NE.0) GO TO 37
      CMN(IROW2,IROW2)=CMN(IROW2,IROW2)-CMPLX(Y22R,Y22I)*SI(NSEG2)
      CMN(IROW2,IROW1)=CMN(IROW2,IROW1)-CMPLX(Y12R,Y12I)*SI(NSEG2)
      GO TO 38
37    RHNX(IROW1)=RHNX(IROW1)+CMPLX(Y12R,Y12I)*VSANT(ISC2)/WLAM
      RHNX(IROW2)=RHNX(IROW2)+CMPLX(Y22R,Y22I)*VSANT(ISC2)/WLAM
38    CONTINUE
C
C     ADD INTERACTION MATRIX ADMITTANCE ELEMENTS TO NETWORK EQUATION
C     MATRIX
C
      DO 41 I=1,NTEQ
      DO 39 J=1,NEQT
39    RHS(J)=(0.,0.)
      IROW1=NTEQA(I)
      RHS(IROW1)=(1.,0.)
      CALL SOLGF (CM,CMB,CMC,CMD,RHS,IP,NP,N1,N,MP,M1,M,NEQ,NEQ2,NEQZ2)
      CALL CABC (RHS)
      DO 40 J=1,NTEQ
      IROW1=NTEQA(J)
40    CMN(I,J)=CMN(I,J)+RHS(IROW1)
41    CONTINUE
C
C     FACTOR NETWORK EQUATION MATRIX
C
      CALL FACTR (NTEQ,CMN,IPNT,NDIMN)
C
C     ADD TO NETWORK EQUATION RIGHT HAND SIDE THE TERMS DUE TO ELEMENT
C     INTERACTIONS
C
42    IF (NONET.EQ.0) GO TO 48
      DO 43 I=1,NEQT
43    RHS(I)=EINC(I)
      CALL SOLGF (CM,CMB,CMC,CMD,RHS,IP,NP,N1,N,MP,M1,M,NEQ,NEQ2,NEQZ2)
      CALL CABC (RHS)
      DO 44 I=1,NTEQ
      IROW1=NTEQA(I)
44    RHNT(I)=RHNX(I)+RHS(IROW1)
C
C     SOLVE NETWORK EQUATIONS
C
      CALL SOLVE (NTEQ,CMN,IPNT,RHNT,NDIMN)
C
C     ADD FIELDS DUE TO NETWORK VOLTAGES TO ELECTRIC FIELDS APPLIED TO
C     STRUCTURE AND SOLVE FOR INDUCED CURRENT
C
      DO 45 I=1,NTEQ
      IROW1=NTEQA(I)
45    EINC(IROW1)=EINC(IROW1)-RHNT(I)
      CALL SOLGF (CM,CMB,CMC,CMD,EINC,IP,NP,N1,N,MP,M1,M,NEQ,NEQ2,NEQZ2)
      CALL CABC (EINC)
      IF (NPRINT.EQ.0) WRITE(6,61)
      IF (NPRINT.EQ.0) WRITE(6,60)
      DO 46 I=1,NTEQ
      IROW1=NTEQA(I)
      VLT=RHNT(I)*SI(IROW1)*WLAM
      CUX=EINC(IROW1)*WLAM
      YMIT=CUX/VLT
      ZPED=VLT/CUX
      IROW2=ITAG(IROW1)
      PWR=.5*REAL(VLT*CONJG(CUX))
      PNLS=PNLS-PWR
46    IF (NPRINT.EQ.0) WRITE(6,62)  IROW2,IROW1,VLT,CUX,ZPED,YMIT,PWR
      IF (NTSC.EQ.0) GO TO 49
      DO 47 I=1,NTSC
      IROW1=NTSCA(I)
      VLT=VSRC(I)
      CUX=EINC(IROW1)*WLAM
      YMIT=CUX/VLT
      ZPED=VLT/CUX
      IROW2=ITAG(IROW1)
      PWR=.5*REAL(VLT*CONJG(CUX))
      PNLS=PNLS-PWR
47    IF (NPRINT.EQ.0) WRITE(6,62)  IROW2,IROW1,VLT,CUX,ZPED,YMIT,PWR
      GO TO 49
C
C     SOLVE FOR CURRENTS WHEN NO NETWORKS ARE PRESENT
C
48    CALL SOLGF (CM,CMB,CMC,CMD,EINC,IP,NP,N1,N,MP,M1,M,NEQ,NEQ2,NEQZ2)
      CALL CABC (EINC)
      NTSC=0
49    IF (NSANT+NVQD.EQ.0) RETURN
      WRITE(6,63)
      WRITE(6,60)
      IF (NSANT.EQ.0) GO TO 56
      DO 55 I=1,NSANT
      ISC1=ISANT(I)
      VLT=VSANT(I)
      IF (NTSC.EQ.0) GO TO 51
      DO 50 J=1,NTSC
      IF (NTSCA(J).EQ.ISC1) GO TO 52
50    CONTINUE
51    CUX=EINC(ISC1)*WLAM
      IROW1=0
      GO TO 54
52    IROW1=NDIMNP-J
      CUX=RHNX(IROW1)
      DO 53 J=1,NTEQ
53    CUX=CUX-CMN(J,IROW1)*RHNT(J)
      CUX=(EINC(ISC1)+CUX)*WLAM
54    YMIT=CUX/VLT
      ZPED=VLT/CUX
      PWR=.5*REAL(VLT*CONJG(CUX))
      PIN=PIN+PWR
      IF (IROW1.NE.0) PNLS=PNLS+PWR
      IROW2=ITAG(ISC1)
55    WRITE(6,62)  IROW2,ISC1,VLT,CUX,ZPED,YMIT,PWR
56    IF (NVQD.EQ.0) RETURN
      DO 57 I=1,NVQD
      ISC1=IVQD(I)
      VLT=VQD(I)
      CUX=CMPLX(AIR(ISC1),AII(ISC1))
      YMIT=CMPLX(BIR(ISC1),BII(ISC1))
      ZPED=CMPLX(CIR(ISC1),CII(ISC1))
      PWR=SI(ISC1)*TP*.5
      CUX=(CUX-YMIT*SIN(PWR)+ZPED*COS(PWR))*WLAM
      YMIT=CUX/VLT
      ZPED=VLT/CUX
      PWR=.5*REAL(VLT*CONJG(CUX))
      PIN=PIN+PWR
      IROW2=ITAG(ISC1)
57    WRITE(6,64)  IROW2,ISC1,VLT,CUX,ZPED,YMIT,PWR
      RETURN
C
58    FORMAT (///, 3X, 'MAXIMUM RELATIVE ASYMMETRY OF THE DRIVING ',
     1       'POINT ADMITTANCE MATRIX IS', 1P, E10.3, ' FOR SEGMENTS',
     2       I5, ' AND', I5, /, 3X, 'RMS RELATIVE ASYMMETRY IS', E10.3)
59    FORMAT (1X, 'ERROR - - NETWORK ARRAY DIMENSIONS TOO SMALL')
60    FORMAT (/, 3X, 'TAG', 3X, 'SEG.', 4X, 'VOLTAGE (VOLTS)', 9X,
     1        'CURRENT (AMPS)', 9X, 'IMPEDANCE (OHMS)', 8X, 'ADMIT',
     2        'TANCE (MHOS)', 6X, 'POWER', /, 3X, 'NO.', 3X, 'NO.',
     3        4X, 'REAL',8X, 'IMAG.', 3(7X, 'REAL', 8X, 'IMAG.'), 5X,
     4        '(WATTS)')
61    FORMAT (///, 27X, '- - - STRUCTURE EXCITATION DATA AT NETWORK',
     1        ' CONNECTION POINTS - - -')
62    FORMAT (2(1X, I5), 1P, 9E12.5)
63    FORMAT (///, 42X, '- - - ANTENNA INPUT PARAMETERS - - -')
64    FORMAT (1X, I5, ' *', I4, 1P, 9E12.5)
      END
