      PROGRAM NEC2S
C CCS version 2.1.N - compiled for PC with SVS Fortran 77
C     PROGRAM NEC(INPUT,TAPE5=INPUT,OUTPUT,TAPE11,TAPE12,TAPE13,TAPE14,
C    1TAPE15,TAPE16,TAPE20,TAPE21)
C
C     NUMERICAL ELECTROMAGNETICS CODE (NEC2)  DEVELOPED AT LAWRENCE
C     LIVERMORE LAB., LIVERMORE, CA.  (CONTACT G. BURKE AT 415-422-8414
C     FOR PROBLEMS WITH THE NEC CODE).
C     FILE CREATED 7/16/93.
C
C                ***********NOTICE**********
C     THIS COMPUTER CODE MATERIAL WAS PREPARED AS AN ACCOUNT OF WORK
C     SPONSORED BY THE UNITED STATES GOVERNMENT.  NEITHER THE UNITED
C     STATES NOR THE UNITED STATES DEPARTMENT OF ENERGY, NOR ANY OF
C     THEIR EMPLOYEES, NOR ANY OF THEIR CONTRACTORS, SUBCONTRACTORS, OR
C     THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR
C     ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY,
C     COMPLETENESS OR USEFULNESS OF ANY INFORMATION, APPARATUS, PRODUCT
C     OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT
C     INFRINGE PRIVATELY-OWNED RIGHTS.
C
C***
      INCLUDE 'MAX.PAR'
      CHARACTER AIN*2,ATST*2
C***
      CHARACTER*6 HPOL,PNET
      COMPLEX  CM,FJ,VSANT,ETH,EPH,ZRATI,CUR,CURI,ZARRAY,ZRATI2
      COMPLEX  EX,EY,EZ,ZPED,VQD,VQDS,T1,Y11A,Y12A,EPSC,U,U2,XX1,XX2
      COMPLEX  AR1,AR2,AR3,EPSCF,FRATI
      INCLUDE 'ANGL.PAR'
      INCLUDE 'CMB.PAR'
      INCLUDE 'CRNT.PAR'
      INCLUDE 'DATA.PAR'
      INCLUDE 'SAVE.PAR'
      INCLUDE 'SCRATM.PAR'
      INCLUDE 'ZLOAD.PAR'
      COMMON /MATPAR/ ICASE,NBLOKS,NPBLK,NLAST,NBLSYM,NPSYM,NLSYM,IMAT,
     1ICASX,NBBX,NPBX,NLBX,NBBL,NPBL,NLBL
      COMMON /GND/ZRATI,ZRATI2,FRATI,CL,CH,SCRWL,SCRWR,NRADL,KSYMP,IFAR,
     1IPERF,T1,T2
      COMMON/YPARM/NCOUP,ICOUP,NCTAG(5),NCSEG(5),Y11A(5),Y12A(20)
      COMMON /SEGJ/ AX(30),BX(30),CX(30),JCO(30),JSNO,ISCON(50),NSCON,
     1IPCON(10),NPCON
      COMMON/VSORC/VQD(30),VSANT(30),VQDS(30),IVQD(30),ISANT(30),
     1IQDS(30),NVQD,NSANT,NQDS
      INCLUDE 'NETCX.PAR'
      COMMON/FPAT/NTH,NPH,IPD,IAVP,INOR,IAX,THETS,PHIS,DTH,DPH,
     1RFLD,GNOR,CLT,CHT,EPSR2,SIG2,IXTYP,XPR6,PINR,PNLR,PLOSS,
     1NEAR,NFEH,NRX,NRY,NRZ,XNR,YNR,ZNR,DXNR,DYNR,DZNR
      COMMON /GGRID/ AR1(11,10,4),AR2(17,5,4),AR3(9,8,4),EPSCF,DXA(3),
     1DYA(3),XSA(3),YSA(3),NXA(3),NYA(3)
      COMMON/GWAV/U,U2,XX1,XX2,R1,R2,ZMH,ZPH
C***
      COMMON /PLOT/ IPLP1,IPLP2,IPLP3,IPLP4
C***
      DIMENSION CAB(1),SAB(1),X2(1),Y2(1),Z2(1)
      DIMENSION LDTYP(30),LDTAG(30),LDTAGF(30),LDTAGT(30),ZLR(30),
     1ZLI(30),ZLC(30)
      DIMENSION ATST(22),PNET(6),HPOL(3),IX(MWS+2*MSP)  !CCS 5/87
      DIMENSION FNORM(200)
      DIMENSION T1X(1),T1Y(1),T1Z(1),T2X(1),T2Y(1),T2Z(1)
C***
      DIMENSION XTEMP(MWS+MSP),YTEMP(MWS+MSP),ZTEMP(MWS+MSP),
     1          SITEMP(MWS+MSP),BITEMP(MWS+MSP)               ! CCS 6/87
      EQUIVALENCE (CAB,ALP),(SAB,BET),(X2,SI),(Y2,ALP),(Z2,BET)
      EQUIVALENCE (T1X,SI),(T1Y,ALP),(T1Z,BET),(T2X,ICON1),(T2Y,ICON2),
     1 (T2Z,ITAG)
      DATA ATST/'CE','FR','LD','GN','EX','NT','XQ','NE','GD','RP','CM',
     1 'NX','EN','TL','PT','KH','NH','PQ','EK','WG','CP','PL'/
      DATA HPOL/'LINEAR','RIGHT','LEFT'/
      DATA PNET/'      ','  ','STRAIG','HT','CROSSE','D'/
      DATA TA/1.745329252E-02/,CVEL/299.8/
      DATA LOADMX,NSMAX,NETMX/30,30,NNET/,NORMF/200/      ! CCS 6/87
C***
      CALL GETFILE
      CALL VERS
C***
      CALL SECOND(EXTIM)
      FJ=(0.,1.)
      LD = MWS + MSP    ! CCS 5/87
      NXA(1)=0
      IRESRV=MRES   ! CCS 5/87
1     KCOM=0
C***
      IFRTIMW=0
      IFRTIMP=0
C***
2     KCOM=KCOM+1
      IF (KCOM.GT.5) KCOM=5
      READ(5,125)AIN,(COM(I,KCOM),I=1,19)
C***
      CALL UPPER(AIN)
C***
      IF(KCOM.GT.1)GO TO 3
      WRITE(6,126)
      WRITE(6,127)
      WRITE(6,128)
3     WRITE(6,129) (COM(I,KCOM),I=1,19)
      IF (AIN.EQ.ATST(11)) GO TO 2
      IF (AIN.EQ.ATST(1)) GO TO 4
      WRITE(6,130)
      STOP
4     CONTINUE
      DO 5 I=1,LD
5     ZARRAY(I)=(0.,0.)
      MPCNT=0
      IMAT=0
C
C     SET UP GEOMETRY DATA IN SUBROUTINE DATAGN
C
      CALL  DATAGN
      IFLOW=1
      IF(IMAT.EQ.0)GO TO 326
C
C     CORE ALLOCATION FOR ARRAYS B, C, AND D FOR N.G.F. SOLUTION
C
      NEQ=N1+2*M1
      NEQ2=N-N1+2*(M-M1)+NSCON+2*NPCON
      CALL FBNGF(NEQ,NEQ2,IRESRV,IB11,IC11,ID11,IX11)
      GO TO 6
326   NEQ=N+2*M
      NEQ2=0
      IB11=1
      IC11=1
      ID11=1
      IX11=1
      ICASX=0
6     NPEQ=NP+2*MP
      WRITE(6,135)
C
C     DEFAULT VALUES FOR INPUT PARAMETERS AND FLAGS
C
C***
      IPLP1=0
      IPLP2=0
      IPLP3=0
      IPLP4=0
C***
      IGO=1
      FMHZS=CVEL
      NFRQ=1
      RKH=1.
      IEXK=0
      IXTYP=0
      NLOAD=0
      NONET=0
      NEAR=-1
      IPTFLG=-2
      IPTFLQ=-1
      IFAR=-1
      ZRATI=(1.,0.)
      IPED=0
      IRNGF=0
      NCOUP=0
      ICOUP=0
      IF(ICASX.GT.0)GO TO 14
      FMHZ=CVEL
      NLODF=0
      KSYMP=1
      NRADL=0
      IPERF=0
C
C     MAIN INPUT SECTION - STANDARD READ STATEMENT - JUMPS TO APPRO-
C     PRIATE SECTION FOR SPECIFIC PARAMETER SET UP
C
C14    READ(5,136)AIN,ITMP1,ITMP2,ITMP3,ITMP4,TMP1,TMP2,TMP3,TMP4,TMP5,
C     1TMP6
C***
14    CALL READMN(AIN,ITMP1,ITMP2,ITMP3,ITMP4,TMP1,TMP2,TMP3,TMP4,TMP5,
     1TMP6)
C***
      MPCNT=MPCNT+1
      WRITE(6,137) MPCNT,AIN,ITMP1,ITMP2,ITMP3,ITMP4,TMP1,TMP2,TMP3,
     1TMP4,TMP5,TMP6
      IF (AIN.EQ.ATST(2)) GO TO 16
      IF (AIN.EQ.ATST(3)) GO TO 17
      IF (AIN.EQ.ATST(4)) GO TO 21
      IF (AIN.EQ.ATST(5)) GO TO 24
      IF (AIN.EQ.ATST(6)) GO TO 28
      IF (AIN.EQ.ATST(14)) GO TO 28
      IF (AIN.EQ.ATST(15)) GO TO 31
      IF (AIN.EQ.ATST(18)) GO TO 319
      IF (AIN.EQ.ATST(7)) GO TO 37
      IF (AIN.EQ.ATST(8)) GO TO 32
      IF (AIN.EQ.ATST(17)) GO TO 208
      IF (AIN.EQ.ATST(9)) GO TO 34
      IF (AIN.EQ.ATST(10)) GO TO 36
      IF (AIN.EQ.ATST(16)) GO TO 305
      IF (AIN.EQ.ATST(19)) GO TO 320
      IF (AIN.EQ.ATST(12)) GO TO 1
      IF (AIN.EQ.ATST(20)) GO TO 322
      IF (AIN.EQ.ATST(21)) GO TO 304
C***
      IF (AIN.EQ.ATST(22)) GO TO 330
C***
      IF (AIN.NE.ATST(13)) GO TO 15
      CALL SECOND(TMP1)
      TMP1=TMP1-EXTIM
      WRITE(6,201) TMP1  ! end of program time
D      CALL PRINT_STACK_USAGE()
      STOP
15    WRITE(6,138)
      STOP
C
C     FREQUENCY PARAMETERS
C
16    IFRQ=ITMP1
      IF(ICASX.EQ.0)GO TO 8
      WRITE(6,303) AIN
      STOP
8     NFRQ=ITMP2
      IF (NFRQ.EQ.0) NFRQ=1
      FMHZ=TMP1
      DELFRQ=TMP2
      IF(IPED.EQ.1)ZPNORM=0.
      IGO=1
      IFLOW=1
      GO TO 14
C
C     MATRIX INTEGRATION LIMIT
C
305   RKH=TMP1
      IF(IGO.GT.2)IGO=2
      IFLOW=1
      GO TO 14
C
C     EXTENDED THIN WIRE KERNEL OPTION
C
320   IEXK=1
      IF(ITMP1.EQ.-1)IEXK=0
      IF(IGO.GT.2)IGO=2
      IFLOW=1
      GO TO 14
C
C     MAXIMUM COUPLING BETWEEN ANTENNAS
C
304   IF(IFLOW.NE.2)NCOUP=0
      ICOUP=0
      IFLOW=2
      IF(ITMP2.EQ.0)GO TO 14
      NCOUP=NCOUP+1
      IF(NCOUP.GT.5)GO TO 312
      NCTAG(NCOUP)=ITMP1
      NCSEG(NCOUP)=ITMP2
      IF(ITMP4.EQ.0)GO TO 14
      NCOUP=NCOUP+1
      IF(NCOUP.GT.5)GO TO 312
      NCTAG(NCOUP)=ITMP3
      NCSEG(NCOUP)=ITMP4
      GO TO 14
312   WRITE(6,313)
      STOP
C
C     LOADING PARAMETERS
C
17    IF (IFLOW.EQ.3) GO TO 18
      NLOAD=0
      IFLOW=3
      IF (IGO.GT.2) IGO=2
      IF (ITMP1.EQ.(-1)) GO TO 14
18    NLOAD=NLOAD+1
      IF (NLOAD.LE.LOADMX) GO TO 19
      WRITE(6,139)
      STOP
19    LDTYP(NLOAD)=ITMP1
      LDTAG(NLOAD)=ITMP2
      IF (ITMP4.EQ.0) ITMP4=ITMP3
      LDTAGF(NLOAD)=ITMP3
      LDTAGT(NLOAD)=ITMP4
      IF (ITMP4.GE.ITMP3) GO TO 20
      WRITE(6,140)  NLOAD,ITMP3,ITMP4
      STOP
20    ZLR(NLOAD)=TMP1
      ZLI(NLOAD)=TMP2
      ZLC(NLOAD)=TMP3
      GO TO 14
C
C     GROUND PARAMETERS UNDER THE ANTENNA
C
21    IFLOW=4
      IF(ICASX.EQ.0)GO TO 10
      WRITE(6,303) AIN
      STOP
10    IF (IGO.GT.2) IGO=2
      IF (ITMP1.NE.(-1)) GO TO 22
      KSYMP=1
      NRADL=0
      IPERF=0
      GO TO 14
22    IPERF=ITMP1
      NRADL=ITMP2
      KSYMP=2
      EPSR=TMP1
      SIG=TMP2
      IF (NRADL.EQ.0) GO TO 23
      IF(IPERF.NE.2)GO TO 314
      WRITE(6,390)
      STOP
314   SCRWLT=TMP3
      SCRWRT=TMP4
      GO TO 14
23    EPSR2=TMP3
      SIG2=TMP4
      CLT=TMP5
      CHT=TMP6
      GO TO 14
C
C     EXCITATION PARAMETERS
C
24    IF (IFLOW.EQ.5) GO TO 25
      NSANT=0
      NVQD=0
      IPED=0
      IFLOW=5
      IF (IGO.GT.3) IGO=3
25    MASYM=ITMP4/10
      IF (ITMP1.GT.0.AND.ITMP1.NE.5) GO TO 27
      IXTYP=ITMP1
      NTSOL=0
      IF(IXTYP.EQ.0)GO TO 205
      NVQD=NVQD+1
      IF(NVQD.GT.NSMAX)GO TO 206
      IVQD(NVQD)=ISEGNO(ITMP2,ITMP3)
      VQD(NVQD)=CMPLX(TMP1,TMP2)
      IF(CABS(VQD(NVQD)).LT.1.E-20)VQD(NVQD)=(1.,0.)
      GO TO 207
205   NSANT=NSANT+1
      IF (NSANT.LE.NSMAX) GO TO 26
206   WRITE(6,141)
      STOP
26    ISANT(NSANT)=ISEGNO(ITMP2,ITMP3)
      VSANT(NSANT)=CMPLX(TMP1,TMP2)
      IF (CABS(VSANT(NSANT)).LT.1.E-20) VSANT(NSANT)=(1.,0.)
207   IPED=ITMP4-MASYM*10
      ZPNORM=TMP3
      IF (IPED.EQ.1.AND.ZPNORM.GT.0) IPED=2
      GO TO 14
27    IF (IXTYP.EQ.0.OR.IXTYP.EQ.5) NTSOL=0
      IXTYP=ITMP1
      NTHI=ITMP2
      NPHI=ITMP3
      XPR1=TMP1
      XPR2=TMP2
      XPR3=TMP3
      XPR4=TMP4
      XPR5=TMP5
      XPR6=TMP6
      NSANT=0
      NVQD=0
      THETIS=XPR1
      PHISS=XPR2
      GO TO 14
C
C     NETWORK PARAMETERS
C
28    IF (IFLOW.EQ.6) GO TO 29
      NONET=0
      NTSOL=0
      IFLOW=6
      IF (IGO.GT.3) IGO=3
      IF (ITMP2.EQ.(-1)) GO TO 14
29    NONET=NONET+1
      IF (NONET.LE.NETMX) GO TO 30
      WRITE(6,142)
      STOP
30    NTYP(NONET)=2
      IF (AIN.EQ.ATST(6)) NTYP(NONET)=1
      ISEG1(NONET)=ISEGNO(ITMP1,ITMP2)
      ISEG2(NONET)=ISEGNO(ITMP3,ITMP4)
      X11R(NONET)=TMP1
      X11I(NONET)=TMP2
      X12R(NONET)=TMP3
      X12I(NONET)=TMP4
      X22R(NONET)=TMP5
      X22I(NONET)=TMP6
      IF (NTYP(NONET).EQ.1.OR.TMP1.GT.0.) GO TO 14
      NTYP(NONET)=3
      X11R(NONET)=-TMP1
      GO TO 14
C***
C
C     PLOT FLAGS
C
330   IPLP1=ITMP1
      IPLP2=ITMP2
      IPLP3=ITMP3
      IPLP4=ITMP4
C***
      GO TO 14
C
C     PRINT CONTROL FOR CURRENT
C
31    IPTFLG=ITMP1
      IPTAG=ITMP2
      IPTAGF=ITMP3
      IPTAGT=ITMP4
      IF(ITMP3.EQ.0.AND.IPTFLG.NE.-1)IPTFLG=-2
      IF (ITMP4.EQ.0) IPTAGT=IPTAGF
      GO TO 14
C
C     WRITE CONTROL FOR CHARGE
C
319   IPTFLQ=ITMP1
      IPTAQ=ITMP2
      IPTAQF=ITMP3
      IPTAQT=ITMP4
      IF(ITMP3.EQ.0.AND.IPTFLQ.NE.-1)IPTFLQ=-2
      IF(ITMP4.EQ.0)IPTAQT=IPTAQF
      GO TO 14
C
C     NEAR FIELD CALCULATION PARAMETERS
C
208   NFEH=1
      GO TO 209
32    NFEH=0
209   IF (.NOT.(IFLOW.EQ.8.AND.NFRQ.NE.1)) GO TO 33
      WRITE(6,143)
33    NEAR=ITMP1
      NRX=ITMP2
      NRY=ITMP3
      NRZ=ITMP4
      XNR=TMP1
      YNR=TMP2
      ZNR=TMP3
      DXNR=TMP4
      DYNR=TMP5
      DZNR=TMP6
      IFLOW=8
      IF (NFRQ.NE.1) GO TO 14
      GO TO (41,46,53,71,72), IGO
C
C     GROUND REPRESENTATION
C
34    EPSR2=TMP1
      SIG2=TMP2
      CLT=TMP3
      CHT=TMP4
      IFLOW=9
      GO TO 14
C
C     STANDARD OBSERVATION ANGLE PARAMETERS
C
36    IFAR=ITMP1
      NTH=ITMP2
      NPH=ITMP3
      IF (NTH.EQ.0) NTH=1
      IF (NPH.EQ.0) NPH=1
      IPD=ITMP4/10
      IAVP=ITMP4-IPD*10
      INOR=IPD/10
      IPD=IPD-INOR*10
      IAX=INOR/10
      INOR=INOR-IAX*10
      IF (IAX.NE.0) IAX=1
      IF (IPD.NE.0) IPD=1
      IF (NTH.LT.2.OR.NPH.LT.2) IAVP=0
      IF (IFAR.EQ.1) IAVP=0
      THETS=TMP1
      PHIS=TMP2
      DTH=TMP3
      DPH=TMP4
      RFLD=TMP5
      GNOR=TMP6
      IFLOW=10
      GO TO (41,46,53,71,78), IGO
C
C     WRITE NUMERICAL GREEN'S FUNCTION TAPE
C
322   IFLOW=12
      IF(ICASX.EQ.0)GO TO 301
      WRITE(6,302)
      STOP
301   IRNGF=IRESRV/2
      GO TO (41,46,52,52,52),IGO
C
C     EXECUTE CARD  -  CALC. INCLUDING RADIATED FIELDS
C
37    IF (IFLOW.EQ.10.AND.ITMP1.EQ.0) GO TO 14
      IF (NFRQ.EQ.1.AND.ITMP1.EQ.0.AND.IFLOW.GT.7) GO TO 14
      IF (ITMP1.NE.0) GO TO 39
      IF (IFLOW.GT.7) GO TO 38
      IFLOW=7
      GO TO 40
38    IFLOW=11
      GO TO 40
39    IFAR=0
      RFLD=0.
      IPD=0
      IAVP=0
      INOR=0
      IAX=0
      NTH=91
      NPH=1
      THETS=0.
      PHIS=0.
      DTH=1.0
      DPH=0.
      IF (ITMP1.EQ.2) PHIS=90.
      IF (ITMP1.NE.3) GO TO 40
      NPH=2
      DPH=90.
40    GO TO (41,46,53,71,78), IGO
C
C     END OF THE MAIN INPUT SECTION
C
C     BEGINNING OF THE FREQUENCY DO LOOP
C
41    MHZ=1
C***
      IF(N.EQ.0 .OR. IFRTIMW .EQ. 1)GO TO 406
        IFRTIMW=1
        DO 445 I=1,N
           XTEMP(I)=X(I)
           YTEMP(I)=Y(I)
           ZTEMP(I)=Z(I)
           SITEMP(I)=SI(I)
           BITEMP(I)=BI(I)
445     CONTINUE
406     IF(M.EQ.0 .OR. IFRTIMP .EQ. 1)GO TO 407
        IFRTIMP=1
        J=LD+1
        DO 545 I=1,M
           J=J-1
           XTEMP(J)=X(J)
           YTEMP(J)=Y(J)
           ZTEMP(J)=Z(J)
           BITEMP(J)=BI(J)
545     CONTINUE
407     CONTINUE
        FMHZ1=FMHZ
C***
C     CORE ALLOCATION FOR PRIMARY INTERACTON MATRIX.  (A)
      IF(IMAT.EQ.0)CALL FBLOCK(NPEQ,NEQ,IRESRV,IRNGF,IPSYM)
42    IF (MHZ.EQ.1) GO TO 44
      IF (IFRQ.EQ.1) GO TO 43
C      FMHZ=FMHZ+DELFRQ
C***
      FMHZ=FMHZ1+(MHZ-1)*DELFRQ
      GO TO 44
43    FMHZ=FMHZ*DELFRQ
44    FR=FMHZ/CVEL
C***
      WLAM=CVEL/FMHZ
      WRITE(6,145)  FMHZ,WLAM
      WRITE(6,196) RKH
      IF(IEXK.EQ.1)WRITE(6,321)
C     FREQUENCY SCALING OF GEOMETRIC PARAMETERS
C***      FMHZS=FMHZ
      IF(N.EQ.0)GO TO 306
      DO 45 I=1,N
C***
      X(I)=XTEMP(I)*FR
      Y(I)=YTEMP(I)*FR
      Z(I)=ZTEMP(I)*FR
      SI(I)=SITEMP(I)*FR
45    BI(I)=BITEMP(I)*FR
C***
306   IF(M.EQ.0)GO TO 307
      FR2=FR*FR
      J=LD+1
      DO 245 I=1,M
      J=J-1
C***
      X(J)=XTEMP(J)*FR
      Y(J)=YTEMP(J)*FR
      Z(J)=ZTEMP(J)*FR
245   BI(J)=BITEMP(J)*FR2
C***
307   IGO=2
C     STRUCTURE SEGMENT LOADING
46    WRITE(6,146)
      IF(NLOAD.NE.0) CALL LOAD(LDTYP,LDTAG,LDTAGF,LDTAGT,ZLR,ZLI,ZLC)
      IF(NLOAD.EQ.0.AND.NLODF.EQ.0)WRITE(6,147)
      IF(NLOAD.EQ.0.AND.NLODF.NE.0)WRITE(6,327)
C     GROUND PARAMETER
      WRITE(6,148)
      IF (KSYMP.EQ.1) GO TO 49
      FRATI=(1.,0.)
      IF (IPERF.EQ.1) GO TO 48
      IF(SIG.LT.0.)SIG=-SIG/(59.96*WLAM)
      EPSC=CMPLX(EPSR,-SIG*WLAM*59.96)
      ZRATI=1./CSQRT(EPSC)
      U=ZRATI
      U2=U*U
      IF (NRADL.EQ.0) GO TO 47
      SCRWL=SCRWLT/WLAM
      SCRWR=SCRWRT/WLAM
      T1=FJ*2367.067/FLOAT(NRADL)
      T2=SCRWR*FLOAT(NRADL)
      WRITE(6,170)  NRADL,SCRWLT,SCRWRT
      WRITE(6,149)
47    IF(IPERF.EQ.2)GO TO 328
      WRITE(6,391)
      GO TO 329
328   IF(NXA(1).EQ.0) then
         open(21, file='fort.21', form='unformatted')
         READ(21)AR1,AR2,AR3,EPSCF,DXA,DYA,XSA,YSA,NXA,NYA
         close (21)
      endif
      FRATI=(EPSC-1.)/(EPSC+1.)
      IF(CABS((EPSCF-EPSC)/EPSC).LT.1.E-3)GO TO 400
      WRITE(6,393) EPSCF,EPSC
      STOP
400   WRITE(6,392)
329   WRITE(6,150)  EPSR,SIG,EPSC
      GO TO 50
48    WRITE(6,151)
      GO TO 50
49    WRITE(6,152)
50    CONTINUE
C * * *
C     FILL AND FACTOR PRIMARY INTERACTION MATRIX
C
      CALL SECOND (TIM1)
      IF(ICASX.NE.0)GO TO 324
      CALL CMSET(NEQ,CM,RKH,IEXK)
      CALL SECOND (TIM2)
      TIM=TIM2-TIM1
      CALL FACTRS(NPEQ,NEQ,CM,IP,IX,11,12,13,14)
      GO TO 323
C
C     N.G.F. - FILL B, C, AND D AND FACTOR D-C(INV(A)B)
C
C *****
324   IF(NEQ2.EQ.0)GO TO 333
C *****
      CALL CMNGF(CM(IB11),CM(IC11),CM(ID11),NPBX,NEQ,NEQ2,RKH,IEXK)
      CALL SECOND (TIM2)
      TIM=TIM2-TIM1
      CALL FACGF(CM,CM(IB11),CM(IC11),CM(ID11),CM(IX11),IP,IX,NP,N1,MP,
     1M1,NEQ,NEQ2)
323   CALL SECOND (TIM1)
      TIM2=TIM1-TIM2
      WRITE(6,153)  TIM,TIM2
333   IGO=3
      NTSOL=0
      IF(IFLOW.NE.12)GO TO 53
C     WRITE N.G.F. FILE
52    CALL GFOUT
      GO TO 14
C
C     EXCITATION SET UP (RIGHT HAND SIDE, -E INC.)
C
53    NTHIC=1
      NPHIC=1
      INC=1
      NPRINT=0
54    IF (IXTYP.EQ.0.OR.IXTYP.EQ.5) GO TO 56
      IF (IPTFLG.LE.0.OR.IXTYP.EQ.4) WRITE(6,154)
      TMP5=TA*XPR5
      TMP4=TA*XPR4
      IF (IXTYP.NE.4) GO TO 55
      TMP1=XPR1/WLAM
      TMP2=XPR2/WLAM
      TMP3=XPR3/WLAM
      TMP6=XPR6/(WLAM*WLAM)
      WRITE(6,156)  XPR1,XPR2,XPR3,XPR4,XPR5,XPR6
      GO TO 56
55    TMP1=TA*XPR1
      TMP2=TA*XPR2
      TMP3=TA*XPR3
      TMP6=XPR6
      IF (IPTFLG.LE.0) WRITE(6,155)  XPR1,XPR2,XPR3,HPOL(IXTYP),XPR6
56    CALL ETMNS (TMP1,TMP2,TMP3,TMP4,TMP5,TMP6,IXTYP,CUR)
C
C     MATRIX SOLVING  (NETWK CALLS SOLVES)
C
      IF (NONET.EQ.0.OR.INC.GT.1) GO TO 60
      WRITE(6,158)
      ITMP3=0
      ITMP1=NTYP(1)
      DO 59 I=1,2
      IF (ITMP1.EQ.3) ITMP1=2
      IF (ITMP1.EQ.2) WRITE(6,159)
      IF (ITMP1.EQ.1) WRITE(6,160)
      DO 58 J=1,NONET
      ITMP2=NTYP(J)
      IF ((ITMP2/ITMP1).EQ.1) GO TO 57
      ITMP3=ITMP2
      GO TO 58
57    ITMP4=ISEG1(J)
      ITMP5=ISEG2(J)
      IF (ITMP2.GE.2.AND.X11I(J).LE.0.) X11I(J)=WLAM*SQRT((X(ITMP5)-
     1 X(ITMP4))**2+(Y(ITMP5)-Y(ITMP4))**2+(Z(ITMP5)-Z(ITMP4))**2)
      WRITE(6,157)  ITAG(ITMP4),ITMP4,ITAG(ITMP5),ITMP5,X11R(J),X11
     1I(J),X12R(J),X12I(J),X22R(J),X22I(J),PNET(2*ITMP2-1),PNET(2*ITMP2)
58    CONTINUE
      IF (ITMP3.EQ.0) GO TO 60
      ITMP1=ITMP3
59    CONTINUE
60    CONTINUE
      IF (INC.GT.1.AND.IPTFLG.GT.0) NPRINT=1
      CALL NETWK(CM,CM(IB11),CM(IC11),CM(ID11),IP,CUR)
      NTSOL=1
      IF (IPED.EQ.0) GO TO 61
      ITMP1=MHZ+4*(MHZ-1)
      IF (ITMP1.GT.(NORMF-3)) GO TO 61
      FNORM(ITMP1)=REAL(ZPED)
      FNORM(ITMP1+1)=AIMAG(ZPED)
      FNORM(ITMP1+2)=CABS(ZPED)
      FNORM(ITMP1+3)=CANG(ZPED)
      IF (IPED.EQ.2) GO TO 61
      IF (FNORM(ITMP1+2).GT.ZPNORM) ZPNORM=FNORM(ITMP1+2)
61    CONTINUE
C
C     PRINTING STRUCTURE CURRENTS
C
      IF(N.EQ.0)GO TO 308
      IF (IPTFLG.EQ.(-1)) GO TO 63
      IF (IPTFLG.GT.0) GO TO 62
      WRITE(6,161)
      WRITE(6,162)
      GO TO 63
62    IF (IPTFLG.EQ.3.OR.INC.GT.1) GO TO 63
      WRITE(6,163)  XPR3,HPOL(IXTYP),XPR6
63    PLOSS=0.
      ITMP1=0
      JUMP=IPTFLG+1
      DO 69 I=1,N
      CURI=CUR(I)*WLAM
      CMAG=CABS(CURI)
      PH=CANG(CURI)
      IF (NLOAD.EQ.0.AND.NLODF.EQ.0) GO TO 64
      IF (ABS(REAL(ZARRAY(I))).LT.1.E-20) GO TO 64
      PLOSS=PLOSS+.5*CMAG*CMAG*REAL(ZARRAY(I))*SI(I)
64    IF (JUMP) 68,69,65
65    IF (IPTAG.EQ.0) GO TO 66
      IF (ITAG(I).NE.IPTAG) GO TO 69
66    ITMP1=ITMP1+1
      IF (ITMP1.LT.IPTAGF.OR.ITMP1.GT.IPTAGT) GO TO 69
      IF (IPTFLG.EQ.0) GO TO 68
      IF (IPTFLG.LT.2.OR.INC.GT.NORMF) GO TO 67
      FNORM(INC)=CMAG
      ISAVE=I
67    IF (IPTFLG.NE.3) WRITE(6,164)  XPR1,XPR2,CMAG,PH,I
      GO TO 69
68    WRITE(6,165)  I,ITAG(I),X(I),Y(I),Z(I),SI(I),CURI,CMAG,PH
C***
      IF(IPLP1 .NE. 1) GO TO 69
      IF(IPLP2 .EQ. 1) WRITE(8,*) CURI
      IF(IPLP2 .EQ. 2) WRITE(8,*) CMAG,PH
C***
69    CONTINUE
      IF(IPTFLQ.EQ.(-1))GO TO 308
      WRITE(6,315)
      ITMP1=0
      FR=1.E-6/FMHZ
      DO 316 I=1,N
      IF(IPTFLQ.EQ.(-2))GO TO 318
      IF(IPTAQ.EQ.0)GO TO 317
      IF(ITAG(I).NE.IPTAQ)GO TO 316
317   ITMP1=ITMP1+1
      IF(ITMP1.LT.IPTAQF.OR.ITMP1.GT.IPTAQT)GO TO 316
318   CURI=FR*CMPLX(-BII(I),BIR(I))
      CMAG=CABS(CURI)
      PH=CANG(CURI)
      WRITE(6,165) I,ITAG(I),X(I),Y(I),Z(I),SI(I),CURI,CMAG,PH
316   CONTINUE
308   IF(M.EQ.0)GO TO 310
      WRITE(6,197)
      J=N-2
      ITMP1=LD+1
      DO 309 I=1,M
      J=J+3
      ITMP1=ITMP1-1
      EX=CUR(J)
      EY=CUR(J+1)
      EZ=CUR(J+2)
      ETH=EX*T1X(ITMP1)+EY*T1Y(ITMP1)+EZ*T1Z(ITMP1)
      EPH=EX*T2X(ITMP1)+EY*T2Y(ITMP1)+EZ*T2Z(ITMP1)
      ETHM=CABS(ETH)
      ETHA=CANG(ETH)
      EPHM=CABS(EPH)
      EPHA=CANG(EPH)
C309   WRITE(6,198) I,X(ITMP1),Y(ITMP1),Z(ITMP1),ETHM,ETHA,EPHM,EPHA,E
C     1X,EY, EZ
C***
      WRITE(6,198) I,X(ITMP1),Y(ITMP1),Z(ITMP1),ETHM,ETHA,EPHM,EPHA,E
     1X,EY,EZ
      IF(IPLP1 .NE. 1) GO TO 309
      IF(IPLP3 .EQ. 1) WRITE(8,*) EX
      IF(IPLP3 .EQ. 2) WRITE(8,*) EY
      IF(IPLP3 .EQ. 3) WRITE(8,*) EZ
      IF(IPLP3 .EQ. 4) WRITE(8,*) EX,EY,EZ
309   CONTINUE
C***
310   IF (IXTYP.NE.0.AND.IXTYP.NE.5) GO TO 70
      TMP1=PIN-PNLS-PLOSS
      TMP2=100.*TMP1/PIN
      WRITE(6,166)  PIN,TMP1,PLOSS,PNLS,TMP2
70    CONTINUE
      IGO=4
      IF(NCOUP.GT.0)CALL COUPLE(CUR,WLAM)
      IF (IFLOW.NE.7) GO TO 71
      IF (IXTYP.GT.0.AND.IXTYP.LT.4) GO TO 113
      IF (NFRQ.NE.1) GO TO 120
      WRITE(6,135)
      GO TO 14
71    IGO=5
C
C     NEAR FIELD CALCULATION
C
72    IF (NEAR.EQ.(-1)) GO TO 78
      CALL NFPAT
      IF (MHZ.EQ.NFRQ) NEAR=-1
      IF (NFRQ.NE.1) GO TO 78
      WRITE(6,135)
      GO TO 14
C
C     STANDARD FAR FIELD CALCULATION
C
78    IF(IFAR.EQ.-1)GO TO 113
      PINR=PIN
      PNLR=PNLS
      CALL RDPAT
113   IF (IXTYP.EQ.0.OR.IXTYP.GE.4) GO TO 119
      NTHIC=NTHIC+1
      INC=INC+1
      XPR1=XPR1+XPR4
      IF (NTHIC.LE.NTHI) GO TO 54
      NTHIC=1
      XPR1=THETIS
      XPR2=XPR2+XPR5
      NPHIC=NPHIC+1
      IF (NPHIC.LE.NPHI) GO TO 54
      NPHIC=1
      XPR2=PHISS
      IF (IPTFLG.LT.2) GO TO 119
C     NORMALIZED RECEIVING PATTERN PRINTED
      ITMP1=NTHI*NPHI
      IF (ITMP1.LE.NORMF) GO TO 114
      ITMP1=NORMF
      WRITE(6,181)
114   TMP1=FNORM(1)
      DO 115 J=2,ITMP1
      IF (FNORM(J).GT.TMP1) TMP1=FNORM(J)
115   CONTINUE
      WRITE(6,182)  TMP1,XPR3,HPOL(IXTYP),XPR6,ISAVE
      DO 118 J=1,NPHI
      ITMP2=NTHI*(J-1)
      DO 116 I=1,NTHI
      ITMP3=I+ITMP2
      IF (ITMP3.GT.ITMP1) GO TO 117
      TMP2=FNORM(ITMP3)/TMP1
      TMP3=DB20(TMP2)
      WRITE(6,183)  XPR1,XPR2,TMP3,TMP2
      XPR1=XPR1+XPR4
116   CONTINUE
117   XPR1=THETIS
      XPR2=XPR2+XPR5
118   CONTINUE
      XPR2=PHISS
119   IF (MHZ.EQ.NFRQ) IFAR=-1
      IF (NFRQ.NE.1) GO TO 120
      WRITE(6,135)
      GO TO 14
120   MHZ=MHZ+1
      IF (MHZ.LE.NFRQ) GO TO 42
      IF (IPED.EQ.0) GO TO 123
      IF(NVQD.LT.1)GO TO 199
      WRITE(6,184) IVQD(NVQD),ZPNORM
      GO TO 204
199   WRITE(6,184)  ISANT(NSANT),ZPNORM
204   ITMP1=NFRQ
      IF (ITMP1.LE.(NORMF/4)) GO TO 121
      ITMP1=NORMF/4
      WRITE(6,185)
121   IF (IFRQ.EQ.0) TMP1=FMHZ-(NFRQ-1)*DELFRQ
      IF (IFRQ.EQ.1) TMP1=FMHZ/(DELFRQ**(NFRQ-1))
      DO 122 I=1,ITMP1
      ITMP2=I+4*(I-1)
      TMP2=FNORM(ITMP2)/ZPNORM
      TMP3=FNORM(ITMP2+1)/ZPNORM
      TMP4=FNORM(ITMP2+2)/ZPNORM
      TMP5=FNORM(ITMP2+3)
      WRITE(6,186)  TMP1,FNORM(ITMP2),FNORM(ITMP2+1),FNORM(ITMP2+2),
     1FNORM(ITMP2+3),TMP2,TMP3,TMP4,TMP5
      IF (IFRQ.EQ.0) TMP1=TMP1+DELFRQ
      IF (IFRQ.EQ.1) TMP1=TMP1*DELFRQ
122   CONTINUE
      WRITE(6,135)
123   CONTINUE
      NFRQ=1
      MHZ=1
      GO TO 14
125   FORMAT (A2,19A4)
126   FORMAT  ('1')
127   FORMAT (///,33X,'************************************', //, 36X,
     1        'NUMERICAL ELECTROMAGNETICS CODE', //, 33X,
     2        '************* ver. 2.1.N **************')
128   FORMAT (////, 37X, '- - - - COMMENTS - - - -', //)
129   FORMAT (25X, 20A4)
130   FORMAT (///, 10X, 'INCORRECT LABEL FOR A COMMENT CARD')
135   FORMAT (/////)
136   FORMAT (A2, I3, 3I5, 6E10.3)
137   FORMAT (1X,  '***** DATA CARD NO.', I3, 3X, A2, 1X, I3,
     1        3(1X, I5),6(1X, 1P, E12.5))
138   FORMAT (///, 10X, 'FAULTY DATA CARD LABEL AFTER GEOMETRY SECTION')
139   FORMAT (///, 10X, 'NUMBER OF LOADING CARDS EXCEEDS STORAGE',
     1        ' ALLOTTED')
140   FORMAT (///, 10X, 'DATA FAULT ON LOADING CARD NO.=', I5, 5X,
     1        'ITAG STEP1=', I5, ' IS GREATER THAN ITAG STEP2=', I5)
141   FORMAT (///, 10X, 'NUMBER OF EXCITATION CARDS EXCEEDS STORAGE ',
     1        'ALLOTTED')
142   FORMAT (///, 10X, 'NUMBER OF NETWORK CARDS EXCEEDS STORAGE ',
     1        'ALLOTTED')
143   FORMAT(///, 10X, 'WHEN MULTIPLE FREQUENCIES ARE REQUESTED, ONLY',
     1       ' ONE NEAR FIELD CARD CAN BE USED -', /, 10X,
     2       'LAST CARD READ IS USED')
145   FORMAT (////, 33X, '- - - - - - FREQUENCY - - - - - -', //, 36X,
     1        'FREQUENCY=', 1P, E11.4, ' MHZ', /, 36X, 'WAVELENGTH=',
     2         E11.4, 'METERS')
146   FORMAT (///, 30X, ' - - - STRUCTURE IMPEDANCE LOADING - - -')
147   FORMAT (/ , 35X, 'THIS STRUCTURE IS NOT LOADED')
148   FORMAT (///, 34X, '- - - ANTENNA ENVIRONMENT - - -', /)
149   FORMAT (40X, 'MEDIUM UNDER SCREEN -')
150   FORMAT (40X, 'RELATIVE DIELECTRIC CONST.=', F7.3, /, 40X,
     1        ' CONDUCTIVITY=', 1P, E10.3, ' MHOS/METER', /, 40X,
     2        'COMPLEX DIELECTRIC CONSTANT=', 2E12.5)
151   FORMAT (  42X, 'PERFECT GROUND')
152   FORMAT (  44X, 'FREE SPACE')
153   FORMAT (///, 32X, '- - - MATRIX TIMING - - -', //, 24X, 'FILL=',
     1        F9.3, ' SEC.  FACTOR=', F9.3, ' SEC.')
154   FORMAT (///, 40X, '- - - EXCITATION - - -')
155   FORMAT (/, 4X, 'PLANE WAVE', 4X, 'THETA=', F7.2, 'DEG,   PHI=',
     1         F7.2, 'DEG,   ETA=', F7.2, ' DEG,   TYPE -', A6,
     1        '=  AXIAL RATIO=', F6.3)
156   FORMAT (/, 31X, 'POSITION (METERS)', 14X, 'ORIENTATION (DEG)=',/,
     1        28X, 'X', 12X, 'Y', 12X, 'Z', 10X, 'ALPHA', 5X, 'BETA',
     2        4X, 13HDIPOLE MOMENT, //, 4X, 'CURRENT SOURCE', 1X,
     3        3(3X, F10.5), 1X, 2(3X, F7.2), 4X, F8.3)
157   FORMAT (4X, 4(I5, 1X), 1P, 6(3X, E11.4), 3X, A6, A2)
158   FORMAT (///, 44X, '- - - NETWORK DATA - - -')
159   FORMAT (/, 6X, '- FROM -    - TO -', 11X, 'TRANSMISSION LINE',
     1        15X, '-  -  SHUNT ADMITTANCES (MHOS)  -  -', 14X, 'LINE',
     2        /, 6X, 'TAG  SEG.    TAG  SEG.', 6X, 'IMPEDANCE', 6X,
     3        'LENGTH', 12X, '- END ONE -', 17X, '- END TWO -', 12X,
     4        'TYPE', /    , 6X, 'NO.   NO.   NO.   NO.', 9X, 'OHMS',
     5        8X, 'METERS', 9X,  'REAL', 10X, 'IMAG.', 9X, 'REAL',
     6        10X, 'IMAG.')
160   FORMAT (/, 6X, '- FROM -', 4X, '- TO -', 26X,
     1        '-  -  ADMITTANCE MATRIX  ELEMENTS (MHOS)  -  -',
     2        /, 6X, 'TAG  SEG.   TAG  SEG.', 13X, '(ONE, ONE)', 19X,
     3        '(ONE, TWO)', 19X, '(TWO, TWO)', / , 6X, 'NO.   NO. ',
     4        '  NO.   NO.', 8X, 'REAL', 10X, 'IMAG.', 9X, 'REAL',
     5        10X, 'IMAG.', 9X, 'REAL', 10X, 'IMAG.')
161   FORMAT (///, 29X, '- - - CURRENTS AND LOCATION - - -', //, 33X,
     1        'DISTANCES IN WAVELENGTHS')
162   FORMAT (  //, 2X, 'SEG.', 2X, 'TAG', 4X, 'COORD. OF SEG. CENTER',
     1        5X, 'SEG.', 12X, '- - - CURRENT (AMPS) - - -', /, 2X,
     2        'NO.', 3X, 'NO.', 5X, 'X', 8X, 'Y', 8X, 'Z', 6X, 'LENGTH',
     3        5X, 'REAL', 8X, 'IMAG.', 7X, 'MAG.', 8X, 'PHASE')
163   FORMAT (///, 33X, '- - - RECEIVING PATTERN PARAMETERS - - -', /,
     1        43X, 'ETA=', F7.2, ' DEGREES', /, 43X, 'TYPE -', A6, /,
     2        43X, 'AXIAL RATIO=', F6.3, //   , 11X, 'THETA', 6X, 'PHI',
     3        10X, '-  CURRENT  -', 9X, 'SEG', /, 11X, '(DEG)', 5X,
     4        '(DEG)', 7X, 'MAGNITUDE', 4X, 'PHASE', 6X, 'NO.', /)
164   FORMAT (10X, 2(F7.2, 3X), 1X, 1P, E11.4, 3X, 0P, F7.2, 4X, I5)
165   FORMAT (1X, 2I5, 3F9.4, F9.5, 1X, 1P, 3E12.4, 0P, F9.3)
166   FORMAT (///, 40X, '- - - POWER BUDGET - - -', //    , 43X,
     1        'INPUT POWER   =', 1P, E11.4, ' WATTS', / , 43X,
     2        'RADIATED POWER=', E11.4, ' WATTS', /, 43X,
     3        'STRUCTURE LOSS=', E11.4, ' WATTS', / , 43X,
     4        'NETWORK LOSS  =',  E11.4, ' WATTS', /, 43X,
     5        'EFFICIENCY    =', 0P, F7.2, ' PERCENT')
170   FORMAT (40X, 'RADIAL WIRE GROUND SCREEN', /, 40X, I5, ' WIRES',
     1        /, 40X, 'WIRE LENGTH=', F8.2, ' METERS', /, 40X,
     2        'WIRE RADIUS=', 1P, E10.3, ' METERS')
181   FORMAT (///, 4X, 'RECEIVING PATTERN STORAGE TOO SMALL,',
     1        ' ARRAY TRUNCATED')
182   FORMAT (///, 32X, '- - - NORMALIZED RECEIVING PATTERN - - -', /,
     1        41X, 'NORMALIZATION FACTOR=', 1P, E11.4, /, 41X, 'ETA=',
     2        0P, F7.2, ' DEGREES', /, 41X, 'TYPE -', A6, /, 41X,
     3        'AXIAL RATIO=', F6.3, /, 41X, 'SEGMENT NO.=',
     4        I5, //, 21X, 'THETA', 6X, 'PHI', 9X, '-  PATTERN  -', /,
     5        21X, '(DEG)', 5X, '(DEG)', 8X, 'DB', 8X, 'MAGNITUDE', /)
183   FORMAT (20X, 2(F7.2, 3X), 1X, F7.2, 4X, 1P, E11.4)
184   FORMAT (///, 36X, '- - - INPUT IMPEDANCE DATA - - -', /, 45X,
     1        'SOURCE SEGMENT NO.', I4, /, 45X, 'NORMALIZATION FACTOR=',
     2        1P, E12.5, //, 7X, 'FREQ.', 13X,
     3        '-  -  UNNORMALIZED IMPEDANCE  -  -', 21X,
     4        '-  -  NORMALIZED IMPEDANCE  -  -', /, 19X, 'RESISTANCE',
     5        4X, 'REACTANCE', 6X, 'MAGNITUDE', 4X, 'PHASE', 7X,
     6        'RESISTANCE', 4X, 'REACTANCE', 6X, 'MAGNITUDE', 4X,
     7        'PHASE', /, 8X, 'MHZ', 11X, 'OHMS', 10X, 'OHMS', 11X,
     8        'OHMS', 5X, 'DEGREES', 47X, 'DEGREES', /)
185   FORMAT (///, 4X, 'STORAGE FOR IMPEDANCE NORMALIZATION TOO ',
     1        ' SMALL, ARRAY TRUNCATED')
186   FORMAT (3X, F9.3, 2X, 1P, 2(2X, E12.5), 3X, E12.5, 2X, 0P, F7.2,
     1       2X, 1P, 2(2X, E12.5), 3X, E12.5, 2X, 0P, F7.2)
196   FORMAT(   ////, 20X, 'APPROXIMATE INTEGRATION EMPLOYED FOR ',
     1       'SEGMENTS MORE THAN', F8.3, ' WAVELENGTHS APART')
197   FORMAT(   ////, 41X, '- - - - SURFACE PATCH CURRENTS - - - -',
     1       //, 50X, 'DISTANCE IN WAVELENGTHS', /, 50X, 'CURRENT ',
     2       ' IN AMPS/METER', //, 28X,  '- - SURFACE COMPONENTS - -',
     3       19X, '- - - RECTANGULAR COMPONENTS - - -', /, 6X,
     4       'PATCH CENTER', 6X, 'TANGENT VECTOR 1', 3X,
     5       'TANGENT VECTOR 2', 11X, 'X', 19X, 'Y', 19X, 'Z', /,
     6       5X, 'X', 6X, 'Y', 6X, 'Z', 5X, 'MAG.', 7X, 'PHASE', 3X,
     7       'MAG.', 7X, 'PHASE', 3(4X, 'REAL', 6X, 'IMAG.'))
198   FORMAT(1X, I4, /, 1X, 3F7.3, 2(1P, E11.4, 0P, F8.2), 1P, 6E10.2)
201   FORMAT(/, ' RUN TIME =', F10.3)
315   FORMAT(///, 34X, '- - - CHARGE DENSITIES - - -', //, 36X,
     1       'DISTANCES IN WAVELENGTHS', ///, 2X, 'SEG.', 2X, 'TAG',
     2       4X, 'COORD. OF SEG. CENTER', 5X, 'SEG.', 10X,
     3       'CHARGE DENSITY (COULOMBS/METER)', /, 2X, 'NO.', 3X,
     4       'NO.', 5X, 'X', 8X, 'Y', 8X, 'Z', 6X, 'LENGTH', 5X,
     5       'REAL', 8X, 'IMAG.', 7X, 'MAG.', 8X, 'PHASE')
321   FORMAT( /, 20X, 'THE EXTENDED THIN WIRE KERNEL WILL BE USED')
303   FORMAT(/, ' ERROR - ', A2, ' CARD IS NOT ALLOWED WITH N.G.F.')
327   FORMAT(/, 35X, ' LOADING ONLY IN N.G.F. SECTION')
302   FORMAT(' ERROR - N.G.F. IN USE.  CANNOT WRITE NEW N.G.F.')
313   FORMAT(/, ' NUMBER OF SEGMENTS IN COUPLING CALCULATION (CP)',
     1        'EXCEEDS LIMIT')
390   FORMAT(' RADIAL WIRE G. S. APPROXIMATION MAY NOT BE USED WITH',
     1       ' SOMMERFELD GROUND OPTION')
391   FORMAT(40X, 'FINITE GROUND.  REFLECTION COEF. APPROXIMATION')
C
392   FORMAT(40X, 'FINITE GROUND.  SOMMERFELD SOLUTION')
393   FORMAT(/, ' ERROR IN GROUND PARAMETERS -', /, ' COMPLEX',
     1       ' DIELECTRIC CONSTANT FROM FILE IS', 1P, 2E12.5, /,
     2       32X, 'REQUESTED', 2E12.5)
      END
