      SUBROUTINE LOAD (LDTYP,LDTAG,LDTAGF,LDTAGT,ZLR,ZLI,ZLC)
C
C     LOAD CALCULATES THE IMPEDANCE OF SPECIFIED SEGMENTS FOR VARIOUS
C     TYPES OF LOADING
C
      INCLUDE 'MAX.PAR'
      COMPLEX ZARRAY,ZT,TPCJ,ZINT
      INCLUDE 'DATA.PAR'
      INCLUDE 'ZLOAD.PAR'
      DIMENSION LDTYP(1), LDTAG(1), LDTAGF(1), LDTAGT(1), ZLR(1), ZLI(1)
     1, ZLC(1), TPCJX(2)
      EQUIVALENCE (TPCJ,TPCJX)
      DATA TPCJX/0.,1.883698955E+9/
C
C     WRITE(6,HEADING)
C
      WRITE(6,25)
C
C     INITIALIZE D ARRAY, USED FOR TEMPORARY STORAGE OF LOADING
C     INFORMATION.
C
      DO 1 I=N2,N
 1    ZARRAY(I)=(0.,0.)
      IWARN=0
C
C     CYCLE OVER LOADING CARDS
C
      ISTEP=0
 2    ISTEP=ISTEP+1
      IF (ISTEP.LE.NLOAD) GO TO 5
      IF (IWARN.EQ.1) WRITE(6,26)
      IF (N1+2*M1.GT.0) GO TO 4
      NOP=N/NP
      IF (NOP.EQ.1) GO TO 4
      DO 3 I=1,NP
      ZT=ZARRAY(I)
      L1=I
      DO 3 L2=2,NOP
      L1=L1+NP
 3    ZARRAY(L1)=ZT
 4    RETURN
 5    IF (LDTYP(ISTEP).LE.5) GO TO 6
      WRITE(6,27)  LDTYP(ISTEP)
      STOP
 6    LDTAGS=LDTAG(ISTEP)
      JUMP=LDTYP(ISTEP)+1
      ICHK=0
C
C     SEARCH SEGMENTS FOR PROPER ITAGS
C
      L1=N2
      L2=N
      IF (LDTAGS.NE.0) GO TO 7
      IF (LDTAGF(ISTEP).EQ.0.AND.LDTAGT(ISTEP).EQ.0) GO TO 7
      L1=LDTAGF(ISTEP)
      L2=LDTAGT(ISTEP)
      IF (L1.GT.N1) GO TO 7
      WRITE(6,29)
      STOP
 7    DO 17 I=L1,L2
      IF (LDTAGS.EQ.0) GO TO 8
      IF (LDTAGS.NE.ITAG(I)) GO TO 17
      IF (LDTAGF(ISTEP).EQ.0) GO TO 8
      ICHK=ICHK+1
      IF (ICHK.GE.LDTAGF(ISTEP).AND.ICHK.LE.LDTAGT(ISTEP)) GO TO 9
      GO TO 17
 8    ICHK=1
C
C     CALCULATION OF LAMDA*IMPED. PER UNIT LENGTH, JUMP TO APPROPRIATE
C     SECTION FOR LOADING TYPE
C
 9    GO TO (10,11,12,13,14,15), JUMP
 10   ZT=ZLR(ISTEP)/SI(I)+TPCJ*ZLI(ISTEP)/(SI(I)*WLAM)
      IF (ABS(ZLC(ISTEP)).GT.1.E-20) ZT=ZT+WLAM/(TPCJ*SI(I)*ZLC(ISTEP))
      GO TO 16
 11   ZT=TPCJ*SI(I)*ZLC(ISTEP)/WLAM
      IF (ABS(ZLI(ISTEP)).GT.1.E-20) ZT=ZT+SI(I)*WLAM/(TPCJ*ZLI(ISTEP))
      IF (ABS(ZLR(ISTEP)).GT.1.E-20) ZT=ZT+SI(I)/ZLR(ISTEP)
      ZT=1./ZT
      GO TO 16
 12   ZT=ZLR(ISTEP)*WLAM+TPCJ*ZLI(ISTEP)
      IF (ABS(ZLC(ISTEP)).GT.1.E-20) ZT=ZT+1./(TPCJ*SI(I)*SI(I)*ZLC(ISTE
     1P))
      GO TO 16
 13   ZT=TPCJ*SI(I)*SI(I)*ZLC(ISTEP)
      IF (ABS(ZLI(ISTEP)).GT.1.E-20) ZT=ZT+1./(TPCJ*ZLI(ISTEP))
      IF (ABS(ZLR(ISTEP)).GT.1.E-20) ZT=ZT+1./(ZLR(ISTEP)*WLAM)
      ZT=1./ZT
      GO TO 16
 14   ZT=CMPLX(ZLR(ISTEP),ZLI(ISTEP))/SI(I)
      GO TO 16
 15   ZT=ZINT(ZLR(ISTEP)*WLAM,BI(I))
 16   IF ((ABS(REAL(ZARRAY(I)))+ABS(AIMAG(ZARRAY(I)))).GT.1.E-20) IWARN=
     11
      ZARRAY(I)=ZARRAY(I)+ZT
 17   CONTINUE
      IF (ICHK.NE.0) GO TO 18
      WRITE(6,28)  LDTAGS
      STOP
C
C     PRINTING THE SEGMENT LOADING DATA, JUMP TO PROPER PRINT
C
 18   GO TO (19,20,21,22,23,24), JUMP
 19   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),ZLR(ISTEP),
     1           ZLI(ISTEP),ZLC(ISTEP),0.,0.,0.,
     2           ' SERIES                 ')
       GO TO 2
 20   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),ZLR(ISTEP),
     1           ZLI(ISTEP),ZLC(ISTEP),0.,0.,0.,
     2           ' PARALLEL               ')
      GO TO 2
 21   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),ZLR(ISTEP),
     1           ZLI(ISTEP),ZLC(ISTEP),0.,0.,0.,
     2           ' SERIES (PER METER)     ')
      GO TO 2
 22   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),ZLR(ISTEP),
     1           ZLI(ISTEP),ZLC(ISTEP),0.,0.,0.,
     2           ' PARALLEL (PER METER)   ')
      GO TO 2
 23   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),0.,0.,0.,
     1           ZLR(ISTEP),ZLI(ISTEP),0.,
     2           ' FIXED IMPEDANCE        ')
      GO TO 2
 24   CALL PRNT (LDTAGS,LDTAGF(ISTEP),LDTAGT(ISTEP),0.,0.,0.,0.,0.,
     1           ZLR(ISTEP),
     2           '  WIRE                  ')
      GO TO 2
C
 25   FORMAT (//, 7X, 'LOCATION', 10X, 'RESISTANCE', 3X, 'INDUCTANCE',
     1        2X, 'CAPACITANCE', 7X, 'IMPEDANCE (OHMS)', 5X,
     2        'CONDUCTIVITY', 4X, 'TYPE', /, 4X, 'ITAG', ' FROM THRU',
     3        10X, 'OHMS', 8X, 'HENRYS', 7X, 'FARADS', 8X, 'REAL',
     4        6X, 'IMAGINARY', 4X, 'MHOS/METER')
 26   FORMAT (/, 10X, 'NOTE, SOME OF THE ABOVE SEGMENTS HAVE BEEN ',
     1        'LOADED TWICE - IMPEDANCES ADDED')
 27   FORMAT (/, 10X, 'IMPROPER LOAD TYPE CHOOSEN, REQUESTED TYPE ',
     1        'IS ',I3)
 28   FORMAT (/, 10X, 'LOADING DATA CARD ERROR, NO SEGMENT HAS AN ',
     1        'ITAG = ',I5)
 29   FORMAT (' ERROR - LOADING MAY NOT BE ADDED TO SEGMENTS IN ',
     1        'N.G.F. SECTION')
      END
