      SUBROUTINE INTRP (X,Y,F1,F2,F3,F4)
C
C     INTRP USES BIVARIATE CUBIC INTERPOLATION TO OBTAIN THE VALUES OF
C     4 FUNCTIONS AT THE POINT (X,Y).
C
      COMPLEX F1,F2,F3,F4,A,B,C,D,FX1,FX2,FX3,FX4,P1,P2,P3,P4,A11,A12,A1
     13,A14,A21,A22,A23,A24,A31,A32,A33,A34,A41,A42,A43,A44,B11,B12,B13,
     2B14,B21,B22,B23,B24,B31,B32,B33,B34,B41,B42,B43,B44,C11,C12,C13,C1
     34,C21,C22,C23,C24,C31,C32,C33,C34,C41,C42,C43,C44,D11,D12,D13,D14,
     4D21,D22,D23,D24,D31,D32,D33,D34,D41,D42,D43,D44
      COMPLEX AR1,AR2,AR3,ARL1,ARL2,ARL3,EPSCF
      COMMON /GGRID/ AR1(11,10,4),AR2(17,5,4),AR3(9,8,4),EPSCF,DXA(3),DY
     1A(3),XSA(3),YSA(3),NXA(3),NYA(3)
      DIMENSION NDA(3), NDPA(3)
      DIMENSION A(4,4), B(4,4), C(4,4), D(4,4), ARL1(1), ARL2(1), ARL3(1
     1)
      EQUIVALENCE (A(1,1),A11), (A(1,2),A12), (A(1,3),A13), (A(1,4),A14)
      EQUIVALENCE (A(2,1),A21), (A(2,2),A22), (A(2,3),A23), (A(2,4),A24)
      EQUIVALENCE (A(3,1),A31), (A(3,2),A32), (A(3,3),A33), (A(3,4),A34)
      EQUIVALENCE (A(4,1),A41), (A(4,2),A42), (A(4,3),A43), (A(4,4),A44)
      EQUIVALENCE (B(1,1),B11), (B(1,2),B12), (B(1,3),B13), (B(1,4),B14)
      EQUIVALENCE (B(2,1),B21), (B(2,2),B22), (B(2,3),B23), (B(2,4),B24)
      EQUIVALENCE (B(3,1),B31), (B(3,2),B32), (B(3,3),B33), (B(3,4),B34)
      EQUIVALENCE (B(4,1),B41), (B(4,2),B42), (B(4,3),B43), (B(4,4),B44)
      EQUIVALENCE (C(1,1),C11), (C(1,2),C12), (C(1,3),C13), (C(1,4),C14)
      EQUIVALENCE (C(2,1),C21), (C(2,2),C22), (C(2,3),C23), (C(2,4),C24)
      EQUIVALENCE (C(3,1),C31), (C(3,2),C32), (C(3,3),C33), (C(3,4),C34)
      EQUIVALENCE (C(4,1),C41), (C(4,2),C42), (C(4,3),C43), (C(4,4),C44)
      EQUIVALENCE (D(1,1),D11), (D(1,2),D12), (D(1,3),D13), (D(1,4),D14)
      EQUIVALENCE (D(2,1),D21), (D(2,2),D22), (D(2,3),D23), (D(2,4),D24)
      EQUIVALENCE (D(3,1),D31), (D(3,2),D32), (D(3,3),D33), (D(3,4),D34)
      EQUIVALENCE (D(4,1),D41), (D(4,2),D42), (D(4,3),D43), (D(4,4),D44)
      EQUIVALENCE (ARL1,AR1), (ARL2,AR2), (ARL3,AR3), (XS2,XSA(2)), (YS3
     1,YSA(3))
      DATA IXS,IYS,IGRS/-10,-10,-10/,DX,DY,XS,YS/1.,1.,0.,0./
      DATA NDA/11,17,9/,NDPA/110,85,72/,IXEG,IYEG/0,0/
      IF (X.LT.XS.OR.Y.LT.YS) GO TO 1
      IX=INT((X-XS)/DX)+1
      IY=INT((Y-YS)/DY)+1
C
C     IF POINT LIES IN SAME 4 BY 4 POINT REGION AS PREVIOUS POINT, OLD
C     VALUES ARE REUSED
C
      IF (IX.LT.IXEG.OR.IY.LT.IYEG) GO TO 1
      IF (IABS(IX-IXS).LT.2.AND.IABS(IY-IYS).LT.2) GO TO 12
C
C     DETERMINE CORRECT GRID AND GRID REGION
C
1     IF (X.GT.XS2) GO TO 2
      IGR=1
      GO TO 3
2     IGR=2
      IF (Y.GT.YS3) IGR=3
3     IF (IGR.EQ.IGRS) GO TO 4
      IGRS=IGR
      DX=DXA(IGRS)
      DY=DYA(IGRS)
      XS=XSA(IGRS)
      YS=YSA(IGRS)
      NXM2=NXA(IGRS)-2
      NYM2=NYA(IGRS)-2
      NXMS=((NXM2+1)/3)*3+1
      NYMS=((NYM2+1)/3)*3+1
      ND=NDA(IGRS)
      NDP=NDPA(IGRS)
      IX=INT((X-XS)/DX)+1
      IY=INT((Y-YS)/DY)+1
4     IXS=((IX-1)/3)*3+2
      IF (IXS.LT.2) IXS=2
      IXEG=-10000
      IF (IXS.LE.NXM2) GO TO 5
      IXS=NXM2
      IXEG=NXMS
5     IYS=((IY-1)/3)*3+2
      IF (IYS.LT.2) IYS=2
      IYEG=-10000
      IF (IYS.LE.NYM2) GO TO 6
      IYS=NYM2
      IYEG=NYMS
C
C     COMPUTE COEFFICIENTS OF 4 CUBIC POLYNOMIALS IN X FOR THE 4 GRID
C     VALUES OF Y FOR EACH OF THE 4 FUNCTIONS
C
6     IADZ=IXS+(IYS-3)*ND-NDP
      DO 11 K=1,4
      IADZ=IADZ+NDP
      IADD=IADZ
      DO 11 I=1,4
      IADD=IADD+ND
      GO TO (7,8,9), IGRS
C     P1=AR1(IXS-1,IYS-2+I,K)
7     P1=ARL1(IADD-1)
      P2=ARL1(IADD)
      P3=ARL1(IADD+1)
      P4=ARL1(IADD+2)
      GO TO 10
8     P1=ARL2(IADD-1)
      P2=ARL2(IADD)
      P3=ARL2(IADD+1)
      P4=ARL2(IADD+2)
      GO TO 10
9     P1=ARL3(IADD-1)
      P2=ARL3(IADD)
      P3=ARL3(IADD+1)
      P4=ARL3(IADD+2)
10    A(I,K)=(P4-P1+3.*(P2-P3))*.1666666667
      B(I,K)=(P1-2.*P2+P3)*.5
      C(I,K)=P3-(2.*P1+3.*P2+P4)*.1666666667
11    D(I,K)=P2
      XZ=(IXS-1)*DX+XS
      YZ=(IYS-1)*DY+YS
C
C     EVALUATE POLYMOMIALS IN X AND THEN USE CUBIC INTERPOLATION IN Y
C     FOR EACH OF THE 4 FUNCTIONS.
C
12    XX=(X-XZ)/DX
      YY=(Y-YZ)/DY
      FX1=((A11*XX+B11)*XX+C11)*XX+D11
      FX2=((A21*XX+B21)*XX+C21)*XX+D21
      FX3=((A31*XX+B31)*XX+C31)*XX+D31
      FX4=((A41*XX+B41)*XX+C41)*XX+D41
      P1=FX4-FX1+3.*(FX2-FX3)
      P2=3.*(FX1-2.*FX2+FX3)
      P3=6.*FX3-2.*FX1-3.*FX2-FX4
      F1=((P1*YY+P2)*YY+P3)*YY*.1666666667+FX2
      FX1=((A12*XX+B12)*XX+C12)*XX+D12
      FX2=((A22*XX+B22)*XX+C22)*XX+D22
      FX3=((A32*XX+B32)*XX+C32)*XX+D32
      FX4=((A42*XX+B42)*XX+C42)*XX+D42
      P1=FX4-FX1+3.*(FX2-FX3)
      P2=3.*(FX1-2.*FX2+FX3)
      P3=6.*FX3-2.*FX1-3.*FX2-FX4
      F2=((P1*YY+P2)*YY+P3)*YY*.1666666667+FX2
      FX1=((A13*XX+B13)*XX+C13)*XX+D13
      FX2=((A23*XX+B23)*XX+C23)*XX+D23
      FX3=((A33*XX+B33)*XX+C33)*XX+D33
      FX4=((A43*XX+B43)*XX+C43)*XX+D43
      P1=FX4-FX1+3.*(FX2-FX3)
      P2=3.*(FX1-2.*FX2+FX3)
      P3=6.*FX3-2.*FX1-3.*FX2-FX4
      F3=((P1*YY+P2)*YY+P3)*YY*.1666666667+FX2
      FX1=((A14*XX+B14)*XX+C14)*XX+D14
      FX2=((A24*XX+B24)*XX+C24)*XX+D24
      FX3=((A34*XX+B34)*XX+C34)*XX+D34
      FX4=((A44*XX+B44)*XX+C44)*XX+D44
      P1=FX4-FX1+3.*(FX2-FX3)
      P2=3.*(FX1-2.*FX2+FX3)
      P3=6.*FX3-2.*FX1-3.*FX2-FX4
      F4=((P1*YY+P2)*YY+P3)*YY*.1666666667+FX2
      RETURN
      END
