      SUBROUTINE HSFLD (XI,YI,ZI,AI)
C     HSFLD COMPUTES THE H FIELD FOR CONSTANT, SINE, AND COSINE CURRENT
C     ON A SEGMENT INCLUDING GROUND EFFECTS.
      COMPLEX EXK,EYK,EZK,EXS,EYS,EZS,EXC,EYC,EZC,ZRATI,ZRATI2,T1,HPK,HP
     1S,HPC,QX,QY,QZ,RRV,RRH,ZRATX,FRATI
      COMMON /DATAJ/ S,B,XJ,YJ,ZJ,CABJ,SABJ,SALPJ,EXK,EYK,EZK,EXS,EYS,EZ
     1S,EXC,EYC,EZC,RKH,IEXK,IND1,IND2,IPGND
      COMMON /GND/ZRATI,ZRATI2,FRATI,CL,CH,SCRWL,SCRWR,NRADL,KSYMP,IFAR,
     1IPERF,T1,T2
      DATA ETA/376.73/
      XIJ=XI-XJ
      YIJ=YI-YJ
      RFL=-1.
      DO 7 IP=1,KSYMP
      RFL=-RFL
      SALPR=SALPJ*RFL
      ZIJ=ZI-RFL*ZJ
      ZP=XIJ*CABJ+YIJ*SABJ+ZIJ*SALPR
      RHOX=XIJ-CABJ*ZP
      RHOY=YIJ-SABJ*ZP
      RHOZ=ZIJ-SALPR*ZP
      RH=SQRT(RHOX*RHOX+RHOY*RHOY+RHOZ*RHOZ+AI*AI)
      IF (RH.GT.1.E-10) GO TO 1
      EXK=0.
      EYK=0.
      EZK=0.
      EXS=0.
      EYS=0.
      EZS=0.
      EXC=0.
      EYC=0.
      EZC=0.
      GO TO 7
1     RHOX=RHOX/RH
      RHOY=RHOY/RH
      RHOZ=RHOZ/RH
      PHX=SABJ*RHOZ-SALPR*RHOY
      PHY=SALPR*RHOX-CABJ*RHOZ
      PHZ=CABJ*RHOY-SABJ*RHOX
      CALL HSFLX (S,RH,ZP,HPK,HPS,HPC)
      IF (IP.NE.2) GO TO 6
      IF (IPERF.EQ.1) GO TO 5
      ZRATX=ZRATI
      RMAG=SQRT(ZP*ZP+RH*RH)
      XYMAG=SQRT(XIJ*XIJ+YIJ*YIJ)
C
C     SET PARAMETERS FOR RADIAL WIRE GROUND SCREEN.
C
      IF (NRADL.EQ.0) GO TO 2
      XSPEC=(XI*ZJ+ZI*XJ)/(ZI+ZJ)
      YSPEC=(YI*ZJ+ZI*YJ)/(ZI+ZJ)
      RHOSPC=SQRT(XSPEC*XSPEC+YSPEC*YSPEC+T2*T2)
      IF (RHOSPC.GT.SCRWL) GO TO 2
      RRV=T1*RHOSPC*ALOG(RHOSPC/T2)
      ZRATX=(RRV*ZRATI)/(ETA*ZRATI+RRV)
2     IF (XYMAG.GT.1.E-6) GO TO 3
C
C     CALCULATION OF REFLECTION COEFFICIENTS WHEN GROUND IS SPECIFIED.
C
      PX=0.
      PY=0.
      CTH=1.
      RRV=(1.,0.)
      GO TO 4
3     PX=-YIJ/XYMAG
      PY=XIJ/XYMAG
      CTH=ZIJ/RMAG
      RRV=CSQRT(1.-ZRATX*ZRATX*(1.-CTH*CTH))
4     RRH=ZRATX*CTH
      RRH=-(RRH-RRV)/(RRH+RRV)
      RRV=ZRATX*RRV
      RRV=(CTH-RRV)/(CTH+RRV)
      QY=(PHX*PX+PHY*PY)*(RRV-RRH)
      QX=QY*PX+PHX*RRH
      QY=QY*PY+PHY*RRH
      QZ=PHZ*RRH
      EXK=EXK-HPK*QX
      EYK=EYK-HPK*QY
      EZK=EZK-HPK*QZ
      EXS=EXS-HPS*QX
      EYS=EYS-HPS*QY
      EZS=EZS-HPS*QZ
      EXC=EXC-HPC*QX
      EYC=EYC-HPC*QY
      EZC=EZC-HPC*QZ
      GO TO 7
5     EXK=EXK-HPK*PHX
      EYK=EYK-HPK*PHY
      EZK=EZK-HPK*PHZ
      EXS=EXS-HPS*PHX
      EYS=EYS-HPS*PHY
      EZS=EZS-HPS*PHZ
      EXC=EXC-HPC*PHX
      EYC=EYC-HPC*PHY
      EZC=EZC-HPC*PHZ
      GO TO 7
6     EXK=HPK*PHX
      EYK=HPK*PHY
      EZK=HPK*PHZ
      EXS=HPS*PHX
      EYS=HPS*PHY
      EZS=HPS*PHZ
      EXC=HPC*PHX
      EYC=HPC*PHY
      EZC=HPC*PHZ
7     CONTINUE
      RETURN
      END
