      SUBROUTINE HELIX(S,HL,A1,B1,A2,B2,RAD,NS,ITG)
C     SUBROUTINE HELIX GENERATES SEGMENT GEOMETRY DATA FOR A HELIX OF NS
C     SEGMENTS
      INCLUDE 'MAX.PAR'
      INCLUDE 'DATA.PAR'
      DIMENSION X2(1),Y2(1),Z2(1)
      EQUIVALENCE (X2(1),SI(1)), (Y2(1),ALP(1)), (Z2(1),BET(1))
      DATA PI/3.1415926/
      IST=N+1
      N=N+NS
      NP=N
      MP=M
      IPSYM=0
      IF(NS.LT.1) RETURN
      TURNS=ABS(HL/S)
      ZINC=ABS(HL/NS)
      Z(IST)=0.
      DO 25 I=IST,N
      BI(I)=RAD
      ITAG(I)=ITG
      IF(I.NE.IST) Z(I)=Z(I-1)+ZINC
      Z2(I)=Z(I)+ZINC
      IF(A2.NE.A1) GO TO 10
      IF(B1.EQ.0) B1=A1
      X(I)=A1*COS(2.*PI*Z(I)/S)
      Y(I)=B1*SIN(2.*PI*Z(I)/S)
      X2(I)=A1*COS(2.*PI*Z2(I)/S)
      Y2(I)=B1*SIN(2.*PI*Z2(I)/S)
      GO TO 20
10    IF(B2.EQ.0) B2=A2
      X(I)=(A1+(A2-A1)*Z(I)/ABS(HL))*COS(2.*PI*Z(I)/S)
      Y(I)=(B1+(B2-B1)*Z(I)/ABS(HL))*SIN(2.*PI*Z(I)/S)
      X2(I)=(A1+(A2-A1)*Z2(I)/ABS(HL))*COS(2.*PI*Z2(I)/S)
      Y2(I)=(B1+(B2-B1)*Z2(I)/ABS(HL))*SIN(2.*PI*Z2(I)/S)
20    IF(HL.GT.0) GO TO 25
      COPY=X(I)
      X(I)=Y(I)
      Y(I)=COPY
      COPY=X2(I)
      X2(I)=Y2(I)
      Y2(I)=COPY
25    CONTINUE
      IF(A2.EQ.A1) GO TO 21
      SANGLE=ATAN(A2/(ABS(HL)+(ABS(HL)*A1)/(A2-A1)))
      WRITE(6,104)  SANGLE
104   FORMAT(5X,'THE CONE ANGLE OF THE SPIRAL IS',F10.4)
      RETURN
21    IF(A1.NE.B1) GO TO 30
      HDIA=2.*A1
      TURN=HDIA*PI
      PITCH=ATAN(S/(PI*HDIA))
      TURN=TURN/COS(PITCH)
      PITCH=180.*PITCH/PI
      GO TO 40
30    IF(A1.LT.B1) GO TO 34
      HMAJ=2.*A1
      HMIN=2.*B1
      GO TO 35
34    HMAJ=2.*B1
      HMIN=2.*A1
35    HDIA=SQRT((HMAJ**2+HMIN**2)/2*HMAJ)
      TURN=2.*PI*HDIA
      PITCH=(180./PI)*ATAN(S/(PI*HDIA))
40    WRITE(6,105) PITCH,TURN
105   FORMAT(5X,'THE PITCH ANGLE IS',F10.4/5X,'THE LENGTH OF WIRE/TURN I
     1S',F10.4)
      RETURN
      END
