      SUBROUTINE GFIL (IPRT)
C
C     GFIL READS THE N.G.F. FILE
C
      INCLUDE 'MAX.PAR'
      COMPLEX CM,SSX,ZRATI,ZRATI2,T1,ZARRAY,AR1,AR2,AR3,EPSCF,FRATI
      INCLUDE 'DATA.PAR'
      INCLUDE 'ANGL.PAR'
      INCLUDE 'CMB.PAR'
      INCLUDE 'ZLOAD.PAR'
      INCLUDE 'SAVE.PAR'
      COMMON /GND/ZRATI,ZRATI2,FRATI,CL,CH,SCRWL,SCRWR,NRADL,KSYMP,IFAR,
     1IPERF,T1,T2
      COMMON /GGRID/ AR1(11,10,4),AR2(17,5,4),AR3(9,8,4),EPSCF,DXA(3),DY
     1A(3),XSA(3),YSA(3),NXA(3),NYA(3)
      COMMON /MATPAR/ ICASE,NBLOKS,NPBLK,NLAST,NBLSYM,NPSYM,NLSYM,IMAT,I
     1CASX,NBBX,NPBX,NLBX,NBBL,NPBL,NLBL
      COMMON /SMAT/ SSX(16,16)
      DATA IGFL/20/
      REWIND IGFL
      READ (IGFL) N1,NP,M1,MP,WLAM,FMHZ,IPSYM,KSYMP,IPERF,NRADL,EPSR,SIG
     1,SCRWLT,SCRWRT,NLODF,KCOM
      N=N1
      M=M1
      N2=N1+1
      M2=M1+1
      IF (N1.EQ.0) GO TO 2
C     READ SEG. DATA AND CONVERT BACK TO END COORD. IN UNITS OF METERS
      READ (IGFL) (X(I),I=1,N1),(Y(I),I=1,N1),(Z(I),I=1,N1)
      READ (IGFL) (SI(I),I=1,N1),(BI(I),I=1,N1),(ALP(I),I=1,N1)
      READ (IGFL) (BET(I),I=1,N1),(SALP(I),I=1,N1)
      READ (IGFL) (ICON1(I),I=1,N1),(ICON2(I),I=1,N1)
      READ (IGFL) (ITAG(I),I=1,N1)
      IF (NLODF.NE.0) READ (IGFL) (ZARRAY(I),I=1,N1)
      DO 1 I=1,N1
      XI=X(I)*WLAM
      YI=Y(I)*WLAM
      ZI=Z(I)*WLAM
      DX=SI(I)*.5*WLAM
      X(I)=XI-ALP(I)*DX
      Y(I)=YI-BET(I)*DX
      Z(I)=ZI-SALP(I)*DX
      SI(I)=XI+ALP(I)*DX
      ALP(I)=YI+BET(I)*DX
      BET(I)=ZI+SALP(I)*DX
      BI(I)=BI(I)*WLAM
1     CONTINUE
2     IF (M1.EQ.0) GO TO 4
      J=LD-M1+1
C     READ PATCH DATA AND CONVERT TO METERS
      READ (IGFL) (X(I),I=J,LD),(Y(I),I=J,LD),(Z(I),I=J,LD)
      READ (IGFL) (SI(I),I=J,LD),(BI(I),I=J,LD),(ALP(I),I=J,LD)
      READ (IGFL) (BET(I),I=J,LD),(SALP(I),I=J,LD)
      READ (IGFL) (ICON1(I),I=J,LD),(ICON2(I),I=J,LD)
      READ (IGFL) (ITAG(I),I=J,LD)
      DX=WLAM*WLAM
      DO 3 I=J,LD
      X(I)=X(I)*WLAM
      Y(I)=Y(I)*WLAM
      Z(I)=Z(I)*WLAM
3     BI(I)=BI(I)*DX
4     READ (IGFL) ICASE,NBLOKS,NPBLK,NLAST,NBLSYM,NPSYM,NLSYM,IMAT
      IF (IPERF.EQ.2) READ (IGFL) AR1,AR2,AR3,EPSCF,DXA,DYA,XSA,YSA,NXA,
     1NYA
      NEQ=N1+2*M1
      NPEQ=NP+2*MP
      NOP=NEQ/NPEQ
      IF (NOP.GT.1) READ (IGFL) ((SSX(I,J),I=1,NOP),J=1,NOP)
      READ (IGFL) (IP(I),I=1,NEQ),COM
C     READ MATRIX A AND WRITE TAPE13 FOR OUT OF CORE
      IF (ICASE.GT.2) GO TO 5
      IOUT=NEQ*NPEQ
      READ (IGFL) (CM(I),I=1,IOUT)
      GO TO 10
5     REWIND 13
      IF (ICASE.NE.4) GO TO 7
      IOUT=NPEQ*NPEQ
      DO 6 K=1,NOP
      READ (IGFL) (CM(J),J=1,IOUT)
6     WRITE (13) (CM(J),J=1,IOUT)
      GO TO 9
7     IOUT=NPSYM*NPEQ*2
      NBL2=2*NBLSYM
      DO 8 IOP=1,NOP
      DO 8 I=1,NBL2
      CALL BLCKIN (CM,IGFL,1,IOUT,1,206)
8     CALL BLCKOT (CM,13,1,IOUT,1,205)
9     REWIND 13
10    REWIND IGFL
C     WRITE(6,N) G.F. HEADING
      WRITE(6,16)
      WRITE(6,14)
      WRITE(6,14)
      WRITE(6,17)
      WRITE(6,18)  N1,M1
      IF (NOP.GT.1) WRITE(6,19)  NOP
      WRITE(6,20)  IMAT,ICASE
      IF (ICASE.LT.3) GO TO 11
      NBL2=NEQ*NPEQ
      WRITE(6,21)  NBL2
11    WRITE(6,22)  FMHZ
      IF (KSYMP.EQ.2.AND.IPERF.EQ.1) WRITE(6,23)
      IF (KSYMP.EQ.2.AND.IPERF.EQ.0) WRITE(6,27)
      IF (KSYMP.EQ.2.AND.IPERF.EQ.2) WRITE(6,28)
      IF (KSYMP.EQ.2.AND.IPERF.NE.1) WRITE(6,24)  EPSR,SIG
      WRITE(6,17)
      DO 12 J=1,KCOM
12    WRITE(6,15)  (COM(I,J),I=1,19)
      WRITE(6,17)
      WRITE(6,14)
      WRITE(6,14)
      WRITE(6,16)
      IF (IPRT.EQ.0) RETURN
      WRITE(6,25)
      DO 13 I=1,N1
13    WRITE(6,26)  I,X(I),Y(I),Z(I),SI(I),ALP(I),BET(I)
      RETURN
C
14    FORMAT (5X, '******************************************',
     1            '******************************************')
15    FORMAT (5X, '** ', 19A4, '   **')
16    FORMAT (////)
17    FORMAT (5X, '**', 80X, '**')
18    FORMAT (5X, '** NUMERICAL GREEN"S FUNCTION', 53X, '**', /, 5X,
     1        '** NO. SEGMENTS =', I4, 10X, 'NO. PATCHES =',
     2        I4, 34X, '**')
19    FORMAT (5X, '** NO. SYMMETRIC SECTIONS =', I4, 51X, '**')
20    FORMAT (5X, '** N.G.F. MATRIX -  CORE STORAGE =', I7,
     1        ' COMPLEX NUMBERS,  CASE', I2, 16X, '**')
21    FORMAT (5X, '**', 19X, 'MATRIX SIZE =', I7, ' COMPLEX NUMBERS',
     1        25X, '**')
22    FORMAT (5X, '** FREQUENCY =', 1P, E12.5, ' MHZ.', 51X, '**')
23    FORMAT (5X, '** PERFECT GROUND', 65X, '**')
24    FORMAT (5X, '** GROUND PARAMETERS - DIELECTRIC CONSTANT =', 1P,
     1        E12.5, 26X, '**', /, 5X, '**', 21X, 'CONDUCTIVITY =',
     2        E12.5, ' MHOS/M.', 25X, '**')
25    FORMAT (39X, 'NUMERICAL GREEN"S FUNCTION DATA', /, 41X,
     1        'COORDINATES OF SEGMENT ENDS', /, 51X, '(METERS)', /,
     2        5X, 'SEG.', 11X, '- - - END ONE - - -', 26X,
     3        '- - - END TWO - - -', /, 6X, 'NO.', 6X, 'X', 14X, 'Y',
     4        14X, 'Z', 14X, 'X', 14X, 'Y', 14X, 'Z')
26    FORMAT (1X, I7, 1P, 6E15.6)
27    FORMAT (5X, '** FINITE GROUND.  REFLECTION COEFFICIENT ',
     1        'APPROXIMATION', 27X, '**')
28    FORMAT (5X, '** FINITE GROUND.  SOMMERFELD SOLUTION', 44X, '**')
      END
