      SUBROUTINE DATAGN
C
C     DATAGN IS THE MAIN ROUTINE FOR INPUT OF GEOMETRY DATA.
C
C***
      CHARACTER*2 GM,ATST
C***
      INCLUDE 'MAX.PAR'
      INCLUDE 'DATA.PAR'
      INCLUDE 'ANGL.PAR'
C***
      COMMON /PLOT/ IPLP1,IPLP2,IPLP3,IPLP4
C***
      DIMENSION X2(1), Y2(1), Z2(1), T1X(1), T1Y(1), T1Z(1), T2X(1), T2Y
     1(1), T2Z(1), ATST(13), IFX(2), IFY(2), IFZ(2), CAB(1), SAB(1), IPT
     2(4)
      EQUIVALENCE (T1X,SI), (T1Y,ALP), (T1Z,BET), (T2X,ICON1), (T2Y,ICON
     12), (T2Z,ITAG), (X2,SI), (Y2,ALP), (Z2,BET), (CAB,ALP), (SAB,BET)
C***
      DATA ATST/'GW', 'GX', 'GR', 'GS', 'GE', 'GM', 'SP', 'SM', 'GF',
     1          'GA', 'SC', 'GC', 'GH'/
C***
      DATA IFX/' ','X'/,IFY/' ','Y'/, IFZ/' ','Z'/
      DATA TA/0.01745329252/,TD/57.29577951/,IPT/'P','R','T','Q'/
      IPSYM=0
      NWIRE=0
      N=0
      NP=0
      M=0
      MP=0
      N1=0
      N2=1
      M1=0
      M2=1
      ISCT=0
      IPHD=0
C
C     READ GEOMETRY DATA CARD AND BRANCH TO SECTION FOR OPERATION
C     REQUESTED
C
C***
C1     READ (5,42) GM,ITG,NS,XW1,YW1,ZW1,XW2,YW2,ZW2,RAD
1     CALL READGM(GM, ITG, NS, XW1, YW1, ZW1, XW2, YW2, ZW2, RAD)
C***
      IF (N+M.GT.LD) GO TO 37
      IF (GM.EQ.ATST(9)) GO TO 27
      IF (IPHD.EQ.1) GO TO 2
      WRITE(6,40)
      WRITE(6,41)
      IPHD=1
2     IF (GM.EQ.ATST(11)) GO TO 10
      ISCT=0
      IF (GM.EQ.ATST(1)) GO TO 3
      IF (GM.EQ.ATST(2)) GO TO 18
      IF (GM.EQ.ATST(3)) GO TO 19
      IF (GM.EQ.ATST(4)) GO TO 21
      IF (GM.EQ.ATST(7)) GO TO 9
      IF (GM.EQ.ATST(8)) GO TO 13
      IF (GM.EQ.ATST(5)) GO TO 29
      IF (GM.EQ.ATST(6)) GO TO 26
      IF (GM.EQ.ATST(10)) GO TO 8
C***
      IF (GM.EQ.ATST(13)) GO TO 123
C***
      GO TO 36
C
C     GENERATE SEGMENT DATA FOR STRAIGHT WIRE.
C
3     NWIRE=NWIRE+1
      I1=N+1
      I2=N+NS
      WRITE(6,43)  NWIRE,XW1,YW1,ZW1,XW2,YW2,ZW2,RAD,NS,I1,I2,ITG
      IF (RAD.EQ.0) GO TO 4
      XS1=1.
      YS1=1.
      GO TO 7
C***
C4     READ (5,42) GM,IX,IY,XS1,YS1,ZS1
4     CALL READGM(GM,IX,IY,XS1,YS1,ZS1,DUMMY,DUMMY,DUMMY,DUMMY)
C***
      IF (GM.EQ.ATST(12)) GO TO 6
5     WRITE(6,48)
      STOP
6     WRITE(6,61)  XS1,YS1,ZS1
      IF (YS1.EQ.0.OR.ZS1.EQ.0) GO TO 5
      RAD=YS1
      YS1=(ZS1/YS1)**(1./(NS-1.))
7     CALL WIRE (XW1,YW1,ZW1,XW2,YW2,ZW2,RAD,XS1,YS1,NS,ITG)
      GO TO 1
C
C     GENERATE SEGMENT DATA FOR WIRE ARC
C
8     NWIRE=NWIRE+1
      I1=N+1
      I2=N+NS
      WRITE(6,38)  NWIRE,XW1,YW1,ZW1,XW2,NS,I1,I2,ITG
      CALL ARC (ITG,NS,XW1,YW1,ZW1,XW2)
      GO TO 1
C***
C
C     GENERATE HELIX
C
123   NWIRE=NWIRE+1
      I1=N+1
      I2=N+NS
      WRITE(6,124) XW1,YW1,NWIRE,ZW1,XW2,YW2,ZW2,RAD,NS,I1,I2,ITG
      CALL HELIX(XW1,YW1,ZW1,XW2,YW2,ZW2,RAD,NS,ITG)
      GO TO 1
C
124   FORMAT(5X, 'HELIX STRUCTURE-   AXIAL SPACING BETWEEN TURNS =',
     1       F8.3, ' TOTAL AXIAL LENGTH =', F8.3/1X, I5, 2X,
     2       'RADIUS OF HELIX =', 4(2X, F8.3), 7X, F11.5, I8, 4X,
     3       I5, 1X, I5, 3X, I5)
C***
C
C     GENERATE SINGLE NEW PATCH
C
9     I1=M+1
      NS=NS+1
      IF (ITG.NE.0) GO TO 17
      WRITE(6, 51)  I1, IPT(NS), XW1, YW1, ZW1, XW2, YW2, ZW2
      IF (NS.EQ.2.OR.NS.EQ.4) ISCT=1
      IF (NS.GT.1) GO TO 14
      XW2=XW2*TA
      YW2=YW2*TA
      GO TO 16
10    IF (ISCT.EQ.0) GO TO 17
      I1=M+1
      NS=NS+1
      IF (ITG.NE.0) GO TO 17
      IF (NS.NE.2.AND.NS.NE.4) GO TO 17
      XS1=X4
      YS1=Y4
      ZS1=Z4
      XS2=X3
      YS2=Y3
      ZS2=Z3
      X3=XW1
      Y3=YW1
      Z3=ZW1
      IF (NS.NE.4) GO TO 11
      X4=XW2
      Y4=YW2
      Z4=ZW2
11    XW1=XS1
      YW1=YS1
      ZW1=ZS1
      XW2=XS2
      YW2=YS2
      ZW2=ZS2
      IF (NS.EQ.4) GO TO 12
      X4=XW1+X3-XW2
      Y4=YW1+Y3-YW2
      Z4=ZW1+Z3-ZW2
12    WRITE(6, 51)  I1, IPT(NS), XW1, YW1, ZW1, XW2, YW2, ZW2
      WRITE(6, 39)  X3, Y3, Z3, X4, Y4, Z4
      GO TO 16
C
C     GENERATE MULTIPLE-PATCH SURFACE
C
13    I1=M+1
      WRITE(6, 59)  I1, IPT(2), XW1, YW1, ZW1, XW2, YW2, ZW2, ITG, NS
      IF (ITG.LT.1.OR.NS.LT.1) GO TO 17
C***
C14    READ (5, 42) GM, IX, IY, X3, Y3, Z3, X4, Y4, Z4
14    CALL READGM(GM, IX, IY, X3, Y3, Z3, X4, Y4, Z4, DUMMY)
C***
      IF (NS.NE.2.AND.ITG.LT.1) GO TO 15
      X4=XW1+X3-XW2
      Y4=YW1+Y3-YW2
      Z4=ZW1+Z3-ZW2
15    WRITE(6, 39)  X3, Y3, Z3, X4, Y4, Z4
      IF (GM.NE.ATST(11)) GO TO 17
16    CALL PATCH (ITG, NS, XW1, YW1, ZW1, XW2, YW2, ZW2,
     2            X3, Y3, Z3, X4, Y4, Z4)
      GO TO 1
17    WRITE(6, 60)
      STOP
C
C  REFLECT STRUCTURE ALONG X, Y, OR Z AXES OR ROTATE TO FORM CYLINDER.
C
18    IY=NS/10
      IZ=NS-IY*10
      IX=IY/10
      IY=IY-IX*10
      IF (IX.NE.0) IX=1
      IF (IY.NE.0) IY=1
      IF (IZ.NE.0) IZ=1
      WRITE(6, 44)  IFX(IX+1), IFY(IY+1), IFZ(IZ+1), ITG
      GO TO 20
19    WRITE(6, 45)  NS, ITG
      IX=-1
20    CALL REFLC (IX, IY, IZ, ITG, NS)
      GO TO 1
C
C     SCALE STRUCTURE DIMENSIONS BY FACTOR XW1.
C
21    IF (N.LT.N2) GO TO 23
      DO 22 I=N2, N
      X(I)=X(I)*XW1
      Y(I)=Y(I)*XW1
      Z(I)=Z(I)*XW1
      X2(I)=X2(I)*XW1
      Y2(I)=Y2(I)*XW1
      Z2(I)=Z2(I)*XW1
22    BI(I)=BI(I)*XW1
23    IF (M.LT.M2) GO TO 25
      YW1=XW1*XW1
      IX=LD+1-M
      IY=LD-M1
      DO 24 I=IX, IY
      X(I)=X(I)*XW1
      Y(I)=Y(I)*XW1
      Z(I)=Z(I)*XW1
24    BI(I)=BI(I)*YW1
25    WRITE(6, 46)  XW1
      GO TO 1
C
C     MOVE STRUCTURE OR REPRODUCE ORIGINAL STRUCTURE IN NEW POSITIONS.
C
26    WRITE(6, 47)  ITG, NS, XW1, YW1, ZW1, XW2, YW2, ZW2, RAD
      XW1=XW1*TA
      YW1=YW1*TA
      ZW1=ZW1*TA
      CALL MOVE (XW1, YW1, ZW1, XW2, YW2, ZW2, INT(RAD+.5), NS, ITG)
      GO TO 1
C
C     READ NUMERICAL GREEN'S FUNCTION TAPE
C
27    IF (N+M.EQ.0) GO TO 28
      WRITE(6, 52)
      STOP
28    CALL GFIL (ITG)
      NPSAV=NP
      MPSAV=MP
      IPSAV=IPSYM
      GO TO 1
C
C     TERMINATE STRUCTURE GEOMETRY INPUT.
C
C***
29    IF(NS.EQ.0) GO TO 290
      IPLP1=1
      IPLP2=1
290   IX=N1+M1
C***
      IF (IX.EQ.0) GO TO 30
      NP=N
      MP=M
      IPSYM=0
30    CALL CONECT (ITG)
      IF (IX.EQ.0) GO TO 31
      NP=NPSAV
      MP=MPSAV
      IPSYM=IPSAV
31    IF (N+M.GT.LD) GO TO 37
      IF (N.EQ.0) GO TO 33
      WRITE(6, 53)
      WRITE(6, 54)
      DO 32 I=1, N
      XW1=X2(I)-X(I)
      YW1=Y2(I)-Y(I)
      ZW1=Z2(I)-Z(I)
      X(I)=(X(I)+X2(I))*.5
      Y(I)=(Y(I)+Y2(I))*.5
      Z(I)=(Z(I)+Z2(I))*.5
      XW2=XW1*XW1+YW1*YW1+ZW1*ZW1
      YW2=SQRT(XW2)
      YW2=(XW2/YW2+YW2)*.5
      SI(I)=YW2
      CAB(I)=XW1/YW2
      SAB(I)=YW1/YW2
      XW2=ZW1/YW2
      IF (XW2.GT.1.) XW2=1.
      IF (XW2.LT.-1.) XW2=-1.
      SALP(I)=XW2
      XW2=ASIN(XW2)*TD
      YW2=ATGN2(YW1, XW1)*TD
      WRITE(6, 55) I, X(I), Y(I), Z(I), SI(I), XW2, YW2, BI(I),
     1             ICON1(I), I, ICON2(I), ITAG(I)
C***
      IF(IPLP1.NE.1) GO TO 320
      WRITE(8, *)X(I), Y(I), Z(I), SI(I), XW2, YW2, BI(I),
     1           ICON1(I), I, ICON2(I)
320   CONTINUE
C***
      IF (SI(I).GT.1.E-20.AND.BI(I).GT.0.) GO TO 32
      WRITE(6, 56)
      STOP
32    CONTINUE
33    IF (M.EQ.0) GO TO 35
      WRITE(6, 57)
      J=LD+1
      DO 34 I=1, M
      J=J-1
      XW1=(T1Y(J)*T2Z(J)-T1Z(J)*T2Y(J))*SALP(J)
      YW1=(T1Z(J)*T2X(J)-T1X(J)*T2Z(J))*SALP(J)
      ZW1=(T1X(J)*T2Y(J)-T1Y(J)*T2X(J))*SALP(J)
      WRITE(6, 58) I, X(J), Y(J), Z(J), XW1, YW1, ZW1, BI(J), T1X(J),
     1             T1Y(J), T1Z(J), T2X(J), T2Y(J), T2Z(J)
34    CONTINUE
35    RETURN
36    WRITE(6, 48)
      WRITE(6, 49)  GM, ITG, NS, XW1, YW1, ZW1, XW2, YW2, ZW2, RAD
      STOP
37    WRITE(6, 50)
      STOP
C
38    FORMAT (1X, I5, 2X, 'ARC RADIUS =', F9.5, 2X, 'FROM', F8.3,
     1        ' TO', F8.3, ' DEGREES', 11X, F11.5, 2X, I5, 4X, I5,
     2        1X, I5, 3X, I5)
39    FORMAT (6X, 3F11.5, 1X, 3F11.5)
40    FORMAT (////, 33X, '- - - STRUCTURE SPECIFICATION - - -', //,
     1         37X,' COORDINATES MUST BE INPUT IN', /, 37X, 'METERS',
     2         ' OR BE SCALED TO METERS', /, 37X, 'BEFORE ',
     3         ' STRUCTURE INPUT IS ENDED', //)
41    FORMAT (2X, 'WIRE', 79X, 'NO. OF', 4X, 'FIRST', 2X, 'LAST',
     1         5X, 'TAG', /, 2X,  'NO.', 8X, 'X1', 9X, 'Y1', 9X,
     2         'Z1', 10X, 'X2', 9X, 'Y2', 9X, 'Z2', 6X, 'RADIUS',
     3         3X, 'SEG.', 5X, 'SEG.', 3X, 'SEG.', 5X, 'NO.')
42    FORMAT (A2, I3, I5, 7F10.5)
43    FORMAT (1X, I5, 7(F10.5, 1X), 2X, I5, 4X, I5, 1X, I5, 3X, I5)
44    FORMAT (6X, 'STRUCTURE REFLECTED ALONG THE AXES', 3(1X, A1),
     1        'TAGS INCREMENTED BY', I5)
45    FORMAT (6X, 'STRUCTURE ROTATED ABOUT Z-AXIS', I3, ' TIMES.',
     1         ' LABELS INCREMENTED BY', I5)
46    FORMAT (6X, 'STRUCTURE SCALED BY FACTOR', F10.5)
47    FORMAT (6X, 'THE STRUCTURE HAS BEEN MOVED,  MOVE DATA CARD IS -',
     1        /, 6X, I3, I5, 7F10.5)
48    FORMAT (' GEOMETRY DATA CARD ERROR')
49    FORMAT (1X, A2, I3, I5, 7F10.5)
50    FORMAT (' NUMBER OF WIRE SEGMENTS AND SURFACE PATCHES EXCEEDS ',
     1        'DIMENSION LIMIT.')
51    FORMAT (1X, I5, A1, F10.5, 2F11.5, 1X, 3F11.5)
52    FORMAT (' ERROR - GF MUST BE FIRST GEOMETRY DATA CARD')
53    FORMAT (////33X, '- - - - SEGMENTATION DATA - - - -', //, 40X,
     1        'COORDINATES IN METERS', //, 25X, 'I+ AND I- INDICATE',
     2        ' THE SEGMENTS BEFORE AND AFTER I', //)
54    FORMAT (2X, 'SEG.', 3X, 'COORDINATES OF SEG. CENTER', 5X, 'SEG.',
     1        5X, 'ORIENTATION ANGLES', 4X, 'WIRE', 4X,
     2        'CONNECTION DATA', 3X, 'TAG', /, 2X, 'NO.', 7X, 'X', 9X,
     3        'Y', 9X, 'Z', 7X, 'LENGTH', 5X, 'ALPHA', 5X, 'BETA', 6X,
     4        'RADIUS', 4X, 'I-', 3X, 'I', 4X, 'I+', 4X, 'NO.')
55    FORMAT (1X, I5, 4F10.5, 1X, 3F10.5, 1X, 3I5, 2X, I5)
56    FORMAT (' SEGMENT DATA ERROR')
57    FORMAT (////, 44X, '- - - SURFACE PATCH DATA - - -', //, 49X,
     1        'COORDINATES IN METERS', //, 1X, 'PATCH', 5X,
     2        'COORD. OF PATCH CENTER', 7X, 'UNIT NORMAL VECTOR', 6X,
     3        'PATCH', 12X, 'COMPONENTS OF UNIT TANGENT VECTORS', /,
     4        2X, 'NO.', 6X, 'X', 9X, 'Y', 9X, 'Z', 9X, 'X', 7X, 'Y',
     5        7X, 'Z', 7X, 'AREA', 7X, 'X1', 6X, 'Y1', 6X, 'Z1', 7X,
     6        'X2', 6X, 'Y2', 6X, 'Z2')
58    FORMAT (1X, I4, 3F10.5, 1X, 3F8.4, F10.5, 1X, 3F8.4, 1X, 3F8.4)
59    FORMAT (1X, I5, A1, F10.5, 2F11.5, 1X, 3F11.5, 5X, 'SURFACE -',
     1         I4, ' BY', I3 , ' PATCHES')
60    FORMAT (' PATCH DATA ERROR')
61    FORMAT (9X, 'ABOVE WIRE IS TAPERED.  SEG. LENGTH RATIO =', F9.5,
     1        /, 33X, 'RADIUS FROM', F9.5, ' TO', F9.5)
      END
