/* ----------------------------------------------------------------------------
 * expWinUtils.cpp --
 *
 *	Misc stuff.
 *
 * ----------------------------------------------------------------------------
 *
 * Written by: Don Libes, libes@cme.nist.gov, NIST, 12/3/90
 * 
 * Design and implementation of this program was paid for by U.S. tax
 * dollars.  Therefore it is public domain.  However, the author and NIST
 * would appreciate credit if this program or parts of it are used.
 * 
 * Copyright (c) 2001-2002 Telindustrie, LLC
 * Copyright (c) 2003 ActiveState Corporation
 *	Work by David Gravereaux <davygrvy@pobox.com> for any Win32 OS.
 *	Based on work by Gordon Chaffee <chaffee@bmrc.berkeley.edu>
 *
 * ----------------------------------------------------------------------------
 * URLs:    http://expect.nist.gov/
 *	    http://expect.sf.net/
 *	    http://bmrc.berkeley.edu/people/chaffee/expectnt.html
 * ----------------------------------------------------------------------------
 * RCS: @(#) $Id: expWinUtils.cpp,v 1.1.2.9 2003/08/26 20:46:54 davygrvy Exp $
 * ----------------------------------------------------------------------------
 */

#include "expWinPort.h"
#include <WinError.h>
#include <ctype.h>
#include <string.h>

/* Fix the error in winnt.h */
#if (_MSC_VER == 1200)
#   undef DEFAULT_UNREACHABLE
#   define DEFAULT_UNREACHABLE default: __assume(0)
#elif !defined(_MSC_VER) || (_MSC_VER < 1200)
#   undef DEFAULT_UNREACHABLE
#   define DEFAULT_UNREACHABLE default: return "UNKNOWN"
#endif

#define ERR_BUF_SIZE	1024
typedef struct ThreadSpecificData {
    char sysMsgSpace[ERR_BUF_SIZE];
} ThreadSpecificData;
static Tcl_ThreadDataKey dataKey;

/*
 * Some earlier <winerror.h> header files do not contain all the
 * error codes of the newest releases.  Add them, here.
 */

#ifndef ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY
#define ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY 217L
#endif
#ifndef ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY
#define ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY 218L
#endif
#ifndef ERROR_OPLOCK_NOT_GRANTED
#define ERROR_OPLOCK_NOT_GRANTED         300L
#endif
#ifndef ERROR_INVALID_OPLOCK_PROTOCOL
#define ERROR_INVALID_OPLOCK_PROTOCOL    301L
#endif
#ifndef ERROR_DISK_TOO_FRAGMENTED
#define ERROR_DISK_TOO_FRAGMENTED        302L
#endif
#ifndef ERROR_DELETE_PENDING
#define ERROR_DELETE_PENDING             303L
#endif
#ifndef ERROR_SCOPE_NOT_FOUND
#define ERROR_SCOPE_NOT_FOUND            318L
#endif
#ifndef ERROR_CANNOT_DETECT_DRIVER_FAILURE
#define ERROR_CANNOT_DETECT_DRIVER_FAILURE 1080L
#endif
#ifndef ERROR_CANNOT_DETECT_PROCESS_ABORT
#define ERROR_CANNOT_DETECT_PROCESS_ABORT 1081L
#endif
#ifndef ERROR_NO_RECOVERY_PROGRAM
#define ERROR_NO_RECOVERY_PROGRAM        1082L
#endif
#ifndef ERROR_SERVICE_NOT_IN_EXE
#define ERROR_SERVICE_NOT_IN_EXE         1083L
#endif
#ifndef ERROR_NOT_SAFEBOOT_SERVICE
#define ERROR_NOT_SAFEBOOT_SERVICE       1084L
#endif
#ifndef ERROR_NO_MORE_USER_HANDLES
#define ERROR_NO_MORE_USER_HANDLES       1158L
#endif
#ifndef ERROR_MESSAGE_SYNC_ONLY
#define ERROR_MESSAGE_SYNC_ONLY          1159L
#endif
#ifndef ERROR_SOURCE_ELEMENT_EMPTY
#define ERROR_SOURCE_ELEMENT_EMPTY       1160L
#endif
#ifndef ERROR_DESTINATION_ELEMENT_FULL
#define ERROR_DESTINATION_ELEMENT_FULL   1161L
#endif
#ifndef ERROR_ILLEGAL_ELEMENT_ADDRESS
#define ERROR_ILLEGAL_ELEMENT_ADDRESS    1162L
#endif
#ifndef ERROR_MAGAZINE_NOT_PRESENT
#define ERROR_MAGAZINE_NOT_PRESENT       1163L
#endif
#ifndef ERROR_DEVICE_REINITIALIZATION_NEEDED
#define ERROR_DEVICE_REINITIALIZATION_NEEDED 1164L
#endif
#ifndef ERROR_DEVICE_REQUIRES_CLEANING
#define ERROR_DEVICE_REQUIRES_CLEANING   1165L
#endif
#ifndef ERROR_DEVICE_DOOR_OPEN
#define ERROR_DEVICE_DOOR_OPEN           1166L
#endif
#ifndef ERROR_DEVICE_NOT_CONNECTED
#define ERROR_DEVICE_NOT_CONNECTED       1167L
#endif
#ifndef ERROR_NOT_FOUND
#define ERROR_NOT_FOUND                  1168L
#endif
#ifndef ERROR_NO_MATCH
#define ERROR_NO_MATCH                   1169L
#endif
#ifndef ERROR_SET_NOT_FOUND
#define ERROR_SET_NOT_FOUND              1170L
#endif
#ifndef ERROR_POINT_NOT_FOUND
#define ERROR_POINT_NOT_FOUND            1171L
#endif
#ifndef ERROR_NO_TRACKING_SERVICE
#define ERROR_NO_TRACKING_SERVICE        1172L
#endif
#ifndef ERROR_NO_VOLUME_ID
#define ERROR_NO_VOLUME_ID               1173L
#endif
#ifndef ERROR_UNABLE_TO_REMOVE_REPLACED
#define ERROR_UNABLE_TO_REMOVE_REPLACED  1175L
#endif
#ifndef ERROR_UNABLE_TO_MOVE_REPLACEMENT
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT 1176L
#endif
#ifndef ERROR_UNABLE_TO_MOVE_REPLACEMENT_2
#define ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 1177L
#endif
#ifndef ERROR_JOURNAL_DELETE_IN_PROGRESS
#define ERROR_JOURNAL_DELETE_IN_PROGRESS 1178L
#endif
#ifndef ERROR_JOURNAL_NOT_ACTIVE
#define ERROR_JOURNAL_NOT_ACTIVE         1179L
#endif
#ifndef ERROR_POTENTIAL_FILE_FOUND
#define ERROR_POTENTIAL_FILE_FOUND       1180L
#endif
#ifndef ERROR_JOURNAL_ENTRY_DELETED
#define ERROR_JOURNAL_ENTRY_DELETED      1181L
#endif
#ifndef ERROR_NO_SUCH_SITE
#define ERROR_NO_SUCH_SITE               1249L
#endif
#ifndef ERROR_DOMAIN_CONTROLLER_EXISTS
#define ERROR_DOMAIN_CONTROLLER_EXISTS   1250L
#endif
#ifndef ERROR_ONLY_IF_CONNECTED
#define ERROR_ONLY_IF_CONNECTED          1251L
#endif
#ifndef ERROR_OVERRIDE_NOCHANGES
#define ERROR_OVERRIDE_NOCHANGES         1252L
#endif
#ifndef ERROR_BAD_USER_PROFILE
#define ERROR_BAD_USER_PROFILE           1253L
#endif
#ifndef ERROR_NOT_SUPPORTED_ON_SBS
#define ERROR_NOT_SUPPORTED_ON_SBS       1254L
#endif
#ifndef ERROR_SERVER_SHUTDOWN_IN_PROGRESS
#define ERROR_SERVER_SHUTDOWN_IN_PROGRESS 1255L
#endif
#ifndef ERROR_HOST_DOWN
#define ERROR_HOST_DOWN                  1256L
#endif
#ifndef ERROR_NON_ACCOUNT_SID
#define ERROR_NON_ACCOUNT_SID            1257L
#endif
#ifndef ERROR_NON_DOMAIN_SID
#define ERROR_NON_DOMAIN_SID             1258L
#endif
#ifndef ERROR_APPHELP_BLOCK
#define ERROR_APPHELP_BLOCK              1259L
#endif
#ifndef ERROR_ACCESS_DISABLED_BY_POLICY
#define ERROR_ACCESS_DISABLED_BY_POLICY  1260L
#endif
#ifndef ERROR_REG_NAT_CONSUMPTION
#define ERROR_REG_NAT_CONSUMPTION        1261L
#endif
#ifndef ERROR_CSCSHARE_OFFLINE
#define ERROR_CSCSHARE_OFFLINE           1262L
#endif
#ifndef ERROR_PKINIT_FAILURE
#define ERROR_PKINIT_FAILURE             1263L
#endif
#ifndef ERROR_SMARTCARD_SUBSYSTEM_FAILURE
#define ERROR_SMARTCARD_SUBSYSTEM_FAILURE 1264L
#endif
#ifndef ERROR_DOWNGRADE_DETECTED
#define ERROR_DOWNGRADE_DETECTED         1265L
#endif
#ifndef ERROR_MACHINE_LOCKED
#define ERROR_MACHINE_LOCKED             1271L
#endif
#ifndef ERROR_CALLBACK_SUPPLIED_INVALID_DATA
#define ERROR_CALLBACK_SUPPLIED_INVALID_DATA 1273L
#endif
#ifndef ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED
#define ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED 1274L
#endif
#ifndef ERROR_DRIVER_BLOCKED
#define ERROR_DRIVER_BLOCKED             1275L
#endif
#ifndef ERROR_INVALID_IMPORT_OF_NON_DLL
#define ERROR_INVALID_IMPORT_OF_NON_DLL  1276L
#endif
#ifndef ERROR_ACCESS_DISABLED_WEBBLADE
#define ERROR_ACCESS_DISABLED_WEBBLADE   1277L
#endif
#ifndef ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER
#define ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER 1278L
#endif
#ifndef ERROR_RECOVERY_FAILURE
#define ERROR_RECOVERY_FAILURE           1279L
#endif
#ifndef ERROR_ALREADY_FIBER
#define ERROR_ALREADY_FIBER              1280L
#endif
#ifndef ERROR_ALREADY_THREAD
#define ERROR_ALREADY_THREAD             1281L
#endif
#ifndef ERROR_STACK_BUFFER_OVERRUN
#define ERROR_STACK_BUFFER_OVERRUN       1282L
#endif
#ifndef ERROR_PARAMETER_QUOTA_EXCEEDED
#define ERROR_PARAMETER_QUOTA_EXCEEDED   1283L
#endif
#ifndef ERROR_DEBUGGER_INACTIVE
#define ERROR_DEBUGGER_INACTIVE          1284L
#endif
#ifndef ERROR_DELAY_LOAD_FAILED
#define ERROR_DELAY_LOAD_FAILED          1285L
#endif
#ifndef ERROR_VDM_DISALLOWED
#define ERROR_VDM_DISALLOWED             1286L
#endif
#ifndef ERROR_UNIDENTIFIED_ERROR
#define ERROR_UNIDENTIFIED_ERROR         1287L
#endif
#ifndef ERROR_WRONG_TARGET_NAME
#define ERROR_WRONG_TARGET_NAME          1396L
#endif
#ifndef ERROR_MUTUAL_AUTH_FAILED
#define ERROR_MUTUAL_AUTH_FAILED         1397L
#endif
#ifndef ERROR_TIME_SKEW
#define ERROR_TIME_SKEW                  1398L
#endif
#ifndef ERROR_CURRENT_DOMAIN_NOT_ALLOWED
#define ERROR_CURRENT_DOMAIN_NOT_ALLOWED 1399L
#endif
#ifndef ERROR_INVALID_MONITOR_HANDLE
#define ERROR_INVALID_MONITOR_HANDLE     1461L
#endif
#ifndef ERROR_INSTALL_SERVICE_FAILURE
#define ERROR_INSTALL_SERVICE_FAILURE    1601L
#endif
#ifndef ERROR_INSTALL_USEREXIT
#define ERROR_INSTALL_USEREXIT           1602L
#endif
#ifndef ERROR_INSTALL_FAILURE
#define ERROR_INSTALL_FAILURE            1603L
#endif
#ifndef ERROR_INSTALL_SUSPEND
#define ERROR_INSTALL_SUSPEND            1604L
#endif
#ifndef ERROR_UNKNOWN_PRODUCT
#define ERROR_UNKNOWN_PRODUCT            1605L
#endif
#ifndef ERROR_UNKNOWN_FEATURE
#define ERROR_UNKNOWN_FEATURE            1606L
#endif
#ifndef ERROR_UNKNOWN_COMPONENT
#define ERROR_UNKNOWN_COMPONENT          1607L
#endif
#ifndef ERROR_UNKNOWN_PROPERTY
#define ERROR_UNKNOWN_PROPERTY           1608L
#endif
#ifndef ERROR_INVALID_HANDLE_STATE
#define ERROR_INVALID_HANDLE_STATE       1609L
#endif
#ifndef ERROR_BAD_CONFIGURATION
#define ERROR_BAD_CONFIGURATION          1610L
#endif
#ifndef ERROR_INDEX_ABSENT
#define ERROR_INDEX_ABSENT               1611L
#endif
#ifndef ERROR_INSTALL_SOURCE_ABSENT
#define ERROR_INSTALL_SOURCE_ABSENT      1612L
#endif
#ifndef ERROR_INSTALL_PACKAGE_VERSION
#define ERROR_INSTALL_PACKAGE_VERSION    1613L
#endif
#ifndef ERROR_INSTALL_PACKAGE_VERSION
#define ERROR_INSTALL_PACKAGE_VERSION    1613L
#endif
#ifndef ERROR_PRODUCT_UNINSTALLED
#define ERROR_PRODUCT_UNINSTALLED        1614L
#endif
#ifndef ERROR_BAD_QUERY_SYNTAX
#define ERROR_BAD_QUERY_SYNTAX           1615L
#endif
#ifndef ERROR_INVALID_FIELD
#define ERROR_INVALID_FIELD              1616L
#endif
#ifndef ERROR_DEVICE_REMOVED
#define ERROR_DEVICE_REMOVED             1617L
#endif
#ifndef ERROR_INSTALL_ALREADY_RUNNING
#define ERROR_INSTALL_ALREADY_RUNNING    1618L
#endif
#ifndef ERROR_INSTALL_PACKAGE_OPEN_FAILED
#define ERROR_INSTALL_PACKAGE_OPEN_FAILED 1619L
#endif
#ifndef ERROR_INSTALL_PACKAGE_INVALID
#define ERROR_INSTALL_PACKAGE_INVALID    1620L
#endif
#ifndef ERROR_INSTALL_UI_FAILURE
#define ERROR_INSTALL_UI_FAILURE         1621L
#endif
#ifndef ERROR_INSTALL_LOG_FAILURE
#define ERROR_INSTALL_LOG_FAILURE        1622L
#endif
#ifndef ERROR_INSTALL_LANGUAGE_UNSUPPORTED
#define ERROR_INSTALL_LANGUAGE_UNSUPPORTED 1623L
#endif
#ifndef ERROR_INSTALL_TRANSFORM_FAILURE
#define ERROR_INSTALL_TRANSFORM_FAILURE  1624L
#endif
#ifndef ERROR_INSTALL_PACKAGE_REJECTED
#define ERROR_INSTALL_PACKAGE_REJECTED   1625L
#endif
#ifndef ERROR_FUNCTION_NOT_CALLED
#define ERROR_FUNCTION_NOT_CALLED        1626L
#endif
#ifndef ERROR_FUNCTION_FAILED
#define ERROR_FUNCTION_FAILED            1627L
#endif
#ifndef ERROR_INVALID_TABLE
#define ERROR_INVALID_TABLE              1628L
#endif
#ifndef ERROR_DATATYPE_MISMATCH
#define ERROR_DATATYPE_MISMATCH          1629L
#endif
#ifndef ERROR_UNSUPPORTED_TYPE
#define ERROR_UNSUPPORTED_TYPE           1630L
#endif
#ifndef ERROR_CREATE_FAILED
#define ERROR_CREATE_FAILED              1631L
#endif
#ifndef ERROR_INSTALL_TEMP_UNWRITABLE
#define ERROR_INSTALL_TEMP_UNWRITABLE    1632L
#endif
#ifndef ERROR_INSTALL_PLATFORM_UNSUPPORTED
#define ERROR_INSTALL_PLATFORM_UNSUPPORTED 1633L
#endif
#ifndef ERROR_INSTALL_NOTUSED
#define ERROR_INSTALL_NOTUSED            1634L
#endif
#ifndef ERROR_PATCH_PACKAGE_OPEN_FAILED
#define ERROR_PATCH_PACKAGE_OPEN_FAILED  1635L
#endif
#ifndef ERROR_PATCH_PACKAGE_INVALID
#define ERROR_PATCH_PACKAGE_INVALID      1636L
#endif
#ifndef ERROR_PATCH_PACKAGE_UNSUPPORTED
#define ERROR_PATCH_PACKAGE_UNSUPPORTED  1637L
#endif
#ifndef ERROR_PRODUCT_VERSION
#define ERROR_PRODUCT_VERSION            1638L
#endif
#ifndef ERROR_INVALID_COMMAND_LINE
#define ERROR_INVALID_COMMAND_LINE       1639L
#endif
#ifndef ERROR_INSTALL_REMOTE_DISALLOWED
#define ERROR_INSTALL_REMOTE_DISALLOWED  1640L
#endif
#ifndef ERROR_SUCCESS_REBOOT_INITIATED
#define ERROR_SUCCESS_REBOOT_INITIATED   1641L
#endif
#ifndef ERROR_PATCH_TARGET_NOT_FOUND
#define ERROR_PATCH_TARGET_NOT_FOUND     1642L
#endif
#ifndef ERROR_PATCH_PACKAGE_REJECTED
#define ERROR_PATCH_PACKAGE_REJECTED     1643L
#endif
#ifndef ERROR_INSTALL_TRANSFORM_REJECTED
#define ERROR_INSTALL_TRANSFORM_REJECTED 1644L
#endif
#ifndef ERROR_INSTALL_REMOTE_PROHIBITED
#define ERROR_INSTALL_REMOTE_PROHIBITED  1645L
#endif
#ifndef RPC_X_WRONG_PIPE_ORDER
#define RPC_X_WRONG_PIPE_ORDER           1831L
#endif
#ifndef RPC_X_WRONG_PIPE_VERSION
#define RPC_X_WRONG_PIPE_VERSION         1832L
#endif
#ifndef RPC_S_INVALID_ASYNC_HANDLE
#define RPC_S_INVALID_ASYNC_HANDLE       1914L
#endif
#ifndef RPC_S_INVALID_ASYNC_CALL
#define RPC_S_INVALID_ASYNC_CALL         1915L
#endif
#ifndef RPC_X_PIPE_CLOSED
#define RPC_X_PIPE_CLOSED                1916L
#endif
#ifndef RPC_X_PIPE_DISCIPLINE_ERROR
#define RPC_X_PIPE_DISCIPLINE_ERROR      1917L
#endif
#ifndef RPC_X_PIPE_EMPTY
#define RPC_X_PIPE_EMPTY                 1918L
#endif
#ifndef ERROR_NO_SITENAME
#define ERROR_NO_SITENAME                1919L
#endif
#ifndef ERROR_CANT_ACCESS_FILE
#define ERROR_CANT_ACCESS_FILE           1920L
#endif
#ifndef ERROR_CANT_RESOLVE_FILENAME
#define ERROR_CANT_RESOLVE_FILENAME      1921L
#endif
#ifndef RPC_S_ENTRY_TYPE_MISMATCH
#define RPC_S_ENTRY_TYPE_MISMATCH        1922L
#endif
#ifndef RPC_S_NOT_ALL_OBJS_EXPORTED
#define RPC_S_NOT_ALL_OBJS_EXPORTED      1923L
#endif
#ifndef RPC_S_INTERFACE_NOT_EXPORTED
#define RPC_S_INTERFACE_NOT_EXPORTED     1924L
#endif
#ifndef RPC_S_PROFILE_NOT_ADDED
#define RPC_S_PROFILE_NOT_ADDED          1925L
#endif
#ifndef RPC_S_PRF_ELT_NOT_ADDED
#define RPC_S_PRF_ELT_NOT_ADDED          1926L
#endif
#ifndef RPC_S_PRF_ELT_NOT_REMOVED
#define RPC_S_PRF_ELT_NOT_REMOVED        1927L
#endif
#ifndef RPC_S_GRP_ELT_NOT_ADDED
#define RPC_S_GRP_ELT_NOT_ADDED          1928L
#endif
#ifndef RPC_S_GRP_ELT_NOT_REMOVED
#define RPC_S_GRP_ELT_NOT_REMOVED        1929L
#endif
#ifndef ERROR_KM_DRIVER_BLOCKED
#define ERROR_KM_DRIVER_BLOCKED          1930L
#endif
#ifndef ERROR_CONTEXT_EXPIRED
#define ERROR_CONTEXT_EXPIRED            1931L
#endif
#ifndef ERROR_PER_USER_TRUST_QUOTA_EXCEEDED
#define ERROR_PER_USER_TRUST_QUOTA_EXCEEDED 1932L
#endif
#ifndef ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED
#define ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED 1933L
#endif
#ifndef ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED
#define ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED 1934L
#endif
#ifndef ERROR_AUTHENTICATION_FIREWALL_FAILED
#define ERROR_AUTHENTICATION_FIREWALL_FAILED 1935L
#endif
#ifndef ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED
#define ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED 1936L
#endif
#ifndef ERROR_INVALID_CMM
#define ERROR_INVALID_CMM                2010L
#endif
#ifndef ERROR_INVALID_PROFILE
#define ERROR_INVALID_PROFILE            2011L
#endif
#ifndef ERROR_TAG_NOT_FOUND
#define ERROR_TAG_NOT_FOUND              2012L
#endif
#ifndef ERROR_TAG_NOT_PRESENT
#define ERROR_TAG_NOT_PRESENT            2013L
#endif
#ifndef ERROR_DUPLICATE_TAG
#define ERROR_DUPLICATE_TAG              2014L
#endif
#ifndef ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE
#define ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE 2015L
#endif
#ifndef ERROR_PROFILE_NOT_FOUND
#define ERROR_PROFILE_NOT_FOUND          2016L
#endif
#ifndef ERROR_INVALID_COLORSPACE
#define ERROR_INVALID_COLORSPACE         2017L
#endif
#ifndef ERROR_ICM_NOT_ENABLED
#define ERROR_ICM_NOT_ENABLED            2018L
#endif
#ifndef ERROR_DELETING_ICM_XFORM
#define ERROR_DELETING_ICM_XFORM         2019L
#endif
#ifndef ERROR_INVALID_TRANSFORM
#define ERROR_INVALID_TRANSFORM          2020L
#endif
#ifndef ERROR_COLORSPACE_MISMATCH
#define ERROR_COLORSPACE_MISMATCH        2021L
#endif
#ifndef ERROR_INVALID_COLORINDEX
#define ERROR_INVALID_COLORINDEX         2022L
#endif
#ifndef ERROR_COLORSPACE_MISMATCH
#define ERROR_COLORSPACE_MISMATCH        2021L
#endif
#ifndef ERROR_INVALID_COLORINDEX
#define ERROR_INVALID_COLORINDEX         2022L
#endif
#ifndef ERROR_CONNECTED_OTHER_PASSWORD
#define ERROR_CONNECTED_OTHER_PASSWORD   2108L
#endif
#ifndef ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT
#define ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT 2109L
#endif
#ifndef ERROR_PRINTER_NOT_FOUND
#define ERROR_PRINTER_NOT_FOUND          3012L
#endif
#ifndef ERROR_PRINTER_DRIVER_WARNED
#define ERROR_PRINTER_DRIVER_WARNED      3013L
#endif
#ifndef ERROR_PRINTER_DRIVER_BLOCKED
#define ERROR_PRINTER_DRIVER_BLOCKED     3014L
#endif
#ifndef ERROR_DHCP_ADDRESS_CONFLICT
#define ERROR_DHCP_ADDRESS_CONFLICT      4100L
#endif
#ifndef ERROR_WMI_GUID_NOT_FOUND
#define ERROR_WMI_GUID_NOT_FOUND         4200L
#endif
#ifndef ERROR_WMI_INSTANCE_NOT_FOUND
#define ERROR_WMI_INSTANCE_NOT_FOUND     4201L
#endif
#ifndef ERROR_WMI_ITEMID_NOT_FOUND
#define ERROR_WMI_ITEMID_NOT_FOUND       4202L
#endif
#ifndef ERROR_WMI_TRY_AGAIN
#define ERROR_WMI_TRY_AGAIN              4203L
#endif
#ifndef ERROR_WMI_DP_NOT_FOUND
#define ERROR_WMI_DP_NOT_FOUND           4204L
#endif
#ifndef ERROR_WMI_UNRESOLVED_INSTANCE_REF
#define ERROR_WMI_UNRESOLVED_INSTANCE_REF 4205L
#endif
#ifndef ERROR_WMI_ALREADY_ENABLED
#define ERROR_WMI_ALREADY_ENABLED        4206L
#endif
#ifndef ERROR_WMI_GUID_DISCONNECTED
#define ERROR_WMI_GUID_DISCONNECTED      4207L
#endif
#ifndef ERROR_WMI_SERVER_UNAVAILABLE
#define ERROR_WMI_SERVER_UNAVAILABLE     4208L
#endif
#ifndef ERROR_WMI_DP_FAILED
#define ERROR_WMI_DP_FAILED              4209L
#endif
#ifndef ERROR_WMI_INVALID_MOF
#define ERROR_WMI_INVALID_MOF            4210L
#endif
#ifndef ERROR_WMI_INVALID_REGINFO
#define ERROR_WMI_INVALID_REGINFO        4211L
#endif
#ifndef ERROR_WMI_ALREADY_DISABLED
#define ERROR_WMI_ALREADY_DISABLED       4212L
#endif
#ifndef ERROR_WMI_READ_ONLY
#define ERROR_WMI_READ_ONLY              4213L
#endif
#ifndef ERROR_WMI_SET_FAILURE
#define ERROR_WMI_SET_FAILURE            4214L
#endif
#ifndef ERROR_INVALID_MEDIA
#define ERROR_INVALID_MEDIA              4300L
#endif
#ifndef ERROR_INVALID_LIBRARY
#define ERROR_INVALID_LIBRARY            4301L
#endif
#ifndef ERROR_INVALID_MEDIA_POOL
#define ERROR_INVALID_MEDIA_POOL         4302L
#endif
#ifndef ERROR_DRIVE_MEDIA_MISMATCH
#define ERROR_DRIVE_MEDIA_MISMATCH       4303L
#endif
#ifndef ERROR_MEDIA_OFFLINE
#define ERROR_MEDIA_OFFLINE              4304L
#endif
#ifndef ERROR_LIBRARY_OFFLINE
#define ERROR_LIBRARY_OFFLINE            4305L
#endif
#ifndef ERROR_EMPTY
#define ERROR_EMPTY                      4306L
#endif
#ifndef ERROR_NOT_EMPTY
#define ERROR_NOT_EMPTY                  4307L
#endif
#ifndef ERROR_MEDIA_UNAVAILABLE
#define ERROR_MEDIA_UNAVAILABLE          4308L
#endif
#ifndef ERROR_RESOURCE_DISABLED
#define ERROR_RESOURCE_DISABLED          4309L
#endif
#ifndef ERROR_INVALID_CLEANER
#define ERROR_INVALID_CLEANER            4310L
#endif
#ifndef ERROR_UNABLE_TO_CLEAN
#define ERROR_UNABLE_TO_CLEAN            4311L
#endif
#ifndef ERROR_OBJECT_NOT_FOUND
#define ERROR_OBJECT_NOT_FOUND           4312L
#endif
#ifndef ERROR_DATABASE_FAILURE
#define ERROR_DATABASE_FAILURE           4313L
#endif
#ifndef ERROR_DATABASE_FULL
#define ERROR_DATABASE_FULL              4314L
#endif
#ifndef ERROR_MEDIA_INCOMPATIBLE
#define ERROR_MEDIA_INCOMPATIBLE         4315L
#endif
#ifndef ERROR_RESOURCE_NOT_PRESENT
#define ERROR_RESOURCE_NOT_PRESENT       4316L
#endif
#ifndef ERROR_INVALID_OPERATION
#define ERROR_INVALID_OPERATION          4317L
#endif
#ifndef ERROR_MEDIA_NOT_AVAILABLE
#define ERROR_MEDIA_NOT_AVAILABLE        4318L
#endif
#ifndef ERROR_DEVICE_NOT_AVAILABLE
#define ERROR_DEVICE_NOT_AVAILABLE       4319L
#endif
#ifndef ERROR_REQUEST_REFUSED
#define ERROR_REQUEST_REFUSED            4320L
#endif
#ifndef ERROR_INVALID_DRIVE_OBJECT
#define ERROR_INVALID_DRIVE_OBJECT       4321L
#endif
#ifndef ERROR_LIBRARY_FULL
#define ERROR_LIBRARY_FULL               4322L
#endif
#ifndef ERROR_MEDIUM_NOT_ACCESSIBLE
#define ERROR_MEDIUM_NOT_ACCESSIBLE      4323L
#endif
#ifndef ERROR_UNABLE_TO_LOAD_MEDIUM
#define ERROR_UNABLE_TO_LOAD_MEDIUM      4324L
#endif
#ifndef ERROR_UNABLE_TO_INVENTORY_DRIVE
#define ERROR_UNABLE_TO_INVENTORY_DRIVE  4325L
#endif
#ifndef ERROR_UNABLE_TO_INVENTORY_SLOT
#define ERROR_UNABLE_TO_INVENTORY_SLOT   4326L
#endif
#ifndef ERROR_UNABLE_TO_INVENTORY_TRANSPORT
#define ERROR_UNABLE_TO_INVENTORY_TRANSPORT 4327L
#endif
#ifndef ERROR_TRANSPORT_FULL
#define ERROR_TRANSPORT_FULL             4328L
#endif
#ifndef ERROR_CONTROLLING_IEPORT
#define ERROR_CONTROLLING_IEPORT         4329L
#endif
#ifndef ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA
#define ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA 4330L
#endif
#ifndef ERROR_CLEANER_SLOT_SET
#define ERROR_CLEANER_SLOT_SET           4331L
#endif
#ifndef ERROR_CLEANER_SLOT_NOT_SET
#define ERROR_CLEANER_SLOT_NOT_SET       4332L
#endif
#ifndef ERROR_CLEANER_CARTRIDGE_SPENT
#define ERROR_CLEANER_CARTRIDGE_SPENT    4333L
#endif
#ifndef ERROR_UNEXPECTED_OMID
#define ERROR_UNEXPECTED_OMID            4334L
#endif
#ifndef ERROR_CANT_DELETE_LAST_ITEM
#define ERROR_CANT_DELETE_LAST_ITEM      4335L
#endif
#ifndef ERROR_MESSAGE_EXCEEDS_MAX_SIZE
#define ERROR_MESSAGE_EXCEEDS_MAX_SIZE   4336L
#endif
#ifndef ERROR_VOLUME_CONTAINS_SYS_FILES
#define ERROR_VOLUME_CONTAINS_SYS_FILES  4337L
#endif
#ifndef ERROR_INDIGENOUS_TYPE
#define ERROR_INDIGENOUS_TYPE            4338L
#endif
#ifndef ERROR_NO_SUPPORTING_DRIVES
#define ERROR_NO_SUPPORTING_DRIVES       4339L
#endif
#ifndef ERROR_CLEANER_CARTRIDGE_INSTALLED
#define ERROR_CLEANER_CARTRIDGE_INSTALLED 4340L
#endif
#ifndef ERROR_IEPORT_FULL
#define ERROR_IEPORT_FULL                4341L
#endif
#ifndef ERROR_FILE_OFFLINE
#define ERROR_FILE_OFFLINE               4350L
#endif
#ifndef ERROR_REMOTE_STORAGE_NOT_ACTIVE
#define ERROR_REMOTE_STORAGE_NOT_ACTIVE  4351L
#endif
#ifndef ERROR_REMOTE_STORAGE_MEDIA_ERROR
#define ERROR_REMOTE_STORAGE_MEDIA_ERROR 4352L
#endif
#ifndef ERROR_NOT_A_REPARSE_POINT
#define ERROR_NOT_A_REPARSE_POINT        4390L
#endif
#ifndef ERROR_REPARSE_ATTRIBUTE_CONFLICT
#define ERROR_REPARSE_ATTRIBUTE_CONFLICT 4391L
#endif
#ifndef ERROR_INVALID_REPARSE_DATA
#define ERROR_INVALID_REPARSE_DATA       4392L
#endif
#ifndef ERROR_REPARSE_TAG_INVALID
#define ERROR_REPARSE_TAG_INVALID        4393L
#endif
#ifndef ERROR_REPARSE_TAG_MISMATCH
#define ERROR_REPARSE_TAG_MISMATCH       4394L
#endif
#ifndef ERROR_VOLUME_NOT_SIS_ENABLED
#define ERROR_VOLUME_NOT_SIS_ENABLED     4500L
#endif
#ifndef ERROR_DEPENDENT_RESOURCE_EXISTS
#define ERROR_DEPENDENT_RESOURCE_EXISTS  5001L
#endif
#ifndef ERROR_DEPENDENCY_NOT_FOUND
#define ERROR_DEPENDENCY_NOT_FOUND       5002L
#endif
#ifndef ERROR_DEPENDENCY_ALREADY_EXISTS
#define ERROR_DEPENDENCY_ALREADY_EXISTS  5003L
#endif
#ifndef ERROR_RESOURCE_NOT_ONLINE
#define ERROR_RESOURCE_NOT_ONLINE        5004L
#endif
#ifndef ERROR_HOST_NODE_NOT_AVAILABLE
#define ERROR_HOST_NODE_NOT_AVAILABLE    5005L
#endif
#ifndef ERROR_RESOURCE_NOT_AVAILABLE
#define ERROR_RESOURCE_NOT_AVAILABLE     5006L
#endif
#ifndef ERROR_RESOURCE_NOT_FOUND
#define ERROR_RESOURCE_NOT_FOUND         5007L
#endif
#ifndef ERROR_SHUTDOWN_CLUSTER
#define ERROR_SHUTDOWN_CLUSTER           5008L
#endif
#ifndef ERROR_CANT_EVICT_ACTIVE_NODE
#define ERROR_CANT_EVICT_ACTIVE_NODE     5009L
#endif
#ifndef ERROR_OBJECT_ALREADY_EXISTS
#define ERROR_OBJECT_ALREADY_EXISTS      5010L
#endif
#ifndef ERROR_OBJECT_IN_LIST
#define ERROR_OBJECT_IN_LIST             5011L
#endif
#ifndef ERROR_GROUP_NOT_AVAILABLE
#define ERROR_GROUP_NOT_AVAILABLE        5012L
#endif
#ifndef ERROR_GROUP_NOT_FOUND
#define ERROR_GROUP_NOT_FOUND            5013L
#endif
#ifndef ERROR_GROUP_NOT_ONLINE
#define ERROR_GROUP_NOT_ONLINE           5014L
#endif
#ifndef ERROR_HOST_NODE_NOT_RESOURCE_OWNER
#define ERROR_HOST_NODE_NOT_RESOURCE_OWNER 5015L
#endif
#ifndef ERROR_HOST_NODE_NOT_GROUP_OWNER
#define ERROR_HOST_NODE_NOT_GROUP_OWNER  5016L
#endif
#ifndef ERROR_RESMON_CREATE_FAILED
#define ERROR_RESMON_CREATE_FAILED       5017L
#endif
#ifndef ERROR_RESMON_ONLINE_FAILED
#define ERROR_RESMON_ONLINE_FAILED       5018L
#endif
#ifndef ERROR_RESOURCE_ONLINE
#define ERROR_RESOURCE_ONLINE            5019L
#endif
#ifndef ERROR_QUORUM_RESOURCE
#define ERROR_QUORUM_RESOURCE            5020L
#endif
#ifndef ERROR_NOT_QUORUM_CAPABLE
#define ERROR_NOT_QUORUM_CAPABLE         5021L
#endif
#ifndef ERROR_CLUSTER_SHUTTING_DOWN
#define ERROR_CLUSTER_SHUTTING_DOWN      5022L
#endif
#ifndef ERROR_INVALID_STATE
#define ERROR_INVALID_STATE              5023L
#endif
#ifndef ERROR_RESOURCE_PROPERTIES_STORED
#define ERROR_RESOURCE_PROPERTIES_STORED 5024L
#endif
#ifndef ERROR_NOT_QUORUM_CLASS
#define ERROR_NOT_QUORUM_CLASS           5025L
#endif
#ifndef ERROR_CORE_RESOURCE
#define ERROR_CORE_RESOURCE              5026L
#endif
#ifndef ERROR_QUORUM_RESOURCE_ONLINE_FAILED
#define ERROR_QUORUM_RESOURCE_ONLINE_FAILED 5027L
#endif
#ifndef ERROR_QUORUMLOG_OPEN_FAILED
#define ERROR_QUORUMLOG_OPEN_FAILED      5028L
#endif
#ifndef ERROR_CLUSTERLOG_CORRUPT
#define ERROR_CLUSTERLOG_CORRUPT         5029L
#endif
#ifndef ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE
#define ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE 5030L
#endif
#ifndef ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE
#define ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE 5031L
#endif
#ifndef ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND
#define ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND 5032L
#endif
#ifndef ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE
#define ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE 5033L
#endif
#ifndef ERROR_QUORUM_OWNER_ALIVE
#define ERROR_QUORUM_OWNER_ALIVE         5034L
#endif
#ifndef ERROR_NETWORK_NOT_AVAILABLE
#define ERROR_NETWORK_NOT_AVAILABLE      5035L
#endif
#ifndef ERROR_NODE_NOT_AVAILABLE
#define ERROR_NODE_NOT_AVAILABLE         5036L
#endif
#ifndef ERROR_ALL_NODES_NOT_AVAILABLE
#define ERROR_ALL_NODES_NOT_AVAILABLE    5037L
#endif
#ifndef ERROR_RESOURCE_FAILED
#define ERROR_RESOURCE_FAILED            5038L
#endif
#ifndef ERROR_CLUSTER_INVALID_NODE
#define ERROR_CLUSTER_INVALID_NODE       5039L
#endif
#ifndef ERROR_CLUSTER_NODE_EXISTS
#define ERROR_CLUSTER_NODE_EXISTS        5040L
#endif
#ifndef ERROR_CLUSTER_JOIN_IN_PROGRESS
#define ERROR_CLUSTER_JOIN_IN_PROGRESS   5041L
#endif
#ifndef ERROR_CLUSTER_NODE_NOT_FOUND
#define ERROR_CLUSTER_NODE_NOT_FOUND     5042L
#endif
#ifndef ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND
#define ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND 5043L
#endif
#ifndef ERROR_CLUSTER_NETWORK_EXISTS
#define ERROR_CLUSTER_NETWORK_EXISTS     5044L
#endif
#ifndef ERROR_CLUSTER_NETWORK_NOT_FOUND
#define ERROR_CLUSTER_NETWORK_NOT_FOUND  5045L
#endif
#ifndef ERROR_CLUSTER_NETINTERFACE_EXISTS
#define ERROR_CLUSTER_NETINTERFACE_EXISTS 5046L
#endif
#ifndef ERROR_CLUSTER_NETINTERFACE_NOT_FOUND
#define ERROR_CLUSTER_NETINTERFACE_NOT_FOUND 5047L
#endif
#ifndef ERROR_CLUSTER_INVALID_REQUEST
#define ERROR_CLUSTER_INVALID_REQUEST    5048L
#endif
#ifndef ERROR_CLUSTER_INVALID_NETWORK_PROVIDER
#define ERROR_CLUSTER_INVALID_NETWORK_PROVIDER 5049L
#endif
#ifndef ERROR_CLUSTER_NODE_DOWN
#define ERROR_CLUSTER_NODE_DOWN          5050L
#endif
#ifndef ERROR_CLUSTER_NODE_UNREACHABLE
#define ERROR_CLUSTER_NODE_UNREACHABLE   5051L
#endif
#ifndef ERROR_CLUSTER_NODE_NOT_MEMBER
#define ERROR_CLUSTER_NODE_NOT_MEMBER    5052L
#endif
#ifndef ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS
#define ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS 5053L
#endif
#ifndef ERROR_CLUSTER_INVALID_NETWORK
#define ERROR_CLUSTER_INVALID_NETWORK    5054L
#endif
#ifndef ERROR_CLUSTER_NODE_UP
#define ERROR_CLUSTER_NODE_UP            5056L
#endif
#ifndef ERROR_CLUSTER_IPADDR_IN_USE
#define ERROR_CLUSTER_IPADDR_IN_USE      5057L
#endif
#ifndef ERROR_CLUSTER_NODE_NOT_PAUSED
#define ERROR_CLUSTER_NODE_NOT_PAUSED    5058L
#endif
#ifndef ERROR_CLUSTER_NO_SECURITY_CONTEXT
#define ERROR_CLUSTER_NO_SECURITY_CONTEXT 5059L
#endif
#ifndef ERROR_CLUSTER_NETWORK_NOT_INTERNAL
#define ERROR_CLUSTER_NETWORK_NOT_INTERNAL 5060L
#endif
#ifndef ERROR_CLUSTER_NODE_ALREADY_UP
#define ERROR_CLUSTER_NODE_ALREADY_UP    5061L
#endif
#ifndef ERROR_CLUSTER_NODE_ALREADY_DOWN
#define ERROR_CLUSTER_NODE_ALREADY_DOWN  5062L
#endif
#ifndef ERROR_CLUSTER_NETWORK_ALREADY_ONLINE
#define ERROR_CLUSTER_NETWORK_ALREADY_ONLINE 5063L
#endif
#ifndef ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE
#define ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE 5064L
#endif
#ifndef ERROR_CLUSTER_NODE_ALREADY_MEMBER
#define ERROR_CLUSTER_NODE_ALREADY_MEMBER 5065L
#endif
#ifndef ERROR_CLUSTER_LAST_INTERNAL_NETWORK
#define ERROR_CLUSTER_LAST_INTERNAL_NETWORK 5066L
#endif
#ifndef ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS
#define ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS 5067L
#endif
#ifndef ERROR_INVALID_OPERATION_ON_QUORUM
#define ERROR_INVALID_OPERATION_ON_QUORUM 5068L
#endif
#ifndef ERROR_DEPENDENCY_NOT_ALLOWED
#define ERROR_DEPENDENCY_NOT_ALLOWED     5069L
#endif
#ifndef ERROR_CLUSTER_NODE_PAUSED
#define ERROR_CLUSTER_NODE_PAUSED        5070L
#endif
#ifndef ERROR_NODE_CANT_HOST_RESOURCE
#define ERROR_NODE_CANT_HOST_RESOURCE    5071L
#endif
#ifndef ERROR_CLUSTER_NODE_NOT_READY
#define ERROR_CLUSTER_NODE_NOT_READY     5072L
#endif
#ifndef ERROR_CLUSTER_NODE_SHUTTING_DOWN
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN 5073L
#endif
#ifndef ERROR_CLUSTER_NODE_SHUTTING_DOWN
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN 5073L
#endif
#ifndef ERROR_CLUSTER_NODE_SHUTTING_DOWN
#define ERROR_CLUSTER_NODE_SHUTTING_DOWN 5073L
#endif
#ifndef ERROR_CLUSTER_JOIN_ABORTED
#define ERROR_CLUSTER_JOIN_ABORTED       5074L
#endif
#ifndef ERROR_CLUSTER_INCOMPATIBLE_VERSIONS
#define ERROR_CLUSTER_INCOMPATIBLE_VERSIONS 5075L
#endif
#ifndef ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED
#define ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED 5076L
#endif
#ifndef ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED
#define ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED 5077L
#endif
#ifndef ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND
#define ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND 5078L
#endif
#ifndef ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED
#define ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED 5079L
#endif
#ifndef ERROR_CLUSTER_RESNAME_NOT_FOUND
#define ERROR_CLUSTER_RESNAME_NOT_FOUND  5080L
#endif
#ifndef ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED
#define ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED 5081L
#endif
#ifndef ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST
#define ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST 5082L
#endif
#ifndef ERROR_CLUSTER_DATABASE_SEQMISMATCH
#define ERROR_CLUSTER_DATABASE_SEQMISMATCH 5083L
#endif
#ifndef ERROR_RESMON_INVALID_STATE
#define ERROR_RESMON_INVALID_STATE       5084L
#endif
#ifndef ERROR_CLUSTER_GUM_NOT_LOCKER
#define ERROR_CLUSTER_GUM_NOT_LOCKER     5085L
#endif
#ifndef ERROR_QUORUM_DISK_NOT_FOUND
#define ERROR_QUORUM_DISK_NOT_FOUND      5086L
#endif
#ifndef ERROR_DATABASE_BACKUP_CORRUPT
#define ERROR_DATABASE_BACKUP_CORRUPT    5087L
#endif
#ifndef ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT
#define ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT 5088L
#endif
#ifndef ERROR_RESOURCE_PROPERTY_UNCHANGEABLE
#define ERROR_RESOURCE_PROPERTY_UNCHANGEABLE 5089L
#endif
#ifndef ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE
#define ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE 5890L
#endif
#ifndef ERROR_CLUSTER_QUORUMLOG_NOT_FOUND
#define ERROR_CLUSTER_QUORUMLOG_NOT_FOUND 5891L
#endif
#ifndef ERROR_CLUSTER_MEMBERSHIP_HALT
#define ERROR_CLUSTER_MEMBERSHIP_HALT    5892L
#endif
#ifndef ERROR_CLUSTER_INSTANCE_ID_MISMATCH
#define ERROR_CLUSTER_INSTANCE_ID_MISMATCH 5893L
#endif
#ifndef ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP
#define ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP 5894L
#endif
#ifndef ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH
#define ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH 5895L
#endif
#ifndef ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP
#define ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP 5896L
#endif
#ifndef ERROR_CLUSTER_PARAMETER_MISMATCH
#define ERROR_CLUSTER_PARAMETER_MISMATCH 5897L
#endif
#ifndef ERROR_NODE_CANNOT_BE_CLUSTERED
#define ERROR_NODE_CANNOT_BE_CLUSTERED   5898L
#endif
#ifndef ERROR_CLUSTER_WRONG_OS_VERSION
#define ERROR_CLUSTER_WRONG_OS_VERSION   5899L
#endif
#ifndef ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME
#define ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME 5900L
#endif
#ifndef ERROR_CLUSCFG_ALREADY_COMMITTED
#define ERROR_CLUSCFG_ALREADY_COMMITTED  5901L
#endif
#ifndef ERROR_CLUSCFG_ROLLBACK_FAILED
#define ERROR_CLUSCFG_ROLLBACK_FAILED    5902L
#endif
#ifndef ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT
#define ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT 5903L
#endif
#ifndef ERROR_CLUSTER_OLD_VERSION
#define ERROR_CLUSTER_OLD_VERSION        5904L
#endif
#ifndef ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME
#define ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME 5905L
#endif
#ifndef ERROR_ENCRYPTION_FAILED
#define ERROR_ENCRYPTION_FAILED          6000L
#endif
#ifndef ERROR_DECRYPTION_FAILED
#define ERROR_DECRYPTION_FAILED          6001L
#endif
#ifndef ERROR_FILE_ENCRYPTED
#define ERROR_FILE_ENCRYPTED             6002L
#endif
#ifndef ERROR_NO_RECOVERY_POLICY
#define ERROR_NO_RECOVERY_POLICY         6003L
#endif
#ifndef ERROR_NO_EFS
#define ERROR_NO_EFS                     6004L
#endif
#ifndef ERROR_WRONG_EFS
#define ERROR_WRONG_EFS                  6005L
#endif
#ifndef ERROR_NO_USER_KEYS
#define ERROR_NO_USER_KEYS               6006L
#endif
#ifndef ERROR_FILE_NOT_ENCRYPTED
#define ERROR_FILE_NOT_ENCRYPTED         6007L
#endif
#ifndef ERROR_NOT_EXPORT_FORMAT
#define ERROR_NOT_EXPORT_FORMAT          6008L
#endif
#ifndef ERROR_FILE_READ_ONLY
#define ERROR_FILE_READ_ONLY             6009L
#endif
#ifndef ERROR_DIR_EFS_DISALLOWED
#define ERROR_DIR_EFS_DISALLOWED         6010L
#endif
#ifndef ERROR_EFS_SERVER_NOT_TRUSTED
#define ERROR_EFS_SERVER_NOT_TRUSTED     6011L
#endif
#ifndef ERROR_BAD_RECOVERY_POLICY
#define ERROR_BAD_RECOVERY_POLICY        6012L
#endif
#ifndef ERROR_EFS_ALG_BLOB_TOO_BIG
#define ERROR_EFS_ALG_BLOB_TOO_BIG       6013L
#endif
#ifndef ERROR_VOLUME_NOT_SUPPORT_EFS
#define ERROR_VOLUME_NOT_SUPPORT_EFS     6014L
#endif
#ifndef ERROR_EFS_DISABLED
#define ERROR_EFS_DISABLED               6015L
#endif
#ifndef ERROR_EFS_VERSION_NOT_SUPPORT
#define ERROR_EFS_VERSION_NOT_SUPPORT    6016L
#endif
#ifndef SCHED_E_SERVICE_NOT_LOCALSYSTEM
#define SCHED_E_SERVICE_NOT_LOCALSYSTEM  6200L
#endif
#ifndef ERROR_CTX_WINSTATION_NAME_INVALID
#define ERROR_CTX_WINSTATION_NAME_INVALID 7001L
#endif
#ifndef ERROR_CTX_INVALID_PD
#define ERROR_CTX_INVALID_PD             7002L
#endif
#ifndef ERROR_CTX_PD_NOT_FOUND
#define ERROR_CTX_PD_NOT_FOUND           7003L
#endif
#ifndef ERROR_CTX_WD_NOT_FOUND
#define ERROR_CTX_WD_NOT_FOUND           7004L
#endif
#ifndef ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY 7005L
#endif
#ifndef ERROR_CTX_SERVICE_NAME_COLLISION
#define ERROR_CTX_SERVICE_NAME_COLLISION 7006L
#endif
#ifndef ERROR_CTX_CLOSE_PENDING
#define ERROR_CTX_CLOSE_PENDING          7007L
#endif
#ifndef ERROR_CTX_NO_OUTBUF
#define ERROR_CTX_NO_OUTBUF              7008L
#endif
#ifndef ERROR_CTX_MODEM_INF_NOT_FOUND
#define ERROR_CTX_MODEM_INF_NOT_FOUND    7009L
#endif
#ifndef ERROR_CTX_INVALID_MODEMNAME
#define ERROR_CTX_INVALID_MODEMNAME      7010L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_ERROR
#define ERROR_CTX_MODEM_RESPONSE_ERROR   7011L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_TIMEOUT
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT 7012L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_NO_CARRIER
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER 7013L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE 7014L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_BUSY
#define ERROR_CTX_MODEM_RESPONSE_BUSY    7015L
#endif
#ifndef ERROR_CTX_MODEM_RESPONSE_VOICE
#define ERROR_CTX_MODEM_RESPONSE_VOICE   7016L
#endif
#ifndef ERROR_CTX_TD_ERROR
#define ERROR_CTX_TD_ERROR               7017L
#endif
#ifndef ERROR_CTX_WINSTATION_NOT_FOUND
#define ERROR_CTX_WINSTATION_NOT_FOUND   7022L
#endif
#ifndef ERROR_CTX_WINSTATION_ALREADY_EXISTS
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS 7023L
#endif
#ifndef ERROR_CTX_WINSTATION_BUSY
#define ERROR_CTX_WINSTATION_BUSY        7024L
#endif
#ifndef ERROR_CTX_BAD_VIDEO_MODE
#define ERROR_CTX_BAD_VIDEO_MODE         7025L
#endif
#ifndef ERROR_CTX_GRAPHICS_INVALID
#define ERROR_CTX_GRAPHICS_INVALID       7035L
#endif
#ifndef ERROR_CTX_LOGON_DISABLED
#define ERROR_CTX_LOGON_DISABLED         7037L
#endif
#ifndef ERROR_CTX_NOT_CONSOLE
#define ERROR_CTX_NOT_CONSOLE            7038L
#endif
#ifndef ERROR_CTX_CLIENT_QUERY_TIMEOUT
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT   7040L
#endif
#ifndef ERROR_CTX_CONSOLE_DISCONNECT
#define ERROR_CTX_CONSOLE_DISCONNECT     7041L
#endif
#ifndef ERROR_CTX_CONSOLE_CONNECT
#define ERROR_CTX_CONSOLE_CONNECT        7042L
#endif
#ifndef ERROR_CTX_SHADOW_DENIED
#define ERROR_CTX_SHADOW_DENIED          7044L
#endif
#ifndef ERROR_CTX_WINSTATION_ACCESS_DENIED
#define ERROR_CTX_WINSTATION_ACCESS_DENIED 7045L
#endif
#ifndef ERROR_CTX_INVALID_WD
#define ERROR_CTX_INVALID_WD             7049L
#endif
#ifndef ERROR_CTX_SHADOW_INVALID
#define ERROR_CTX_SHADOW_INVALID         7050L
#endif
#ifndef ERROR_CTX_SHADOW_DISABLED
#define ERROR_CTX_SHADOW_DISABLED        7051L
#endif
#ifndef ERROR_CTX_CLIENT_LICENSE_IN_USE
#define ERROR_CTX_CLIENT_LICENSE_IN_USE  7052L
#endif
#ifndef ERROR_CTX_CLIENT_LICENSE_NOT_SET
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET 7053L
#endif
#ifndef ERROR_CTX_LICENSE_NOT_AVAILABLE
#define ERROR_CTX_LICENSE_NOT_AVAILABLE  7054L
#endif
#ifndef ERROR_CTX_LICENSE_CLIENT_INVALID
#define ERROR_CTX_LICENSE_CLIENT_INVALID 7055L
#endif
#ifndef ERROR_CTX_LICENSE_EXPIRED
#define ERROR_CTX_LICENSE_EXPIRED        7056L
#endif
#ifndef ERROR_CTX_SHADOW_NOT_RUNNING
#define ERROR_CTX_SHADOW_NOT_RUNNING     7057L
#endif
#ifndef ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE 7058L
#endif
#ifndef ERROR_ACTIVATION_COUNT_EXCEEDED
#define ERROR_ACTIVATION_COUNT_EXCEEDED  7059L
#endif
#ifndef FRS_ERR_INVALID_API_SEQUENCE
#define FRS_ERR_INVALID_API_SEQUENCE     8001L
#endif
#ifndef FRS_ERR_STARTING_SERVICE
#define FRS_ERR_STARTING_SERVICE         8002L
#endif
#ifndef FRS_ERR_STOPPING_SERVICE
#define FRS_ERR_STOPPING_SERVICE         8003L
#endif
#ifndef FRS_ERR_INTERNAL_API
#define FRS_ERR_INTERNAL_API             8004L
#endif
#ifndef FRS_ERR_INTERNAL
#define FRS_ERR_INTERNAL                 8005L
#endif
#ifndef FRS_ERR_SERVICE_COMM
#define FRS_ERR_SERVICE_COMM             8006L
#endif
#ifndef FRS_ERR_INSUFFICIENT_PRIV
#define FRS_ERR_INSUFFICIENT_PRIV        8007L
#endif
#ifndef FRS_ERR_AUTHENTICATION
#define FRS_ERR_AUTHENTICATION           8008L
#endif
#ifndef FRS_ERR_PARENT_INSUFFICIENT_PRIV
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV 8009L
#endif
#ifndef FRS_ERR_PARENT_AUTHENTICATION
#define FRS_ERR_PARENT_AUTHENTICATION    8010L
#endif
#ifndef FRS_ERR_CHILD_TO_PARENT_COMM
#define FRS_ERR_CHILD_TO_PARENT_COMM     8011L
#endif
#ifndef FRS_ERR_PARENT_TO_CHILD_COMM
#define FRS_ERR_PARENT_TO_CHILD_COMM     8012L
#endif
#ifndef FRS_ERR_SYSVOL_POPULATE
#define FRS_ERR_SYSVOL_POPULATE          8013L
#endif
#ifndef FRS_ERR_SYSVOL_POPULATE_TIMEOUT
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT  8014L
#endif
#ifndef FRS_ERR_SYSVOL_IS_BUSY
#define FRS_ERR_SYSVOL_IS_BUSY           8015L
#endif
#ifndef FRS_ERR_SYSVOL_DEMOTE
#define FRS_ERR_SYSVOL_DEMOTE            8016L
#endif
#ifndef FRS_ERR_INVALID_SERVICE_PARAMETER
#define FRS_ERR_INVALID_SERVICE_PARAMETER 8017L
#endif
#ifdef ERROR_DS_NOT_INSTALLED
#   if ERROR_DS_NOT_INSTALLED == ERROR_ONLY_IF_CONNECTED
#	undef ERROR_DS_NOT_INSTALLED
#   endif
#endif
#ifndef ERROR_DS_NOT_INSTALLED
#define ERROR_DS_NOT_INSTALLED           8200L
#endif
#ifdef ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY
#   if ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY == RPC_S_ENTRY_TYPE_MISMATCH
#	undef ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY
#   endif
#endif
#ifndef ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY 8201L
#endif
#ifdef ERROR_DS_NO_ATTRIBUTE_OR_VALUE
#   if ERROR_DS_NO_ATTRIBUTE_OR_VALUE == RPC_S_NOT_ALL_OBJS_EXPORTED
#	undef ERROR_DS_NO_ATTRIBUTE_OR_VALUE
#   endif
#endif
#ifndef ERROR_DS_NO_ATTRIBUTE_OR_VALUE
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE   8202L
#endif
#ifdef ERROR_DS_INVALID_ATTRIBUTE_SYNTAX
#   if ERROR_DS_INVALID_ATTRIBUTE_SYNTAX == RPC_S_INTERFACE_NOT_EXPORTED
#	undef ERROR_DS_INVALID_ATTRIBUTE_SYNTAX
#   endif
#endif
#ifndef ERROR_DS_INVALID_ATTRIBUTE_SYNTAX
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX 8203L
#endif
#ifdef ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED
#   if ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED == RPC_S_PROFILE_NOT_ADDED
#	undef ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED
#   endif
#endif
#ifndef ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED 8204L
#endif
#ifdef ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS
#   if ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS == RPC_S_PRF_ELT_NOT_ADDED
#	undef ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS
#   endif
#endif
#ifndef ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS 8205L
#endif
#ifdef ERROR_DS_BUSY
#   if ERROR_DS_BUSY == RPC_S_PRF_ELT_NOT_REMOVED
#	undef ERROR_DS_BUSY
#   endif
#endif
#ifndef ERROR_DS_BUSY
#define ERROR_DS_BUSY                    8206L
#endif
#ifdef ERROR_DS_UNAVAILABLE
#   if ERROR_DS_UNAVAILABLE == RPC_S_GRP_ELT_NOT_ADDED
#	undef ERROR_DS_UNAVAILABLE
#   endif
#endif
#ifndef ERROR_DS_UNAVAILABLE
#define ERROR_DS_UNAVAILABLE             8207L
#endif
#ifdef ERROR_DS_NO_RIDS_ALLOCATED
#   if ERROR_DS_NO_RIDS_ALLOCATED == RPC_S_GRP_ELT_NOT_REMOVED
#	undef ERROR_DS_NO_RIDS_ALLOCATED
#   endif
#endif
#ifndef ERROR_DS_NO_RIDS_ALLOCATED
#define ERROR_DS_NO_RIDS_ALLOCATED       8208L
#endif
#ifdef ERROR_DS_NO_MORE_RIDS
#   if ERROR_DS_NO_MORE_RIDS == ERROR_KM_DRIVER_BLOCKED
#	undef ERROR_DS_NO_MORE_RIDS
#   endif
#endif
#ifndef ERROR_DS_NO_MORE_RIDS
#define ERROR_DS_NO_MORE_RIDS            8209L
#endif
#ifdef ERROR_DS_INCORRECT_ROLE_OWNER
#   if ERROR_DS_INCORRECT_ROLE_OWNER == ERROR_CONTEXT_EXPIRED
#	undef ERROR_DS_INCORRECT_ROLE_OWNER
#   endif
#endif
#ifndef ERROR_DS_INCORRECT_ROLE_OWNER
#define ERROR_DS_INCORRECT_ROLE_OWNER    8210L
#endif
#ifdef ERROR_DS_RIDMGR_INIT_ERROR
#   if ERROR_DS_RIDMGR_INIT_ERROR == ERROR_PER_USER_TRUST_QUOTA_EXCEEDED
#	undef ERROR_DS_RIDMGR_INIT_ERROR
#   endif
#endif
#ifndef ERROR_DS_RIDMGR_INIT_ERROR
#define ERROR_DS_RIDMGR_INIT_ERROR       8211L
#endif
#ifdef ERROR_DS_OBJ_CLASS_VIOLATION
#   if ERROR_DS_OBJ_CLASS_VIOLATION == ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED
#	undef ERROR_DS_OBJ_CLASS_VIOLATION
#   endif
#endif
#ifndef ERROR_DS_OBJ_CLASS_VIOLATION
#define ERROR_DS_OBJ_CLASS_VIOLATION     8212L
#endif
#ifdef ERROR_DS_CANT_ON_NON_LEAF
#   if ERROR_DS_CANT_ON_NON_LEAF == ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED
#	undef ERROR_DS_CANT_ON_NON_LEAF
#   endif
#endif
#ifndef ERROR_DS_CANT_ON_NON_LEAF
#define ERROR_DS_CANT_ON_NON_LEAF        8213L
#endif
#ifdef ERROR_DS_CANT_ON_RDN
#   if ERROR_DS_CANT_ON_RDN == ERROR_AUTHENTICATION_FIREWALL_FAILED
#	undef ERROR_DS_CANT_ON_RDN
#   endif
#endif
#ifndef ERROR_DS_CANT_ON_RDN
#define ERROR_DS_CANT_ON_RDN             8214L
#endif
#ifdef ERROR_DS_CANT_MOD_OBJ_CLASS
#   if ERROR_DS_CANT_MOD_OBJ_CLASS == ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED
#	undef ERROR_DS_CANT_MOD_OBJ_CLASS
#   endif
#endif
#ifndef ERROR_DS_CANT_MOD_OBJ_CLASS
#define ERROR_DS_CANT_MOD_OBJ_CLASS      8215L
#endif
#ifdef ERROR_DS_CROSS_DOM_MOVE_ERROR
#   if ERROR_DS_CROSS_DOM_MOVE_ERROR == 1937L
#	undef ERROR_DS_CROSS_DOM_MOVE_ERROR
#   endif
#endif
#ifndef ERROR_DS_CROSS_DOM_MOVE_ERROR
#define ERROR_DS_CROSS_DOM_MOVE_ERROR    8216L
#endif
#ifdef ERROR_DS_GC_NOT_AVAILABLE
#   if ERROR_DS_GC_NOT_AVAILABLE == 1938L
#	undef ERROR_DS_GC_NOT_AVAILABLE
#   endif
#endif
#ifndef ERROR_DS_GC_NOT_AVAILABLE
#define ERROR_DS_GC_NOT_AVAILABLE        8217L
#endif
#ifndef ERROR_SHARED_POLICY
#define ERROR_SHARED_POLICY              8218L
#endif
#ifndef ERROR_POLICY_OBJECT_NOT_FOUND
#define ERROR_POLICY_OBJECT_NOT_FOUND    8219L
#endif
#ifndef ERROR_POLICY_ONLY_IN_DS
#define ERROR_POLICY_ONLY_IN_DS          8220L
#endif
#ifndef ERROR_PROMOTION_ACTIVE
#define ERROR_PROMOTION_ACTIVE           8221L
#endif
#ifndef ERROR_NO_PROMOTION_ACTIVE
#define ERROR_NO_PROMOTION_ACTIVE        8222L
#endif
#ifndef ERROR_DS_OPERATIONS_ERROR
#define ERROR_DS_OPERATIONS_ERROR        8224L
#endif
#ifndef ERROR_DS_PROTOCOL_ERROR
#define ERROR_DS_PROTOCOL_ERROR          8225L
#endif
#ifndef ERROR_DS_TIMELIMIT_EXCEEDED
#define ERROR_DS_TIMELIMIT_EXCEEDED      8226L
#endif
#ifndef ERROR_DS_SIZELIMIT_EXCEEDED
#define ERROR_DS_SIZELIMIT_EXCEEDED      8227L
#endif
#ifndef ERROR_DS_ADMIN_LIMIT_EXCEEDED
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED    8228L
#endif
#ifndef ERROR_DS_COMPARE_FALSE
#define ERROR_DS_COMPARE_FALSE           8229L
#endif
#ifndef ERROR_DS_COMPARE_TRUE
#define ERROR_DS_COMPARE_TRUE            8230L
#endif
#ifndef ERROR_DS_AUTH_METHOD_NOT_SUPPORTED
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED 8231L
#endif
#ifndef ERROR_DS_STRONG_AUTH_REQUIRED
#define ERROR_DS_STRONG_AUTH_REQUIRED    8232L
#endif
#ifndef ERROR_DS_INAPPROPRIATE_AUTH
#define ERROR_DS_INAPPROPRIATE_AUTH      8233L
#endif
#ifndef ERROR_DS_AUTH_UNKNOWN
#define ERROR_DS_AUTH_UNKNOWN            8234L
#endif
#ifndef ERROR_DS_REFERRAL
#define ERROR_DS_REFERRAL                8235L
#endif
#ifndef ERROR_DS_UNAVAILABLE_CRIT_EXTENSION
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION 8236L
#endif
#ifndef ERROR_DS_CONFIDENTIALITY_REQUIRED
#define ERROR_DS_CONFIDENTIALITY_REQUIRED 8237L
#endif
#ifndef ERROR_DS_INAPPROPRIATE_MATCHING
#define ERROR_DS_INAPPROPRIATE_MATCHING  8238L
#endif
#ifndef ERROR_DS_CONSTRAINT_VIOLATION
#define ERROR_DS_CONSTRAINT_VIOLATION    8239L
#endif
#ifndef ERROR_DS_NO_SUCH_OBJECT
#define ERROR_DS_NO_SUCH_OBJECT          8240L
#endif
#ifndef ERROR_DS_ALIAS_PROBLEM
#define ERROR_DS_ALIAS_PROBLEM           8241L
#endif
#ifndef ERROR_DS_INVALID_DN_SYNTAX
#define ERROR_DS_INVALID_DN_SYNTAX       8242L
#endif
#ifndef ERROR_DS_IS_LEAF
#define ERROR_DS_IS_LEAF                 8243L
#endif
#ifndef ERROR_DS_ALIAS_DEREF_PROBLEM
#define ERROR_DS_ALIAS_DEREF_PROBLEM     8244L
#endif
#ifndef ERROR_DS_UNWILLING_TO_PERFORM
#define ERROR_DS_UNWILLING_TO_PERFORM    8245L
#endif
#ifndef ERROR_DS_LOOP_DETECT
#define ERROR_DS_LOOP_DETECT             8246L
#endif
#ifndef ERROR_DS_NAMING_VIOLATION
#define ERROR_DS_NAMING_VIOLATION        8247L
#endif
#ifndef ERROR_DS_OBJECT_RESULTS_TOO_LARGE
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE 8248L
#endif
#ifndef ERROR_DS_AFFECTS_MULTIPLE_DSAS
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS   8249L
#endif
#ifndef ERROR_DS_SERVER_DOWN
#define ERROR_DS_SERVER_DOWN             8250L
#endif
#ifndef ERROR_DS_LOCAL_ERROR
#define ERROR_DS_LOCAL_ERROR             8251L
#endif
#ifndef ERROR_DS_ENCODING_ERROR
#define ERROR_DS_ENCODING_ERROR          8252L
#endif
#ifndef ERROR_DS_DECODING_ERROR
#define ERROR_DS_DECODING_ERROR          8253L
#endif
#ifndef ERROR_DS_FILTER_UNKNOWN
#define ERROR_DS_FILTER_UNKNOWN          8254L
#endif
#ifndef ERROR_DS_PARAM_ERROR
#define ERROR_DS_PARAM_ERROR             8255L
#endif
#ifndef ERROR_DS_NOT_SUPPORTED
#define ERROR_DS_NOT_SUPPORTED           8256L
#endif
#ifndef ERROR_DS_NO_RESULTS_RETURNED
#define ERROR_DS_NO_RESULTS_RETURNED     8257L
#endif
#ifndef ERROR_DS_CONTROL_NOT_FOUND
#define ERROR_DS_CONTROL_NOT_FOUND       8258L
#endif
#ifndef ERROR_DS_CLIENT_LOOP
#define ERROR_DS_CLIENT_LOOP             8259L
#endif
#ifndef ERROR_DS_REFERRAL_LIMIT_EXCEEDED
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED 8260L
#endif
#ifndef ERROR_DS_SORT_CONTROL_MISSING
#define ERROR_DS_SORT_CONTROL_MISSING    8261L
#endif
#ifndef ERROR_DS_OFFSET_RANGE_ERROR
#define ERROR_DS_OFFSET_RANGE_ERROR      8262L
#endif
#ifndef ERROR_DS_ROOT_MUST_BE_NC
#define ERROR_DS_ROOT_MUST_BE_NC         8301L
#endif
#ifndef ERROR_DS_ADD_REPLICA_INHIBITED
#define ERROR_DS_ADD_REPLICA_INHIBITED   8302L
#endif
#ifndef ERROR_DS_ATT_NOT_DEF_IN_SCHEMA
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA   8303L
#endif
#ifndef ERROR_DS_MAX_OBJ_SIZE_EXCEEDED
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED   8304L
#endif
#ifndef ERROR_DS_OBJ_STRING_NAME_EXISTS
#define ERROR_DS_OBJ_STRING_NAME_EXISTS  8305L
#endif
#ifndef ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA 8306L
#endif
#ifndef ERROR_DS_RDN_DOESNT_MATCH_SCHEMA
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA 8307L
#endif
#ifndef ERROR_DS_NO_REQUESTED_ATTS_FOUND
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND 8308L
#endif
#ifndef ERROR_DS_USER_BUFFER_TO_SMALL
#define ERROR_DS_USER_BUFFER_TO_SMALL    8309L
#endif
#ifndef ERROR_DS_ATT_IS_NOT_ON_OBJ
#define ERROR_DS_ATT_IS_NOT_ON_OBJ       8310L
#endif
#ifndef ERROR_DS_ILLEGAL_MOD_OPERATION
#define ERROR_DS_ILLEGAL_MOD_OPERATION   8311L
#endif
#ifndef ERROR_DS_OBJ_TOO_LARGE
#define ERROR_DS_OBJ_TOO_LARGE           8312L
#endif
#ifndef ERROR_DS_BAD_INSTANCE_TYPE
#define ERROR_DS_BAD_INSTANCE_TYPE       8313L
#endif
#ifndef ERROR_DS_MASTERDSA_REQUIRED
#define ERROR_DS_MASTERDSA_REQUIRED      8314L
#endif
#ifndef ERROR_DS_OBJECT_CLASS_REQUIRED
#define ERROR_DS_OBJECT_CLASS_REQUIRED   8315L
#endif
#ifndef ERROR_DS_MISSING_REQUIRED_ATT
#define ERROR_DS_MISSING_REQUIRED_ATT    8316L
#endif
#ifndef ERROR_DS_ATT_NOT_DEF_FOR_CLASS
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS   8317L
#endif
#ifndef ERROR_DS_ATT_ALREADY_EXISTS
#define ERROR_DS_ATT_ALREADY_EXISTS      8318L
#endif
#ifndef ERROR_DS_CANT_ADD_ATT_VALUES
#define ERROR_DS_CANT_ADD_ATT_VALUES     8320L
#endif
#ifndef ERROR_DS_SINGLE_VALUE_CONSTRAINT
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT 8321L
#endif
#ifndef ERROR_DS_RANGE_CONSTRAINT
#define ERROR_DS_RANGE_CONSTRAINT        8322L
#endif
#ifndef ERROR_DS_ATT_VAL_ALREADY_EXISTS
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS  8323L
#endif
#ifndef ERROR_DS_CANT_REM_MISSING_ATT
#define ERROR_DS_CANT_REM_MISSING_ATT    8324L
#endif
#ifndef ERROR_DS_CANT_REM_MISSING_ATT_VAL
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL 8325L
#endif
#ifndef ERROR_DS_ROOT_CANT_BE_SUBREF
#define ERROR_DS_ROOT_CANT_BE_SUBREF     8326L
#endif
#ifndef ERROR_DS_NO_CHAINING
#define ERROR_DS_NO_CHAINING             8327L
#endif
#ifndef ERROR_DS_NO_CHAINED_EVAL
#define ERROR_DS_NO_CHAINED_EVAL         8328L
#endif
#ifndef ERROR_DS_NO_PARENT_OBJECT
#define ERROR_DS_NO_PARENT_OBJECT        8329L
#endif
#ifndef ERROR_DS_PARENT_IS_AN_ALIAS
#define ERROR_DS_PARENT_IS_AN_ALIAS      8330L
#endif
#ifndef ERROR_DS_CANT_MIX_MASTER_AND_REPS
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS 8331L
#endif
#ifndef ERROR_DS_CHILDREN_EXIST
#define ERROR_DS_CHILDREN_EXIST          8332L
#endif
#ifndef ERROR_DS_OBJ_NOT_FOUND
#define ERROR_DS_OBJ_NOT_FOUND           8333L
#endif
#ifndef ERROR_DS_ALIASED_OBJ_MISSING
#define ERROR_DS_ALIASED_OBJ_MISSING     8334L
#endif
#ifndef ERROR_DS_BAD_NAME_SYNTAX
#define ERROR_DS_BAD_NAME_SYNTAX         8335L
#endif
#ifndef ERROR_DS_ALIAS_POINTS_TO_ALIAS
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS   8336L
#endif
#ifndef ERROR_DS_CANT_DEREF_ALIAS
#define ERROR_DS_CANT_DEREF_ALIAS        8337L
#endif
#ifndef ERROR_DS_OUT_OF_SCOPE
#define ERROR_DS_OUT_OF_SCOPE            8338L
#endif
#ifndef ERROR_DS_OBJECT_BEING_REMOVED
#define ERROR_DS_OBJECT_BEING_REMOVED    8339L
#endif
#ifndef ERROR_DS_CANT_DELETE_DSA_OBJ
#define ERROR_DS_CANT_DELETE_DSA_OBJ     8340L
#endif
#ifndef ERROR_DS_GENERIC_ERROR
#define ERROR_DS_GENERIC_ERROR           8341L
#endif
#ifndef ERROR_DS_DSA_MUST_BE_INT_MASTER
#define ERROR_DS_DSA_MUST_BE_INT_MASTER  8342L
#endif
#ifndef ERROR_DS_CLASS_NOT_DSA
#define ERROR_DS_CLASS_NOT_DSA           8343L
#endif
#ifndef ERROR_DS_INSUFF_ACCESS_RIGHTS
#define ERROR_DS_INSUFF_ACCESS_RIGHTS    8344L
#endif
#ifndef ERROR_DS_ILLEGAL_SUPERIOR
#define ERROR_DS_ILLEGAL_SUPERIOR        8345L
#endif
#ifndef ERROR_DS_ATTRIBUTE_OWNED_BY_SAM
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM  8346L
#endif
#ifndef ERROR_DS_NAME_TOO_MANY_PARTS
#define ERROR_DS_NAME_TOO_MANY_PARTS     8347L
#endif
#ifndef ERROR_DS_NAME_TOO_LONG
#define ERROR_DS_NAME_TOO_LONG           8348L
#endif
#ifndef ERROR_DS_NAME_VALUE_TOO_LONG
#define ERROR_DS_NAME_VALUE_TOO_LONG     8349L
#endif
#ifndef ERROR_DS_NAME_UNPARSEABLE
#define ERROR_DS_NAME_UNPARSEABLE        8350L
#endif
#ifndef ERROR_DS_NAME_TYPE_UNKNOWN
#define ERROR_DS_NAME_TYPE_UNKNOWN       8351L
#endif
#ifndef ERROR_DS_NOT_AN_OBJECT
#define ERROR_DS_NOT_AN_OBJECT           8352L
#endif
#ifndef ERROR_DS_SEC_DESC_TOO_SHORT
#define ERROR_DS_SEC_DESC_TOO_SHORT      8353L
#endif
#ifndef ERROR_DS_SEC_DESC_INVALID
#define ERROR_DS_SEC_DESC_INVALID        8354L
#endif
#ifndef ERROR_DS_NO_DELETED_NAME
#define ERROR_DS_NO_DELETED_NAME         8355L
#endif
#ifndef ERROR_DS_SUBREF_MUST_HAVE_PARENT
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT 8356L
#endif
#ifndef ERROR_DS_NCNAME_MUST_BE_NC
#define ERROR_DS_NCNAME_MUST_BE_NC       8357L
#endif
#ifndef ERROR_DS_CANT_ADD_SYSTEM_ONLY
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY    8358L
#endif
#ifndef ERROR_DS_CLASS_MUST_BE_CONCRETE
#define ERROR_DS_CLASS_MUST_BE_CONCRETE  8359L
#endif
#ifndef ERROR_DS_INVALID_DMD
#define ERROR_DS_INVALID_DMD             8360L
#endif
#ifndef ERROR_DS_OBJ_GUID_EXISTS
#define ERROR_DS_OBJ_GUID_EXISTS         8361L
#endif
#ifndef ERROR_DS_NOT_ON_BACKLINK
#define ERROR_DS_NOT_ON_BACKLINK         8362L
#endif
#ifndef ERROR_DS_NO_CROSSREF_FOR_NC
#define ERROR_DS_NO_CROSSREF_FOR_NC      8363L
#endif
#ifndef ERROR_DS_SHUTTING_DOWN
#define ERROR_DS_SHUTTING_DOWN           8364L
#endif
#ifndef ERROR_DS_UNKNOWN_OPERATION
#define ERROR_DS_UNKNOWN_OPERATION       8365L
#endif
#ifndef ERROR_DS_INVALID_ROLE_OWNER
#define ERROR_DS_INVALID_ROLE_OWNER      8366L
#endif
#ifndef ERROR_DS_COULDNT_CONTACT_FSMO
#define ERROR_DS_COULDNT_CONTACT_FSMO    8367L
#endif
#ifndef ERROR_DS_CROSS_NC_DN_RENAME
#define ERROR_DS_CROSS_NC_DN_RENAME      8368L
#endif
#ifndef ERROR_DS_CANT_MOD_SYSTEM_ONLY
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY    8369L
#endif
#ifndef ERROR_DS_REPLICATOR_ONLY
#define ERROR_DS_REPLICATOR_ONLY         8370L
#endif
#ifndef ERROR_DS_OBJ_CLASS_NOT_DEFINED
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED   8371L
#endif
#ifndef ERROR_DS_OBJ_CLASS_NOT_SUBCLASS
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS  8372L
#endif
#ifndef ERROR_DS_NAME_REFERENCE_INVALID
#define ERROR_DS_NAME_REFERENCE_INVALID  8373L
#endif
#ifndef ERROR_DS_CROSS_REF_EXISTS
#define ERROR_DS_CROSS_REF_EXISTS        8374L
#endif
#ifndef ERROR_DS_CANT_DEL_MASTER_CROSSREF
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF 8375L
#endif
#ifndef ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD 8376L
#endif
#ifndef ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX 8377L
#endif
#ifndef ERROR_DS_DUP_RDN
#define ERROR_DS_DUP_RDN                 8378L
#endif
#ifndef ERROR_DS_DUP_OID
#define ERROR_DS_DUP_OID                 8379L
#endif
#ifndef ERROR_DS_DUP_MAPI_ID
#define ERROR_DS_DUP_MAPI_ID             8380L
#endif
#ifndef ERROR_DS_DUP_SCHEMA_ID_GUID
#define ERROR_DS_DUP_SCHEMA_ID_GUID      8381L
#endif
#ifndef ERROR_DS_DUP_LDAP_DISPLAY_NAME
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME   8382L
#endif
#ifndef ERROR_DS_SEMANTIC_ATT_TEST
#define ERROR_DS_SEMANTIC_ATT_TEST       8383L
#endif
#ifndef ERROR_DS_SYNTAX_MISMATCH
#define ERROR_DS_SYNTAX_MISMATCH         8384L
#endif
#ifndef ERROR_DS_EXISTS_IN_MUST_HAVE
#define ERROR_DS_EXISTS_IN_MUST_HAVE     8385L
#endif
#ifndef ERROR_DS_EXISTS_IN_MAY_HAVE
#define ERROR_DS_EXISTS_IN_MAY_HAVE      8386L
#endif
#ifndef ERROR_DS_NONEXISTENT_MAY_HAVE
#define ERROR_DS_NONEXISTENT_MAY_HAVE    8387L
#endif
#ifndef ERROR_DS_NONEXISTENT_MUST_HAVE
#define ERROR_DS_NONEXISTENT_MUST_HAVE   8388L
#endif
#ifndef ERROR_DS_AUX_CLS_TEST_FAIL
#define ERROR_DS_AUX_CLS_TEST_FAIL       8389L
#endif
#ifndef ERROR_DS_NONEXISTENT_POSS_SUP
#define ERROR_DS_NONEXISTENT_POSS_SUP    8390L
#endif
#ifndef ERROR_DS_SUB_CLS_TEST_FAIL
#define ERROR_DS_SUB_CLS_TEST_FAIL       8391L
#endif
#ifndef ERROR_DS_BAD_RDN_ATT_ID_SYNTAX
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX   8392L
#endif
#ifndef ERROR_DS_EXISTS_IN_AUX_CLS
#define ERROR_DS_EXISTS_IN_AUX_CLS       8393L
#endif
#ifndef ERROR_DS_EXISTS_IN_SUB_CLS
#define ERROR_DS_EXISTS_IN_SUB_CLS       8394L
#endif
#ifndef ERROR_DS_EXISTS_IN_POSS_SUP
#define ERROR_DS_EXISTS_IN_POSS_SUP      8395L
#endif
#ifndef ERROR_DS_RECALCSCHEMA_FAILED
#define ERROR_DS_RECALCSCHEMA_FAILED     8396L
#endif
#ifndef ERROR_DS_TREE_DELETE_NOT_FINISHED
#define ERROR_DS_TREE_DELETE_NOT_FINISHED 8397L
#endif
#ifndef ERROR_DS_CANT_DELETE
#define ERROR_DS_CANT_DELETE             8398L
#endif
#ifndef ERROR_DS_ATT_SCHEMA_REQ_ID
#define ERROR_DS_ATT_SCHEMA_REQ_ID       8399L
#endif
#ifndef ERROR_DS_BAD_ATT_SCHEMA_SYNTAX
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX   8400L
#endif
#ifndef ERROR_DS_CANT_CACHE_ATT
#define ERROR_DS_CANT_CACHE_ATT          8401L
#endif
#ifndef ERROR_DS_CANT_CACHE_CLASS
#define ERROR_DS_CANT_CACHE_CLASS        8402L
#endif
#ifndef ERROR_DS_CANT_REMOVE_ATT_CACHE
#define ERROR_DS_CANT_REMOVE_ATT_CACHE   8403L
#endif
#ifndef ERROR_DS_CANT_REMOVE_CLASS_CACHE
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE 8404L
#endif
#ifndef ERROR_DS_CANT_RETRIEVE_DN
#define ERROR_DS_CANT_RETRIEVE_DN        8405L
#endif
#ifndef ERROR_DS_MISSING_SUPREF
#define ERROR_DS_MISSING_SUPREF          8406L
#endif
#ifndef ERROR_DS_CANT_RETRIEVE_INSTANCE
#define ERROR_DS_CANT_RETRIEVE_INSTANCE  8407L
#endif
#ifndef ERROR_DS_CODE_INCONSISTENCY
#define ERROR_DS_CODE_INCONSISTENCY      8408L
#endif
#ifndef ERROR_DS_DATABASE_ERROR
#define ERROR_DS_DATABASE_ERROR          8409L
#endif
#ifndef ERROR_DS_GOVERNSID_MISSING
#define ERROR_DS_GOVERNSID_MISSING       8410L
#endif
#ifndef ERROR_DS_MISSING_EXPECTED_ATT
#define ERROR_DS_MISSING_EXPECTED_ATT    8411L
#endif
#ifndef ERROR_DS_NCNAME_MISSING_CR_REF
#define ERROR_DS_NCNAME_MISSING_CR_REF   8412L
#endif
#ifndef ERROR_DS_SECURITY_CHECKING_ERROR
#define ERROR_DS_SECURITY_CHECKING_ERROR 8413L
#endif
#ifndef ERROR_DS_SCHEMA_NOT_LOADED
#define ERROR_DS_SCHEMA_NOT_LOADED       8414L
#endif
#ifndef ERROR_DS_SCHEMA_ALLOC_FAILED
#define ERROR_DS_SCHEMA_ALLOC_FAILED     8415L
#endif
#ifndef ERROR_DS_ATT_SCHEMA_REQ_SYNTAX
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX   8416L
#endif
#ifndef ERROR_DS_GCVERIFY_ERROR
#define ERROR_DS_GCVERIFY_ERROR          8417L
#endif
#ifndef ERROR_DS_DRA_SCHEMA_MISMATCH
#define ERROR_DS_DRA_SCHEMA_MISMATCH     8418L
#endif
#ifndef ERROR_DS_CANT_FIND_DSA_OBJ
#define ERROR_DS_CANT_FIND_DSA_OBJ       8419L
#endif
#ifndef ERROR_DS_CANT_FIND_EXPECTED_NC
#define ERROR_DS_CANT_FIND_EXPECTED_NC   8420L
#endif
#ifndef ERROR_DS_CANT_FIND_NC_IN_CACHE
#define ERROR_DS_CANT_FIND_NC_IN_CACHE   8421L
#endif
#ifndef ERROR_DS_CANT_RETRIEVE_CHILD
#define ERROR_DS_CANT_RETRIEVE_CHILD     8422L
#endif
#ifndef ERROR_DS_SECURITY_ILLEGAL_MODIFY
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY 8423L
#endif
#ifndef ERROR_DS_CANT_REPLACE_HIDDEN_REC
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC 8424L
#endif
#ifndef ERROR_DS_BAD_HIERARCHY_FILE
#define ERROR_DS_BAD_HIERARCHY_FILE      8425L
#endif
#ifndef ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED 8426L
#endif
#ifndef ERROR_DS_CONFIG_PARAM_MISSING
#define ERROR_DS_CONFIG_PARAM_MISSING    8427L
#endif
#ifndef ERROR_DS_COUNTING_AB_INDICES_FAILED
#define ERROR_DS_COUNTING_AB_INDICES_FAILED 8428L
#endif
#ifndef ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED 8429L
#endif
#ifndef ERROR_DS_INTERNAL_FAILURE
#define ERROR_DS_INTERNAL_FAILURE        8430L
#endif
#ifndef ERROR_DS_UNKNOWN_ERROR
#define ERROR_DS_UNKNOWN_ERROR           8431L
#endif
#ifndef ERROR_DS_ROOT_REQUIRES_CLASS_TOP
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP 8432L
#endif
#ifndef ERROR_DS_REFUSING_FSMO_ROLES
#define ERROR_DS_REFUSING_FSMO_ROLES     8433L
#endif
#ifndef ERROR_DS_MISSING_FSMO_SETTINGS
#define ERROR_DS_MISSING_FSMO_SETTINGS   8434L
#endif
#ifndef ERROR_DS_UNABLE_TO_SURRENDER_ROLES
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES 8435L
#endif
#ifndef ERROR_DS_DRA_GENERIC
#define ERROR_DS_DRA_GENERIC             8436L
#endif
#ifndef ERROR_DS_DRA_INVALID_PARAMETER
#define ERROR_DS_DRA_INVALID_PARAMETER   8437L
#endif
#ifndef ERROR_DS_DRA_BUSY
#define ERROR_DS_DRA_BUSY                8438L
#endif
#ifndef ERROR_DS_DRA_BAD_DN
#define ERROR_DS_DRA_BAD_DN              8439L
#endif
#ifndef ERROR_DS_DRA_BAD_NC
#define ERROR_DS_DRA_BAD_NC              8440L
#endif
#ifndef ERROR_DS_DRA_DN_EXISTS
#define ERROR_DS_DRA_DN_EXISTS           8441L
#endif
#ifndef ERROR_DS_DRA_INTERNAL_ERROR
#define ERROR_DS_DRA_INTERNAL_ERROR      8442L
#endif
#ifndef ERROR_DS_DRA_INCONSISTENT_DIT
#define ERROR_DS_DRA_INCONSISTENT_DIT    8443L
#endif
#ifndef ERROR_DS_DRA_CONNECTION_FAILED
#define ERROR_DS_DRA_CONNECTION_FAILED   8444L
#endif
#ifndef ERROR_DS_DRA_BAD_INSTANCE_TYPE
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE   8445L
#endif
#ifndef ERROR_DS_DRA_OUT_OF_MEM
#define ERROR_DS_DRA_OUT_OF_MEM          8446L
#endif
#ifndef ERROR_DS_DRA_MAIL_PROBLEM
#define ERROR_DS_DRA_MAIL_PROBLEM        8447L
#endif
#ifndef ERROR_DS_DRA_REF_ALREADY_EXISTS
#define ERROR_DS_DRA_REF_ALREADY_EXISTS  8448L
#endif
#ifndef ERROR_DS_DRA_REF_NOT_FOUND
#define ERROR_DS_DRA_REF_NOT_FOUND       8449L
#endif
#ifndef ERROR_DS_DRA_OBJ_IS_REP_SOURCE
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE   8450L
#endif
#ifndef ERROR_DS_DRA_DB_ERROR
#define ERROR_DS_DRA_DB_ERROR            8451L
#endif
#ifndef ERROR_DS_DRA_NO_REPLICA
#define ERROR_DS_DRA_NO_REPLICA          8452L
#endif
#ifndef ERROR_DS_DRA_ACCESS_DENIED
#define ERROR_DS_DRA_ACCESS_DENIED       8453L
#endif
#ifndef ERROR_DS_DRA_NOT_SUPPORTED
#define ERROR_DS_DRA_NOT_SUPPORTED       8454L
#endif
#ifndef ERROR_DS_DRA_RPC_CANCELLED
#define ERROR_DS_DRA_RPC_CANCELLED       8455L
#endif
#ifndef ERROR_DS_DRA_SOURCE_DISABLED
#define ERROR_DS_DRA_SOURCE_DISABLED     8456L
#endif
#ifndef ERROR_DS_DRA_SINK_DISABLED
#define ERROR_DS_DRA_SINK_DISABLED       8457L
#endif
#ifndef ERROR_DS_DRA_NAME_COLLISION
#define ERROR_DS_DRA_NAME_COLLISION      8458L
#endif
#ifndef ERROR_DS_DRA_SOURCE_REINSTALLED
#define ERROR_DS_DRA_SOURCE_REINSTALLED  8459L
#endif
#ifndef ERROR_DS_DRA_MISSING_PARENT
#define ERROR_DS_DRA_MISSING_PARENT      8460L
#endif
#ifndef ERROR_DS_DRA_PREEMPTED
#define ERROR_DS_DRA_PREEMPTED           8461L
#endif
#ifndef ERROR_DS_DRA_ABANDON_SYNC
#define ERROR_DS_DRA_ABANDON_SYNC        8462L
#endif
#ifndef ERROR_DS_DRA_SHUTDOWN
#define ERROR_DS_DRA_SHUTDOWN            8463L
#endif
#ifndef ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET 8464L
#endif
#ifndef ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA 8465L
#endif
#ifndef ERROR_DS_DRA_EXTN_CONNECTION_FAILED
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED 8466L
#endif
#ifndef ERROR_DS_INSTALL_SCHEMA_MISMATCH
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH 8467L
#endif
#ifndef ERROR_DS_DUP_LINK_ID
#define ERROR_DS_DUP_LINK_ID             8468L
#endif
#ifndef ERROR_DS_NAME_ERROR_RESOLVING
#define ERROR_DS_NAME_ERROR_RESOLVING    8469L
#endif
#ifndef ERROR_DS_NAME_ERROR_NOT_FOUND
#define ERROR_DS_NAME_ERROR_NOT_FOUND    8470L
#endif
#ifndef ERROR_DS_NAME_ERROR_NOT_UNIQUE
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE   8471L
#endif
#ifndef ERROR_DS_NAME_ERROR_NO_MAPPING
#define ERROR_DS_NAME_ERROR_NO_MAPPING   8472L
#endif
#ifndef ERROR_DS_NAME_ERROR_DOMAIN_ONLY
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY  8473L
#endif
#ifndef ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING 8474L
#endif
#ifndef ERROR_DS_CONSTRUCTED_ATT_MOD
#define ERROR_DS_CONSTRUCTED_ATT_MOD     8475L
#endif
#ifndef ERROR_DS_WRONG_OM_OBJ_CLASS
#define ERROR_DS_WRONG_OM_OBJ_CLASS      8476L
#endif
#ifndef ERROR_DS_DRA_REPL_PENDING
#define ERROR_DS_DRA_REPL_PENDING        8477L
#endif
#ifndef ERROR_DS_DS_REQUIRED
#define ERROR_DS_DS_REQUIRED             8478L
#endif
#ifndef ERROR_DS_INVALID_LDAP_DISPLAY_NAME
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME 8479L
#endif
#ifndef ERROR_DS_NON_BASE_SEARCH
#define ERROR_DS_NON_BASE_SEARCH         8480L
#endif
#ifndef ERROR_DS_CANT_RETRIEVE_ATTS
#define ERROR_DS_CANT_RETRIEVE_ATTS      8481L
#endif
#ifndef ERROR_DS_BACKLINK_WITHOUT_LINK
#define ERROR_DS_BACKLINK_WITHOUT_LINK   8482L
#endif
#ifndef ERROR_DS_EPOCH_MISMATCH
#define ERROR_DS_EPOCH_MISMATCH          8483L
#endif
#ifndef ERROR_DS_SRC_NAME_MISMATCH
#define ERROR_DS_SRC_NAME_MISMATCH       8484L
#endif
#ifndef ERROR_DS_SRC_AND_DST_NC_IDENTICAL
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL 8485L
#endif
#ifndef ERROR_DS_DST_NC_MISMATCH
#define ERROR_DS_DST_NC_MISMATCH         8486L
#endif
#ifndef ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC 8487L
#endif
#ifndef ERROR_DS_SRC_GUID_MISMATCH
#define ERROR_DS_SRC_GUID_MISMATCH       8488L
#endif
#ifndef ERROR_DS_CANT_MOVE_DELETED_OBJECT
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT 8489L
#endif
#ifndef ERROR_DS_PDC_OPERATION_IN_PROGRESS
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS 8490L
#endif
#ifndef ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD 8491L
#endif
#ifndef ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION 8492L
#endif
#ifndef ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS 8493L
#endif
#ifndef ERROR_DS_NC_MUST_HAVE_NC_PARENT
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT  8494L
#endif
#ifndef ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE 8495L
#endif
#ifndef ERROR_DS_DST_DOMAIN_NOT_NATIVE
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE   8496L
#endif
#ifndef ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER 8497L
#endif
#ifndef ERROR_DS_CANT_MOVE_ACCOUNT_GROUP
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP 8498L
#endif
#ifndef ERROR_DS_CANT_MOVE_RESOURCE_GROUP
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP 8499L
#endif
#ifndef ERROR_DS_INVALID_SEARCH_FLAG
#define ERROR_DS_INVALID_SEARCH_FLAG     8500L
#endif
#ifndef ERROR_DS_NO_TREE_DELETE_ABOVE_NC
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC 8501L
#endif
#ifndef ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE 8502L
#endif
#ifndef ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE 8503L
#endif
#ifndef ERROR_DS_SAM_INIT_FAILURE
#define ERROR_DS_SAM_INIT_FAILURE        8504L
#endif
#ifndef ERROR_DS_SENSITIVE_GROUP_VIOLATION
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION 8505L
#endif
#ifndef ERROR_DS_CANT_MOD_PRIMARYGROUPID
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID 8506L
#endif
#ifndef ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD 8507L
#endif
#ifndef ERROR_DS_NONSAFE_SCHEMA_CHANGE
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE   8508L
#endif
#ifndef ERROR_DS_SCHEMA_UPDATE_DISALLOWED
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED 8509L
#endif
#ifndef ERROR_DS_CANT_CREATE_UNDER_SCHEMA
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA 8510L
#endif
#ifndef ERROR_DS_INSTALL_NO_SRC_SCH_VERSION
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION 8511L
#endif
#ifndef ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE 8512L
#endif
#ifndef ERROR_DS_INVALID_GROUP_TYPE
#define ERROR_DS_INVALID_GROUP_TYPE      8513L
#endif
#ifndef ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN 8514L
#endif
#ifndef ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN 8515L
#endif
#ifndef ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER 8516L
#endif
#ifndef ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER 8517L
#endif
#ifndef ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER 8518L
#endif
#ifndef ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER 8519L
#endif
#ifndef ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER 8520L
#endif
#ifndef ERROR_DS_HAVE_PRIMARY_MEMBERS
#define ERROR_DS_HAVE_PRIMARY_MEMBERS    8521L
#endif
#ifndef ERROR_DS_STRING_SD_CONVERSION_FAILED
#define ERROR_DS_STRING_SD_CONVERSION_FAILED 8522L
#endif
#ifndef ERROR_DS_NAMING_MASTER_GC
#define ERROR_DS_NAMING_MASTER_GC        8523L
#endif
#ifndef ERROR_DS_DNS_LOOKUP_FAILURE
#define ERROR_DS_DNS_LOOKUP_FAILURE      8524L
#endif
#ifndef ERROR_DS_COULDNT_UPDATE_SPNS
#define ERROR_DS_COULDNT_UPDATE_SPNS     8525L
#endif
#ifndef ERROR_DS_CANT_RETRIEVE_SD
#define ERROR_DS_CANT_RETRIEVE_SD        8526L
#endif
#ifndef ERROR_DS_KEY_NOT_UNIQUE
#define ERROR_DS_KEY_NOT_UNIQUE          8527L
#endif
#ifndef ERROR_DS_WRONG_LINKED_ATT_SYNTAX
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX 8528L
#endif
#ifndef ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD 8529L
#endif
#ifndef ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY 8530L
#endif
#ifndef ERROR_DS_CANT_START
#define ERROR_DS_CANT_START              8531L
#endif
#ifndef ERROR_DS_INIT_FAILURE
#define ERROR_DS_INIT_FAILURE            8532L
#endif
#ifndef ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION 8533L
#endif
#ifndef ERROR_DS_SOURCE_DOMAIN_IN_FOREST
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST 8534L
#endif
#ifndef ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST 8535L
#endif
#ifndef ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED 8536L
#endif
#ifndef ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN 8537L
#endif
#ifndef ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER 8538L
#endif
#ifndef ERROR_DS_SRC_SID_EXISTS_IN_FOREST
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST 8539L
#endif
#ifndef ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH 8540L
#endif
#ifndef ERROR_SAM_INIT_FAILURE
#define ERROR_SAM_INIT_FAILURE           8541L
#endif
#ifndef ERROR_DS_DRA_SCHEMA_INFO_SHIP
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP    8542L
#endif
#ifndef ERROR_DS_DRA_SCHEMA_CONFLICT
#define ERROR_DS_DRA_SCHEMA_CONFLICT     8543L
#endif
#ifndef ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT 8544L
#endif
#ifndef ERROR_DS_DRA_OBJ_NC_MISMATCH
#define ERROR_DS_DRA_OBJ_NC_MISMATCH     8545L
#endif
#ifndef ERROR_DS_NC_STILL_HAS_DSAS
#define ERROR_DS_NC_STILL_HAS_DSAS       8546L
#endif
#ifndef ERROR_DS_GC_REQUIRED
#define ERROR_DS_GC_REQUIRED             8547L
#endif
#ifndef ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY 8548L
#endif
#ifndef ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS 8549L
#endif
#ifndef ERROR_DS_CANT_ADD_TO_GC
#define ERROR_DS_CANT_ADD_TO_GC          8550L
#endif
#ifndef ERROR_DS_NO_CHECKPOINT_WITH_PDC
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC  8551L
#endif
#ifndef ERROR_DS_SOURCE_AUDITING_NOT_ENABLED
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED 8552L
#endif
#ifndef ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC 8553L
#endif
#ifndef ERROR_DS_INVALID_NAME_FOR_SPN
#define ERROR_DS_INVALID_NAME_FOR_SPN    8554L
#endif
#ifndef ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS 8555L
#endif
#ifndef ERROR_DS_UNICODEPWD_NOT_IN_QUOTES
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES 8556L
#endif
#ifndef ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED 8557L
#endif
#ifndef ERROR_DS_MUST_BE_RUN_ON_DST_DC
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC   8558L
#endif
#ifndef ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER 8559L
#endif
#ifndef ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ 8560L
#endif
#ifndef ERROR_DS_INIT_FAILURE_CONSOLE
#define ERROR_DS_INIT_FAILURE_CONSOLE    8561L
#endif
#ifndef ERROR_DS_SAM_INIT_FAILURE_CONSOLE
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE 8562L
#endif
#ifndef ERROR_DS_FOREST_VERSION_TOO_HIGH
#define ERROR_DS_FOREST_VERSION_TOO_HIGH 8563L
#endif
#ifndef ERROR_DS_DOMAIN_VERSION_TOO_HIGH
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH 8564L
#endif
#ifndef ERROR_DS_FOREST_VERSION_TOO_LOW
#define ERROR_DS_FOREST_VERSION_TOO_LOW  8565L
#endif
#ifndef ERROR_DS_DOMAIN_VERSION_TOO_LOW
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW  8566L
#endif
#ifndef ERROR_DS_INCOMPATIBLE_VERSION
#define ERROR_DS_INCOMPATIBLE_VERSION    8567L
#endif
#ifndef ERROR_DS_LOW_DSA_VERSION
#define ERROR_DS_LOW_DSA_VERSION         8568L
#endif
#ifndef ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN 8569L
#endif
#ifndef ERROR_DS_NOT_SUPPORTED_SORT_ORDER
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER 8570L
#endif
#ifndef ERROR_DS_NAME_NOT_UNIQUE
#define ERROR_DS_NAME_NOT_UNIQUE         8571L
#endif
#ifndef ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 8572L
#endif
#ifndef ERROR_DS_OUT_OF_VERSION_STORE
#define ERROR_DS_OUT_OF_VERSION_STORE    8573L
#endif
#ifndef ERROR_DS_INCOMPATIBLE_CONTROLS_USED
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED 8574L
#endif
#ifndef ERROR_DS_NO_REF_DOMAIN
#define ERROR_DS_NO_REF_DOMAIN           8575L
#endif
#ifndef ERROR_DS_RESERVED_LINK_ID
#define ERROR_DS_RESERVED_LINK_ID        8576L
#endif
#ifndef ERROR_DS_LINK_ID_NOT_AVAILABLE
#define ERROR_DS_LINK_ID_NOT_AVAILABLE   8577L
#endif
#ifndef ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER 8578L
#endif
#ifndef ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE 8579L
#endif
#ifndef ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC 8580L
#endif
#ifndef ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG 8581L
#endif
#ifndef ERROR_DS_MODIFYDN_WRONG_GRANDPARENT
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT 8582L
#endif
#ifndef ERROR_DS_NAME_ERROR_TRUST_REFERRAL
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL 8583L
#endif
#ifndef ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER 8584L
#endif
#ifndef ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD 8585L
#endif
#ifndef ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 8586L
#endif
#ifndef ERROR_DS_THREAD_LIMIT_EXCEEDED
#define ERROR_DS_THREAD_LIMIT_EXCEEDED   8587L
#endif
#ifndef ERROR_DS_NOT_CLOSEST
#define ERROR_DS_NOT_CLOSEST             8588L
#endif
#ifndef ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF 8589L
#endif
#ifndef ERROR_DS_SINGLE_USER_MODE_FAILED
#define ERROR_DS_SINGLE_USER_MODE_FAILED 8590L
#endif
#ifndef ERROR_DS_NTDSCRIPT_SYNTAX_ERROR
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR  8591L
#endif
#ifndef ERROR_DS_NTDSCRIPT_PROCESS_ERROR
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR 8592L
#endif
#ifndef ERROR_DS_DIFFERENT_REPL_EPOCHS
#define ERROR_DS_DIFFERENT_REPL_EPOCHS   8593L
#endif
#ifndef ERROR_DS_DRS_EXTENSIONS_CHANGED
#define ERROR_DS_DRS_EXTENSIONS_CHANGED  8594L
#endif
#ifndef ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR 8595L
#endif
#ifndef ERROR_DS_NO_MSDS_INTID
#define ERROR_DS_NO_MSDS_INTID           8596L
#endif
#ifndef ERROR_DS_DUP_MSDS_INTID
#define ERROR_DS_DUP_MSDS_INTID          8597L
#endif
#ifndef ERROR_DS_EXISTS_IN_RDNATTID
#define ERROR_DS_EXISTS_IN_RDNATTID      8598L
#endif
#ifndef ERROR_DS_AUTHORIZATION_FAILED
#define ERROR_DS_AUTHORIZATION_FAILED    8599L
#endif
#ifndef ERROR_DS_INVALID_SCRIPT
#define ERROR_DS_INVALID_SCRIPT          8600L
#endif
#ifndef ERROR_DS_REMOTE_CROSSREF_OP_FAILED
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED 8601L
#endif
#ifndef ERROR_DS_CROSS_REF_BUSY
#define ERROR_DS_CROSS_REF_BUSY          8602L
#endif
#ifndef ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN 8603L
#endif
#ifndef ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC 8604L
#endif
#ifndef ERROR_DS_DUPLICATE_ID_FOUND
#define ERROR_DS_DUPLICATE_ID_FOUND      8605L
#endif
#ifndef ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT 8606L
#endif
#ifndef ERROR_DS_GROUP_CONVERSION_ERROR
#define ERROR_DS_GROUP_CONVERSION_ERROR  8607L
#endif
#ifndef ERROR_DS_CANT_MOVE_APP_BASIC_GROUP
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP 8608L
#endif
#ifndef ERROR_DS_CANT_MOVE_APP_QUERY_GROUP
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP 8609L
#endif
#ifndef ERROR_DS_ROLE_NOT_VERIFIED
#define ERROR_DS_ROLE_NOT_VERIFIED       8610L
#endif
#ifndef ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL 8611L
#endif
#ifndef ERROR_DS_DOMAIN_RENAME_IN_PROGRESS
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS 8612L
#endif
#ifndef ERROR_DS_EXISTING_AD_CHILD_NC
#define ERROR_DS_EXISTING_AD_CHILD_NC    8613L
#endif
#ifndef ERROR_DS_REPL_LIFETIME_EXCEEDED
#define ERROR_DS_REPL_LIFETIME_EXCEEDED  8614L
#endif
#ifndef ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER
#define ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER 8615L
#endif
#ifndef ERROR_DS_LDAP_SEND_QUEUE_FULL
#define ERROR_DS_LDAP_SEND_QUEUE_FULL    8616L
#endif
#ifndef ERROR_DS_DRA_OUT_SCHEDULE_WINDOW
#define ERROR_DS_DRA_OUT_SCHEDULE_WINDOW 8617L
#endif
#ifndef DNS_ERROR_RCODE_FORMAT_ERROR
#define DNS_ERROR_RCODE_FORMAT_ERROR     9001L
#endif
#ifndef DNS_ERROR_RCODE_SERVER_FAILURE
#define DNS_ERROR_RCODE_SERVER_FAILURE   9002L
#endif
#ifndef DNS_ERROR_RCODE_NAME_ERROR
#define DNS_ERROR_RCODE_NAME_ERROR       9003L
#endif
#ifndef DNS_ERROR_RCODE_NOT_IMPLEMENTED
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED  9004L
#endif
#ifndef DNS_ERROR_RCODE_REFUSED
#define DNS_ERROR_RCODE_REFUSED          9005L
#endif
#ifndef DNS_ERROR_RCODE_YXDOMAIN
#define DNS_ERROR_RCODE_YXDOMAIN         9006L
#endif
#ifndef DNS_ERROR_RCODE_YXRRSET
#define DNS_ERROR_RCODE_YXRRSET          9007L
#endif
#ifndef DNS_ERROR_RCODE_NXRRSET
#define DNS_ERROR_RCODE_NXRRSET          9008L
#endif
#ifndef DNS_ERROR_RCODE_NOTAUTH
#define DNS_ERROR_RCODE_NOTAUTH          9009L
#endif
#ifndef DNS_ERROR_RCODE_NOTZONE
#define DNS_ERROR_RCODE_NOTZONE          9010L
#endif
#ifndef DNS_ERROR_RCODE_BADSIG
#define DNS_ERROR_RCODE_BADSIG           9016L
#endif
#ifndef DNS_ERROR_RCODE_BADKEY
#define DNS_ERROR_RCODE_BADKEY           9017L
#endif
#ifndef DNS_ERROR_RCODE_BADTIME
#define DNS_ERROR_RCODE_BADTIME          9018L
#endif
#ifndef DNS_INFO_NO_RECORDS
#define DNS_INFO_NO_RECORDS              9501L
#endif
#ifndef DNS_ERROR_BAD_PACKET
#define DNS_ERROR_BAD_PACKET             9502L
#endif
#ifndef DNS_ERROR_NO_PACKET
#define DNS_ERROR_NO_PACKET              9503L
#endif
#ifndef DNS_ERROR_RCODE
#define DNS_ERROR_RCODE                  9504L
#endif
#ifndef DNS_ERROR_UNSECURE_PACKET
#define DNS_ERROR_UNSECURE_PACKET        9505L
#endif
#ifndef DNS_ERROR_INVALID_TYPE
#define DNS_ERROR_INVALID_TYPE           9551L
#endif
#ifndef DNS_ERROR_INVALID_IP_ADDRESS
#define DNS_ERROR_INVALID_IP_ADDRESS     9552L
#endif
#ifndef DNS_ERROR_INVALID_PROPERTY
#define DNS_ERROR_INVALID_PROPERTY       9553L
#endif
#ifndef DNS_ERROR_TRY_AGAIN_LATER
#define DNS_ERROR_TRY_AGAIN_LATER        9554L
#endif
#ifndef DNS_ERROR_NOT_UNIQUE
#define DNS_ERROR_NOT_UNIQUE             9555L
#endif
#ifndef DNS_ERROR_NON_RFC_NAME
#define DNS_ERROR_NON_RFC_NAME           9556L
#endif
#ifndef DNS_STATUS_FQDN
#define DNS_STATUS_FQDN                  9557L
#endif
#ifndef DNS_STATUS_DOTTED_NAME
#define DNS_STATUS_DOTTED_NAME           9558L
#endif
#ifndef DNS_STATUS_SINGLE_PART_NAME
#define DNS_STATUS_SINGLE_PART_NAME      9559L
#endif
#ifndef DNS_ERROR_INVALID_NAME_CHAR
#define DNS_ERROR_INVALID_NAME_CHAR      9560L
#endif
#ifndef DNS_ERROR_NUMERIC_NAME
#define DNS_ERROR_NUMERIC_NAME           9561L
#endif
#ifndef DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER 9562L
#endif
#ifndef DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION 9563L
#endif
#ifndef DNS_ERROR_CANNOT_FIND_ROOT_HINTS
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS 9564L
#endif
#ifndef DNS_ERROR_INCONSISTENT_ROOT_HINTS
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS 9565L
#endif
#ifndef DNS_ERROR_ZONE_DOES_NOT_EXIST
#define DNS_ERROR_ZONE_DOES_NOT_EXIST    9601L
#endif
#ifndef DNS_ERROR_NO_ZONE_INFO
#define DNS_ERROR_NO_ZONE_INFO           9602L
#endif
#ifndef DNS_ERROR_INVALID_ZONE_OPERATION
#define DNS_ERROR_INVALID_ZONE_OPERATION 9603L
#endif
#ifndef DNS_ERROR_ZONE_CONFIGURATION_ERROR
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR 9604L
#endif
#ifndef DNS_ERROR_ZONE_HAS_NO_SOA_RECORD
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD 9605L
#endif
#ifndef DNS_ERROR_ZONE_HAS_NO_NS_RECORDS
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS 9606L
#endif
#ifndef DNS_ERROR_ZONE_LOCKED
#define DNS_ERROR_ZONE_LOCKED            9607L
#endif
#ifndef DNS_ERROR_ZONE_CREATION_FAILED
#define DNS_ERROR_ZONE_CREATION_FAILED   9608L
#endif
#ifndef DNS_ERROR_ZONE_ALREADY_EXISTS
#define DNS_ERROR_ZONE_ALREADY_EXISTS    9609L
#endif
#ifndef DNS_ERROR_AUTOZONE_ALREADY_EXISTS
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS 9610L
#endif
#ifndef DNS_ERROR_INVALID_ZONE_TYPE
#define DNS_ERROR_INVALID_ZONE_TYPE      9611L
#endif
#ifndef DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP 9612L
#endif
#ifndef DNS_ERROR_ZONE_NOT_SECONDARY
#define DNS_ERROR_ZONE_NOT_SECONDARY     9613L
#endif
#ifndef DNS_ERROR_NEED_SECONDARY_ADDRESSES
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES 9614L
#endif
#ifndef DNS_ERROR_WINS_INIT_FAILED
#define DNS_ERROR_WINS_INIT_FAILED       9615L
#endif
#ifndef DNS_ERROR_NEED_WINS_SERVERS
#define DNS_ERROR_NEED_WINS_SERVERS      9616L
#endif
#ifndef DNS_ERROR_NBSTAT_INIT_FAILED
#define DNS_ERROR_NBSTAT_INIT_FAILED     9617L
#endif
#ifndef DNS_ERROR_SOA_DELETE_INVALID
#define DNS_ERROR_SOA_DELETE_INVALID     9618L
#endif
#ifndef DNS_ERROR_FORWARDER_ALREADY_EXISTS
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS 9619L
#endif
#ifndef DNS_ERROR_ZONE_REQUIRES_MASTER_IP
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP 9620L
#endif
#ifndef DNS_ERROR_ZONE_IS_SHUTDOWN
#define DNS_ERROR_ZONE_IS_SHUTDOWN       9621L
#endif
#ifndef DNS_ERROR_PRIMARY_REQUIRES_DATAFILE
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE 9651L
#endif
#ifndef DNS_ERROR_INVALID_DATAFILE_NAME
#define DNS_ERROR_INVALID_DATAFILE_NAME  9652L
#endif
#ifndef DNS_ERROR_DATAFILE_OPEN_FAILURE
#define DNS_ERROR_DATAFILE_OPEN_FAILURE  9653L
#endif
#ifndef DNS_ERROR_FILE_WRITEBACK_FAILED
#define DNS_ERROR_FILE_WRITEBACK_FAILED  9654L
#endif
#ifndef DNS_ERROR_DATAFILE_PARSING
#define DNS_ERROR_DATAFILE_PARSING       9655L
#endif
#ifndef DNS_ERROR_RECORD_DOES_NOT_EXIST
#define DNS_ERROR_RECORD_DOES_NOT_EXIST  9701L
#endif
#ifndef DNS_ERROR_RECORD_FORMAT
#define DNS_ERROR_RECORD_FORMAT          9702L
#endif
#ifndef DNS_ERROR_NODE_CREATION_FAILED
#define DNS_ERROR_NODE_CREATION_FAILED   9703L
#endif
#ifndef DNS_ERROR_UNKNOWN_RECORD_TYPE
#define DNS_ERROR_UNKNOWN_RECORD_TYPE    9704L
#endif
#ifndef DNS_ERROR_RECORD_TIMED_OUT
#define DNS_ERROR_RECORD_TIMED_OUT       9705L
#endif
#ifndef DNS_ERROR_NAME_NOT_IN_ZONE
#define DNS_ERROR_NAME_NOT_IN_ZONE       9706L
#endif
#ifndef DNS_ERROR_CNAME_LOOP
#define DNS_ERROR_CNAME_LOOP             9707L
#endif
#ifndef DNS_ERROR_NODE_IS_CNAME
#define DNS_ERROR_NODE_IS_CNAME          9708L
#endif
#ifndef DNS_ERROR_CNAME_COLLISION
#define DNS_ERROR_CNAME_COLLISION        9709L
#endif
#ifndef DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT 9710L
#endif
#ifndef DNS_ERROR_RECORD_ALREADY_EXISTS
#define DNS_ERROR_RECORD_ALREADY_EXISTS  9711L
#endif
#ifndef DNS_ERROR_SECONDARY_DATA
#define DNS_ERROR_SECONDARY_DATA         9712L
#endif
#ifndef DNS_ERROR_NO_CREATE_CACHE_DATA
#define DNS_ERROR_NO_CREATE_CACHE_DATA   9713L
#endif
#ifndef DNS_ERROR_NAME_DOES_NOT_EXIST
#define DNS_ERROR_NAME_DOES_NOT_EXIST    9714L
#endif
#ifndef DNS_WARNING_PTR_CREATE_FAILED
#define DNS_WARNING_PTR_CREATE_FAILED    9715L
#endif
#ifndef DNS_WARNING_DOMAIN_UNDELETED
#define DNS_WARNING_DOMAIN_UNDELETED     9716L
#endif
#ifndef DNS_ERROR_DS_UNAVAILABLE
#define DNS_ERROR_DS_UNAVAILABLE         9717L
#endif
#ifndef DNS_ERROR_DS_ZONE_ALREADY_EXISTS
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS 9718L
#endif
#ifndef DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE 9719L
#endif
#ifndef DNS_INFO_AXFR_COMPLETE
#define DNS_INFO_AXFR_COMPLETE           9751L
#endif
#ifndef DNS_ERROR_AXFR
#define DNS_ERROR_AXFR                   9752L
#endif
#ifndef DNS_INFO_ADDED_LOCAL_WINS
#define DNS_INFO_ADDED_LOCAL_WINS        9753L
#endif
#ifndef DNS_STATUS_CONTINUE_NEEDED
#define DNS_STATUS_CONTINUE_NEEDED       9801L
#endif
#ifndef DNS_ERROR_NO_TCPIP
#define DNS_ERROR_NO_TCPIP               9851L
#endif
#ifndef DNS_ERROR_NO_DNS_SERVERS
#define DNS_ERROR_NO_DNS_SERVERS         9852L
#endif
#ifndef DNS_ERROR_DP_DOES_NOT_EXIST
#define DNS_ERROR_DP_DOES_NOT_EXIST      9901L
#endif
#ifndef DNS_ERROR_DP_ALREADY_EXISTS
#define DNS_ERROR_DP_ALREADY_EXISTS      9902L
#endif
#ifndef DNS_ERROR_DP_NOT_ENLISTED
#define DNS_ERROR_DP_NOT_ENLISTED        9903L
#endif
#ifndef DNS_ERROR_DP_ALREADY_ENLISTED
#define DNS_ERROR_DP_ALREADY_ENLISTED    9904L
#endif
#ifndef DNS_ERROR_DP_NOT_AVAILABLE
#define DNS_ERROR_DP_NOT_AVAILABLE       9905L
#endif
#ifndef DNS_ERROR_DP_FSMO_ERROR
#define DNS_ERROR_DP_FSMO_ERROR          9906L
#endif
#ifndef WSA_QOS_RECEIVERS
#define WSA_QOS_RECEIVERS                11005L
#endif
#ifndef WSA_QOS_SENDERS
#define WSA_QOS_SENDERS                  11006L
#endif
#ifndef WSA_QOS_NO_SENDERS
#define WSA_QOS_NO_SENDERS               11007L
#endif
#ifndef WSA_QOS_NO_RECEIVERS
#define WSA_QOS_NO_RECEIVERS             11008L
#endif
#ifndef WSA_QOS_REQUEST_CONFIRMED
#define WSA_QOS_REQUEST_CONFIRMED        11009L
#endif
#ifndef WSA_QOS_ADMISSION_FAILURE
#define WSA_QOS_ADMISSION_FAILURE        11010L
#endif
#ifndef WSA_QOS_POLICY_FAILURE
#define WSA_QOS_POLICY_FAILURE           11011L
#endif
#ifndef WSA_QOS_BAD_STYLE
#define WSA_QOS_BAD_STYLE                11012L
#endif
#ifndef WSA_QOS_BAD_OBJECT
#define WSA_QOS_BAD_OBJECT               11013L
#endif
#ifndef WSA_QOS_TRAFFIC_CTRL_ERROR
#define WSA_QOS_TRAFFIC_CTRL_ERROR       11014L
#endif
#ifndef WSA_QOS_GENERIC_ERROR
#define WSA_QOS_GENERIC_ERROR            11015L
#endif
#ifndef WSA_QOS_ESERVICETYPE
#define WSA_QOS_ESERVICETYPE             11016L
#endif
#ifndef WSA_QOS_EFLOWSPEC
#define WSA_QOS_EFLOWSPEC                11017L
#endif
#ifndef WSA_QOS_EPROVSPECBUF
#define WSA_QOS_EPROVSPECBUF             11018L
#endif
#ifndef WSA_QOS_EFILTERSTYLE
#define WSA_QOS_EFILTERSTYLE             11019L
#endif
#ifndef WSA_QOS_EFILTERTYPE
#define WSA_QOS_EFILTERTYPE              11020L
#endif
#ifndef WSA_QOS_EFILTERCOUNT
#define WSA_QOS_EFILTERCOUNT             11021L
#endif
#ifndef WSA_QOS_EOBJLENGTH
#define WSA_QOS_EOBJLENGTH               11022L
#endif
#ifndef WSA_QOS_EFLOWCOUNT
#define WSA_QOS_EFLOWCOUNT               11023L
#endif
#ifndef WSA_QOS_EUNKOWNPSOBJ
#define WSA_QOS_EUNKOWNPSOBJ             11024L
#endif
#ifndef WSA_QOS_EPOLICYOBJ
#define WSA_QOS_EPOLICYOBJ               11025L
#endif
#ifndef WSA_QOS_EFLOWDESC
#define WSA_QOS_EFLOWDESC                11026L
#endif
#ifndef WSA_QOS_EPSFLOWSPEC
#define WSA_QOS_EPSFLOWSPEC              11027L
#endif
#ifndef WSA_QOS_EPSFILTERSPEC
#define WSA_QOS_EPSFILTERSPEC            11028L
#endif
#ifndef WSA_QOS_ESDMODEOBJ
#define WSA_QOS_ESDMODEOBJ               11029L
#endif
#ifndef WSA_QOS_ESHAPERATEOBJ
#define WSA_QOS_ESHAPERATEOBJ            11030L
#endif
#ifndef WSA_QOS_RESERVED_PETYPE
#define WSA_QOS_RESERVED_PETYPE          11031L
#endif
#ifndef ERROR_SXS_SECTION_NOT_FOUND
#define ERROR_SXS_SECTION_NOT_FOUND      14000L
#endif
#ifndef ERROR_SXS_CANT_GEN_ACTCTX
#define ERROR_SXS_CANT_GEN_ACTCTX        14001L
#endif
#ifndef ERROR_SXS_INVALID_ACTCTXDATA_FORMAT
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT 14002L
#endif
#ifndef ERROR_SXS_ASSEMBLY_NOT_FOUND
#define ERROR_SXS_ASSEMBLY_NOT_FOUND     14003L
#endif
#ifndef ERROR_SXS_MANIFEST_FORMAT_ERROR
#define ERROR_SXS_MANIFEST_FORMAT_ERROR  14004L
#endif
#ifndef ERROR_SXS_MANIFEST_PARSE_ERROR
#define ERROR_SXS_MANIFEST_PARSE_ERROR   14005L
#endif
#ifndef ERROR_SXS_ACTIVATION_CONTEXT_DISABLED
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED 14006L
#endif
#ifndef ERROR_SXS_KEY_NOT_FOUND
#define ERROR_SXS_KEY_NOT_FOUND          14007L
#endif
#ifndef ERROR_SXS_VERSION_CONFLICT
#define ERROR_SXS_VERSION_CONFLICT       14008L
#endif
#ifndef ERROR_SXS_WRONG_SECTION_TYPE
#define ERROR_SXS_WRONG_SECTION_TYPE     14009L
#endif
#ifndef ERROR_SXS_THREAD_QUERIES_DISABLED
#define ERROR_SXS_THREAD_QUERIES_DISABLED 14010L
#endif
#ifndef ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET 14011L
#endif
#ifndef ERROR_SXS_UNKNOWN_ENCODING_GROUP
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP 14012L
#endif
#ifndef ERROR_SXS_UNKNOWN_ENCODING
#define ERROR_SXS_UNKNOWN_ENCODING       14013L
#endif
#ifndef ERROR_SXS_INVALID_XML_NAMESPACE_URI
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI 14014L
#endif
#ifndef ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED 14015L
#endif
#ifndef ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED 14016L
#endif
#ifndef ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE 14017L
#endif
#ifndef ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE 14018L
#endif
#ifndef ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE 14019L
#endif
#ifndef ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT 14020L
#endif
#ifndef ERROR_SXS_DUPLICATE_DLL_NAME
#define ERROR_SXS_DUPLICATE_DLL_NAME     14021L
#endif
#ifndef ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME 14022L
#endif
#ifndef ERROR_SXS_DUPLICATE_CLSID
#define ERROR_SXS_DUPLICATE_CLSID        14023L
#endif
#ifndef ERROR_SXS_DUPLICATE_IID
#define ERROR_SXS_DUPLICATE_IID          14024L
#endif
#ifndef ERROR_SXS_DUPLICATE_TLBID
#define ERROR_SXS_DUPLICATE_TLBID        14025L
#endif
#ifndef ERROR_SXS_DUPLICATE_PROGID
#define ERROR_SXS_DUPLICATE_PROGID       14026L
#endif
#ifndef ERROR_SXS_DUPLICATE_ASSEMBLY_NAME
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME 14027L
#endif
#ifndef ERROR_SXS_FILE_HASH_MISMATCH
#define ERROR_SXS_FILE_HASH_MISMATCH     14028L
#endif
#ifndef ERROR_SXS_POLICY_PARSE_ERROR
#define ERROR_SXS_POLICY_PARSE_ERROR     14029L
#endif
#ifndef ERROR_SXS_XML_E_MISSINGQUOTE
#define ERROR_SXS_XML_E_MISSINGQUOTE     14030L
#endif
#ifndef ERROR_SXS_XML_E_COMMENTSYNTAX
#define ERROR_SXS_XML_E_COMMENTSYNTAX    14031L
#endif
#ifndef ERROR_SXS_XML_E_BADSTARTNAMECHAR
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR 14032L
#endif
#ifndef ERROR_SXS_XML_E_BADNAMECHAR
#define ERROR_SXS_XML_E_BADNAMECHAR      14033L
#endif
#ifndef ERROR_SXS_XML_E_BADCHARINSTRING
#define ERROR_SXS_XML_E_BADCHARINSTRING  14034L
#endif
#ifndef ERROR_SXS_XML_E_XMLDECLSYNTAX
#define ERROR_SXS_XML_E_XMLDECLSYNTAX    14035L
#endif
#ifndef ERROR_SXS_XML_E_BADCHARDATA
#define ERROR_SXS_XML_E_BADCHARDATA      14036L
#endif
#ifndef ERROR_SXS_XML_E_MISSINGWHITESPACE
#define ERROR_SXS_XML_E_MISSINGWHITESPACE 14037L
#endif
#ifndef ERROR_SXS_XML_E_EXPECTINGTAGEND
#define ERROR_SXS_XML_E_EXPECTINGTAGEND  14038L
#endif
#ifndef ERROR_SXS_XML_E_MISSINGSEMICOLON
#define ERROR_SXS_XML_E_MISSINGSEMICOLON 14039L
#endif
#ifndef ERROR_SXS_XML_E_UNBALANCEDPAREN
#define ERROR_SXS_XML_E_UNBALANCEDPAREN  14040L
#endif
#ifndef ERROR_SXS_XML_E_INTERNALERROR
#define ERROR_SXS_XML_E_INTERNALERROR    14041L
#endif
#ifndef ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE 14042L
#endif
#ifndef ERROR_SXS_XML_E_INCOMPLETE_ENCODING
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING 14043L
#endif
#ifndef ERROR_SXS_XML_E_MISSING_PAREN
#define ERROR_SXS_XML_E_MISSING_PAREN    14044L
#endif
#ifndef ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE 14045L
#endif
#ifndef ERROR_SXS_XML_E_MULTIPLE_COLONS
#define ERROR_SXS_XML_E_MULTIPLE_COLONS  14046L
#endif
#ifndef ERROR_SXS_XML_E_INVALID_DECIMAL
#define ERROR_SXS_XML_E_INVALID_DECIMAL  14047L
#endif
#ifndef ERROR_SXS_XML_E_INVALID_HEXIDECIMAL
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL 14048L
#endif
#ifndef ERROR_SXS_XML_E_INVALID_UNICODE
#define ERROR_SXS_XML_E_INVALID_UNICODE  14049L
#endif
#ifndef ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK 14050L
#endif
#ifndef ERROR_SXS_XML_E_UNEXPECTEDENDTAG
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG 14051L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDTAG
#define ERROR_SXS_XML_E_UNCLOSEDTAG      14052L
#endif
#ifndef ERROR_SXS_XML_E_DUPLICATEATTRIBUTE
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE 14053L
#endif
#ifndef ERROR_SXS_XML_E_MULTIPLEROOTS
#define ERROR_SXS_XML_E_MULTIPLEROOTS    14054L
#endif
#ifndef ERROR_SXS_XML_E_INVALIDATROOTLEVEL
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL 14055L
#endif
#ifndef ERROR_SXS_XML_E_BADXMLDECL
#define ERROR_SXS_XML_E_BADXMLDECL       14056L
#endif
#ifndef ERROR_SXS_XML_E_MISSINGROOT
#define ERROR_SXS_XML_E_MISSINGROOT      14057L
#endif
#ifndef ERROR_SXS_XML_E_UNEXPECTEDEOF
#define ERROR_SXS_XML_E_UNEXPECTEDEOF    14058L
#endif
#ifndef ERROR_SXS_XML_E_BADPEREFINSUBSET
#define ERROR_SXS_XML_E_BADPEREFINSUBSET 14059L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDSTARTTAG
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG 14060L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDENDTAG
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG   14061L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDSTRING
#define ERROR_SXS_XML_E_UNCLOSEDSTRING   14062L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDCOMMENT
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT  14063L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDDECL
#define ERROR_SXS_XML_E_UNCLOSEDDECL     14064L
#endif
#ifndef ERROR_SXS_XML_E_UNCLOSEDCDATA
#define ERROR_SXS_XML_E_UNCLOSEDCDATA    14065L
#endif
#ifndef ERROR_SXS_XML_E_RESERVEDNAMESPACE
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE 14066L
#endif
#ifndef ERROR_SXS_XML_E_INVALIDENCODING
#define ERROR_SXS_XML_E_INVALIDENCODING  14067L
#endif
#ifndef ERROR_SXS_XML_E_INVALIDSWITCH
#define ERROR_SXS_XML_E_INVALIDSWITCH    14068L
#endif
#ifndef ERROR_SXS_XML_E_BADXMLCASE
#define ERROR_SXS_XML_E_BADXMLCASE       14069L
#endif
#ifndef ERROR_SXS_XML_E_INVALID_STANDALONE
#define ERROR_SXS_XML_E_INVALID_STANDALONE 14070L
#endif
#ifndef ERROR_SXS_XML_E_UNEXPECTED_STANDALONE
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE 14071L
#endif
#ifndef ERROR_SXS_XML_E_INVALID_VERSION
#define ERROR_SXS_XML_E_INVALID_VERSION  14072L
#endif
#ifndef ERROR_SXS_XML_E_MISSINGEQUALS
#define ERROR_SXS_XML_E_MISSINGEQUALS    14073L
#endif
#ifndef ERROR_SXS_PROTECTION_RECOVERY_FAILED
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED 14074L
#endif
#ifndef ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT 14075L
#endif
#ifndef ERROR_SXS_PROTECTION_CATALOG_NOT_VALID
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID 14076L
#endif
#ifndef ERROR_SXS_UNTRANSLATABLE_HRESULT
#define ERROR_SXS_UNTRANSLATABLE_HRESULT 14077L
#endif
#ifndef ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING 14078L
#endif
#ifndef ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE 14079L
#endif
#ifndef ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME 14080L
#endif
#ifndef ERROR_IPSEC_QM_POLICY_EXISTS
#define ERROR_IPSEC_QM_POLICY_EXISTS     13000L
#endif
#ifndef ERROR_IPSEC_QM_POLICY_NOT_FOUND
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND  13001L
#endif
#ifndef ERROR_IPSEC_QM_POLICY_IN_USE
#define ERROR_IPSEC_QM_POLICY_IN_USE     13002L
#endif
#ifndef ERROR_IPSEC_MM_POLICY_EXISTS
#define ERROR_IPSEC_MM_POLICY_EXISTS     13003L
#endif
#ifndef ERROR_IPSEC_MM_POLICY_NOT_FOUND
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND  13004L
#endif
#ifndef ERROR_IPSEC_MM_POLICY_IN_USE
#define ERROR_IPSEC_MM_POLICY_IN_USE     13005L
#endif
#ifndef ERROR_IPSEC_MM_FILTER_EXISTS
#define ERROR_IPSEC_MM_FILTER_EXISTS     13006L
#endif
#ifndef ERROR_IPSEC_MM_FILTER_NOT_FOUND
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND  13007L
#endif
#ifndef ERROR_IPSEC_TRANSPORT_FILTER_EXISTS
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS 13008L
#endif
#ifndef ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND 13009L
#endif
#ifndef ERROR_IPSEC_MM_AUTH_EXISTS
#define ERROR_IPSEC_MM_AUTH_EXISTS       13010L
#endif
#ifndef ERROR_IPSEC_MM_AUTH_NOT_FOUND
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND    13011L
#endif
#ifndef ERROR_IPSEC_MM_AUTH_IN_USE
#define ERROR_IPSEC_MM_AUTH_IN_USE       13012L
#endif
#ifndef ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND 13013L
#endif
#ifndef ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND 13014L
#endif
#ifndef ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND 13015L
#endif
#ifndef ERROR_IPSEC_TUNNEL_FILTER_EXISTS
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS 13016L
#endif
#ifndef ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND 13017L
#endif
#ifndef ERROR_IPSEC_MM_FILTER_PENDING_DELETION
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION 13018L
#endif
#ifndef ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION 13019L
#endif
#ifndef ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION 13020L
#endif
#ifndef ERROR_IPSEC_MM_POLICY_PENDING_DELETION
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION 13021L
#endif
#ifndef ERROR_IPSEC_MM_AUTH_PENDING_DELETION
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION 13022L
#endif
#ifndef ERROR_IPSEC_QM_POLICY_PENDING_DELETION
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION 13023L
#endif
#ifndef WARNING_IPSEC_MM_POLICY_PRUNED
#define WARNING_IPSEC_MM_POLICY_PRUNED   13024L
#endif
#ifndef WARNING_IPSEC_QM_POLICY_PRUNED
#define WARNING_IPSEC_QM_POLICY_PRUNED   13025L
#endif
#ifndef ERROR_IPSEC_IKE_NEG_STATUS_BEGIN
#define ERROR_IPSEC_IKE_NEG_STATUS_BEGIN 13800L
#endif
#ifndef ERROR_IPSEC_IKE_AUTH_FAIL
#define ERROR_IPSEC_IKE_AUTH_FAIL        13801L
#endif
#ifndef ERROR_IPSEC_IKE_ATTRIB_FAIL
#define ERROR_IPSEC_IKE_ATTRIB_FAIL      13802L
#endif
#ifndef ERROR_IPSEC_IKE_NEGOTIATION_PENDING
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING 13803L
#endif
#ifndef ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR 13804L
#endif
#ifndef ERROR_IPSEC_IKE_TIMED_OUT
#define ERROR_IPSEC_IKE_TIMED_OUT        13805L
#endif
#ifndef ERROR_IPSEC_IKE_NO_CERT
#define ERROR_IPSEC_IKE_NO_CERT          13806L
#endif
#ifndef ERROR_IPSEC_IKE_SA_DELETED
#define ERROR_IPSEC_IKE_SA_DELETED       13807L
#endif
#ifndef ERROR_IPSEC_IKE_SA_REAPED
#define ERROR_IPSEC_IKE_SA_REAPED        13808L
#endif
#ifndef ERROR_IPSEC_IKE_MM_ACQUIRE_DROP
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP  13809L
#endif
#ifndef ERROR_IPSEC_IKE_QM_ACQUIRE_DROP
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP  13810L
#endif
#ifndef ERROR_IPSEC_IKE_QUEUE_DROP_MM
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM    13811L
#endif
#ifndef ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM 13812L
#endif
#ifndef ERROR_IPSEC_IKE_DROP_NO_RESPONSE
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE 13813L
#endif
#ifndef ERROR_IPSEC_IKE_MM_DELAY_DROP
#define ERROR_IPSEC_IKE_MM_DELAY_DROP    13814L
#endif
#ifndef ERROR_IPSEC_IKE_QM_DELAY_DROP
#define ERROR_IPSEC_IKE_QM_DELAY_DROP    13815L
#endif
#ifndef ERROR_IPSEC_IKE_ERROR
#define ERROR_IPSEC_IKE_ERROR            13816L
#endif
#ifndef ERROR_IPSEC_IKE_CRL_FAILED
#define ERROR_IPSEC_IKE_CRL_FAILED       13817L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_KEY_USAGE
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE 13818L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_CERT_TYPE
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE 13819L
#endif
#ifndef ERROR_IPSEC_IKE_NO_PRIVATE_KEY
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY   13820L
#endif
#ifndef ERROR_IPSEC_IKE_DH_FAIL
#define ERROR_IPSEC_IKE_DH_FAIL          13822L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_HEADER
#define ERROR_IPSEC_IKE_INVALID_HEADER   13824L
#endif
#ifndef ERROR_IPSEC_IKE_NO_POLICY
#define ERROR_IPSEC_IKE_NO_POLICY        13825L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_SIGNATURE
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE 13826L
#endif
#ifndef ERROR_IPSEC_IKE_KERBEROS_ERROR
#define ERROR_IPSEC_IKE_KERBEROS_ERROR   13827L
#endif
#ifndef ERROR_IPSEC_IKE_NO_PUBLIC_KEY
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY    13828L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR
#define ERROR_IPSEC_IKE_PROCESS_ERR      13829L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_SA
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA   13830L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_PROP
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP 13831L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_TRANS
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS 13832L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_KE
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE   13833L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_ID
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID   13834L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_CERT
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT 13835L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ 13836L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_HASH
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH 13837L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_SIG
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG  13838L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_NONCE
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE 13839L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY 13840L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_DELETE
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE 13841L
#endif
#ifndef ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR 13842L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_PAYLOAD
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD  13843L
#endif
#ifndef ERROR_IPSEC_IKE_LOAD_SOFT_SA
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA     13844L
#endif
#ifndef ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN 13845L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_COOKIE
#define ERROR_IPSEC_IKE_INVALID_COOKIE   13846L
#endif
#ifndef ERROR_IPSEC_IKE_NO_PEER_CERT
#define ERROR_IPSEC_IKE_NO_PEER_CERT     13847L
#endif
#ifndef ERROR_IPSEC_IKE_PEER_CRL_FAILED
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED  13848L
#endif
#ifndef ERROR_IPSEC_IKE_POLICY_CHANGE
#define ERROR_IPSEC_IKE_POLICY_CHANGE    13849L
#endif
#ifndef ERROR_IPSEC_IKE_NO_MM_POLICY
#define ERROR_IPSEC_IKE_NO_MM_POLICY     13850L
#endif
#ifndef ERROR_IPSEC_IKE_NOTCBPRIV
#define ERROR_IPSEC_IKE_NOTCBPRIV        13851L
#endif
#ifndef ERROR_IPSEC_IKE_SECLOADFAIL
#define ERROR_IPSEC_IKE_SECLOADFAIL      13852L
#endif
#ifndef ERROR_IPSEC_IKE_FAILSSPINIT
#define ERROR_IPSEC_IKE_FAILSSPINIT      13853L
#endif
#ifndef ERROR_IPSEC_IKE_FAILQUERYSSP
#define ERROR_IPSEC_IKE_FAILQUERYSSP     13854L
#endif
#ifndef ERROR_IPSEC_IKE_SRVACQFAIL
#define ERROR_IPSEC_IKE_SRVACQFAIL       13855L
#endif
#ifndef ERROR_IPSEC_IKE_SRVQUERYCRED
#define ERROR_IPSEC_IKE_SRVQUERYCRED     13856L
#endif
#ifndef ERROR_IPSEC_IKE_GETSPIFAIL
#define ERROR_IPSEC_IKE_GETSPIFAIL       13857L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_FILTER
#define ERROR_IPSEC_IKE_INVALID_FILTER   13858L
#endif
#ifndef ERROR_IPSEC_IKE_OUT_OF_MEMORY
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY    13859L
#endif
#ifndef ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED 13860L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_POLICY
#define ERROR_IPSEC_IKE_INVALID_POLICY   13861L
#endif
#ifndef ERROR_IPSEC_IKE_UNKNOWN_DOI
#define ERROR_IPSEC_IKE_UNKNOWN_DOI      13862L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_SITUATION
#define ERROR_IPSEC_IKE_INVALID_SITUATION 13863L
#endif
#ifndef ERROR_IPSEC_IKE_DH_FAILURE
#define ERROR_IPSEC_IKE_DH_FAILURE       13864L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_GROUP
#define ERROR_IPSEC_IKE_INVALID_GROUP    13865L
#endif
#ifndef ERROR_IPSEC_IKE_ENCRYPT
#define ERROR_IPSEC_IKE_ENCRYPT          13866L
#endif
#ifndef ERROR_IPSEC_IKE_DECRYPT
#define ERROR_IPSEC_IKE_DECRYPT          13867L
#endif
#ifndef ERROR_IPSEC_IKE_POLICY_MATCH
#define ERROR_IPSEC_IKE_POLICY_MATCH     13868L
#endif
#ifndef ERROR_IPSEC_IKE_UNSUPPORTED_ID
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID   13869L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_HASH
#define ERROR_IPSEC_IKE_INVALID_HASH     13870L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_HASH_ALG
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG 13871L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_HASH_SIZE
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE 13872L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG 13873L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_AUTH_ALG
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG 13874L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_SIG
#define ERROR_IPSEC_IKE_INVALID_SIG      13875L
#endif
#ifndef ERROR_IPSEC_IKE_LOAD_FAILED
#define ERROR_IPSEC_IKE_LOAD_FAILED      13876L
#endif
#ifndef ERROR_IPSEC_IKE_RPC_DELETE
#define ERROR_IPSEC_IKE_RPC_DELETE       13877L
#endif
#ifndef ERROR_IPSEC_IKE_BENIGN_REINIT
#define ERROR_IPSEC_IKE_BENIGN_REINIT    13878L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY 13879L
#endif
#ifndef ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN 13881L
#endif
#ifndef ERROR_IPSEC_IKE_MM_LIMIT
#define ERROR_IPSEC_IKE_MM_LIMIT         13882L
#endif
#ifndef ERROR_IPSEC_IKE_NEGOTIATION_DISABLED
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED 13883L
#endif
#ifndef ERROR_IPSEC_IKE_NEG_STATUS_END
#define ERROR_IPSEC_IKE_NEG_STATUS_END   13884L
#endif

/*
 *----------------------------------------------------------------------
 *
 * Exp_Win32ErrId --
 *
 *	Same as Tcl_ErrnoId(), but for windows error codes.
 *
 * Results:
 *      The symbolic name of the error code.
 *    
 * Comments:
 *	Current complete list from <winerror.h> as of the Platform
 *	SDK October 2002 release.  If I'm going to export this function,
 *	I may as well make it complete :)
 *
 * Side Effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

CONST char *
Exp_Win32ErrId (DWORD errorCode)
{
    switch (errorCode) {
	case ERROR_SUCCESS :		    return "ERROR_SUCCESS";
	case ERROR_INVALID_FUNCTION :	    return "ERROR_INVALID_FUNCTION";
	case ERROR_FILE_NOT_FOUND :	    return "ERROR_FILE_NOT_FOUND";
	case ERROR_PATH_NOT_FOUND :	    return "ERROR_PATH_NOT_FOUND";
	case ERROR_TOO_MANY_OPEN_FILES :    return "ERROR_TOO_MANY_OPEN_FILES";
	case ERROR_ACCESS_DENIED :	    return "ERROR_ACCESS_DENIED";
	case ERROR_INVALID_HANDLE :	    return "ERROR_INVALID_HANDLE";
	case ERROR_ARENA_TRASHED :	    return "ERROR_ARENA_TRASHED";
	case ERROR_NOT_ENOUGH_MEMORY :	    return "ERROR_NOT_ENOUGH_MEMORY";
	case ERROR_INVALID_BLOCK :	    return "ERROR_INVALID_BLOCK";
	case ERROR_BAD_ENVIRONMENT :	    return "ERROR_BAD_ENVIRONMENT";
	case ERROR_BAD_FORMAT :		    return "ERROR_BAD_FORMAT";
	case ERROR_INVALID_ACCESS :	    return "ERROR_INVALID_ACCESS";
	case ERROR_INVALID_DATA :	    return "ERROR_INVALID_DATA";
	case ERROR_OUTOFMEMORY :	    return "ERROR_OUTOFMEMORY";
	case ERROR_INVALID_DRIVE :	    return "ERROR_INVALID_DRIVE";
	case ERROR_CURRENT_DIRECTORY :	    return "ERROR_CURRENT_DIRECTORY";
	case ERROR_NOT_SAME_DEVICE :	    return "ERROR_NOT_SAME_DEVICE";
	case ERROR_NO_MORE_FILES :	    return "ERROR_NO_MORE_FILES";
	case ERROR_WRITE_PROTECT :	    return "ERROR_WRITE_PROTECT";
	case ERROR_BAD_UNIT :		    return "ERROR_BAD_UNIT";
	case ERROR_NOT_READY :		    return "ERROR_NOT_READY";
	case ERROR_BAD_COMMAND :	    return "ERROR_BAD_COMMAND";
	case ERROR_CRC :		    return "ERROR_CRC";
	case ERROR_BAD_LENGTH :		    return "ERROR_BAD_LENGTH";
	case ERROR_SEEK :		    return "ERROR_SEEK";
	case ERROR_NOT_DOS_DISK :	    return "ERROR_NOT_DOS_DISK";
	case ERROR_SECTOR_NOT_FOUND :	    return "ERROR_SECTOR_NOT_FOUND";
	case ERROR_OUT_OF_PAPER :	    return "ERROR_OUT_OF_PAPER";
	case ERROR_WRITE_FAULT :	    return "ERROR_WRITE_FAULT";
	case ERROR_READ_FAULT :		    return "ERROR_READ_FAULT";
	case ERROR_GEN_FAILURE :	    return "ERROR_GEN_FAILURE";
	case ERROR_SHARING_VIOLATION :	    return "ERROR_SHARING_VIOLATION";
	case ERROR_LOCK_VIOLATION :	    return "ERROR_LOCK_VIOLATION";
	case ERROR_WRONG_DISK :		    return "ERROR_WRONG_DISK";
	case ERROR_SHARING_BUFFER_EXCEEDED : return "ERROR_SHARING_BUFFER_EXCEEDED";
	case ERROR_HANDLE_EOF :		    return "ERROR_HANDLE_EOF";
	case ERROR_HANDLE_DISK_FULL :	    return "ERROR_HANDLE_DISK_FULL";
	case ERROR_NOT_SUPPORTED :	    return "ERROR_NOT_SUPPORTED";
	case ERROR_REM_NOT_LIST :	    return "ERROR_REM_NOT_LIST";
	case ERROR_DUP_NAME :		    return "ERROR_DUP_NAME";
	case ERROR_BAD_NETPATH :	    return "ERROR_BAD_NETPATH";
	case ERROR_NETWORK_BUSY :	    return "ERROR_NETWORK_BUSY";
	case ERROR_DEV_NOT_EXIST :	    return "ERROR_DEV_NOT_EXIST";
	case ERROR_TOO_MANY_CMDS :	    return "ERROR_TOO_MANY_CMDS";
	case ERROR_ADAP_HDW_ERR :	    return "ERROR_ADAP_HDW_ERR";
	case ERROR_BAD_NET_RESP :	    return "ERROR_BAD_NET_RESP";
	case ERROR_UNEXP_NET_ERR :	    return "ERROR_UNEXP_NET_ERR";
	case ERROR_BAD_REM_ADAP :	    return "ERROR_BAD_REM_ADAP";
	case ERROR_PRINTQ_FULL :	    return "ERROR_PRINTQ_FULL";
	case ERROR_NO_SPOOL_SPACE :	    return "ERROR_NO_SPOOL_SPACE";
	case ERROR_PRINT_CANCELLED :	    return "ERROR_PRINT_CANCELLED";
	case ERROR_NETNAME_DELETED :	    return "ERROR_NETNAME_DELETED";
	case ERROR_NETWORK_ACCESS_DENIED :  return "ERROR_NETWORK_ACCESS_DENIED";
	case ERROR_BAD_DEV_TYPE :	    return "ERROR_BAD_DEV_TYPE";
	case ERROR_BAD_NET_NAME :	    return "ERROR_BAD_NET_NAME";
	case ERROR_TOO_MANY_NAMES :	    return "ERROR_TOO_MANY_NAMES";
	case ERROR_TOO_MANY_SESS :	    return "ERROR_TOO_MANY_SESS";
	case ERROR_SHARING_PAUSED :	    return "ERROR_SHARING_PAUSED";
	case ERROR_REQ_NOT_ACCEP :	    return "ERROR_REQ_NOT_ACCEP";
	case ERROR_REDIR_PAUSED :	    return "ERROR_REDIR_PAUSED";
	case ERROR_FILE_EXISTS :	    return "ERROR_FILE_EXISTS";
	case ERROR_CANNOT_MAKE :	    return "ERROR_CANNOT_MAKE";
	case ERROR_FAIL_I24 :		    return "ERROR_FAIL_I24";
	case ERROR_OUT_OF_STRUCTURES :	    return "ERROR_OUT_OF_STRUCTURES";
	case ERROR_ALREADY_ASSIGNED :	    return "ERROR_ALREADY_ASSIGNED";
	case ERROR_INVALID_PASSWORD :	    return "ERROR_INVALID_PASSWORD";
	case ERROR_INVALID_PARAMETER :	    return "ERROR_INVALID_PARAMETER";
	case ERROR_NET_WRITE_FAULT :	    return "ERROR_NET_WRITE_FAULT";
	case ERROR_NO_PROC_SLOTS :	    return "ERROR_NO_PROC_SLOTS";
	case ERROR_TOO_MANY_SEMAPHORES :    return "ERROR_TOO_MANY_SEMAPHORES";
	case ERROR_EXCL_SEM_ALREADY_OWNED : return "ERROR_EXCL_SEM_ALREADY_OWNED";
	case ERROR_SEM_IS_SET :		    return "ERROR_SEM_IS_SET";
	case ERROR_TOO_MANY_SEM_REQUESTS :  return "ERROR_TOO_MANY_SEM_REQUESTS";
	case ERROR_INVALID_AT_INTERRUPT_TIME : return "ERROR_INVALID_AT_INTERRUPT_TIME";
	case ERROR_SEM_OWNER_DIED :	    return "ERROR_SEM_OWNER_DIED";
	case ERROR_SEM_USER_LIMIT :	    return "ERROR_SEM_USER_LIMIT";
	case ERROR_DISK_CHANGE :	    return "ERROR_DISK_CHANGE";
	case ERROR_DRIVE_LOCKED :	    return "ERROR_DRIVE_LOCKED";
	case ERROR_BROKEN_PIPE :	    return "ERROR_BROKEN_PIPE";
	case ERROR_OPEN_FAILED :	    return "ERROR_OPEN_FAILED";
	case ERROR_BUFFER_OVERFLOW :	    return "ERROR_BUFFER_OVERFLOW";
	case ERROR_DISK_FULL :		    return "ERROR_DISK_FULL";
	case ERROR_NO_MORE_SEARCH_HANDLES : return "ERROR_NO_MORE_SEARCH_HANDLES";
	case ERROR_INVALID_TARGET_HANDLE :  return "ERROR_INVALID_TARGET_HANDLE";
	case ERROR_INVALID_CATEGORY :	    return "ERROR_INVALID_CATEGORY";
	case ERROR_INVALID_VERIFY_SWITCH :  return "ERROR_INVALID_VERIFY_SWITCH";
	case ERROR_BAD_DRIVER_LEVEL :	    return "ERROR_BAD_DRIVER_LEVEL";
	case ERROR_CALL_NOT_IMPLEMENTED :   return "ERROR_CALL_NOT_IMPLEMENTED";
	case ERROR_SEM_TIMEOUT :	    return "ERROR_SEM_TIMEOUT";
	case ERROR_INSUFFICIENT_BUFFER :    return "ERROR_INSUFFICIENT_BUFFER";
	case ERROR_INVALID_NAME :	    return "ERROR_INVALID_NAME";
	case ERROR_INVALID_LEVEL :	    return "ERROR_INVALID_LEVEL";
	case ERROR_NO_VOLUME_LABEL :	    return "ERROR_NO_VOLUME_LABEL";
	case ERROR_MOD_NOT_FOUND :	    return "ERROR_MOD_NOT_FOUND";
	case ERROR_PROC_NOT_FOUND :	    return "ERROR_PROC_NOT_FOUND";
	case ERROR_WAIT_NO_CHILDREN :	    return "ERROR_WAIT_NO_CHILDREN";
	case ERROR_CHILD_NOT_COMPLETE :	    return "ERROR_CHILD_NOT_COMPLETE";
	case ERROR_DIRECT_ACCESS_HANDLE :   return "ERROR_DIRECT_ACCESS_HANDLE";
	case ERROR_NEGATIVE_SEEK :	    return "ERROR_NEGATIVE_SEEK";
	case ERROR_SEEK_ON_DEVICE :	    return "ERROR_SEEK_ON_DEVICE";
	case ERROR_IS_JOIN_TARGET :	    return "ERROR_IS_JOIN_TARGET";
	case ERROR_IS_JOINED :		    return "ERROR_IS_JOINED";
	case ERROR_IS_SUBSTED :		    return "ERROR_IS_SUBSTED";
	case ERROR_NOT_JOINED :		    return "ERROR_NOT_JOINED";
	case ERROR_NOT_SUBSTED :	    return "ERROR_NOT_SUBSTED";
	case ERROR_JOIN_TO_JOIN :	    return "ERROR_JOIN_TO_JOIN";
	case ERROR_SUBST_TO_SUBST :	    return "ERROR_SUBST_TO_SUBST";
	case ERROR_JOIN_TO_SUBST :	    return "ERROR_JOIN_TO_SUBST";
	case ERROR_SUBST_TO_JOIN :	    return "ERROR_SUBST_TO_JOIN";
	case ERROR_BUSY_DRIVE :		    return "ERROR_BUSY_DRIVE";
	case ERROR_SAME_DRIVE :		    return "ERROR_SAME_DRIVE";
	case ERROR_DIR_NOT_ROOT :	    return "ERROR_DIR_NOT_ROOT";
	case ERROR_DIR_NOT_EMPTY :	    return "ERROR_DIR_NOT_EMPTY";
	case ERROR_IS_SUBST_PATH :	    return "ERROR_IS_SUBST_PATH";
	case ERROR_IS_JOIN_PATH :	    return "ERROR_IS_JOIN_PATH";
	case ERROR_PATH_BUSY :		    return "ERROR_PATH_BUSY";
	case ERROR_IS_SUBST_TARGET :	    return "ERROR_IS_SUBST_TARGET";
	case ERROR_SYSTEM_TRACE :	    return "ERROR_SYSTEM_TRACE";
	case ERROR_INVALID_EVENT_COUNT :    return "ERROR_INVALID_EVENT_COUNT";
	case ERROR_TOO_MANY_MUXWAITERS :    return "ERROR_TOO_MANY_MUXWAITERS";
	case ERROR_INVALID_LIST_FORMAT :    return "ERROR_INVALID_LIST_FORMAT";
	case ERROR_LABEL_TOO_LONG :	    return "ERROR_LABEL_TOO_LONG";
	case ERROR_TOO_MANY_TCBS :	    return "ERROR_TOO_MANY_TCBS";
	case ERROR_SIGNAL_REFUSED :	    return "ERROR_SIGNAL_REFUSED";
	case ERROR_DISCARDED :		    return "ERROR_DISCARDED";
	case ERROR_NOT_LOCKED :		    return "ERROR_NOT_LOCKED";
	case ERROR_BAD_THREADID_ADDR :	    return "ERROR_BAD_THREADID_ADDR";
	case ERROR_BAD_ARGUMENTS :	    return "ERROR_BAD_ARGUMENTS";
	case ERROR_BAD_PATHNAME :	    return "ERROR_BAD_PATHNAME";
	case ERROR_SIGNAL_PENDING :	    return "ERROR_SIGNAL_PENDING";
	case ERROR_MAX_THRDS_REACHED :	    return "ERROR_MAX_THRDS_REACHED";
	case ERROR_LOCK_FAILED :	    return "ERROR_LOCK_FAILED";
	case ERROR_BUSY :		    return "ERROR_BUSY";
	case ERROR_CANCEL_VIOLATION :	    return "ERROR_CANCEL_VIOLATION";
	case ERROR_ATOMIC_LOCKS_NOT_SUPPORTED : return "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED";
	case ERROR_INVALID_SEGMENT_NUMBER : return "ERROR_INVALID_SEGMENT_NUMBER";
	case ERROR_INVALID_ORDINAL :	    return "ERROR_INVALID_ORDINAL";
	case ERROR_ALREADY_EXISTS :	    return "ERROR_ALREADY_EXISTS";
	case ERROR_INVALID_FLAG_NUMBER :    return "ERROR_INVALID_FLAG_NUMBER";
	case ERROR_SEM_NOT_FOUND :	    return "ERROR_SEM_NOT_FOUND";
	case ERROR_INVALID_STARTING_CODESEG : return "ERROR_INVALID_STARTING_CODESEG";
	case ERROR_INVALID_STACKSEG :	    return "ERROR_INVALID_STACKSEG";
	case ERROR_INVALID_MODULETYPE :	    return "ERROR_INVALID_MODULETYPE";
	case ERROR_INVALID_EXE_SIGNATURE :  return "ERROR_INVALID_EXE_SIGNATURE";
	case ERROR_EXE_MARKED_INVALID :	    return "ERROR_EXE_MARKED_INVALID";
	case ERROR_BAD_EXE_FORMAT :	    return "ERROR_BAD_EXE_FORMAT";
	case ERROR_ITERATED_DATA_EXCEEDS_64k : return "ERROR_ITERATED_DATA_EXCEEDS_64k";
	case ERROR_INVALID_MINALLOCSIZE :   return "ERROERROR_INVALID_MINALLOCSIZER_WRITE_FAULT";
	case ERROR_DYNLINK_FROM_INVALID_RING : return "ERROR_DYNLINK_FROM_INVALID_RING";
	case ERROR_IOPL_NOT_ENABLED :	    return "ERROR_IOPL_NOT_ENABLED";
	case ERROR_INVALID_SEGDPL :	    return "ERROR_INVALID_SEGDPL";
	case ERROR_AUTODATASEG_EXCEEDS_64k : return "ERROR_AUTODATASEG_EXCEEDS_64k";
	case ERROR_RING2SEG_MUST_BE_MOVABLE : return "ERROR_RING2SEG_MUST_BE_MOVABLE";
	case ERROR_RELOC_CHAIN_XEEDS_SEGLIM : return "ERROR_RELOC_CHAIN_XEEDS_SEGLIM";
	case ERROR_INFLOOP_IN_RELOC_CHAIN : return "ERROR_INFLOOP_IN_RELOC_CHAIN";
	case ERROR_ENVVAR_NOT_FOUND :	    return "ERROR_ENVVAR_NOT_FOUND";
	case ERROR_NO_SIGNAL_SENT :	    return "ERROR_NO_SIGNAL_SENT";
	case ERROR_FILENAME_EXCED_RANGE :   return "ERROR_FILENAME_EXCED_RANGE";
	case ERROR_RING2_STACK_IN_USE :	    return "ERROR_RING2_STACK_IN_USE";
	case ERROR_META_EXPANSION_TOO_LONG : return "ERROR_META_EXPANSION_TOO_LONG";
	case ERROR_INVALID_SIGNAL_NUMBER :  return "ERROR_INVALID_SIGNAL_NUMBER";
	case ERROR_THREAD_1_INACTIVE :	    return "ERROR_THREAD_1_INACTIVE";
	case ERROR_LOCKED :		    return "ERROR_LOCKED";
	case ERROR_TOO_MANY_MODULES :	    return "ERROR_TOO_MANY_MODULES";
	case ERROR_NESTING_NOT_ALLOWED :    return "ERROR_NESTING_NOT_ALLOWED";
	case ERROR_EXE_MACHINE_TYPE_MISMATCH : return "ERROR_EXE_MACHINE_TYPE_MISMATCH";
	case ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY : return "ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY";
	case ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY : return "ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY";
	case ERROR_BAD_PIPE :		    return "ERROR_BAD_PIPE";
	case ERROR_PIPE_BUSY :		    return "ERROR_PIPE_BUSY";
	case ERROR_NO_DATA :		    return "ERROR_NO_DATA";
	case ERROR_PIPE_NOT_CONNECTED :	    return "ERROR_PIPE_NOT_CONNECTED";
	case ERROR_MORE_DATA :		    return "ERROR_MORE_DATA";
	case ERROR_VC_DISCONNECTED :	    return "ERROR_VC_DISCONNECTED";
	case ERROR_INVALID_EA_NAME :	    return "ERROR_INVALID_EA_NAME";
	case ERROR_EA_LIST_INCONSISTENT :   return "ERROR_EA_LIST_INCONSISTENT";
	case WAIT_TIMEOUT :		    return "WAIT_TIMEOUT";
	case ERROR_NO_MORE_ITEMS :	    return "ERROR_NO_MORE_ITEMS";
	case ERROR_CANNOT_COPY :	    return "ERROR_CANNOT_COPY";
	case ERROR_DIRECTORY :		    return "ERROR_DIRECTORY";
	case ERROR_EAS_DIDNT_FIT :	    return "ERROR_EAS_DIDNT_FIT";
	case ERROR_EA_FILE_CORRUPT :	    return "ERROR_EA_FILE_CORRUPT";
	case ERROR_EA_TABLE_FULL :	    return "ERROR_EA_TABLE_FULL";
	case ERROR_INVALID_EA_HANDLE :	    return "ERROR_INVALID_EA_HANDLE";
	case ERROR_EAS_NOT_SUPPORTED :	    return "ERROR_EAS_NOT_SUPPORTED";
	case ERROR_NOT_OWNER :		    return "ERROR_NOT_OWNER";
	case ERROR_TOO_MANY_POSTS :	    return "ERROR_TOO_MANY_POSTS";
	case ERROR_PARTIAL_COPY :	    return "ERROR_PARTIAL_COPY";
	case ERROR_OPLOCK_NOT_GRANTED :	    return "ERROR_OPLOCK_NOT_GRANTED";
	case ERROR_INVALID_OPLOCK_PROTOCOL : return "ERROR_INVALID_OPLOCK_PROTOCOL";
	case ERROR_DISK_TOO_FRAGMENTED :    return "ERROR_DISK_TOO_FRAGMENTED";
	case ERROR_DELETE_PENDING :	    return "ERROR_DELETE_PENDING";
	case ERROR_MR_MID_NOT_FOUND :	    return "ERROR_MR_MID_NOT_FOUND";
	case ERROR_SCOPE_NOT_FOUND :	    return "ERROR_SCOPE_NOT_FOUND";
	case ERROR_INVALID_ADDRESS :	    return "ERROR_INVALID_ADDRESS";
	case ERROR_ARITHMETIC_OVERFLOW :    return "ERROR_ARITHMETIC_OVERFLOW";
	case ERROR_PIPE_CONNECTED :	    return "ERROR_PIPE_CONNECTED";
	case ERROR_PIPE_LISTENING :	    return "ERROR_PIPE_LISTENING";
	case ERROR_EA_ACCESS_DENIED :	    return "ERROR_EA_ACCESS_DENIED";
	case ERROR_OPERATION_ABORTED :	    return "ERROR_OPERATION_ABORTED";
	case ERROR_IO_INCOMPLETE :	    return "ERROR_IO_INCOMPLETE";
	case ERROR_IO_PENDING :		    return "ERROR_IO_PENDING";
	case ERROR_NOACCESS :		    return "ERROR_NOACCESS";
	case ERROR_SWAPERROR :		    return "ERROR_SWAPERROR";
	case ERROR_STACK_OVERFLOW :	    return "ERROR_STACK_OVERFLOW";
	case ERROR_INVALID_MESSAGE :	    return "ERROR_INVALID_MESSAGE";
	case ERROR_CAN_NOT_COMPLETE :	    return "ERROR_CAN_NOT_COMPLETE";
	case ERROR_INVALID_FLAGS :	    return "ERROR_INVALID_FLAGS";
	case ERROR_UNRECOGNIZED_VOLUME :    return "ERROR_UNRECOGNIZED_VOLUME";
	case ERROR_FILE_INVALID :	    return "ERROR_FILE_INVALID";
	case ERROR_FULLSCREEN_MODE :	    return "ERROR_FULLSCREEN_MODE";
	case ERROR_NO_TOKEN :		    return "ERROR_NO_TOKEN";
	case ERROR_BADDB :		    return "ERROR_BADDB";
	case ERROR_BADKEY :		    return "ERROR_BADKEY";
	case ERROR_CANTOPEN :		    return "ERROR_CANTOPEN";
	case ERROR_CANTREAD :		    return "ERROR_CANTREAD";
	case ERROR_CANTWRITE :		    return "ERROR_CANTWRITE";
	case ERROR_REGISTRY_RECOVERED :	    return "ERROR_REGISTRY_RECOVERED";
	case ERROR_REGISTRY_CORRUPT :	    return "ERROR_REGISTRY_CORRUPT";
	case ERROR_REGISTRY_IO_FAILED :	    return "ERROR_REGISTRY_IO_FAILED";
	case ERROR_NOT_REGISTRY_FILE :	    return "ERROR_NOT_REGISTRY_FILE";
	case ERROR_KEY_DELETED :	    return "ERROR_KEY_DELETED";
	case ERROR_NO_LOG_SPACE :	    return "ERROR_NO_LOG_SPACE";
	case ERROR_KEY_HAS_CHILDREN :	    return "ERROR_KEY_HAS_CHILDREN";
	case ERROR_CHILD_MUST_BE_VOLATILE : return "ERROR_CHILD_MUST_BE_VOLATILE";
	case ERROR_NOTIFY_ENUM_DIR :	    return "ERROR_NOTIFY_ENUM_DIR";
	case ERROR_DEPENDENT_SERVICES_RUNNING : return "ERROR_DEPENDENT_SERVICES_RUNNING";
	case ERROR_INVALID_SERVICE_CONTROL : return "ERROR_INVALID_SERVICE_CONTROL";
	case ERROR_SERVICE_REQUEST_TIMEOUT : return "ERROR_SERVICE_REQUEST_TIMEOUT";
	case ERROR_SERVICE_NO_THREAD :	    return "ERROR_SERVICE_NO_THREAD";
	case ERROR_SERVICE_DATABASE_LOCKED : return "ERROR_SERVICE_DATABASE_LOCKED";
	case ERROR_SERVICE_ALREADY_RUNNING : return "ERROR_SERVICE_ALREADY_RUNNING";
	case ERROR_INVALID_SERVICE_ACCOUNT : return "ERROR_INVALID_SERVICE_ACCOUNT";
	case ERROR_SERVICE_DISABLED :	    return "ERROR_SERVICE_DISABLED";
	case ERROR_CIRCULAR_DEPENDENCY :    return "ERROR_CIRCULAR_DEPENDENCY";
	case ERROR_SERVICE_DOES_NOT_EXIST : return "ERROR_SERVICE_DOES_NOT_EXIST";
	case ERROR_SERVICE_CANNOT_ACCEPT_CTRL : return "ERROR_SERVICE_CANNOT_ACCEPT_CTRL";
	case ERROR_SERVICE_NOT_ACTIVE :	    return "ERROR_SERVICE_NOT_ACTIVE";
	case ERROR_FAILED_SERVICE_CONTROLLER_CONNECT : return "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT";
	case ERROR_EXCEPTION_IN_SERVICE :   return "ERROR_EXCEPTION_IN_SERVICE";
	case ERROR_DATABASE_DOES_NOT_EXIST : return "ERROR_DATABASE_DOES_NOT_EXIST";
	case ERROR_SERVICE_SPECIFIC_ERROR : return "ERROR_SERVICE_SPECIFIC_ERROR";
	case ERROR_PROCESS_ABORTED :	    return "ERROR_PROCESS_ABORTED";
	case ERROR_SERVICE_DEPENDENCY_FAIL : return "ERROR_SERVICE_DEPENDENCY_FAIL";
	case ERROR_SERVICE_LOGON_FAILED :   return "ERROR_SERVICE_LOGON_FAILED";
	case ERROR_SERVICE_START_HANG :	    return "ERROR_SERVICE_START_HANG";
	case ERROR_INVALID_SERVICE_LOCK :   return "ERROR_INVALID_SERVICE_LOCK";
	case ERROR_SERVICE_MARKED_FOR_DELETE : return "ERROR_SERVICE_MARKED_FOR_DELETE";
	case ERROR_SERVICE_EXISTS :	    return "ERROR_SERVICE_EXISTS";
	case ERROR_ALREADY_RUNNING_LKG :    return "ERROR_ALREADY_RUNNING_LKG";
	case ERROR_SERVICE_DEPENDENCY_DELETED : return "ERROR_SERVICE_DEPENDENCY_DELETED";
	case ERROR_BOOT_ALREADY_ACCEPTED :  return "ERROR_BOOT_ALREADY_ACCEPTED";
	case ERROR_SERVICE_NEVER_STARTED :  return "ERROR_SERVICE_NEVER_STARTED";
	case ERROR_DUPLICATE_SERVICE_NAME : return "ERROR_DUPLICATE_SERVICE_NAME";
	case ERROR_DIFFERENT_SERVICE_ACCOUNT : return "ERROR_DIFFERENT_SERVICE_ACCOUNT";
	case ERROR_CANNOT_DETECT_DRIVER_FAILURE : return "ERROR_CANNOT_DETECT_DRIVER_FAILURE";
	case ERROR_CANNOT_DETECT_PROCESS_ABORT : return "ERROR_CANNOT_DETECT_PROCESS_ABORT";
	case ERROR_NO_RECOVERY_PROGRAM :    return "ERROR_NO_RECOVERY_PROGRAM";
	case ERROR_SERVICE_NOT_IN_EXE :	    return "ERROR_SERVICE_NOT_IN_EXE";
	case ERROR_NOT_SAFEBOOT_SERVICE :   return "ERROR_NOT_SAFEBOOT_SERVICE";
	case ERROR_END_OF_MEDIA :	    return "ERROR_END_OF_MEDIA";
	case ERROR_FILEMARK_DETECTED :	    return "ERROR_FILEMARK_DETECTED";
	case ERROR_BEGINNING_OF_MEDIA :	    return "ERROR_BEGINNING_OF_MEDIA";
	case ERROR_SETMARK_DETECTED :	    return "ERROR_SETMARK_DETECTED";
	case ERROR_NO_DATA_DETECTED :	    return "ERROR_NO_DATA_DETECTED";
	case ERROR_PARTITION_FAILURE :	    return "ERROR_PARTITION_FAILURE";
	case ERROR_INVALID_BLOCK_LENGTH :   return "ERROR_INVALID_BLOCK_LENGTH";
	case ERROR_DEVICE_NOT_PARTITIONED : return "ERROR_DEVICE_NOT_PARTITIONED";
	case ERROR_UNABLE_TO_LOCK_MEDIA :   return "ERROR_UNABLE_TO_LOCK_MEDIA";
	case ERROR_MEDIA_CHANGED :	    return "ERROR_MEDIA_CHANGED";
	case ERROR_BUS_RESET :		    return "ERROR_BUS_RESET";
	case ERROR_NO_MEDIA_IN_DRIVE :	    return "ERROR_NO_MEDIA_IN_DRIVE";
	case ERROR_NO_UNICODE_TRANSLATION : return "ERROR_NO_UNICODE_TRANSLATION";
	case ERROR_DLL_INIT_FAILED :	    return "ERROR_DLL_INIT_FAILED";
	case ERROR_SHUTDOWN_IN_PROGRESS :   return "ERROR_SHUTDOWN_IN_PROGRESS";
	case ERROR_NO_SHUTDOWN_IN_PROGRESS : return "ERROR_NO_SHUTDOWN_IN_PROGRESS";
	case ERROR_IO_DEVICE :		    return "ERROR_IO_DEVICE";
	case ERROR_SERIAL_NO_DEVICE :	    return "ERROR_SERIAL_NO_DEVICE";
	case ERROR_IRQ_BUSY :		    return "ERROR_IRQ_BUSY";
	case ERROR_MORE_WRITES :	    return "ERROR_MORE_WRITES";
	case ERROR_COUNTER_TIMEOUT :	    return "ERROR_COUNTER_TIMEOUT";
	case ERROR_FLOPPY_ID_MARK_NOT_FOUND : return "ERROR_FLOPPY_ID_MARK_NOT_FOUND";
	case ERROR_FLOPPY_WRONG_CYLINDER :  return "ERROR_FLOPPY_WRONG_CYLINDER";
	case ERROR_FLOPPY_UNKNOWN_ERROR :   return "ERROR_FLOPPY_UNKNOWN_ERROR";
	case ERROR_FLOPPY_BAD_REGISTERS :   return "ERROR_FLOPPY_BAD_REGISTERS";
	case ERROR_DISK_RECALIBRATE_FAILED : return "ERROR_DISK_RECALIBRATE_FAILED";
	case ERROR_DISK_OPERATION_FAILED :  return "ERROR_DISK_OPERATION_FAILED";
	case ERROR_DISK_RESET_FAILED :	    return "ERROR_DISK_RESET_FAILED";
	case ERROR_EOM_OVERFLOW :	    return "ERROR_EOM_OVERFLOW";
	case ERROR_NOT_ENOUGH_SERVER_MEMORY : return "ERROR_NOT_ENOUGH_SERVER_MEMORY";
	case ERROR_POSSIBLE_DEADLOCK :	    return "ERROR_POSSIBLE_DEADLOCK";
	case ERROR_MAPPED_ALIGNMENT :	    return "ERROR_MAPPED_ALIGNMENT";
	case ERROR_SET_POWER_STATE_VETOED : return "ERROR_SET_POWER_STATE_VETOED";
	case ERROR_SET_POWER_STATE_FAILED : return "ERROR_SET_POWER_STATE_FAILED";
	case ERROR_TOO_MANY_LINKS :	    return "ERROR_TOO_MANY_LINKS";
	case ERROR_OLD_WIN_VERSION :	    return "ERROR_OLD_WIN_VERSION";
	case ERROR_APP_WRONG_OS :	    return "ERROR_APP_WRONG_OS";
	case ERROR_SINGLE_INSTANCE_APP :    return "ERROR_SINGLE_INSTANCE_APP";
	case ERROR_RMODE_APP :		    return "ERROR_RMODE_APP";
	case ERROR_INVALID_DLL :	    return "ERROR_INVALID_DLL";
	case ERROR_NO_ASSOCIATION :	    return "ERROR_NO_ASSOCIATION";
	case ERROR_DDE_FAIL :		    return "ERROR_DDE_FAIL";
	case ERROR_DLL_NOT_FOUND :	    return "ERROR_DLL_NOT_FOUND";
	case ERROR_NO_MORE_USER_HANDLES :   return "ERROR_NO_MORE_USER_HANDLES";
	case ERROR_MESSAGE_SYNC_ONLY :	    return "ERROR_MESSAGE_SYNC_ONLY";
	case ERROR_SOURCE_ELEMENT_EMPTY :   return "ERROR_SOURCE_ELEMENT_EMPTY";
	case ERROR_DESTINATION_ELEMENT_FULL : return "ERROR_DESTINATION_ELEMENT_FULL";
	case ERROR_ILLEGAL_ELEMENT_ADDRESS : return "ERROR_ILLEGAL_ELEMENT_ADDRESS";
	case ERROR_MAGAZINE_NOT_PRESENT :   return "ERROR_MAGAZINE_NOT_PRESENT";
	case ERROR_DEVICE_REINITIALIZATION_NEEDED : return "ERROR_DEVICE_REINITIALIZATION_NEEDED";
	case ERROR_DEVICE_REQUIRES_CLEANING : return "ERROR_DEVICE_REQUIRES_CLEANING";
	case ERROR_DEVICE_DOOR_OPEN :	    return "ERROR_DEVICE_DOOR_OPEN";
	case ERROR_DEVICE_NOT_CONNECTED :   return "ERROR_DEVICE_NOT_CONNECTED";
	case ERROR_NOT_FOUND :		    return "ERROR_NOT_FOUND";
	case ERROR_NO_MATCH :		    return "ERROR_NO_MATCH";
	case ERROR_SET_NOT_FOUND :	    return "ERROR_SET_NOT_FOUND";
	case ERROR_POINT_NOT_FOUND :	    return "ERROR_POINT_NOT_FOUND";
	case ERROR_NO_TRACKING_SERVICE :    return "ERROR_NO_TRACKING_SERVICE";
	case ERROR_NO_VOLUME_ID :	    return "ERROR_NO_VOLUME_ID";
	case ERROR_UNABLE_TO_REMOVE_REPLACED : return "ERROR_UNABLE_TO_REMOVE_REPLACED";
	case ERROR_UNABLE_TO_MOVE_REPLACEMENT : return "ERROR_UNABLE_TO_MOVE_REPLACEMENT";
	case ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 : return "ERROR_UNABLE_TO_MOVE_REPLACEMENT_2";
	case ERROR_JOURNAL_DELETE_IN_PROGRESS : return "ERROR_JOURNAL_DELETE_IN_PROGRESS";
	case ERROR_JOURNAL_NOT_ACTIVE :	    return "ERROR_JOURNAL_NOT_ACTIVE";
	case ERROR_POTENTIAL_FILE_FOUND :   return "ERROR_POTENTIAL_FILE_FOUND";
	case ERROR_JOURNAL_ENTRY_DELETED :  return "ERROR_JOURNAL_ENTRY_DELETED";
	case ERROR_BAD_DEVICE :		    return "ERROR_BAD_DEVICE";
	case ERROR_CONNECTION_UNAVAIL :	    return "ERROR_CONNECTION_UNAVAIL";
	case ERROR_DEVICE_ALREADY_REMEMBERED : return "ERROR_DEVICE_ALREADY_REMEMBERED";
	case ERROR_NO_NET_OR_BAD_PATH :	    return "ERROR_NO_NET_OR_BAD_PATH";
	case ERROR_BAD_PROVIDER :	    return "ERROR_BAD_PROVIDER";
	case ERROR_CANNOT_OPEN_PROFILE :    return "ERROR_CANNOT_OPEN_PROFILE";
	case ERROR_NOT_CONTAINER :	    return "ERROR_NOT_CONTAINER";
	case ERROR_EXTENDED_ERROR :	    return "ERROR_EXTENDED_ERROR";
	case ERROR_INVALID_GROUPNAME :	    return "ERROR_INVALID_GROUPNAME";
	case ERROR_INVALID_COMPUTERNAME :   return "ERROR_INVALID_COMPUTERNAME";
	case ERROR_INVALID_EVENTNAME :	    return "ERROR_INVALID_EVENTNAME";
	case ERROR_INVALID_DOMAINNAME :	    return "ERROR_INVALID_DOMAINNAME";
	case ERROR_INVALID_SERVICENAME :    return "ERROR_INVALID_SERVICENAME";
	case ERROR_INVALID_NETNAME :	    return "ERROR_INVALID_NETNAME";
	case ERROR_INVALID_SHARENAME :	    return "ERROR_INVALID_SHARENAME";
	case ERROR_INVALID_PASSWORDNAME :   return "ERROR_INVALID_PASSWORDNAME";
	case ERROR_INVALID_MESSAGENAME :    return "ERROR_INVALID_MESSAGENAME";
	case ERROR_INVALID_MESSAGEDEST :    return "ERROR_INVALID_MESSAGEDEST";
	case ERROR_SESSION_CREDENTIAL_CONFLICT : return "ERROR_SESSION_CREDENTIAL_CONFLICT";
	case ERROR_REMOTE_SESSION_LIMIT_EXCEEDED : return "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED";
	case ERROR_DUP_DOMAINNAME :	    return "ERROR_DUP_DOMAINNAME";
	case ERROR_NO_NETWORK :		    return "ERROR_NO_NETWORK";
	case ERROR_CANCELLED :		    return "ERROR_CANCELLED";
	case ERROR_USER_MAPPED_FILE :	    return "ERROR_USER_MAPPED_FILE";
	case ERROR_CONNECTION_REFUSED :	    return "ERROR_CONNECTION_REFUSED";
	case ERROR_GRACEFUL_DISCONNECT :    return "ERROR_GRACEFUL_DISCONNECT";
	case ERROR_ADDRESS_ALREADY_ASSOCIATED : return "ERROR_ADDRESS_ALREADY_ASSOCIATED";
	case ERROR_ADDRESS_NOT_ASSOCIATED : return "ERROR_ADDRESS_NOT_ASSOCIATED";
	case ERROR_CONNECTION_INVALID :	    return "ERROR_CONNECTION_INVALID";
	case ERROR_CONNECTION_ACTIVE :	    return "ERROR_CONNECTION_ACTIVE";
	case ERROR_NETWORK_UNREACHABLE :    return "ERROR_NETWORK_UNREACHABLE";
	case ERROR_HOST_UNREACHABLE :	    return "ERROR_HOST_UNREACHABLE";
	case ERROR_PROTOCOL_UNREACHABLE :   return "ERROR_PROTOCOL_UNREACHABLE";
	case ERROR_PORT_UNREACHABLE :	    return "ERROR_PORT_UNREACHABLE";
	case ERROR_REQUEST_ABORTED :	    return "ERROR_REQUEST_ABORTED";
	case ERROR_CONNECTION_ABORTED :	    return "ERROR_CONNECTION_ABORTED";
	case ERROR_RETRY :		    return "ERROR_RETRY";
	case ERROR_CONNECTION_COUNT_LIMIT : return "ERROR_CONNECTION_COUNT_LIMIT";
	case ERROR_LOGIN_TIME_RESTRICTION : return "ERROR_LOGIN_TIME_RESTRICTION";
	case ERROR_LOGIN_WKSTA_RESTRICTION : return "ERROR_LOGIN_WKSTA_RESTRICTION";
	case ERROR_INCORRECT_ADDRESS :	    return "ERROR_INCORRECT_ADDRESS";
	case ERROR_ALREADY_REGISTERED :	    return "ERROR_ALREADY_REGISTERED";
	case ERROR_SERVICE_NOT_FOUND :	    return "ERROR_SERVICE_NOT_FOUND";
	case ERROR_NOT_AUTHENTICATED :	    return "ERROR_NOT_AUTHENTICATED";
	case ERROR_NOT_LOGGED_ON :	    return "ERROR_NOT_LOGGED_ON";
	case ERROR_CONTINUE :		    return "ERROR_CONTINUE";
	case ERROR_ALREADY_INITIALIZED :    return "ERROR_ALREADY_INITIALIZED";
	case ERROR_NO_MORE_DEVICES :	    return "ERROR_NO_MORE_DEVICES";
	case ERROR_NO_SUCH_SITE :	    return "ERROR_NO_SUCH_SITE";
	case ERROR_DOMAIN_CONTROLLER_EXISTS : return "ERROR_DOMAIN_CONTROLLER_EXISTS";
	case ERROR_ONLY_IF_CONNECTED :	    return "ERROR_ONLY_IF_CONNECTED";
	case ERROR_OVERRIDE_NOCHANGES :	    return "ERROR_OVERRIDE_NOCHANGES";
	case ERROR_BAD_USER_PROFILE :	    return "ERROR_BAD_USER_PROFILE";
	case ERROR_NOT_SUPPORTED_ON_SBS :   return "ERROR_NOT_SUPPORTED_ON_SBS";
	case ERROR_SERVER_SHUTDOWN_IN_PROGRESS : return "ERROR_SERVER_SHUTDOWN_IN_PROGRESS";
	case ERROR_HOST_DOWN :		    return "ERROR_HOST_DOWN";
	case ERROR_NON_ACCOUNT_SID :	    return "ERROR_NON_ACCOUNT_SID";
	case ERROR_NON_DOMAIN_SID :	    return "ERROR_NON_DOMAIN_SID";
	case ERROR_APPHELP_BLOCK :	    return "ERROR_APPHELP_BLOCK";
	case ERROR_ACCESS_DISABLED_BY_POLICY : return "ERROR_ACCESS_DISABLED_BY_POLICY";
	case ERROR_REG_NAT_CONSUMPTION :    return "ERROR_REG_NAT_CONSUMPTION";
	case ERROR_CSCSHARE_OFFLINE :	    return "ERROR_CSCSHARE_OFFLINE";
	case ERROR_PKINIT_FAILURE :	    return "ERROR_PKINIT_FAILURE";
	case ERROR_SMARTCARD_SUBSYSTEM_FAILURE : return "ERROR_SMARTCARD_SUBSYSTEM_FAILURE";
	case ERROR_DOWNGRADE_DETECTED :	    return "ERROR_DOWNGRADE_DETECTED";
	case ERROR_MACHINE_LOCKED :	    return "ERROR_MACHINE_LOCKED";
	case ERROR_CALLBACK_SUPPLIED_INVALID_DATA : return "ERROR_CALLBACK_SUPPLIED_INVALID_DATA";
	case ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED : return "ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED";
	case ERROR_DRIVER_BLOCKED :	    return "ERROR_DRIVER_BLOCKED";
	case ERROR_INVALID_IMPORT_OF_NON_DLL : return "ERROR_INVALID_IMPORT_OF_NON_DLL";
	case ERROR_ACCESS_DISABLED_WEBBLADE : return "ERROR_ACCESS_DISABLED_WEBBLADE";
	case ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER : return "ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER";
	case ERROR_RECOVERY_FAILURE :	    return "ERROR_RECOVERY_FAILURE";
	case ERROR_ALREADY_FIBER :	    return "ERROR_ALREADY_FIBER";
	case ERROR_ALREADY_THREAD :	    return "ERROR_ALREADY_THREAD";
	case ERROR_STACK_BUFFER_OVERRUN :   return "ERROR_STACK_BUFFER_OVERRUN";
	case ERROR_PARAMETER_QUOTA_EXCEEDED : return "ERROR_PARAMETER_QUOTA_EXCEEDED";
	case ERROR_DEBUGGER_INACTIVE :	    return "ERROR_DEBUGGER_INACTIVE";
	case ERROR_DELAY_LOAD_FAILED :	    return "ERROR_DELAY_LOAD_FAILED";
	case ERROR_VDM_DISALLOWED :	    return "ERROR_VDM_DISALLOWED";
	case ERROR_UNIDENTIFIED_ERROR :	    return "ERROR_UNIDENTIFIED_ERROR";
	// Security Status Codes .....
	case ERROR_NOT_ALL_ASSIGNED :	    return "ERROR_NOT_ALL_ASSIGNED";
	case ERROR_SOME_NOT_MAPPED :	    return "ERROR_SOME_NOT_MAPPED";
	case ERROR_NO_QUOTAS_FOR_ACCOUNT :  return "ERROR_NO_QUOTAS_FOR_ACCOUNT";
	case ERROR_LOCAL_USER_SESSION_KEY : return "ERROR_LOCAL_USER_SESSION_KEY";
	case ERROR_NULL_LM_PASSWORD :	    return "ERROR_NULL_LM_PASSWORD";
	case ERROR_UNKNOWN_REVISION :	    return "ERROR_UNKNOWN_REVISION";
	case ERROR_REVISION_MISMATCH :	    return "ERROR_REVISION_MISMATCH";
	case ERROR_INVALID_OWNER :	    return "ERROR_INVALID_OWNER";
	case ERROR_INVALID_PRIMARY_GROUP :  return "ERROR_INVALID_PRIMARY_GROUP";
	case ERROR_NO_IMPERSONATION_TOKEN : return "ERROR_NO_IMPERSONATION_TOKEN";
	case ERROR_CANT_DISABLE_MANDATORY : return "ERROR_CANT_DISABLE_MANDATORY";
	case ERROR_NO_LOGON_SERVERS :	    return "ERROR_NO_LOGON_SERVERS";
	case ERROR_NO_SUCH_LOGON_SESSION :  return "ERROR_NO_SUCH_LOGON_SESSION";
	case ERROR_NO_SUCH_PRIVILEGE :	    return "ERROR_NO_SUCH_PRIVILEGE";
	case ERROR_PRIVILEGE_NOT_HELD :	    return "ERROR_PRIVILEGE_NOT_HELD";
	case ERROR_INVALID_ACCOUNT_NAME :   return "ERROR_INVALID_ACCOUNT_NAME";
	case ERROR_USER_EXISTS :	    return "ERROR_USER_EXISTS";
	case ERROR_NO_SUCH_USER :	    return "ERROR_NO_SUCH_USER";
	case ERROR_GROUP_EXISTS :	    return "ERROR_GROUP_EXISTS";
	case ERROR_NO_SUCH_GROUP :	    return "ERROR_NO_SUCH_GROUP";
	case ERROR_MEMBER_IN_GROUP :	    return "ERROR_MEMBER_IN_GROUP";
	case ERROR_LAST_ADMIN :		    return "ERROR_LAST_ADMIN";
	case ERROR_WRONG_PASSWORD :	    return "ERROR_WRONG_PASSWORD";
	case ERROR_ILL_FORMED_PASSWORD :    return "ERROR_ILL_FORMED_PASSWORD";
	case ERROR_PASSWORD_RESTRICTION :   return "ERROR_PASSWORD_RESTRICTION";
	case ERROR_LOGON_FAILURE :	    return "ERROR_LOGON_FAILURE";
	case ERROR_ACCOUNT_RESTRICTION :    return "ERROR_ACCOUNT_RESTRICTION";
	case ERROR_INVALID_LOGON_HOURS :    return "ERROR_INVALID_LOGON_HOURS";
	case ERROR_INVALID_WORKSTATION :    return "ERROR_INVALID_WORKSTATION";
	case ERROR_PASSWORD_EXPIRED :	    return "ERROR_PASSWORD_EXPIRED";
	case ERROR_ACCOUNT_DISABLED :	    return "ERROR_ACCOUNT_DISABLED";
	case ERROR_NONE_MAPPED :	    return "ERROR_NONE_MAPPED";
	case ERROR_TOO_MANY_LUIDS_REQUESTED : return "ERROR_TOO_MANY_LUIDS_REQUESTED";
	case ERROR_LUIDS_EXHAUSTED :	    return "ERROR_LUIDS_EXHAUSTED";
	case ERROR_INVALID_SUB_AUTHORITY :  return "ERROR_INVALID_SUB_AUTHORITY";
	case ERROR_INVALID_ACL :	    return "ERROR_INVALID_ACL";
	case ERROR_INVALID_SID :	    return "ERROR_INVALID_SID";
	case ERROR_INVALID_SECURITY_DESCR : return "ERROR_INVALID_SECURITY_DESCR";
	case ERROR_BAD_INHERITANCE_ACL :    return "ERROR_BAD_INHERITANCE_ACL";
	case ERROR_SERVER_DISABLED :	    return "ERROR_SERVER_DISABLED";
	case ERROR_SERVER_NOT_DISABLED :    return "ERROR_SERVER_NOT_DISABLED";
	case ERROR_INVALID_ID_AUTHORITY :   return "ERROR_INVALID_ID_AUTHORITY";
	case ERROR_ALLOTTED_SPACE_EXCEEDED : return "ERROR_ALLOTTED_SPACE_EXCEEDED";
	case ERROR_INVALID_GROUP_ATTRIBUTES : return "ERROR_INVALID_GROUP_ATTRIBUTES";
	case ERROR_BAD_IMPERSONATION_LEVEL : return "ERROR_BAD_IMPERSONATION_LEVEL";
	case ERROR_CANT_OPEN_ANONYMOUS :    return "ERROR_CANT_OPEN_ANONYMOUS";
	case ERROR_BAD_VALIDATION_CLASS :   return "ERROR_BAD_VALIDATION_CLASS";
	case ERROR_BAD_TOKEN_TYPE :	    return "ERROR_BAD_TOKEN_TYPE";
	case ERROR_NO_SECURITY_ON_OBJECT :  return "ERROR_NO_SECURITY_ON_OBJECT";
	case ERROR_CANT_ACCESS_DOMAIN_INFO : return "ERROR_CANT_ACCESS_DOMAIN_INFO";
	case ERROR_INVALID_SERVER_STATE :   return "ERROR_INVALID_SERVER_STATE";
	case ERROR_INVALID_DOMAIN_STATE :   return "ERROR_INVALID_DOMAIN_STATE";
	case ERROR_INVALID_DOMAIN_ROLE :    return "ERROR_INVALID_DOMAIN_ROLE";
	case ERROR_NO_SUCH_DOMAIN :	    return "ERROR_NO_SUCH_DOMAIN";
	case ERROR_DOMAIN_EXISTS :	    return "ERROR_DOMAIN_EXISTS";
	case ERROR_DOMAIN_LIMIT_EXCEEDED :  return "ERROR_DOMAIN_LIMIT_EXCEEDED";
	case ERROR_INTERNAL_DB_CORRUPTION : return "ERROR_INTERNAL_DB_CORRUPTION";
	case ERROR_INTERNAL_ERROR :	    return "ERROR_INTERNAL_ERROR";
	case ERROR_GENERIC_NOT_MAPPED :	    return "ERROR_GENERIC_NOT_MAPPED";
	case ERROR_BAD_DESCRIPTOR_FORMAT :  return "ERROR_BAD_DESCRIPTOR_FORMAT";
	case ERROR_NOT_LOGON_PROCESS :	    return "ERROR_NOT_LOGON_PROCESS";
	case ERROR_LOGON_SESSION_EXISTS :   return "ERROR_LOGON_SESSION_EXISTS";
	case ERROR_NO_SUCH_PACKAGE :	    return "ERROR_NO_SUCH_PACKAGE";
	case ERROR_BAD_LOGON_SESSION_STATE : return "ERROR_BAD_LOGON_SESSION_STATE";
	case ERROR_LOGON_SESSION_COLLISION : return "ERROR_LOGON_SESSION_COLLISION";
	case ERROR_INVALID_LOGON_TYPE :	    return "ERROR_INVALID_LOGON_TYPE";
	case ERROR_CANNOT_IMPERSONATE :	    return "ERROR_CANNOT_IMPERSONATE";
	case ERROR_RXACT_INVALID_STATE :    return "ERROR_RXACT_INVALID_STATE";
	case ERROR_RXACT_COMMIT_FAILURE :   return "ERROR_RXACT_COMMIT_FAILURE";
	case ERROR_SPECIAL_ACCOUNT :	    return "ERROR_SPECIAL_ACCOUNT";
	case ERROR_SPECIAL_GROUP :	    return "ERROR_SPECIAL_GROUP";
	case ERROR_SPECIAL_USER :	    return "ERROR_SPECIAL_USER";
	case ERROR_MEMBERS_PRIMARY_GROUP :  return "ERROR_MEMBERS_PRIMARY_GROUP";
	case ERROR_TOKEN_ALREADY_IN_USE :   return "ERROR_TOKEN_ALREADY_IN_USE";
	case ERROR_NO_SUCH_ALIAS :	    return "ERROR_NO_SUCH_ALIAS";
	case ERROR_MEMBER_NOT_IN_ALIAS :    return "ERROR_MEMBER_NOT_IN_ALIAS";
	case ERROR_MEMBER_IN_ALIAS :	    return "ERROR_MEMBER_IN_ALIAS";
	case ERROR_ALIAS_EXISTS :	    return "ERROR_ALIAS_EXISTS";
	case ERROR_LOGON_NOT_GRANTED :	    return "ERROR_LOGON_NOT_GRANTED";
	case ERROR_TOO_MANY_SECRETS :	    return "ERROR_TOO_MANY_SECRETS";
	case ERROR_SECRET_TOO_LONG :	    return "ERROR_SECRET_TOO_LONG";
	case ERROR_INTERNAL_DB_ERROR :	    return "ERROR_INTERNAL_DB_ERROR";
	case ERROR_TOO_MANY_CONTEXT_IDS :   return "ERROR_TOO_MANY_CONTEXT_IDS";
	case ERROR_LOGON_TYPE_NOT_GRANTED : return "ERROR_LOGON_TYPE_NOT_GRANTED";
	case ERROR_NT_CROSS_ENCRYPTION_REQUIRED : return "ERROR_NT_CROSS_ENCRYPTION_REQUIRED";
	case ERROR_NO_SUCH_MEMBER :	    return "ERROR_NO_SUCH_MEMBER";
	case ERROR_INVALID_MEMBER :	    return "ERROR_INVALID_MEMBER";
	case ERROR_TOO_MANY_SIDS :	    return "ERROR_TOO_MANY_SIDS";
	case ERROR_LM_CROSS_ENCRYPTION_REQUIRED : return "ERROR_LM_CROSS_ENCRYPTION_REQUIRED";
	case ERROR_NO_INHERITANCE :	    return "ERROR_NO_INHERITANCE";
	case ERROR_FILE_CORRUPT :	    return "ERROR_FILE_CORRUPT";
	case ERROR_DISK_CORRUPT :	    return "ERROR_DISK_CORRUPT";
	case ERROR_NO_USER_SESSION_KEY :    return "ERROR_NO_USER_SESSION_KEY";
	case ERROR_LICENSE_QUOTA_EXCEEDED : return "ERROR_LICENSE_QUOTA_EXCEEDED";
	case ERROR_WRONG_TARGET_NAME :	    return "ERROR_WRONG_TARGET_NAME";
	case ERROR_MUTUAL_AUTH_FAILED :	    return "ERROR_MUTUAL_AUTH_FAILED";
	case ERROR_TIME_SKEW :		    return "ERROR_TIME_SKEW";
	case ERROR_CURRENT_DOMAIN_NOT_ALLOWED : return "ERROR_CURRENT_DOMAIN_NOT_ALLOWED";
	// WinUser Error Codes
	case ERROR_INVALID_WINDOW_HANDLE :  return "ERROR_INVALID_WINDOW_HANDLE";
	case ERROR_INVALID_MENU_HANDLE :    return "ERROR_INVALID_MENU_HANDLE";
	case ERROR_INVALID_CURSOR_HANDLE :  return "ERROR_INVALID_CURSOR_HANDLE";
	case ERROR_INVALID_ACCEL_HANDLE :   return "ERROR_INVALID_ACCEL_HANDLE";
	case ERROR_INVALID_HOOK_HANDLE :    return "ERROR_INVALID_HOOK_HANDLE";
	case ERROR_INVALID_DWP_HANDLE :	    return "ERROR_INVALID_DWP_HANDLE";
	case ERROR_TLW_WITH_WSCHILD :	    return "ERROR_TLW_WITH_WSCHILD";
	case ERROR_CANNOT_FIND_WND_CLASS :  return "ERROR_CANNOT_FIND_WND_CLASS";
	case ERROR_WINDOW_OF_OTHER_THREAD : return "ERROR_WINDOW_OF_OTHER_THREAD";
	case ERROR_HOTKEY_ALREADY_REGISTERED : return "ERROR_HOTKEY_ALREADY_REGISTERED";
	case ERROR_CLASS_ALREADY_EXISTS :   return "ERROR_CLASS_ALREADY_EXISTS";
	case ERROR_CLASS_DOES_NOT_EXIST :   return "ERROR_CLASS_DOES_NOT_EXIST";
	case ERROR_CLASS_HAS_WINDOWS :	    return "ERROR_CLASS_HAS_WINDOWS";
	case ERROR_INVALID_INDEX :	    return "ERROR_INVALID_INDEX";
	case ERROR_INVALID_ICON_HANDLE :    return "ERROR_INVALID_ICON_HANDLE";
	case ERROR_PRIVATE_DIALOG_INDEX :   return "ERROR_PRIVATE_DIALOG_INDEX";
	case ERROR_LISTBOX_ID_NOT_FOUND :   return "ERROR_LISTBOX_ID_NOT_FOUND";
	case ERROR_NO_WILDCARD_CHARACTERS : return "ERROR_NO_WILDCARD_CHARACTERS";
	case ERROR_CLIPBOARD_NOT_OPEN :	    return "ERROR_CLIPBOARD_NOT_OPEN";
	case ERROR_HOTKEY_NOT_REGISTERED :  return "ERROR_HOTKEY_NOT_REGISTERED";
	case ERROR_WINDOW_NOT_DIALOG :	    return "ERROR_WINDOW_NOT_DIALOG";
	case ERROR_CONTROL_ID_NOT_FOUND :   return "ERROR_CONTROL_ID_NOT_FOUND";
	case ERROR_INVALID_COMBOBOX_MESSAGE : return "ERROR_INVALID_COMBOBOX_MESSAGE";
	case ERROR_WINDOW_NOT_COMBOBOX :    return "ERROR_WINDOW_NOT_COMBOBOX";
	case ERROR_INVALID_EDIT_HEIGHT :    return "ERROR_INVALID_EDIT_HEIGHT";
	case ERROR_DC_NOT_FOUND :	    return "ERROR_DC_NOT_FOUND";
	case ERROR_INVALID_HOOK_FILTER :    return "ERROR_INVALID_HOOK_FILTER";
	case ERROR_INVALID_FILTER_PROC :    return "ERROR_INVALID_FILTER_PROC";
	case ERROR_HOOK_NEEDS_HMOD :	    return "ERROR_HOOK_NEEDS_HMOD";
	case ERROR_GLOBAL_ONLY_HOOK :	    return "ERROR_GLOBAL_ONLY_HOOK";
	case ERROR_JOURNAL_HOOK_SET :	    return "ERROR_JOURNAL_HOOK_SET";
	case ERROR_HOOK_NOT_INSTALLED :	    return "ERROR_HOOK_NOT_INSTALLED";
	case ERROR_INVALID_LB_MESSAGE :	    return "ERROR_INVALID_LB_MESSAGE";
	case ERROR_SETCOUNT_ON_BAD_LB :	    return "ERROR_SETCOUNT_ON_BAD_LB";
	case ERROR_LB_WITHOUT_TABSTOPS :    return "ERROR_LB_WITHOUT_TABSTOPS";
	case ERROR_DESTROY_OBJECT_OF_OTHER_THREAD : return "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD";
	case ERROR_CHILD_WINDOW_MENU :	    return "ERROR_CHILD_WINDOW_MENU";
	case ERROR_NO_SYSTEM_MENU :	    return "ERROR_NO_SYSTEM_MENU";
	case ERROR_INVALID_MSGBOX_STYLE :   return "ERROR_INVALID_MSGBOX_STYLE";
	case ERROR_INVALID_SPI_VALUE :	    return "ERROR_INVALID_SPI_VALUE";
	case ERROR_SCREEN_ALREADY_LOCKED :  return "ERROR_SCREEN_ALREADY_LOCKED";
	case ERROR_HWNDS_HAVE_DIFF_PARENT : return "ERROR_HWNDS_HAVE_DIFF_PARENT";
	case ERROR_NOT_CHILD_WINDOW :	    return "ERROR_NOT_CHILD_WINDOW";
	case ERROR_INVALID_GW_COMMAND :	    return "ERROR_INVALID_GW_COMMAND";
	case ERROR_INVALID_THREAD_ID :	    return "ERROR_INVALID_THREAD_ID";
	case ERROR_NON_MDICHILD_WINDOW :    return "ERROR_NON_MDICHILD_WINDOW";
	case ERROR_POPUP_ALREADY_ACTIVE :   return "ERROR_POPUP_ALREADY_ACTIVE";
	case ERROR_NO_SCROLLBARS :	    return "ERROR_NO_SCROLLBARS";
	case ERROR_INVALID_SCROLLBAR_RANGE : return "ERROR_INVALID_SCROLLBAR_RANGE";
	case ERROR_INVALID_SHOWWIN_COMMAND : return "ERROR_INVALID_SHOWWIN_COMMAND";
	case ERROR_NO_SYSTEM_RESOURCES :    return "ERROR_NO_SYSTEM_RESOURCES";
	case ERROR_NONPAGED_SYSTEM_RESOURCES : return "ERROR_NONPAGED_SYSTEM_RESOURCES";
	case ERROR_PAGED_SYSTEM_RESOURCES : return "ERROR_PAGED_SYSTEM_RESOURCES";
	case ERROR_WORKING_SET_QUOTA :	    return "ERROR_WORKING_SET_QUOTA";
	case ERROR_PAGEFILE_QUOTA :	    return "ERROR_PAGEFILE_QUOTA";
	case ERROR_COMMITMENT_LIMIT :	    return "ERROR_COMMITMENT_LIMIT";
	case ERROR_MENU_ITEM_NOT_FOUND :    return "ERROR_MENU_ITEM_NOT_FOUND";
	case ERROR_INVALID_KEYBOARD_HANDLE : return "ERROR_INVALID_KEYBOARD_HANDLE";
	case ERROR_HOOK_TYPE_NOT_ALLOWED :  return "ERROR_HOOK_TYPE_NOT_ALLOWED";
	case ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION : return "ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION";
	case ERROR_TIMEOUT :		    return "ERROR_TIMEOUT";
	case ERROR_INVALID_MONITOR_HANDLE : return "ERROR_INVALID_MONITOR_HANDLE";
	// Eventlog Status Codes
	case ERROR_EVENTLOG_FILE_CORRUPT :  return "ERROR_EVENTLOG_FILE_CORRUPT";
	case ERROR_EVENTLOG_CANT_START :    return "ERROR_EVENTLOG_CANT_START";
	case ERROR_LOG_FILE_FULL :	    return "ERROR_LOG_FILE_FULL";
	case ERROR_EVENTLOG_FILE_CHANGED :  return "ERROR_EVENTLOG_FILE_CHANGED";
	// MSI Error Codes
	case ERROR_INSTALL_SERVICE_FAILURE : return "ERROR_INSTALL_SERVICE_FAILURE";
	case ERROR_INSTALL_USEREXIT :	    return "ERROR_INSTALL_USEREXIT";
	case ERROR_INSTALL_FAILURE :	    return "ERROR_INSTALL_FAILURE";
	case ERROR_INSTALL_SUSPEND :	    return "ERROR_INSTALL_SUSPEND";
	case ERROR_UNKNOWN_PRODUCT :	    return "ERROR_UNKNOWN_PRODUCT";
	case ERROR_UNKNOWN_FEATURE :	    return "ERROR_UNKNOWN_FEATURE";
	case ERROR_UNKNOWN_COMPONENT :	    return "ERROR_UNKNOWN_COMPONENT";
	case ERROR_UNKNOWN_PROPERTY :	    return "ERROR_UNKNOWN_PROPERTY";
	case ERROR_INVALID_HANDLE_STATE :   return "ERROR_INVALID_HANDLE_STATE";
	case ERROR_BAD_CONFIGURATION :	    return "ERROR_BAD_CONFIGURATION";
	case ERROR_INDEX_ABSENT :	    return "ERROR_INDEX_ABSENT";
	case ERROR_INSTALL_SOURCE_ABSENT :  return "ERROR_INSTALL_SOURCE_ABSENT";
	case ERROR_INSTALL_PACKAGE_VERSION : return "ERROR_INSTALL_PACKAGE_VERSION";
	case ERROR_PRODUCT_UNINSTALLED :    return "ERROR_PRODUCT_UNINSTALLED";
	case ERROR_BAD_QUERY_SYNTAX :	    return "ERROR_BAD_QUERY_SYNTAX";
	case ERROR_INVALID_FIELD :	    return "ERROR_INVALID_FIELD";
	case ERROR_DEVICE_REMOVED :	    return "ERROR_DEVICE_REMOVED";
	case ERROR_INSTALL_ALREADY_RUNNING : return "ERROR_INSTALL_ALREADY_RUNNING";
	case ERROR_INSTALL_PACKAGE_OPEN_FAILED : return "ERROR_INSTALL_PACKAGE_OPEN_FAILED";
	case ERROR_INSTALL_PACKAGE_INVALID : return "ERROR_INSTALL_PACKAGE_INVALID";
	case ERROR_INSTALL_UI_FAILURE :	    return "ERROR_INSTALL_UI_FAILURE";
	case ERROR_INSTALL_LOG_FAILURE :    return "ERROR_INSTALL_LOG_FAILURE";
	case ERROR_INSTALL_LANGUAGE_UNSUPPORTED : return "ERROR_INSTALL_LANGUAGE_UNSUPPORTED";
	case ERROR_INSTALL_TRANSFORM_FAILURE : return "ERROR_INSTALL_TRANSFORM_FAILURE";
	case ERROR_INSTALL_PACKAGE_REJECTED : return "ERROR_INSTALL_PACKAGE_REJECTED";
	case ERROR_FUNCTION_NOT_CALLED :    return "ERROR_FUNCTION_NOT_CALLED";
	case ERROR_FUNCTION_FAILED :	    return "ERROR_FUNCTION_FAILED";
	case ERROR_INVALID_TABLE :	    return "ERROR_INVALID_TABLE";
	case ERROR_DATATYPE_MISMATCH :	    return "ERROR_DATATYPE_MISMATCH";
	case ERROR_UNSUPPORTED_TYPE :	    return "ERROR_UNSUPPORTED_TYPE";
	case ERROR_CREATE_FAILED :	    return "ERROR_CREATE_FAILED";
	case ERROR_INSTALL_TEMP_UNWRITABLE : return "ERROR_INSTALL_TEMP_UNWRITABLE";
	case ERROR_INSTALL_PLATFORM_UNSUPPORTED : return "ERROR_INSTALL_PLATFORM_UNSUPPORTED";
	case ERROR_INSTALL_NOTUSED :	    return "ERROR_INSTALL_NOTUSED";
	case ERROR_PATCH_PACKAGE_OPEN_FAILED : return "ERROR_PATCH_PACKAGE_OPEN_FAILED";
	case ERROR_PATCH_PACKAGE_INVALID :  return "ERROR_PATCH_PACKAGE_INVALID";
	case ERROR_PATCH_PACKAGE_UNSUPPORTED : return "ERROR_PATCH_PACKAGE_UNSUPPORTED";
	case ERROR_PRODUCT_VERSION :	    return "ERROR_PRODUCT_VERSION";
	case ERROR_INVALID_COMMAND_LINE :   return "ERROR_INVALID_COMMAND_LINE";
	case ERROR_INSTALL_REMOTE_DISALLOWED : return "ERROR_INSTALL_REMOTE_DISALLOWED";
	case ERROR_SUCCESS_REBOOT_INITIATED : return "ERROR_SUCCESS_REBOOT_INITIATED";
	case ERROR_PATCH_TARGET_NOT_FOUND : return "ERROR_PATCH_TARGET_NOT_FOUND";
	case ERROR_PATCH_PACKAGE_REJECTED : return "ERROR_PATCH_PACKAGE_REJECTED";
	case ERROR_INSTALL_TRANSFORM_REJECTED : return "ERROR_INSTALL_TRANSFORM_REJECTED";
	case ERROR_INSTALL_REMOTE_PROHIBITED : return "ERROR_INSTALL_REMOTE_PROHIBITED";
	//   RPC Status Codes
	case RPC_S_INVALID_STRING_BINDING : return "RPC_S_INVALID_STRING_BINDING";
	case RPC_S_WRONG_KIND_OF_BINDING :  return "RPC_S_WRONG_KIND_OF_BINDING";
	case RPC_S_INVALID_BINDING :	    return "RPC_S_INVALID_BINDING";
	case RPC_S_PROTSEQ_NOT_SUPPORTED :  return "RPC_S_PROTSEQ_NOT_SUPPORTED";
	case RPC_S_INVALID_RPC_PROTSEQ :    return "RPC_S_INVALID_RPC_PROTSEQ";
	case RPC_S_INVALID_STRING_UUID :    return "RPC_S_INVALID_STRING_UUID";
	case RPC_S_INVALID_ENDPOINT_FORMAT : return "RPC_S_INVALID_ENDPOINT_FORMAT";
	case RPC_S_INVALID_NET_ADDR :	    return "RPC_S_INVALID_NET_ADDR";
	case RPC_S_NO_ENDPOINT_FOUND :	    return "RPC_S_NO_ENDPOINT_FOUND";
	case RPC_S_INVALID_TIMEOUT :	    return "RPC_S_INVALID_TIMEOUT";
	case RPC_S_OBJECT_NOT_FOUND :	    return "RPC_S_OBJECT_NOT_FOUND";
	case RPC_S_ALREADY_REGISTERED :	    return "RPC_S_ALREADY_REGISTERED";
	case RPC_S_TYPE_ALREADY_REGISTERED : return "RPC_S_TYPE_ALREADY_REGISTERED";
	case RPC_S_ALREADY_LISTENING :	    return "RPC_S_ALREADY_LISTENING";
	case RPC_S_NO_PROTSEQS_REGISTERED : return "RPC_S_NO_PROTSEQS_REGISTERED";
	case RPC_S_NOT_LISTENING :	    return "RPC_S_NOT_LISTENING";
	case RPC_S_UNKNOWN_MGR_TYPE :	    return "RPC_S_UNKNOWN_MGR_TYPE";
	case RPC_S_UNKNOWN_IF :		    return "RPC_S_UNKNOWN_IF";
	case RPC_S_NO_BINDINGS :	    return "RPC_S_NO_BINDINGS";
	case RPC_S_NO_PROTSEQS :	    return "RPC_S_NO_PROTSEQS";
	case RPC_S_CANT_CREATE_ENDPOINT :   return "RPC_S_CANT_CREATE_ENDPOINT";
	case RPC_S_OUT_OF_RESOURCES :	    return "RPC_S_OUT_OF_RESOURCES";
	case RPC_S_SERVER_UNAVAILABLE :	    return "RPC_S_SERVER_UNAVAILABLE";
	case RPC_S_SERVER_TOO_BUSY :	    return "RPC_S_SERVER_TOO_BUSY";
	case RPC_S_INVALID_NETWORK_OPTIONS : return "RPC_S_INVALID_NETWORK_OPTIONS";
	case RPC_S_NO_CALL_ACTIVE :	    return "RPC_S_NO_CALL_ACTIVE";
	case RPC_S_CALL_FAILED :	    return "RPC_S_CALL_FAILED";
	case RPC_S_CALL_FAILED_DNE :	    return "RPC_S_CALL_FAILED_DNE";
	case RPC_S_PROTOCOL_ERROR :	    return "RPC_S_PROTOCOL_ERROR";
	case RPC_S_UNSUPPORTED_TRANS_SYN :  return "RPC_S_UNSUPPORTED_TRANS_SYN";
	case RPC_S_UNSUPPORTED_TYPE :	    return "RPC_S_UNSUPPORTED_TYPE";
	case RPC_S_INVALID_TAG :	    return "RPC_S_INVALID_TAG";
	case RPC_S_INVALID_BOUND :	    return "RPC_S_INVALID_BOUND";
	case RPC_S_NO_ENTRY_NAME :	    return "RPC_S_NO_ENTRY_NAME";
	case RPC_S_INVALID_NAME_SYNTAX :    return "RPC_S_INVALID_NAME_SYNTAX";
	case RPC_S_UNSUPPORTED_NAME_SYNTAX : return "RPC_S_UNSUPPORTED_NAME_SYNTAX";
	case RPC_S_UUID_NO_ADDRESS :	    return "RPC_S_UUID_NO_ADDRESS";
	case RPC_S_DUPLICATE_ENDPOINT :	    return "RPC_S_DUPLICATE_ENDPOINT";
	case RPC_S_UNKNOWN_AUTHN_TYPE :	    return "RPC_S_UNKNOWN_AUTHN_TYPE";
	case RPC_S_MAX_CALLS_TOO_SMALL :    return "RPC_S_MAX_CALLS_TOO_SMALL";
	case RPC_S_STRING_TOO_LONG :	    return "RPC_S_STRING_TOO_LONG";
	case RPC_S_PROTSEQ_NOT_FOUND :	    return "RPC_S_PROTSEQ_NOT_FOUND";
	case RPC_S_PROCNUM_OUT_OF_RANGE :   return "RPC_S_PROCNUM_OUT_OF_RANGE";
	case RPC_S_BINDING_HAS_NO_AUTH :    return "RPC_S_BINDING_HAS_NO_AUTH";
	case RPC_S_UNKNOWN_AUTHN_SERVICE :  return "RPC_S_UNKNOWN_AUTHN_SERVICE";
	case RPC_S_UNKNOWN_AUTHN_LEVEL :    return "RPC_S_UNKNOWN_AUTHN_LEVEL";
	case RPC_S_INVALID_AUTH_IDENTITY :  return "RPC_S_INVALID_AUTH_IDENTITY";
	case RPC_S_UNKNOWN_AUTHZ_SERVICE :  return "RPC_S_UNKNOWN_AUTHZ_SERVICE";
	case EPT_S_INVALID_ENTRY :	    return "EPT_S_INVALID_ENTRY";
	case EPT_S_CANT_PERFORM_OP :	    return "EPT_S_CANT_PERFORM_OP";
	case EPT_S_NOT_REGISTERED :	    return "EPT_S_NOT_REGISTERED";
	case RPC_S_NOTHING_TO_EXPORT :	    return "RPC_S_NOTHING_TO_EXPORT";
	case RPC_S_INCOMPLETE_NAME :	    return "RPC_S_INCOMPLETE_NAME";
	case RPC_S_INVALID_VERS_OPTION :    return "RPC_S_INVALID_VERS_OPTION";
	case RPC_S_NO_MORE_MEMBERS :	    return "RPC_S_NO_MORE_MEMBERS";
	case RPC_S_NOT_ALL_OBJS_UNEXPORTED : return "RPC_S_NOT_ALL_OBJS_UNEXPORTED";
	case RPC_S_INTERFACE_NOT_FOUND :    return "RPC_S_INTERFACE_NOT_FOUND";
	case RPC_S_ENTRY_ALREADY_EXISTS :   return "RPC_S_ENTRY_ALREADY_EXISTS";
	case RPC_S_ENTRY_NOT_FOUND :	    return "RPC_S_ENTRY_NOT_FOUND";
	case RPC_S_NAME_SERVICE_UNAVAILABLE : return "RPC_S_NAME_SERVICE_UNAVAILABLE";
	case RPC_S_INVALID_NAF_ID :	    return "RPC_S_INVALID_NAF_ID";
	case RPC_S_CANNOT_SUPPORT :	    return "RPC_S_CANNOT_SUPPORT";
	case RPC_S_NO_CONTEXT_AVAILABLE :   return "RPC_S_NO_CONTEXT_AVAILABLE";
	case RPC_S_INTERNAL_ERROR :	    return "RPC_S_INTERNAL_ERROR";
	case RPC_S_ZERO_DIVIDE :	    return "RPC_S_ZERO_DIVIDE";
	case RPC_S_ADDRESS_ERROR :	    return "RPC_S_ADDRESS_ERROR";
	case RPC_S_FP_DIV_ZERO :	    return "RPC_S_FP_DIV_ZERO";
	case RPC_S_FP_UNDERFLOW :	    return "RPC_S_FP_UNDERFLOW";
	case RPC_S_FP_OVERFLOW :	    return "RPC_S_FP_OVERFLOW";
	case RPC_X_NO_MORE_ENTRIES :	    return "RPC_X_NO_MORE_ENTRIES";
	case RPC_X_SS_CHAR_TRANS_OPEN_FAIL : return "RPC_X_SS_CHAR_TRANS_OPEN_FAIL";
	case RPC_X_SS_CHAR_TRANS_SHORT_FILE : return "RPC_X_SS_CHAR_TRANS_SHORT_FILE";
	case RPC_X_SS_IN_NULL_CONTEXT :	    return "RPC_X_SS_IN_NULL_CONTEXT";
	case RPC_X_SS_CONTEXT_DAMAGED :	    return "RPC_X_SS_CONTEXT_DAMAGED";
	case RPC_X_SS_HANDLES_MISMATCH :    return "RPC_X_SS_HANDLES_MISMATCH";
	case RPC_X_SS_CANNOT_GET_CALL_HANDLE : return "RPC_X_SS_CANNOT_GET_CALL_HANDLE";
	case RPC_X_NULL_REF_POINTER :	    return "RPC_X_NULL_REF_POINTER";
	case RPC_X_ENUM_VALUE_OUT_OF_RANGE : return "RPC_X_ENUM_VALUE_OUT_OF_RANGE";
	case RPC_X_BYTE_COUNT_TOO_SMALL :   return "RPC_X_BYTE_COUNT_TOO_SMALL";
	case RPC_X_BAD_STUB_DATA :	    return "RPC_X_BAD_STUB_DATA";
	case ERROR_INVALID_USER_BUFFER :    return "ERROR_INVALID_USER_BUFFER";
	case ERROR_UNRECOGNIZED_MEDIA :	    return "ERROR_UNRECOGNIZED_MEDIA";
	case ERROR_NO_TRUST_LSA_SECRET :    return "ERROR_NO_TRUST_LSA_SECRET";
	case ERROR_NO_TRUST_SAM_ACCOUNT :   return "ERROR_NO_TRUST_SAM_ACCOUNT";
	case ERROR_TRUSTED_DOMAIN_FAILURE : return "ERROR_TRUSTED_DOMAIN_FAILURE";
	case ERROR_TRUSTED_RELATIONSHIP_FAILURE : return "ERROR_TRUSTED_RELATIONSHIP_FAILURE";
	case ERROR_TRUST_FAILURE :	    return "ERROR_TRUST_FAILURE";
	case RPC_S_CALL_IN_PROGRESS :	    return "RPC_S_CALL_IN_PROGRESS";
	case ERROR_NETLOGON_NOT_STARTED :   return "ERROR_NETLOGON_NOT_STARTED";
	case ERROR_ACCOUNT_EXPIRED :	    return "ERROR_ACCOUNT_EXPIRED";
	case ERROR_REDIRECTOR_HAS_OPEN_HANDLES : return "ERROR_REDIRECTOR_HAS_OPEN_HANDLES";
	case ERROR_PRINTER_DRIVER_ALREADY_INSTALLED : return "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED";
	case ERROR_UNKNOWN_PORT :	    return "ERROR_UNKNOWN_PORT";
	case ERROR_UNKNOWN_PRINTER_DRIVER : return "ERROR_UNKNOWN_PRINTER_DRIVER";
	case ERROR_UNKNOWN_PRINTPROCESSOR : return "ERROR_UNKNOWN_PRINTPROCESSOR";
	case ERROR_INVALID_SEPARATOR_FILE : return "ERROR_INVALID_SEPARATOR_FILE";
	case ERROR_INVALID_PRIORITY :	    return "ERROR_INVALID_PRIORITY";
	case ERROR_INVALID_PRINTER_NAME :   return "ERROR_INVALID_PRINTER_NAME";
	case ERROR_PRINTER_ALREADY_EXISTS : return "ERROR_PRINTER_ALREADY_EXISTS";
	case ERROR_INVALID_PRINTER_COMMAND : return "ERROR_INVALID_PRINTER_COMMAND";
	case ERROR_INVALID_DATATYPE :	    return "ERROR_INVALID_DATATYPE";
	case ERROR_INVALID_ENVIRONMENT :    return "ERROR_INVALID_ENVIRONMENT";
	case RPC_S_NO_MORE_BINDINGS :	    return "RPC_S_NO_MORE_BINDINGS";
	case ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT : return "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT";
	case ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT : return "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT";
	case ERROR_NOLOGON_SERVER_TRUST_ACCOUNT : return "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT";
	case ERROR_DOMAIN_TRUST_INCONSISTENT : return "ERROR_DOMAIN_TRUST_INCONSISTENT";
	case ERROR_SERVER_HAS_OPEN_HANDLES : return "ERROR_SERVER_HAS_OPEN_HANDLES";
	case ERROR_RESOURCE_DATA_NOT_FOUND : return "ERROR_RESOURCE_DATA_NOT_FOUND";
	case ERROR_RESOURCE_TYPE_NOT_FOUND : return "ERROR_RESOURCE_TYPE_NOT_FOUND";
	case ERROR_RESOURCE_NAME_NOT_FOUND : return "ERROR_RESOURCE_NAME_NOT_FOUND";
	case ERROR_RESOURCE_LANG_NOT_FOUND : return "ERROR_RESOURCE_LANG_NOT_FOUND";
	case ERROR_NOT_ENOUGH_QUOTA :	    return "ERROR_NOT_ENOUGH_QUOTA";
	case RPC_S_NO_INTERFACES :	    return "RPC_S_NO_INTERFACES";
	case RPC_S_CALL_CANCELLED :	    return "RPC_S_CALL_CANCELLED";
	case RPC_S_BINDING_INCOMPLETE :	    return "RPC_S_BINDING_INCOMPLETE";
	case RPC_S_COMM_FAILURE :	    return "RPC_S_COMM_FAILURE";
	case RPC_S_UNSUPPORTED_AUTHN_LEVEL : return "RPC_S_UNSUPPORTED_AUTHN_LEVEL";
	case RPC_S_NO_PRINC_NAME :	    return "RPC_S_NO_PRINC_NAME";
	case RPC_S_NOT_RPC_ERROR :	    return "RPC_S_NOT_RPC_ERROR";
	case RPC_S_UUID_LOCAL_ONLY :	    return "RPC_S_UUID_LOCAL_ONLY";
	case RPC_S_SEC_PKG_ERROR :	    return "RPC_S_SEC_PKG_ERROR";
	case RPC_S_NOT_CANCELLED :	    return "RPC_S_NOT_CANCELLED";
	case RPC_X_INVALID_ES_ACTION :	    return "RPC_X_INVALID_ES_ACTION";
	case RPC_X_WRONG_ES_VERSION :	    return "RPC_X_WRONG_ES_VERSION";
	case RPC_X_WRONG_STUB_VERSION :	    return "RPC_X_WRONG_STUB_VERSION";
	case RPC_X_INVALID_PIPE_OBJECT :    return "RPC_X_INVALID_PIPE_OBJECT";
	case RPC_X_WRONG_PIPE_ORDER :	    return "RPC_X_WRONG_PIPE_ORDER";
	case RPC_X_WRONG_PIPE_VERSION :	    return "RPC_X_WRONG_PIPE_VERSION";
	case RPC_S_GROUP_MEMBER_NOT_FOUND : return "RPC_S_GROUP_MEMBER_NOT_FOUND";
	case EPT_S_CANT_CREATE :	    return "EPT_S_CANT_CREATE";
	case RPC_S_INVALID_OBJECT :	    return "RPC_S_INVALID_OBJECT";
	case ERROR_INVALID_TIME :	    return "ERROR_INVALID_TIME";
	case ERROR_INVALID_FORM_NAME :	    return "ERROR_INVALID_FORM_NAME";
	case ERROR_INVALID_FORM_SIZE :	    return "ERROR_INVALID_FORM_SIZE";
	case ERROR_ALREADY_WAITING :	    return "ERROR_ALREADY_WAITING";
	case ERROR_PRINTER_DELETED :	    return "ERROR_PRINTER_DELETED";
	case ERROR_INVALID_PRINTER_STATE :  return "ERROR_INVALID_PRINTER_STATE";
	case ERROR_PASSWORD_MUST_CHANGE :   return "ERROR_PASSWORD_MUST_CHANGE";
	case ERROR_DOMAIN_CONTROLLER_NOT_FOUND : return "ERROR_DOMAIN_CONTROLLER_NOT_FOUND";
	case ERROR_ACCOUNT_LOCKED_OUT :	    return "ERROR_ACCOUNT_LOCKED_OUT";
	case OR_INVALID_OXID :		    return "OR_INVALID_OXID";
	case OR_INVALID_OID :		    return "OR_INVALID_OID";
	case OR_INVALID_SET :		    return "OR_INVALID_SET";
	case RPC_S_SEND_INCOMPLETE :	    return "RPC_S_SEND_INCOMPLETE";
	case RPC_S_INVALID_ASYNC_HANDLE :   return "RPC_S_INVALID_ASYNC_HANDLE";
	case RPC_S_INVALID_ASYNC_CALL :	    return "RPC_S_INVALID_ASYNC_CALL";
	case RPC_X_PIPE_CLOSED :	    return "RPC_X_PIPE_CLOSED";
	case RPC_X_PIPE_DISCIPLINE_ERROR :  return "RPC_X_PIPE_DISCIPLINE_ERROR";
	case RPC_X_PIPE_EMPTY :		    return "RPC_X_PIPE_EMPTY";
	case ERROR_NO_SITENAME :	    return "ERROR_NO_SITENAME";
	case ERROR_CANT_ACCESS_FILE :	    return "ERROR_CANT_ACCESS_FILE";
	case ERROR_CANT_RESOLVE_FILENAME :  return "ERROR_CANT_RESOLVE_FILENAME";
	case RPC_S_ENTRY_TYPE_MISMATCH :    return "RPC_S_ENTRY_TYPE_MISMATCH";
	case RPC_S_NOT_ALL_OBJS_EXPORTED :  return "RPC_S_NOT_ALL_OBJS_EXPORTED";
	case RPC_S_INTERFACE_NOT_EXPORTED : return "RPC_S_INTERFACE_NOT_EXPORTED";
	case RPC_S_PROFILE_NOT_ADDED :	    return "RPC_S_PROFILE_NOT_ADDED";
	case RPC_S_PRF_ELT_NOT_ADDED :	    return "RPC_S_PRF_ELT_NOT_ADDED";
	case RPC_S_PRF_ELT_NOT_REMOVED :    return "RPC_S_PRF_ELT_NOT_REMOVED";
	case RPC_S_GRP_ELT_NOT_ADDED :	    return "RPC_S_GRP_ELT_NOT_ADDED";
	case RPC_S_GRP_ELT_NOT_REMOVED :    return "RPC_S_GRP_ELT_NOT_REMOVED";
	case ERROR_KM_DRIVER_BLOCKED :	    return "ERROR_KM_DRIVER_BLOCKED";
	case ERROR_CONTEXT_EXPIRED :	    return "ERROR_CONTEXT_EXPIRED";
	case ERROR_PER_USER_TRUST_QUOTA_EXCEEDED : return "ERROR_PER_USER_TRUST_QUOTA_EXCEEDED";
	case ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED : return "ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED";
	case ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED : return "ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED";
	case ERROR_AUTHENTICATION_FIREWALL_FAILED : return "ERROR_AUTHENTICATION_FIREWALL_FAILED";
	case ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED : return "ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED";
	//   OpenGL Error Code
	case ERROR_INVALID_PIXEL_FORMAT :   return "ERROR_INVALID_PIXEL_FORMAT";
	case ERROR_BAD_DRIVER :		    return "ERROR_BAD_DRIVER";
	case ERROR_INVALID_WINDOW_STYLE :   return "ERROR_INVALID_WINDOW_STYLE";
	case ERROR_METAFILE_NOT_SUPPORTED : return "ERROR_METAFILE_NOT_SUPPORTED";
	case ERROR_TRANSFORM_NOT_SUPPORTED : return "ERROR_TRANSFORM_NOT_SUPPORTED";
	case ERROR_CLIPPING_NOT_SUPPORTED : return "ERROR_CLIPPING_NOT_SUPPORTED";
	//   Image Color Management Error Code
	case ERROR_INVALID_CMM :	    return "ERROR_INVALID_CMM";
	case ERROR_INVALID_PROFILE :	    return "ERROR_INVALID_PROFILE";
	case ERROR_TAG_NOT_FOUND :	    return "ERROR_TAG_NOT_FOUND";
	case ERROR_TAG_NOT_PRESENT :	    return "ERROR_TAG_NOT_PRESENT";
	case ERROR_DUPLICATE_TAG :	    return "ERROR_DUPLICATE_TAG";
	case ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE : return "ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE";
	case ERROR_PROFILE_NOT_FOUND :	    return "ERROR_PROFILE_NOT_FOUND";
	case ERROR_INVALID_COLORSPACE :	    return "ERROR_INVALID_COLORSPACE";
	case ERROR_ICM_NOT_ENABLED :	    return "ERROR_ICM_NOT_ENABLED";
	case ERROR_DELETING_ICM_XFORM :	    return "ERROR_DELETING_ICM_XFORM";
	case ERROR_INVALID_TRANSFORM :	    return "ERROR_INVALID_TRANSFORM";
	case ERROR_COLORSPACE_MISMATCH :    return "ERROR_COLORSPACE_MISMATCH";
	case ERROR_INVALID_COLORINDEX :	    return "ERROR_INVALID_COLORINDEX";
	// Winnet32 Status Codes //
	case ERROR_CONNECTED_OTHER_PASSWORD : return "ERROR_CONNECTED_OTHER_PASSWORD";
	case ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT : return "ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT";
	case ERROR_BAD_USERNAME :	    return "ERROR_BAD_USERNAME";
	case ERROR_NOT_CONNECTED :	    return "ERROR_NOT_CONNECTED";
	case ERROR_OPEN_FILES :		    return "ERROR_OPEN_FILES";
	case ERROR_ACTIVE_CONNECTIONS :	    return "ERROR_ACTIVE_CONNECTIONS";
	case ERROR_DEVICE_IN_USE :	    return "ERROR_DEVICE_IN_USE";
	// Win32 Spooler Error Codes
	case ERROR_UNKNOWN_PRINT_MONITOR :  return "ERROR_UNKNOWN_PRINT_MONITOR";
	case ERROR_PRINTER_DRIVER_IN_USE :  return "ERROR_PRINTER_DRIVER_IN_USE";
	case ERROR_SPOOL_FILE_NOT_FOUND :   return "ERROR_SPOOL_FILE_NOT_FOUND";
	case ERROR_SPL_NO_STARTDOC :	    return "ERROR_SPL_NO_STARTDOC";
	case ERROR_SPL_NO_ADDJOB :	    return "ERROR_SPL_NO_ADDJOB";
	case ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED : return "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED";
	case ERROR_PRINT_MONITOR_ALREADY_INSTALLED : return "ERROR_PRINT_MONITOR_ALREADY_INSTALLED";
	case ERROR_INVALID_PRINT_MONITOR :  return "ERROR_INVALID_PRINT_MONITOR";
	case ERROR_PRINTER_HAS_JOBS_QUEUED : return "ERROR_PRINTER_HAS_JOBS_QUEUED";
	case ERROR_SUCCESS_REBOOT_REQUIRED : return "ERROR_SUCCESS_REBOOT_REQUIRED";
	case ERROR_SUCCESS_RESTART_REQUIRED : return "ERROR_SUCCESS_RESTART_REQUIRED";
	case ERROR_PRINTER_NOT_FOUND :	    return "ERROR_PRINTER_NOT_FOUND";
	case ERROR_PRINTER_DRIVER_WARNED :  return "ERROR_PRINTER_DRIVER_WARNED";
	case ERROR_PRINTER_DRIVER_BLOCKED : return "ERROR_PRINTER_DRIVER_BLOCKED";
	// Wins Error Codes
	case ERROR_WINS_INTERNAL :	    return "ERROR_WINS_INTERNAL";
	case ERROR_CAN_NOT_DEL_LOCAL_WINS : return "ERROR_CAN_NOT_DEL_LOCAL_WINS";
	case ERROR_STATIC_INIT :	    return "ERROR_STATIC_INIT";
	case ERROR_INC_BACKUP :		    return "ERROR_INC_BACKUP";
	case ERROR_FULL_BACKUP :	    return "ERROR_FULL_BACKUP";
	case ERROR_REC_NON_EXISTENT :	    return "ERROR_REC_NON_EXISTENT";
	case ERROR_RPL_NOT_ALLOWED :	    return "ERROR_RPL_NOT_ALLOWED";
	// DHCP Error Codes
	case ERROR_DHCP_ADDRESS_CONFLICT :  return "ERROR_DHCP_ADDRESS_CONFLICT";
	// WMI Error Codes
	case ERROR_WMI_GUID_NOT_FOUND :	    return "ERROR_WMI_GUID_NOT_FOUND";
	case ERROR_WMI_INSTANCE_NOT_FOUND : return "ERROR_WMI_INSTANCE_NOT_FOUND";
	case ERROR_WMI_ITEMID_NOT_FOUND :   return "ERROR_WMI_ITEMID_NOT_FOUND";
	case ERROR_WMI_TRY_AGAIN :	    return "ERROR_WMI_TRY_AGAIN";
	case ERROR_WMI_DP_NOT_FOUND :	    return "ERROR_WMI_DP_NOT_FOUND";
	case ERROR_WMI_UNRESOLVED_INSTANCE_REF : return "ERROR_WMI_UNRESOLVED_INSTANCE_REF";
	case ERROR_WMI_ALREADY_ENABLED :    return "ERROR_WMI_ALREADY_ENABLED";
	case ERROR_WMI_GUID_DISCONNECTED :  return "ERROR_WMI_GUID_DISCONNECTED";
	case ERROR_WMI_SERVER_UNAVAILABLE : return "ERROR_WMI_SERVER_UNAVAILABLE";
	case ERROR_WMI_DP_FAILED :	    return "ERROR_WMI_DP_FAILED";
	case ERROR_WMI_INVALID_MOF :	    return "ERROR_WMI_INVALID_MOF";
	case ERROR_WMI_INVALID_REGINFO :    return "ERROR_WMI_INVALID_REGINFO";
	case ERROR_WMI_ALREADY_DISABLED :   return "ERROR_WMI_ALREADY_DISABLED";
	case ERROR_WMI_READ_ONLY :	    return "ERROR_WMI_READ_ONLY";
	case ERROR_WMI_SET_FAILURE :	    return "ERROR_WMI_SET_FAILURE";
	// NT Media Services (RSM) Error Codes
	case ERROR_INVALID_MEDIA :	    return "ERROR_INVALID_MEDIA";
	case ERROR_INVALID_LIBRARY :	    return "ERROR_INVALID_LIBRARY";
	case ERROR_INVALID_MEDIA_POOL :	    return "ERROR_INVALID_MEDIA_POOL";
	case ERROR_DRIVE_MEDIA_MISMATCH :   return "ERROR_DRIVE_MEDIA_MISMATCH";
	case ERROR_MEDIA_OFFLINE :	    return "ERROR_MEDIA_OFFLINE";
	case ERROR_LIBRARY_OFFLINE :	    return "ERROR_LIBRARY_OFFLINE";
	case ERROR_EMPTY :		    return "ERROR_EMPTY";
	case ERROR_NOT_EMPTY :		    return "ERROR_NOT_EMPTY";
	case ERROR_MEDIA_UNAVAILABLE :	    return "ERROR_MEDIA_UNAVAILABLE";
	case ERROR_RESOURCE_DISABLED :	    return "ERROR_RESOURCE_DISABLED";
	case ERROR_INVALID_CLEANER :	    return "ERROR_INVALID_CLEANER";
	case ERROR_UNABLE_TO_CLEAN :	    return "ERROR_UNABLE_TO_CLEAN";
	case ERROR_OBJECT_NOT_FOUND :	    return "ERROR_OBJECT_NOT_FOUND";
	case ERROR_DATABASE_FAILURE :	    return "ERROR_DATABASE_FAILURE";
	case ERROR_DATABASE_FULL :	    return "ERROR_DATABASE_FULL";
	case ERROR_MEDIA_INCOMPATIBLE :	    return "ERROR_MEDIA_INCOMPATIBLE";
	case ERROR_RESOURCE_NOT_PRESENT :   return "ERROR_RESOURCE_NOT_PRESENT";
	case ERROR_INVALID_OPERATION :	    return "ERROR_INVALID_OPERATION";
	case ERROR_MEDIA_NOT_AVAILABLE :    return "ERROR_MEDIA_NOT_AVAILABLE";
	case ERROR_DEVICE_NOT_AVAILABLE :   return "ERROR_DEVICE_NOT_AVAILABLE";
	case ERROR_REQUEST_REFUSED :	    return "ERROR_REQUEST_REFUSED";
	case ERROR_INVALID_DRIVE_OBJECT :   return "ERROR_INVALID_DRIVE_OBJECT";
	case ERROR_LIBRARY_FULL :	    return "ERROR_LIBRARY_FULL";
	case ERROR_MEDIUM_NOT_ACCESSIBLE :  return "ERROR_MEDIUM_NOT_ACCESSIBLE";
	case ERROR_UNABLE_TO_LOAD_MEDIUM :  return "ERROR_UNABLE_TO_LOAD_MEDIUM";
	case ERROR_UNABLE_TO_INVENTORY_DRIVE : return "ERROR_UNABLE_TO_INVENTORY_DRIVE";
	case ERROR_UNABLE_TO_INVENTORY_SLOT : return "ERROR_UNABLE_TO_INVENTORY_SLOT";
	case ERROR_UNABLE_TO_INVENTORY_TRANSPORT : return "ERROR_UNABLE_TO_INVENTORY_TRANSPORT";
	case ERROR_TRANSPORT_FULL :	    return "ERROR_TRANSPORT_FULL";
	case ERROR_CONTROLLING_IEPORT :	    return "ERROR_CONTROLLING_IEPORT";
	case ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA : return "ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA";
	case ERROR_CLEANER_SLOT_SET :	    return "ERROR_CLEANER_SLOT_SET";
	case ERROR_CLEANER_SLOT_NOT_SET :   return "ERROR_CLEANER_SLOT_NOT_SET";
	case ERROR_CLEANER_CARTRIDGE_SPENT : return "ERROR_CLEANER_CARTRIDGE_SPENT";
	case ERROR_UNEXPECTED_OMID :	    return "ERROR_UNEXPECTED_OMID";
	case ERROR_CANT_DELETE_LAST_ITEM :  return "ERROR_CANT_DELETE_LAST_ITEM";
	case ERROR_MESSAGE_EXCEEDS_MAX_SIZE : return "ERROR_MESSAGE_EXCEEDS_MAX_SIZE";
	case ERROR_VOLUME_CONTAINS_SYS_FILES : return "ERROR_VOLUME_CONTAINS_SYS_FILES";
	case ERROR_INDIGENOUS_TYPE :	    return "ERROR_INDIGENOUS_TYPE";
	case ERROR_NO_SUPPORTING_DRIVES :   return "ERROR_NO_SUPPORTING_DRIVES";
	case ERROR_CLEANER_CARTRIDGE_INSTALLED : return "ERROR_CLEANER_CARTRIDGE_INSTALLED";
	case ERROR_IEPORT_FULL :	    return "ERROR_IEPORT_FULL";
	// NT Remote Storage Service Error Codes
	case ERROR_FILE_OFFLINE :	    return "ERROR_FILE_OFFLINE";
	case ERROR_REMOTE_STORAGE_NOT_ACTIVE : return "ERROR_REMOTE_STORAGE_NOT_ACTIVE";
	case ERROR_REMOTE_STORAGE_MEDIA_ERROR : return "ERROR_REMOTE_STORAGE_MEDIA_ERROR";
	// NT Reparse Points Error Codes
	case ERROR_NOT_A_REPARSE_POINT :    return "ERROR_NOT_A_REPARSE_POINT";
	case ERROR_REPARSE_ATTRIBUTE_CONFLICT : return "ERROR_REPARSE_ATTRIBUTE_CONFLICT";
	case ERROR_INVALID_REPARSE_DATA :   return "ERROR_INVALID_REPARSE_DATA";
	case ERROR_REPARSE_TAG_INVALID :    return "ERROR_REPARSE_TAG_INVALID";
	case ERROR_REPARSE_TAG_MISMATCH :   return "ERROR_REPARSE_TAG_MISMATCH";
	// NT Single Instance Store Error Codes
	case ERROR_VOLUME_NOT_SIS_ENABLED : return "ERROR_VOLUME_NOT_SIS_ENABLED";
	// Cluster Error Codes
	case ERROR_DEPENDENT_RESOURCE_EXISTS : return "ERROR_DEPENDENT_RESOURCE_EXISTS";
	case ERROR_DEPENDENCY_NOT_FOUND :   return "ERROR_DEPENDENCY_NOT_FOUND";
	case ERROR_DEPENDENCY_ALREADY_EXISTS : return "ERROR_DEPENDENCY_ALREADY_EXISTS";
	case ERROR_RESOURCE_NOT_ONLINE :    return "ERROR_RESOURCE_NOT_ONLINE";
	case ERROR_HOST_NODE_NOT_AVAILABLE : return "ERROR_HOST_NODE_NOT_AVAILABLE";
	case ERROR_RESOURCE_NOT_AVAILABLE : return "ERROR_RESOURCE_NOT_AVAILABLE";
	case ERROR_RESOURCE_NOT_FOUND :	    return "ERROR_RESOURCE_NOT_FOUND";
	case ERROR_SHUTDOWN_CLUSTER :	    return "ERROR_SHUTDOWN_CLUSTER";
	case ERROR_CANT_EVICT_ACTIVE_NODE : return "ERROR_CANT_EVICT_ACTIVE_NODE";
	case ERROR_OBJECT_ALREADY_EXISTS :  return "ERROR_OBJECT_ALREADY_EXISTS";
	case ERROR_OBJECT_IN_LIST :	    return "ERROR_OBJECT_IN_LIST";
	case ERROR_GROUP_NOT_AVAILABLE :    return "ERROR_GROUP_NOT_AVAILABLE";
	case ERROR_GROUP_NOT_FOUND :	    return "ERROR_GROUP_NOT_FOUND";
	case ERROR_GROUP_NOT_ONLINE :	    return "ERROR_GROUP_NOT_ONLINE";
	case ERROR_HOST_NODE_NOT_RESOURCE_OWNER : return "ERROR_HOST_NODE_NOT_RESOURCE_OWNER";
	case ERROR_HOST_NODE_NOT_GROUP_OWNER : return "ERROR_HOST_NODE_NOT_GROUP_OWNER";
	case ERROR_RESMON_CREATE_FAILED :   return "ERROR_RESMON_CREATE_FAILED";
	case ERROR_RESMON_ONLINE_FAILED :   return "ERROR_RESMON_ONLINE_FAILED";
	case ERROR_RESOURCE_ONLINE :	    return "ERROR_RESOURCE_ONLINE";
	case ERROR_QUORUM_RESOURCE :	    return "ERROR_QUORUM_RESOURCE";
	case ERROR_NOT_QUORUM_CAPABLE :	    return "ERROR_NOT_QUORUM_CAPABLE";
	case ERROR_CLUSTER_SHUTTING_DOWN :  return "ERROR_CLUSTER_SHUTTING_DOWN";
	case ERROR_INVALID_STATE :	    return "ERROR_INVALID_STATE";
	case ERROR_RESOURCE_PROPERTIES_STORED : return "ERROR_RESOURCE_PROPERTIES_STORED";
	case ERROR_NOT_QUORUM_CLASS :	    return "ERROR_NOT_QUORUM_CLASS";
	case ERROR_CORE_RESOURCE :	    return "ERROR_CORE_RESOURCE";
	case ERROR_QUORUM_RESOURCE_ONLINE_FAILED : return "ERROR_QUORUM_RESOURCE_ONLINE_FAILED";
	case ERROR_QUORUMLOG_OPEN_FAILED :  return "ERROR_QUORUMLOG_OPEN_FAILED";
	case ERROR_CLUSTERLOG_CORRUPT :	    return "ERROR_CLUSTERLOG_CORRUPT";
	case ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE : return "ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE";
	case ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE : return "ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE";
	case ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND : return "ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND";
	case ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE : return "ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE";
	case ERROR_QUORUM_OWNER_ALIVE :	    return "ERROR_QUORUM_OWNER_ALIVE";
	case ERROR_NETWORK_NOT_AVAILABLE :  return "ERROR_NETWORK_NOT_AVAILABLE";
	case ERROR_NODE_NOT_AVAILABLE :	    return "ERROR_NODE_NOT_AVAILABLE";
	case ERROR_ALL_NODES_NOT_AVAILABLE : return "ERROR_ALL_NODES_NOT_AVAILABLE";
	case ERROR_RESOURCE_FAILED :	    return "ERROR_RESOURCE_FAILED";
	case ERROR_CLUSTER_INVALID_NODE :   return "ERROR_CLUSTER_INVALID_NODE";
	case ERROR_CLUSTER_NODE_EXISTS :    return "ERROR_CLUSTER_NODE_EXISTS";
	case ERROR_CLUSTER_JOIN_IN_PROGRESS : return "ERROR_CLUSTER_JOIN_IN_PROGRESS";
	case ERROR_CLUSTER_NODE_NOT_FOUND : return "ERROR_CLUSTER_NODE_NOT_FOUND";
	case ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND : return "ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND";
	case ERROR_CLUSTER_NETWORK_EXISTS : return "ERROR_CLUSTER_NETWORK_EXISTS";
	case ERROR_CLUSTER_NETWORK_NOT_FOUND : return "ERROR_CLUSTER_NETWORK_NOT_FOUND";
	case ERROR_CLUSTER_NETINTERFACE_EXISTS : return "ERROR_CLUSTER_NETINTERFACE_EXISTS";
	case ERROR_CLUSTER_NETINTERFACE_NOT_FOUND : return "ERROR_CLUSTER_NETINTERFACE_NOT_FOUND";
	case ERROR_CLUSTER_INVALID_REQUEST : return "ERROR_CLUSTER_INVALID_REQUEST";
	case ERROR_CLUSTER_INVALID_NETWORK_PROVIDER : return "ERROR_CLUSTER_INVALID_NETWORK_PROVIDER";
	case ERROR_CLUSTER_NODE_DOWN :	    return "ERROR_CLUSTER_NODE_DOWN";
	case ERROR_CLUSTER_NODE_UNREACHABLE : return "ERROR_CLUSTER_NODE_UNREACHABLE";
	case ERROR_CLUSTER_NODE_NOT_MEMBER : return "ERROR_CLUSTER_NODE_NOT_MEMBER";
	case ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS : return "ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS";
	case ERROR_CLUSTER_INVALID_NETWORK : return "ERROR_CLUSTER_INVALID_NETWORK";
	case ERROR_CLUSTER_NODE_UP :	    return "ERROR_CLUSTER_NODE_UP";
	case ERROR_CLUSTER_IPADDR_IN_USE :  return "ERROR_CLUSTER_IPADDR_IN_USE";
	case ERROR_CLUSTER_NODE_NOT_PAUSED : return "ERROR_CLUSTER_NODE_NOT_PAUSED";
	case ERROR_CLUSTER_NO_SECURITY_CONTEXT : return "ERROR_CLUSTER_NO_SECURITY_CONTEXT";
	case ERROR_CLUSTER_NETWORK_NOT_INTERNAL : return "ERROR_CLUSTER_NETWORK_NOT_INTERNAL";
	case ERROR_CLUSTER_NODE_ALREADY_UP : return "ERROR_CLUSTER_NODE_ALREADY_UP";
	case ERROR_CLUSTER_NODE_ALREADY_DOWN : return "ERROR_CLUSTER_NODE_ALREADY_DOWN";
	case ERROR_CLUSTER_NETWORK_ALREADY_ONLINE : return "ERROR_CLUSTER_NETWORK_ALREADY_ONLINE";
	case ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE : return "ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE";
	case ERROR_CLUSTER_NODE_ALREADY_MEMBER : return "ERROR_CLUSTER_NODE_ALREADY_MEMBER";
	case ERROR_CLUSTER_LAST_INTERNAL_NETWORK : return "ERROR_CLUSTER_LAST_INTERNAL_NETWORK";
	case ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS : return "ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS";
	case ERROR_INVALID_OPERATION_ON_QUORUM : return "ERROR_INVALID_OPERATION_ON_QUORUM";
	case ERROR_DEPENDENCY_NOT_ALLOWED : return "ERROR_DEPENDENCY_NOT_ALLOWED";
	case ERROR_CLUSTER_NODE_PAUSED :    return "ERROR_CLUSTER_NODE_PAUSED";
	case ERROR_NODE_CANT_HOST_RESOURCE : return "ERROR_NODE_CANT_HOST_RESOURCE";
	case ERROR_CLUSTER_NODE_NOT_READY : return "ERROR_CLUSTER_NODE_NOT_READY";
	case ERROR_CLUSTER_NODE_SHUTTING_DOWN : return "ERROR_CLUSTER_NODE_SHUTTING_DOWN";
	case ERROR_CLUSTER_JOIN_ABORTED :   return "ERROR_CLUSTER_JOIN_ABORTED";
	case ERROR_CLUSTER_INCOMPATIBLE_VERSIONS : return "ERROR_CLUSTER_INCOMPATIBLE_VERSIONS";
	case ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED : return "ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED";
	case ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED : return "ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED";
	case ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND : return "ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND";
	case ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED : return "ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED";
	case ERROR_CLUSTER_RESNAME_NOT_FOUND : return "ERROR_CLUSTER_RESNAME_NOT_FOUND";
	case ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED : return "ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED";
	case ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST : return "ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST";
	case ERROR_CLUSTER_DATABASE_SEQMISMATCH : return "ERROR_CLUSTER_DATABASE_SEQMISMATCH";
	case ERROR_RESMON_INVALID_STATE :   return "ERROR_RESMON_INVALID_STATE";
	case ERROR_CLUSTER_GUM_NOT_LOCKER : return "ERROR_CLUSTER_GUM_NOT_LOCKER";
	case ERROR_QUORUM_DISK_NOT_FOUND :  return "ERROR_QUORUM_DISK_NOT_FOUND";
	case ERROR_DATABASE_BACKUP_CORRUPT : return "ERROR_DATABASE_BACKUP_CORRUPT";
	case ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT : return "ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT";
	case ERROR_RESOURCE_PROPERTY_UNCHANGEABLE : return "ERROR_RESOURCE_PROPERTY_UNCHANGEABLE";
	case ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE : return "ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE";
	case ERROR_CLUSTER_QUORUMLOG_NOT_FOUND : return "ERROR_CLUSTER_QUORUMLOG_NOT_FOUND";
	case ERROR_CLUSTER_MEMBERSHIP_HALT : return "ERROR_CLUSTER_MEMBERSHIP_HALT";
	case ERROR_CLUSTER_INSTANCE_ID_MISMATCH : return "ERROR_CLUSTER_INSTANCE_ID_MISMATCH";
	case ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP : return "ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP";
	case ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH : return "ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH";
	case ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP : return "ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP";
	case ERROR_CLUSTER_PARAMETER_MISMATCH : return "ERROR_CLUSTER_PARAMETER_MISMATCH";
	case ERROR_NODE_CANNOT_BE_CLUSTERED : return "ERROR_NODE_CANNOT_BE_CLUSTERED";
	case ERROR_CLUSTER_WRONG_OS_VERSION : return "ERROR_CLUSTER_WRONG_OS_VERSION";
	case ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME : return "ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME";
	case ERROR_CLUSCFG_ALREADY_COMMITTED : return "ERROR_CLUSCFG_ALREADY_COMMITTED";
	case ERROR_CLUSCFG_ROLLBACK_FAILED : return "ERROR_CLUSCFG_ROLLBACK_FAILED";
	case ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT : return "ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT";
	case ERROR_CLUSTER_OLD_VERSION :    return "ERROR_CLUSTER_OLD_VERSION";
	case ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME : return "ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME";
	// EFS Error Codes
	case ERROR_ENCRYPTION_FAILED :	    return "ERROR_ENCRYPTION_FAILED";
	case ERROR_DECRYPTION_FAILED :	    return "ERROR_DECRYPTION_FAILED";
	case ERROR_FILE_ENCRYPTED :	    return "ERROR_FILE_ENCRYPTED";
	case ERROR_NO_RECOVERY_POLICY :	    return "ERROR_NO_RECOVERY_POLICY";
	case ERROR_NO_EFS :		    return "ERROR_NO_EFS";
	case ERROR_WRONG_EFS :		    return "ERROR_WRONG_EFS";
	case ERROR_NO_USER_KEYS :	    return "ERROR_NO_USER_KEYS";
	case ERROR_FILE_NOT_ENCRYPTED :	    return "ERROR_FILE_NOT_ENCRYPTED";
	case ERROR_NOT_EXPORT_FORMAT :	    return "ERROR_NOT_EXPORT_FORMAT";
	case ERROR_FILE_READ_ONLY :	    return "ERROR_FILE_READ_ONLY";
	case ERROR_DIR_EFS_DISALLOWED :	    return "ERROR_DIR_EFS_DISALLOWED";
	case ERROR_EFS_SERVER_NOT_TRUSTED : return "ERROR_EFS_SERVER_NOT_TRUSTED";
	case ERROR_BAD_RECOVERY_POLICY :    return "ERROR_BAD_RECOVERY_POLICY";
	case ERROR_EFS_ALG_BLOB_TOO_BIG :   return "ERROR_EFS_ALG_BLOB_TOO_BIG";
	case ERROR_VOLUME_NOT_SUPPORT_EFS : return "ERROR_VOLUME_NOT_SUPPORT_EFS";
	case ERROR_EFS_DISABLED :	    return "ERROR_EFS_DISABLED";
	case ERROR_EFS_VERSION_NOT_SUPPORT : return "ERROR_EFS_VERSION_NOT_SUPPORT";
	case ERROR_NO_BROWSER_SERVERS_FOUND : return "ERROR_NO_BROWSER_SERVERS_FOUND";
	// Task Scheduler Error Codes that NET START must understand
	case SCHED_E_SERVICE_NOT_LOCALSYSTEM : return "SCHED_E_SERVICE_NOT_LOCALSYSTEM";
	// Terminal Server Error Codes
	case ERROR_CTX_WINSTATION_NAME_INVALID : return "ERROR_CTX_WINSTATION_NAME_INVALID";
	case ERROR_CTX_INVALID_PD :	    return "ERROR_CTX_INVALID_PD";
	case ERROR_CTX_PD_NOT_FOUND :	    return "ERROR_CTX_PD_NOT_FOUND";
	case ERROR_CTX_WD_NOT_FOUND :	    return "ERROR_CTX_WD_NOT_FOUND";
	case ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY : return "ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY";
	case ERROR_CTX_SERVICE_NAME_COLLISION : return "ERROR_CTX_SERVICE_NAME_COLLISION";
	case ERROR_CTX_CLOSE_PENDING :	    return "ERROR_CTX_CLOSE_PENDING";
	case ERROR_CTX_NO_OUTBUF :	    return "ERROR_CTX_NO_OUTBUF";
	case ERROR_CTX_MODEM_INF_NOT_FOUND : return "ERROR_CTX_MODEM_INF_NOT_FOUND";
	case ERROR_CTX_INVALID_MODEMNAME :  return "ERROR_CTX_INVALID_MODEMNAME";
	case ERROR_CTX_MODEM_RESPONSE_ERROR : return "ERROR_CTX_MODEM_RESPONSE_ERROR";
	case ERROR_CTX_MODEM_RESPONSE_TIMEOUT : return "ERROR_CTX_MODEM_RESPONSE_TIMEOUT";
	case ERROR_CTX_MODEM_RESPONSE_NO_CARRIER : return "ERROR_CTX_MODEM_RESPONSE_NO_CARRIER";
	case ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE : return "ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE";
	case ERROR_CTX_MODEM_RESPONSE_BUSY : return "ERROR_CTX_MODEM_RESPONSE_BUSY";
	case ERROR_CTX_MODEM_RESPONSE_VOICE : return "ERROR_CTX_MODEM_RESPONSE_VOICE";
	case ERROR_CTX_TD_ERROR :	    return "ERROR_CTX_TD_ERROR";
	case ERROR_CTX_WINSTATION_NOT_FOUND : return "ERROR_CTX_WINSTATION_NOT_FOUND";
	case ERROR_CTX_WINSTATION_ALREADY_EXISTS : return "ERROR_CTX_WINSTATION_ALREADY_EXISTS";
	case ERROR_CTX_WINSTATION_BUSY :    return "ERROR_CTX_WINSTATION_BUSY";
	case ERROR_CTX_BAD_VIDEO_MODE :	    return "ERROR_CTX_BAD_VIDEO_MODE";
	case ERROR_CTX_GRAPHICS_INVALID :   return "ERROR_CTX_GRAPHICS_INVALID";
	case ERROR_CTX_LOGON_DISABLED :	    return "ERROR_CTX_LOGON_DISABLED";
	case ERROR_CTX_NOT_CONSOLE :	    return "ERROR_CTX_NOT_CONSOLE";
	case ERROR_CTX_CLIENT_QUERY_TIMEOUT : return "ERROR_CTX_CLIENT_QUERY_TIMEOUT";
	case ERROR_CTX_CONSOLE_DISCONNECT : return "ERROR_CTX_CONSOLE_DISCONNECT";
	case ERROR_CTX_CONSOLE_CONNECT :    return "ERROR_CTX_CONSOLE_CONNECT";
	case ERROR_CTX_SHADOW_DENIED :	    return "ERROR_CTX_SHADOW_DENIED";
	case ERROR_CTX_WINSTATION_ACCESS_DENIED : return "ERROR_CTX_WINSTATION_ACCESS_DENIED";
	case ERROR_CTX_INVALID_WD :	    return "ERROR_CTX_INVALID_WD";
	case ERROR_CTX_SHADOW_INVALID :	    return "ERROR_CTX_SHADOW_INVALID";
	case ERROR_CTX_SHADOW_DISABLED :    return "ERROR_CTX_SHADOW_DISABLED";
	case ERROR_CTX_CLIENT_LICENSE_IN_USE : return "ERROR_CTX_CLIENT_LICENSE_IN_USE";
	case ERROR_CTX_CLIENT_LICENSE_NOT_SET : return "ERROR_CTX_CLIENT_LICENSE_NOT_SET";
	case ERROR_CTX_LICENSE_NOT_AVAILABLE : return "ERROR_CTX_LICENSE_NOT_AVAILABLE";
	case ERROR_CTX_LICENSE_CLIENT_INVALID : return "ERROR_CTX_LICENSE_CLIENT_INVALID";
	case ERROR_CTX_LICENSE_EXPIRED :    return "ERROR_CTX_LICENSE_EXPIRED";
	case ERROR_CTX_SHADOW_NOT_RUNNING : return "ERROR_CTX_SHADOW_NOT_RUNNING";
	case ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE : return "ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE";
	case ERROR_ACTIVATION_COUNT_EXCEEDED : return "ERROR_ACTIVATION_COUNT_EXCEEDED";
	// Traffic Control Error Codes,  defined in: tcerror.h
	// Active Directory Error Codes
	case FRS_ERR_INVALID_API_SEQUENCE : return "FRS_ERR_INVALID_API_SEQUENCE";
	case FRS_ERR_STARTING_SERVICE :	    return "FRS_ERR_STARTING_SERVICE";
	case FRS_ERR_STOPPING_SERVICE :	    return "FRS_ERR_STOPPING_SERVICE";
	case FRS_ERR_INTERNAL_API :	    return "FRS_ERR_INTERNAL_API";
	case FRS_ERR_INTERNAL :		    return "FRS_ERR_INTERNAL";
	case FRS_ERR_SERVICE_COMM :	    return "FRS_ERR_SERVICE_COMM";
	case FRS_ERR_INSUFFICIENT_PRIV :    return "FRS_ERR_INSUFFICIENT_PRIV";
	case FRS_ERR_AUTHENTICATION :	    return "FRS_ERR_AUTHENTICATION";
	case FRS_ERR_PARENT_INSUFFICIENT_PRIV : return "FRS_ERR_PARENT_INSUFFICIENT_PRIV";
	case FRS_ERR_PARENT_AUTHENTICATION : return "FRS_ERR_PARENT_AUTHENTICATION";
	case FRS_ERR_CHILD_TO_PARENT_COMM : return "FRS_ERR_CHILD_TO_PARENT_COMM";
	case FRS_ERR_PARENT_TO_CHILD_COMM : return "FRS_ERR_PARENT_TO_CHILD_COMM";
	case FRS_ERR_SYSVOL_POPULATE :	    return "FRS_ERR_SYSVOL_POPULATE";
	case FRS_ERR_SYSVOL_POPULATE_TIMEOUT : return "FRS_ERR_SYSVOL_POPULATE_TIMEOUT";
	case FRS_ERR_SYSVOL_IS_BUSY :	    return "FRS_ERR_SYSVOL_IS_BUSY";
	case FRS_ERR_SYSVOL_DEMOTE :	    return "FRS_ERR_SYSVOL_DEMOTE";
	case FRS_ERR_INVALID_SERVICE_PARAMETER : return "FRS_ERR_INVALID_SERVICE_PARAMETER";
	case ERROR_DS_NOT_INSTALLED :	    return "ERROR_DS_NOT_INSTALLED";
	case ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY : return "ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY";
	case ERROR_DS_NO_ATTRIBUTE_OR_VALUE : return "ERROR_DS_NO_ATTRIBUTE_OR_VALUE";
	case ERROR_DS_INVALID_ATTRIBUTE_SYNTAX : return "ERROR_DS_INVALID_ATTRIBUTE_SYNTAX";
	case ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED : return "ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED";
	case ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS : return "ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS";
	case ERROR_DS_BUSY :		    return "ERROR_DS_BUSY";
	case ERROR_DS_UNAVAILABLE :	    return "ERROR_DS_UNAVAILABLE";
	case ERROR_DS_NO_RIDS_ALLOCATED :   return "ERROR_DS_NO_RIDS_ALLOCATED";
	case ERROR_DS_NO_MORE_RIDS :	    return "ERROR_DS_NO_MORE_RIDS";
	case ERROR_DS_INCORRECT_ROLE_OWNER : return "ERROR_DS_INCORRECT_ROLE_OWNER";
	case ERROR_DS_RIDMGR_INIT_ERROR :   return "ERROR_DS_RIDMGR_INIT_ERROR";
	case ERROR_DS_OBJ_CLASS_VIOLATION : return "ERROR_DS_OBJ_CLASS_VIOLATION";
	case ERROR_DS_CANT_ON_NON_LEAF :    return "ERROR_DS_CANT_ON_NON_LEAF";
	case ERROR_DS_CANT_ON_RDN :	    return "ERROR_DS_CANT_ON_RDN";
	case ERROR_DS_CANT_MOD_OBJ_CLASS :  return "ERROR_DS_CANT_MOD_OBJ_CLASS";
	case ERROR_DS_CROSS_DOM_MOVE_ERROR : return "ERROR_DS_CROSS_DOM_MOVE_ERROR";
	case ERROR_DS_GC_NOT_AVAILABLE :    return "ERROR_DS_GC_NOT_AVAILABLE";
	case ERROR_SHARED_POLICY :	    return "ERROR_SHARED_POLICY";
	case ERROR_POLICY_OBJECT_NOT_FOUND : return "ERROR_POLICY_OBJECT_NOT_FOUND";
	case ERROR_POLICY_ONLY_IN_DS :	    return "ERROR_POLICY_ONLY_IN_DS";
	case ERROR_PROMOTION_ACTIVE :	    return "ERROR_PROMOTION_ACTIVE";
	case ERROR_NO_PROMOTION_ACTIVE :    return "ERROR_NO_PROMOTION_ACTIVE";
	case ERROR_DS_OPERATIONS_ERROR :    return "ERROR_DS_OPERATIONS_ERROR";
	case ERROR_DS_PROTOCOL_ERROR :	    return "ERROR_DS_PROTOCOL_ERROR";
	case ERROR_DS_TIMELIMIT_EXCEEDED :  return "ERROR_DS_TIMELIMIT_EXCEEDED";
	case ERROR_DS_SIZELIMIT_EXCEEDED :  return "ERROR_DS_SIZELIMIT_EXCEEDED";
	case ERROR_DS_ADMIN_LIMIT_EXCEEDED : return "ERROR_DS_ADMIN_LIMIT_EXCEEDED";
	case ERROR_DS_COMPARE_FALSE :	    return "ERROR_DS_COMPARE_FALSE";
	case ERROR_DS_COMPARE_TRUE :	    return "ERROR_DS_COMPARE_TRUE";
	case ERROR_DS_AUTH_METHOD_NOT_SUPPORTED : return "ERROR_DS_AUTH_METHOD_NOT_SUPPORTED";
	case ERROR_DS_STRONG_AUTH_REQUIRED : return "ERROR_DS_STRONG_AUTH_REQUIRED";
	case ERROR_DS_INAPPROPRIATE_AUTH :  return "ERROR_DS_INAPPROPRIATE_AUTH";
	case ERROR_DS_AUTH_UNKNOWN :	    return "ERROR_DS_AUTH_UNKNOWN";
	case ERROR_DS_REFERRAL :	    return "ERROR_DS_REFERRAL";
	case ERROR_DS_UNAVAILABLE_CRIT_EXTENSION : return "ERROR_DS_UNAVAILABLE_CRIT_EXTENSION";
	case ERROR_DS_CONFIDENTIALITY_REQUIRED : return "ERROR_DS_CONFIDENTIALITY_REQUIRED";
	case ERROR_DS_INAPPROPRIATE_MATCHING : return "ERROR_DS_INAPPROPRIATE_MATCHING";
	case ERROR_DS_CONSTRAINT_VIOLATION : return "ERROR_DS_CONSTRAINT_VIOLATION";
	case ERROR_DS_NO_SUCH_OBJECT :	    return "ERROR_DS_NO_SUCH_OBJECT";
	case ERROR_DS_ALIAS_PROBLEM :	    return "ERROR_DS_ALIAS_PROBLEM";
	case ERROR_DS_INVALID_DN_SYNTAX :   return "ERROR_DS_INVALID_DN_SYNTAX";
	case ERROR_DS_IS_LEAF :		    return "ERROR_DS_IS_LEAF";
	case ERROR_DS_ALIAS_DEREF_PROBLEM : return "ERROR_DS_ALIAS_DEREF_PROBLEM";
	case ERROR_DS_UNWILLING_TO_PERFORM : return "ERROR_DS_UNWILLING_TO_PERFORM";
	case ERROR_DS_LOOP_DETECT :	    return "ERROR_DS_LOOP_DETECT";
	case ERROR_DS_NAMING_VIOLATION :    return "ERROR_DS_NAMING_VIOLATION";
	case ERROR_DS_OBJECT_RESULTS_TOO_LARGE : return "ERROR_DS_OBJECT_RESULTS_TOO_LARGE";
	case ERROR_DS_AFFECTS_MULTIPLE_DSAS : return "ERROR_DS_AFFECTS_MULTIPLE_DSAS";
	case ERROR_DS_SERVER_DOWN :	    return "ERROR_DS_SERVER_DOWN";
	case ERROR_DS_LOCAL_ERROR :	    return "ERROR_DS_LOCAL_ERROR";
	case ERROR_DS_ENCODING_ERROR :	    return "ERROR_DS_ENCODING_ERROR";
	case ERROR_DS_DECODING_ERROR :	    return "ERROR_DS_DECODING_ERROR";
	case ERROR_DS_FILTER_UNKNOWN :	    return "ERROR_DS_FILTER_UNKNOWN";
	case ERROR_DS_PARAM_ERROR :	    return "ERROR_DS_PARAM_ERROR";
	case ERROR_DS_NOT_SUPPORTED :	    return "ERROR_DS_NOT_SUPPORTED";
	case ERROR_DS_NO_RESULTS_RETURNED : return "ERROR_DS_NO_RESULTS_RETURNED";
	case ERROR_DS_CONTROL_NOT_FOUND :   return "ERROR_DS_CONTROL_NOT_FOUND";
	case ERROR_DS_CLIENT_LOOP :	    return "ERROR_DS_CLIENT_LOOP";
	case ERROR_DS_REFERRAL_LIMIT_EXCEEDED : return "ERROR_DS_REFERRAL_LIMIT_EXCEEDED";
	case ERROR_DS_SORT_CONTROL_MISSING : return "ERROR_DS_SORT_CONTROL_MISSING";
	case ERROR_DS_OFFSET_RANGE_ERROR :  return "ERROR_DS_OFFSET_RANGE_ERROR";
	case ERROR_DS_ROOT_MUST_BE_NC :	    return "ERROR_DS_ROOT_MUST_BE_NC";
	case ERROR_DS_ADD_REPLICA_INHIBITED : return "ERROR_DS_ADD_REPLICA_INHIBITED";
	case ERROR_DS_ATT_NOT_DEF_IN_SCHEMA : return "ERROR_DS_ATT_NOT_DEF_IN_SCHEMA";
	case ERROR_DS_MAX_OBJ_SIZE_EXCEEDED : return "ERROR_DS_MAX_OBJ_SIZE_EXCEEDED";
	case ERROR_DS_OBJ_STRING_NAME_EXISTS : return "ERROR_DS_OBJ_STRING_NAME_EXISTS";
	case ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA : return "ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA";
	case ERROR_DS_RDN_DOESNT_MATCH_SCHEMA : return "ERROR_DS_RDN_DOESNT_MATCH_SCHEMA";
	case ERROR_DS_NO_REQUESTED_ATTS_FOUND : return "ERROR_DS_NO_REQUESTED_ATTS_FOUND";
	case ERROR_DS_USER_BUFFER_TO_SMALL : return "ERROR_DS_USER_BUFFER_TO_SMALL";
	case ERROR_DS_ATT_IS_NOT_ON_OBJ :   return "ERROR_DS_ATT_IS_NOT_ON_OBJ";
	case ERROR_DS_ILLEGAL_MOD_OPERATION : return "ERROR_DS_ILLEGAL_MOD_OPERATION";
	case ERROR_DS_OBJ_TOO_LARGE :	    return "ERROR_DS_OBJ_TOO_LARGE";
	case ERROR_DS_BAD_INSTANCE_TYPE :   return "ERROR_DS_BAD_INSTANCE_TYPE";
	case ERROR_DS_MASTERDSA_REQUIRED :  return "ERROR_DS_MASTERDSA_REQUIRED";
	case ERROR_DS_OBJECT_CLASS_REQUIRED : return "ERROR_DS_OBJECT_CLASS_REQUIRED";
	case ERROR_DS_MISSING_REQUIRED_ATT : return "ERROR_DS_MISSING_REQUIRED_ATT";
	case ERROR_DS_ATT_NOT_DEF_FOR_CLASS : return "ERROR_DS_ATT_NOT_DEF_FOR_CLASS";
	case ERROR_DS_ATT_ALREADY_EXISTS :  return "ERROR_DS_ATT_ALREADY_EXISTS";
	case ERROR_DS_CANT_ADD_ATT_VALUES : return "ERROR_DS_CANT_ADD_ATT_VALUES";
	case ERROR_DS_SINGLE_VALUE_CONSTRAINT : return "ERROR_DS_SINGLE_VALUE_CONSTRAINT";
	case ERROR_DS_RANGE_CONSTRAINT :    return "ERROR_DS_RANGE_CONSTRAINT";
	case ERROR_DS_ATT_VAL_ALREADY_EXISTS : return "ERROR_DS_ATT_VAL_ALREADY_EXISTS";
	case ERROR_DS_CANT_REM_MISSING_ATT : return "ERROR_DS_CANT_REM_MISSING_ATT";
	case ERROR_DS_CANT_REM_MISSING_ATT_VAL : return "ERROR_DS_CANT_REM_MISSING_ATT_VAL";
	case ERROR_DS_ROOT_CANT_BE_SUBREF : return "ERROR_DS_ROOT_CANT_BE_SUBREF";
	case ERROR_DS_NO_CHAINING :	    return "ERROR_DS_NO_CHAINING";
	case ERROR_DS_NO_CHAINED_EVAL :	    return "ERROR_DS_NO_CHAINED_EVAL";
	case ERROR_DS_NO_PARENT_OBJECT :    return "ERROR_DS_NO_PARENT_OBJECT";
	case ERROR_DS_PARENT_IS_AN_ALIAS :  return "ERROR_DS_PARENT_IS_AN_ALIAS";
	case ERROR_DS_CANT_MIX_MASTER_AND_REPS : return "ERROR_DS_CANT_MIX_MASTER_AND_REPS";
	case ERROR_DS_CHILDREN_EXIST :	    return "ERROR_DS_CHILDREN_EXIST";
	case ERROR_DS_OBJ_NOT_FOUND :	    return "ERROR_DS_OBJ_NOT_FOUND";
	case ERROR_DS_ALIASED_OBJ_MISSING : return "ERROR_DS_ALIASED_OBJ_MISSING";
	case ERROR_DS_BAD_NAME_SYNTAX :	    return "ERROR_DS_BAD_NAME_SYNTAX";
	case ERROR_DS_ALIAS_POINTS_TO_ALIAS : return "ERROR_DS_ALIAS_POINTS_TO_ALIAS";
	case ERROR_DS_CANT_DEREF_ALIAS :    return "ERROR_DS_CANT_DEREF_ALIAS";
	case ERROR_DS_OUT_OF_SCOPE :	    return "ERROR_DS_OUT_OF_SCOPE";
	case ERROR_DS_OBJECT_BEING_REMOVED : return "ERROR_DS_OBJECT_BEING_REMOVED";
	case ERROR_DS_CANT_DELETE_DSA_OBJ : return "ERROR_DS_CANT_DELETE_DSA_OBJ";
	case ERROR_DS_GENERIC_ERROR :	    return "ERROR_DS_GENERIC_ERROR";
	case ERROR_DS_DSA_MUST_BE_INT_MASTER : return "ERROR_DS_DSA_MUST_BE_INT_MASTER";
	case ERROR_DS_CLASS_NOT_DSA :	    return "ERROR_DS_CLASS_NOT_DSA";
	case ERROR_DS_INSUFF_ACCESS_RIGHTS : return "ERROR_DS_INSUFF_ACCESS_RIGHTS";
	case ERROR_DS_ILLEGAL_SUPERIOR :    return "ERROR_DS_ILLEGAL_SUPERIOR";
	case ERROR_DS_ATTRIBUTE_OWNED_BY_SAM : return "ERROR_DS_ATTRIBUTE_OWNED_BY_SAM";
	case ERROR_DS_NAME_TOO_MANY_PARTS : return "ERROR_DS_NAME_TOO_MANY_PARTS";
	case ERROR_DS_NAME_TOO_LONG :	    return "ERROR_DS_NAME_TOO_LONG";
	case ERROR_DS_NAME_VALUE_TOO_LONG : return "ERROR_DS_NAME_VALUE_TOO_LONG";
	case ERROR_DS_NAME_UNPARSEABLE :    return "ERROR_DS_NAME_UNPARSEABLE";
	case ERROR_DS_NAME_TYPE_UNKNOWN :   return "ERROR_DS_NAME_TYPE_UNKNOWN";
	case ERROR_DS_NOT_AN_OBJECT :	    return "ERROR_DS_NOT_AN_OBJECT";
	case ERROR_DS_SEC_DESC_TOO_SHORT :  return "ERROR_DS_SEC_DESC_TOO_SHORT";
	case ERROR_DS_SEC_DESC_INVALID :    return "ERROR_DS_SEC_DESC_INVALID";
	case ERROR_DS_NO_DELETED_NAME :	    return "ERROR_DS_NO_DELETED_NAME";
	case ERROR_DS_SUBREF_MUST_HAVE_PARENT : return "ERROR_DS_SUBREF_MUST_HAVE_PARENT";
	case ERROR_DS_NCNAME_MUST_BE_NC :   return "ERROR_DS_NCNAME_MUST_BE_NC";
	case ERROR_DS_CANT_ADD_SYSTEM_ONLY : return "ERROR_DS_CANT_ADD_SYSTEM_ONLY";
	case ERROR_DS_CLASS_MUST_BE_CONCRETE : return "ERROR_DS_CLASS_MUST_BE_CONCRETE";
	case ERROR_DS_INVALID_DMD :	    return "ERROR_DS_INVALID_DMD";
	case ERROR_DS_OBJ_GUID_EXISTS :	    return "ERROR_DS_OBJ_GUID_EXISTS";
	case ERROR_DS_NOT_ON_BACKLINK :	    return "ERROR_DS_NOT_ON_BACKLINK";
	case ERROR_DS_NO_CROSSREF_FOR_NC :  return "ERROR_DS_NO_CROSSREF_FOR_NC";
	case ERROR_DS_SHUTTING_DOWN :	    return "ERROR_DS_SHUTTING_DOWN";
	case ERROR_DS_UNKNOWN_OPERATION :   return "ERROR_DS_UNKNOWN_OPERATION";
	case ERROR_DS_INVALID_ROLE_OWNER :  return "ERROR_DS_INVALID_ROLE_OWNER";
	case ERROR_DS_COULDNT_CONTACT_FSMO : return "ERROR_DS_COULDNT_CONTACT_FSMO";
	case ERROR_DS_CROSS_NC_DN_RENAME :  return "ERROR_DS_CROSS_NC_DN_RENAME";
	case ERROR_DS_CANT_MOD_SYSTEM_ONLY : return "ERROR_DS_CANT_MOD_SYSTEM_ONLY";
	case ERROR_DS_REPLICATOR_ONLY :	    return "ERROR_DS_REPLICATOR_ONLY";
	case ERROR_DS_OBJ_CLASS_NOT_DEFINED : return "ERROR_DS_OBJ_CLASS_NOT_DEFINED";
	case ERROR_DS_OBJ_CLASS_NOT_SUBCLASS : return "ERROR_DS_OBJ_CLASS_NOT_SUBCLASS";
	case ERROR_DS_NAME_REFERENCE_INVALID : return "ERROR_DS_NAME_REFERENCE_INVALID";
	case ERROR_DS_CROSS_REF_EXISTS :    return "ERROR_DS_CROSS_REF_EXISTS";
	case ERROR_DS_CANT_DEL_MASTER_CROSSREF : return "ERROR_DS_CANT_DEL_MASTER_CROSSREF";
	case ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD : return "ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD";
	case ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX : return "ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX";
	case ERROR_DS_DUP_RDN :		    return "ERROR_DS_DUP_RDN";
	case ERROR_DS_DUP_OID :		    return "ERROR_DS_DUP_OID";
	case ERROR_DS_DUP_MAPI_ID :	    return "ERROR_DS_DUP_MAPI_ID";
	case ERROR_DS_DUP_SCHEMA_ID_GUID :  return "ERROR_DS_DUP_SCHEMA_ID_GUID";
	case ERROR_DS_DUP_LDAP_DISPLAY_NAME : return "ERROR_DS_DUP_LDAP_DISPLAY_NAME";
	case ERROR_DS_SEMANTIC_ATT_TEST :   return "ERROR_DS_SEMANTIC_ATT_TEST";
	case ERROR_DS_SYNTAX_MISMATCH :	    return "ERROR_DS_SYNTAX_MISMATCH";
	case ERROR_DS_EXISTS_IN_MUST_HAVE : return "ERROR_DS_EXISTS_IN_MUST_HAVE";
	case ERROR_DS_EXISTS_IN_MAY_HAVE :  return "ERROR_DS_EXISTS_IN_MAY_HAVE";
	case ERROR_DS_NONEXISTENT_MAY_HAVE : return "ERROR_DS_NONEXISTENT_MAY_HAVE";
	case ERROR_DS_NONEXISTENT_MUST_HAVE : return "ERROR_DS_NONEXISTENT_MUST_HAVE";
	case ERROR_DS_AUX_CLS_TEST_FAIL :   return "ERROR_DS_AUX_CLS_TEST_FAIL";
	case ERROR_DS_NONEXISTENT_POSS_SUP : return "ERROR_DS_NONEXISTENT_POSS_SUP";
	case ERROR_DS_SUB_CLS_TEST_FAIL :   return "ERROR_DS_SUB_CLS_TEST_FAIL";
	case ERROR_DS_BAD_RDN_ATT_ID_SYNTAX : return "ERROR_DS_BAD_RDN_ATT_ID_SYNTAX";
	case ERROR_DS_EXISTS_IN_AUX_CLS :   return "ERROR_DS_EXISTS_IN_AUX_CLS";
	case ERROR_DS_EXISTS_IN_SUB_CLS :   return "ERROR_DS_EXISTS_IN_SUB_CLS";
	case ERROR_DS_EXISTS_IN_POSS_SUP :  return "ERROR_DS_EXISTS_IN_POSS_SUP";
	case ERROR_DS_RECALCSCHEMA_FAILED : return "ERROR_DS_RECALCSCHEMA_FAILED";
	case ERROR_DS_TREE_DELETE_NOT_FINISHED : return "ERROR_DS_TREE_DELETE_NOT_FINISHED";
	case ERROR_DS_CANT_DELETE :	    return "ERROR_DS_CANT_DELETE";
	case ERROR_DS_ATT_SCHEMA_REQ_ID :   return "ERROR_DS_ATT_SCHEMA_REQ_ID";
	case ERROR_DS_BAD_ATT_SCHEMA_SYNTAX : return "ERROR_DS_BAD_ATT_SCHEMA_SYNTAX";
	case ERROR_DS_CANT_CACHE_ATT :	    return "ERROR_DS_CANT_CACHE_ATT";
	case ERROR_DS_CANT_CACHE_CLASS :    return "ERROR_DS_CANT_CACHE_CLASS";
	case ERROR_DS_CANT_REMOVE_ATT_CACHE : return "ERROR_DS_CANT_REMOVE_ATT_CACHE";
	case ERROR_DS_CANT_REMOVE_CLASS_CACHE : return "ERROR_DS_CANT_REMOVE_CLASS_CACHE";
	case ERROR_DS_CANT_RETRIEVE_DN :    return "ERROR_DS_CANT_RETRIEVE_DN";
	case ERROR_DS_MISSING_SUPREF :	    return "ERROR_DS_MISSING_SUPREF";
	case ERROR_DS_CANT_RETRIEVE_INSTANCE : return "ERROR_DS_CANT_RETRIEVE_INSTANCE";
	case ERROR_DS_CODE_INCONSISTENCY :  return "ERROR_DS_CODE_INCONSISTENCY";
	case ERROR_DS_DATABASE_ERROR :	    return "ERROR_DS_DATABASE_ERROR";
	case ERROR_DS_GOVERNSID_MISSING :   return "ERROR_DS_GOVERNSID_MISSING";
	case ERROR_DS_MISSING_EXPECTED_ATT : return "ERROR_DS_MISSING_EXPECTED_ATT";
	case ERROR_DS_NCNAME_MISSING_CR_REF : return "ERROR_DS_NCNAME_MISSING_CR_REF";
	case ERROR_DS_SECURITY_CHECKING_ERROR : return "ERROR_DS_SECURITY_CHECKING_ERROR";
	case ERROR_DS_SCHEMA_NOT_LOADED :   return "ERROR_DS_SCHEMA_NOT_LOADED";
	case ERROR_DS_SCHEMA_ALLOC_FAILED : return "ERROR_DS_SCHEMA_ALLOC_FAILED";
	case ERROR_DS_ATT_SCHEMA_REQ_SYNTAX : return "ERROR_DS_ATT_SCHEMA_REQ_SYNTAX";
	case ERROR_DS_GCVERIFY_ERROR :	    return "ERROR_DS_GCVERIFY_ERROR";
	case ERROR_DS_DRA_SCHEMA_MISMATCH : return "ERROR_DS_DRA_SCHEMA_MISMATCH";
	case ERROR_DS_CANT_FIND_DSA_OBJ :   return "ERROR_DS_CANT_FIND_DSA_OBJ";
	case ERROR_DS_CANT_FIND_EXPECTED_NC : return "ERROR_DS_CANT_FIND_EXPECTED_NC";
	case ERROR_DS_CANT_FIND_NC_IN_CACHE : return "ERROR_DS_CANT_FIND_NC_IN_CACHE";
	case ERROR_DS_CANT_RETRIEVE_CHILD : return "ERROR_DS_CANT_RETRIEVE_CHILD";
	case ERROR_DS_SECURITY_ILLEGAL_MODIFY : return "ERROR_DS_SECURITY_ILLEGAL_MODIFY";
	case ERROR_DS_CANT_REPLACE_HIDDEN_REC : return "ERROR_DS_CANT_REPLACE_HIDDEN_REC";
	case ERROR_DS_BAD_HIERARCHY_FILE :  return "ERROR_DS_BAD_HIERARCHY_FILE";
	case ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED : return "ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED";
	case ERROR_DS_CONFIG_PARAM_MISSING : return "ERROR_DS_CONFIG_PARAM_MISSING";
	case ERROR_DS_COUNTING_AB_INDICES_FAILED : return "ERROR_DS_COUNTING_AB_INDICES_FAILED";
	case ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED : return "ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED";
	case ERROR_DS_INTERNAL_FAILURE :    return "ERROR_DS_INTERNAL_FAILURE";
	case ERROR_DS_UNKNOWN_ERROR :	    return "ERROR_DS_UNKNOWN_ERROR";
	case ERROR_DS_ROOT_REQUIRES_CLASS_TOP : return "ERROR_DS_ROOT_REQUIRES_CLASS_TOP";
	case ERROR_DS_REFUSING_FSMO_ROLES : return "ERROR_DS_REFUSING_FSMO_ROLES";
	case ERROR_DS_MISSING_FSMO_SETTINGS : return "ERROR_DS_MISSING_FSMO_SETTINGS";
	case ERROR_DS_UNABLE_TO_SURRENDER_ROLES : return "ERROR_DS_UNABLE_TO_SURRENDER_ROLES";
	case ERROR_DS_DRA_GENERIC :	    return "ERROR_DS_DRA_GENERIC";
	case ERROR_DS_DRA_INVALID_PARAMETER : return "ERROR_DS_DRA_INVALID_PARAMETER";
	case ERROR_DS_DRA_BUSY :	    return "ERROR_DS_DRA_BUSY";
	case ERROR_DS_DRA_BAD_DN :	    return "ERROR_DS_DRA_BAD_DN";
	case ERROR_DS_DRA_BAD_NC :	    return "ERROR_DS_DRA_BAD_NC";
	case ERROR_DS_DRA_DN_EXISTS :	    return "ERROR_DS_DRA_DN_EXISTS";
	case ERROR_DS_DRA_INTERNAL_ERROR :  return "ERROR_DS_DRA_INTERNAL_ERROR";
	case ERROR_DS_DRA_INCONSISTENT_DIT : return "ERROR_DS_DRA_INCONSISTENT_DIT";
	case ERROR_DS_DRA_CONNECTION_FAILED : return "ERROR_DS_DRA_CONNECTION_FAILED";
	case ERROR_DS_DRA_BAD_INSTANCE_TYPE : return "ERROR_DS_DRA_BAD_INSTANCE_TYPE";
	case ERROR_DS_DRA_OUT_OF_MEM :	    return "ERROR_DS_DRA_OUT_OF_MEM";
	case ERROR_DS_DRA_MAIL_PROBLEM :    return "ERROR_DS_DRA_MAIL_PROBLEM";
	case ERROR_DS_DRA_REF_ALREADY_EXISTS : return "ERROR_DS_DRA_REF_ALREADY_EXISTS";
	case ERROR_DS_DRA_REF_NOT_FOUND :   return "ERROR_DS_DRA_REF_NOT_FOUND";
	case ERROR_DS_DRA_OBJ_IS_REP_SOURCE : return "ERROR_DS_DRA_OBJ_IS_REP_SOURCE";
	case ERROR_DS_DRA_DB_ERROR :	    return "ERROR_DS_DRA_DB_ERROR";
	case ERROR_DS_DRA_NO_REPLICA :	    return "ERROR_DS_DRA_NO_REPLICA";
	case ERROR_DS_DRA_ACCESS_DENIED :   return "ERROR_DS_DRA_ACCESS_DENIED";
	case ERROR_DS_DRA_NOT_SUPPORTED :   return "ERROR_DS_DRA_NOT_SUPPORTED";
	case ERROR_DS_DRA_RPC_CANCELLED :   return "ERROR_DS_DRA_RPC_CANCELLED";
	case ERROR_DS_DRA_SOURCE_DISABLED : return "ERROR_DS_DRA_SOURCE_DISABLED";
	case ERROR_DS_DRA_SINK_DISABLED :   return "ERROR_DS_DRA_SINK_DISABLED";
	case ERROR_DS_DRA_NAME_COLLISION :  return "ERROR_DS_DRA_NAME_COLLISION";
	case ERROR_DS_DRA_SOURCE_REINSTALLED : return "ERROR_DS_DRA_SOURCE_REINSTALLED";
	case ERROR_DS_DRA_MISSING_PARENT :  return "ERROR_DS_DRA_MISSING_PARENT";
	case ERROR_DS_DRA_PREEMPTED :	    return "ERROR_DS_DRA_PREEMPTED";
	case ERROR_DS_DRA_ABANDON_SYNC :    return "ERROR_DS_DRA_ABANDON_SYNC";
	case ERROR_DS_DRA_SHUTDOWN :	    return "ERROR_DS_DRA_SHUTDOWN";
	case ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET : return "ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET";
	case ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA : return "ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA";
	case ERROR_DS_DRA_EXTN_CONNECTION_FAILED : return "ERROR_DS_DRA_EXTN_CONNECTION_FAILED";
	case ERROR_DS_INSTALL_SCHEMA_MISMATCH : return "ERROR_DS_INSTALL_SCHEMA_MISMATCH";
	case ERROR_DS_DUP_LINK_ID :	    return "ERROR_DS_DUP_LINK_ID";
	case ERROR_DS_NAME_ERROR_RESOLVING : return "ERROR_DS_NAME_ERROR_RESOLVING";
	case ERROR_DS_NAME_ERROR_NOT_FOUND : return "ERROR_DS_NAME_ERROR_NOT_FOUND";
	case ERROR_DS_NAME_ERROR_NOT_UNIQUE : return "ERROR_DS_NAME_ERROR_NOT_UNIQUE";
	case ERROR_DS_NAME_ERROR_NO_MAPPING : return "ERROR_DS_NAME_ERROR_NO_MAPPING";
	case ERROR_DS_NAME_ERROR_DOMAIN_ONLY : return "ERROR_DS_NAME_ERROR_DOMAIN_ONLY";
	case ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING : return "ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING";
	case ERROR_DS_CONSTRUCTED_ATT_MOD : return "ERROR_DS_CONSTRUCTED_ATT_MOD";
	case ERROR_DS_WRONG_OM_OBJ_CLASS :  return "ERROR_DS_WRONG_OM_OBJ_CLASS";
	case ERROR_DS_DRA_REPL_PENDING :    return "ERROR_DS_DRA_REPL_PENDING";
	case ERROR_DS_DS_REQUIRED :	    return "ERROR_DS_DS_REQUIRED";
	case ERROR_DS_INVALID_LDAP_DISPLAY_NAME : return "ERROR_DS_INVALID_LDAP_DISPLAY_NAME";
	case ERROR_DS_NON_BASE_SEARCH :	    return "ERROR_DS_NON_BASE_SEARCH";
	case ERROR_DS_CANT_RETRIEVE_ATTS :  return "ERROR_DS_CANT_RETRIEVE_ATTS";
	case ERROR_DS_BACKLINK_WITHOUT_LINK : return "ERROR_DS_BACKLINK_WITHOUT_LINK";
	case ERROR_DS_EPOCH_MISMATCH :	    return "ERROR_DS_EPOCH_MISMATCH";
	case ERROR_DS_SRC_NAME_MISMATCH :   return "ERROR_DS_SRC_NAME_MISMATCH";
	case ERROR_DS_SRC_AND_DST_NC_IDENTICAL : return "ERROR_DS_SRC_AND_DST_NC_IDENTICAL";
	case ERROR_DS_DST_NC_MISMATCH :	    return "ERROR_DS_DST_NC_MISMATCH";
	case ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC : return "ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC";
	case ERROR_DS_SRC_GUID_MISMATCH :   return "ERROR_DS_SRC_GUID_MISMATCH";
	case ERROR_DS_CANT_MOVE_DELETED_OBJECT : return "ERROR_DS_CANT_MOVE_DELETED_OBJECT";
	case ERROR_DS_PDC_OPERATION_IN_PROGRESS : return "ERROR_DS_PDC_OPERATION_IN_PROGRESS";
	case ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD : return "ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD";
	case ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION : return "ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION";
	case ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS : return "ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS";
	case ERROR_DS_NC_MUST_HAVE_NC_PARENT : return "ERROR_DS_NC_MUST_HAVE_NC_PARENT";
	case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE : return "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE";
	case ERROR_DS_DST_DOMAIN_NOT_NATIVE : return "ERROR_DS_DST_DOMAIN_NOT_NATIVE";
	case ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER : return "ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER";
	case ERROR_DS_CANT_MOVE_ACCOUNT_GROUP : return "ERROR_DS_CANT_MOVE_ACCOUNT_GROUP";
	case ERROR_DS_CANT_MOVE_RESOURCE_GROUP : return "ERROR_DS_CANT_MOVE_RESOURCE_GROUP";
	case ERROR_DS_INVALID_SEARCH_FLAG : return "ERROR_DS_INVALID_SEARCH_FLAG";
	case ERROR_DS_NO_TREE_DELETE_ABOVE_NC : return "ERROR_DS_NO_TREE_DELETE_ABOVE_NC";
	case ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE : return "ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE";
	case ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE : return "ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE";
	case ERROR_DS_SAM_INIT_FAILURE :    return "ERROR_DS_SAM_INIT_FAILURE";
	case ERROR_DS_SENSITIVE_GROUP_VIOLATION : return "ERROR_DS_SENSITIVE_GROUP_VIOLATION";
	case ERROR_DS_CANT_MOD_PRIMARYGROUPID : return "ERROR_DS_CANT_MOD_PRIMARYGROUPID";
	case ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD : return "ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD";
	case ERROR_DS_NONSAFE_SCHEMA_CHANGE : return "ERROR_DS_NONSAFE_SCHEMA_CHANGE";
	case ERROR_DS_SCHEMA_UPDATE_DISALLOWED : return "ERROR_DS_SCHEMA_UPDATE_DISALLOWED";
	case ERROR_DS_CANT_CREATE_UNDER_SCHEMA : return "ERROR_DS_CANT_CREATE_UNDER_SCHEMA";
	case ERROR_DS_INSTALL_NO_SRC_SCH_VERSION : return "ERROR_DS_INSTALL_NO_SRC_SCH_VERSION";
	case ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE : return "ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE";
	case ERROR_DS_INVALID_GROUP_TYPE :  return "ERROR_DS_INVALID_GROUP_TYPE";
	case ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN : return "ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN";
	case ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN : return "ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN";
	case ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER : return "ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER";
	case ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER : return "ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER";
	case ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER : return "ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER";
	case ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER : return "ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER";
	case ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER : return "ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER";
	case ERROR_DS_HAVE_PRIMARY_MEMBERS : return "ERROR_DS_HAVE_PRIMARY_MEMBERS";
	case ERROR_DS_STRING_SD_CONVERSION_FAILED : return "ERROR_DS_STRING_SD_CONVERSION_FAILED";
	case ERROR_DS_NAMING_MASTER_GC :    return "ERROR_DS_NAMING_MASTER_GC";
	case ERROR_DS_DNS_LOOKUP_FAILURE :  return "ERROR_DS_DNS_LOOKUP_FAILURE";
	case ERROR_DS_COULDNT_UPDATE_SPNS : return "ERROR_DS_COULDNT_UPDATE_SPNS";
	case ERROR_DS_CANT_RETRIEVE_SD :    return "ERROR_DS_CANT_RETRIEVE_SD";
	case ERROR_DS_KEY_NOT_UNIQUE :	    return "ERROR_DS_KEY_NOT_UNIQUE";
	case ERROR_DS_WRONG_LINKED_ATT_SYNTAX : return "ERROR_DS_WRONG_LINKED_ATT_SYNTAX";
	case ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD : return "ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD";
	case ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY : return "ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY";
	case ERROR_DS_CANT_START :	    return "ERROR_DS_CANT_START";
	case ERROR_DS_INIT_FAILURE :	    return "ERROR_DS_INIT_FAILURE";
	case ERROR_DS_SAM_INIT_FAILURE_CONSOLE : return "ERROR_DS_SAM_INIT_FAILURE_CONSOLE";
	case ERROR_DS_FOREST_VERSION_TOO_HIGH : return "ERROR_DS_FOREST_VERSION_TOO_HIGH";
	case ERROR_DS_DOMAIN_VERSION_TOO_HIGH : return "ERROR_DS_DOMAIN_VERSION_TOO_HIGH";
	case ERROR_DS_FOREST_VERSION_TOO_LOW : return "ERROR_DS_FOREST_VERSION_TOO_LOW";
	case ERROR_DS_DOMAIN_VERSION_TOO_LOW : return "ERROR_DS_DOMAIN_VERSION_TOO_LOW";
	case ERROR_DS_INCOMPATIBLE_VERSION : return "ERROR_DS_INCOMPATIBLE_VERSION";
	case ERROR_DS_LOW_DSA_VERSION :	    return "ERROR_DS_LOW_DSA_VERSION";
	case ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN : return "ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN";
	case ERROR_DS_NOT_SUPPORTED_SORT_ORDER : return "ERROR_DS_NOT_SUPPORTED_SORT_ORDER";
	case ERROR_DS_NAME_NOT_UNIQUE :	    return "ERROR_DS_NAME_NOT_UNIQUE";
	case ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 : return "ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4";
	case ERROR_DS_OUT_OF_VERSION_STORE : return "ERROR_DS_OUT_OF_VERSION_STORE";
	case ERROR_DS_INCOMPATIBLE_CONTROLS_USED : return "ERROR_DS_INCOMPATIBLE_CONTROLS_USED";
	case ERROR_DS_NO_REF_DOMAIN :	    return "ERROR_DS_NO_REF_DOMAIN";
	case ERROR_DS_RESERVED_LINK_ID :    return "ERROR_DS_RESERVED_LINK_ID";
	case ERROR_DS_LINK_ID_NOT_AVAILABLE : return "ERROR_DS_LINK_ID_NOT_AVAILABLE";
	case ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER : return "ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER";
	case ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE : return "ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE";
	case ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC : return "ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC";
	case ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG : return "ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG";
	case ERROR_DS_MODIFYDN_WRONG_GRANDPARENT : return "ERROR_DS_MODIFYDN_WRONG_GRANDPARENT";
	case ERROR_DS_NAME_ERROR_TRUST_REFERRAL : return "ERROR_DS_NAME_ERROR_TRUST_REFERRAL";
	case ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER : return "ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER";
	case ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD : return "ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD";
	case ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 : return "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2";
	case ERROR_DS_THREAD_LIMIT_EXCEEDED : return "ERROR_DS_THREAD_LIMIT_EXCEEDED";
	case ERROR_DS_NOT_CLOSEST :	    return "ERROR_DS_NOT_CLOSEST";
	case ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF : return "ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF";
	case ERROR_DS_SINGLE_USER_MODE_FAILED : return "ERROR_DS_SINGLE_USER_MODE_FAILED";
	case ERROR_DS_NTDSCRIPT_SYNTAX_ERROR : return "ERROR_DS_NTDSCRIPT_SYNTAX_ERROR";
	case ERROR_DS_NTDSCRIPT_PROCESS_ERROR : return "ERROR_DS_NTDSCRIPT_PROCESS_ERROR";
	case ERROR_DS_DIFFERENT_REPL_EPOCHS : return "ERROR_DS_DIFFERENT_REPL_EPOCHS";
	case ERROR_DS_DRS_EXTENSIONS_CHANGED : return "ERROR_DS_DRS_EXTENSIONS_CHANGED";
	case ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR : return "ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR";
	case ERROR_DS_NO_MSDS_INTID :	    return "ERROR_DS_NO_MSDS_INTID";
	case ERROR_DS_DUP_MSDS_INTID :	    return "ERROR_DS_DUP_MSDS_INTID";
	case ERROR_DS_EXISTS_IN_RDNATTID :  return "ERROR_DS_EXISTS_IN_RDNATTID";
	case ERROR_DS_AUTHORIZATION_FAILED : return "ERROR_DS_AUTHORIZATION_FAILED";
	case ERROR_DS_INVALID_SCRIPT :	    return "ERROR_DS_INVALID_SCRIPT";
	case ERROR_DS_REMOTE_CROSSREF_OP_FAILED : return "ERROR_DS_REMOTE_CROSSREF_OP_FAILED";
	case ERROR_DS_CROSS_REF_BUSY :	    return "ERROR_DS_CROSS_REF_BUSY";
	case ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN : return "ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN";
	case ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC : return "ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC";
	case ERROR_DS_DUPLICATE_ID_FOUND :  return "ERROR_DS_DUPLICATE_ID_FOUND";
	case ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT : return "ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT";
	case ERROR_DS_GROUP_CONVERSION_ERROR : return "ERROR_DS_GROUP_CONVERSION_ERROR";
	case ERROR_DS_CANT_MOVE_APP_BASIC_GROUP : return "ERROR_DS_CANT_MOVE_APP_BASIC_GROUP";
	case ERROR_DS_CANT_MOVE_APP_QUERY_GROUP : return "ERROR_DS_CANT_MOVE_APP_QUERY_GROUP";
	case ERROR_DS_ROLE_NOT_VERIFIED :   return "ERROR_DS_ROLE_NOT_VERIFIED";
	case ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL : return "ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL";
	case ERROR_DS_DOMAIN_RENAME_IN_PROGRESS : return "ERROR_DS_DOMAIN_RENAME_IN_PROGRESS";
	case ERROR_DS_EXISTING_AD_CHILD_NC : return "ERROR_DS_EXISTING_AD_CHILD_NC";
	case ERROR_DS_REPL_LIFETIME_EXCEEDED : return "ERROR_DS_REPL_LIFETIME_EXCEEDED";
	case ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER : return "ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER";
	case ERROR_DS_LDAP_SEND_QUEUE_FULL : return "ERROR_DS_LDAP_SEND_QUEUE_FULL";
	case ERROR_DS_DRA_OUT_SCHEDULE_WINDOW : return "ERROR_DS_DRA_OUT_SCHEDULE_WINDOW";
	// DNS Error Codes
	case DNS_ERROR_RCODE_FORMAT_ERROR : return "DNS_ERROR_RCODE_FORMAT_ERROR";
	case DNS_ERROR_RCODE_SERVER_FAILURE : return "DNS_ERROR_RCODE_SERVER_FAILURE";
	case DNS_ERROR_RCODE_NAME_ERROR :   return "DNS_ERROR_RCODE_NAME_ERROR";
	case DNS_ERROR_RCODE_NOT_IMPLEMENTED : return "DNS_ERROR_RCODE_NOT_IMPLEMENTED";
	case DNS_ERROR_RCODE_REFUSED :	    return "DNS_ERROR_RCODE_REFUSED";
	case DNS_ERROR_RCODE_YXDOMAIN :	    return "DNS_ERROR_RCODE_YXDOMAIN";
	case DNS_ERROR_RCODE_YXRRSET :	    return "DNS_ERROR_RCODE_YXRRSET";
	case DNS_ERROR_RCODE_NXRRSET :	    return "DNS_ERROR_RCODE_NXRRSET";
	case DNS_ERROR_RCODE_NOTAUTH :	    return "DNS_ERROR_RCODE_NOTAUTH";
	case DNS_ERROR_RCODE_NOTZONE :	    return "DNS_ERROR_RCODE_NOTZONE";
	case DNS_ERROR_RCODE_BADSIG :	    return "DNS_ERROR_RCODE_BADSIG";
	case DNS_ERROR_RCODE_BADKEY :	    return "DNS_ERROR_RCODE_BADKEY";
	case DNS_ERROR_RCODE_BADTIME :	    return "DNS_ERROR_RCODE_BADTIME";
	case DNS_INFO_NO_RECORDS :	    return "DNS_INFO_NO_RECORDS";
	case DNS_ERROR_BAD_PACKET :	    return "DNS_ERROR_BAD_PACKET";
	case DNS_ERROR_NO_PACKET :	    return "DNS_ERROR_NO_PACKET";
	case DNS_ERROR_RCODE :		    return "DNS_ERROR_RCODE";
	case DNS_ERROR_UNSECURE_PACKET :    return "DNS_ERROR_UNSECURE_PACKET";
	case DNS_ERROR_INVALID_TYPE :	    return "DNS_ERROR_INVALID_TYPE";
	case DNS_ERROR_INVALID_IP_ADDRESS : return "DNS_ERROR_INVALID_IP_ADDRESS";
	case DNS_ERROR_INVALID_PROPERTY :   return "DNS_ERROR_INVALID_PROPERTY";
	case DNS_ERROR_TRY_AGAIN_LATER :    return "DNS_ERROR_TRY_AGAIN_LATER";
	case DNS_ERROR_NOT_UNIQUE :	    return "DNS_ERROR_NOT_UNIQUE";
	case DNS_ERROR_NON_RFC_NAME :	    return "DNS_ERROR_NON_RFC_NAME";
	case DNS_STATUS_FQDN :		    return "DNS_STATUS_FQDN";
	case DNS_STATUS_DOTTED_NAME :	    return "DNS_STATUS_DOTTED_NAME";
	case DNS_STATUS_SINGLE_PART_NAME :  return "DNS_STATUS_SINGLE_PART_NAME";
	case DNS_ERROR_INVALID_NAME_CHAR :  return "DNS_ERROR_INVALID_NAME_CHAR";
	case DNS_ERROR_NUMERIC_NAME :	    return "DNS_ERROR_NUMERIC_NAME";
	case DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER : return "DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER";
	case DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION : return "DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION";
	case DNS_ERROR_CANNOT_FIND_ROOT_HINTS : return "DNS_ERROR_CANNOT_FIND_ROOT_HINTS";
	case DNS_ERROR_INCONSISTENT_ROOT_HINTS : return "DNS_ERROR_INCONSISTENT_ROOT_HINTS";
	case DNS_ERROR_ZONE_DOES_NOT_EXIST : return "DNS_ERROR_ZONE_DOES_NOT_EXIST";
	case DNS_ERROR_NO_ZONE_INFO :	    return "DNS_ERROR_NO_ZONE_INFO";
	case DNS_ERROR_INVALID_ZONE_OPERATION : return "DNS_ERROR_INVALID_ZONE_OPERATION";
	case DNS_ERROR_ZONE_CONFIGURATION_ERROR : return "DNS_ERROR_ZONE_CONFIGURATION_ERROR";
	case DNS_ERROR_ZONE_HAS_NO_SOA_RECORD : return "DNS_ERROR_ZONE_HAS_NO_SOA_RECORD";
	case DNS_ERROR_ZONE_HAS_NO_NS_RECORDS : return "DNS_ERROR_ZONE_HAS_NO_NS_RECORDS";
	case DNS_ERROR_ZONE_LOCKED :	    return "DNS_ERROR_ZONE_LOCKED";
	case DNS_ERROR_ZONE_CREATION_FAILED : return "DNS_ERROR_ZONE_CREATION_FAILED";
	case DNS_ERROR_ZONE_ALREADY_EXISTS : return "DNS_ERROR_ZONE_ALREADY_EXISTS";
	case DNS_ERROR_AUTOZONE_ALREADY_EXISTS : return "DNS_ERROR_AUTOZONE_ALREADY_EXISTS";
	case DNS_ERROR_INVALID_ZONE_TYPE :  return "DNS_ERROR_INVALID_ZONE_TYPE";
	case DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP : return "DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP";
	case DNS_ERROR_ZONE_NOT_SECONDARY : return "DNS_ERROR_ZONE_NOT_SECONDARY";
	case DNS_ERROR_NEED_SECONDARY_ADDRESSES : return "DNS_ERROR_NEED_SECONDARY_ADDRESSES";
	case DNS_ERROR_WINS_INIT_FAILED :   return "DNS_ERROR_WINS_INIT_FAILED";
	case DNS_ERROR_NEED_WINS_SERVERS :  return "DNS_ERROR_NEED_WINS_SERVERS";
	case DNS_ERROR_NBSTAT_INIT_FAILED : return "DNS_ERROR_NBSTAT_INIT_FAILED";
	case DNS_ERROR_SOA_DELETE_INVALID : return "DNS_ERROR_SOA_DELETE_INVALID";
	case DNS_ERROR_FORWARDER_ALREADY_EXISTS : return "DNS_ERROR_FORWARDER_ALREADY_EXISTS";
	case DNS_ERROR_ZONE_REQUIRES_MASTER_IP : return "DNS_ERROR_ZONE_REQUIRES_MASTER_IP";
	case DNS_ERROR_ZONE_IS_SHUTDOWN :   return "DNS_ERROR_ZONE_IS_SHUTDOWN";
	case DNS_ERROR_PRIMARY_REQUIRES_DATAFILE : return "DNS_ERROR_PRIMARY_REQUIRES_DATAFILE";
	case DNS_ERROR_INVALID_DATAFILE_NAME : return "DNS_ERROR_INVALID_DATAFILE_NAME";
	case DNS_ERROR_DATAFILE_OPEN_FAILURE : return "DNS_ERROR_DATAFILE_OPEN_FAILURE";
	case DNS_ERROR_FILE_WRITEBACK_FAILED : return "DNS_ERROR_FILE_WRITEBACK_FAILED";
	case DNS_ERROR_DATAFILE_PARSING :   return "DNS_ERROR_DATAFILE_PARSING";
	case DNS_ERROR_RECORD_DOES_NOT_EXIST : return "DNS_ERROR_RECORD_DOES_NOT_EXIST";
	case DNS_ERROR_RECORD_FORMAT :	    return "DNS_ERROR_RECORD_FORMAT";
	case DNS_ERROR_NODE_CREATION_FAILED : return "DNS_ERROR_NODE_CREATION_FAILED";
	case DNS_ERROR_UNKNOWN_RECORD_TYPE : return "DNS_ERROR_UNKNOWN_RECORD_TYPE";
	case DNS_ERROR_RECORD_TIMED_OUT :   return "DNS_ERROR_RECORD_TIMED_OUT";
	case DNS_ERROR_NAME_NOT_IN_ZONE :   return "DNS_ERROR_NAME_NOT_IN_ZONE";
	case DNS_ERROR_CNAME_LOOP :	    return "DNS_ERROR_CNAME_LOOP";
	case DNS_ERROR_NODE_IS_CNAME :	    return "DNS_ERROR_NODE_IS_CNAME";
	case DNS_ERROR_CNAME_COLLISION :    return "DNS_ERROR_CNAME_COLLISION";
	case DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT : return "DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT";
	case DNS_ERROR_RECORD_ALREADY_EXISTS : return "DNS_ERROR_RECORD_ALREADY_EXISTS";
	case DNS_ERROR_SECONDARY_DATA :	    return "DNS_ERROR_SECONDARY_DATA";
	case DNS_ERROR_NO_CREATE_CACHE_DATA : return "DNS_ERROR_NO_CREATE_CACHE_DATA";
	case DNS_ERROR_NAME_DOES_NOT_EXIST : return "DNS_ERROR_NAME_DOES_NOT_EXIST";
	case DNS_WARNING_PTR_CREATE_FAILED : return "DNS_WARNING_PTR_CREATE_FAILED";
	case DNS_WARNING_DOMAIN_UNDELETED : return "DNS_WARNING_DOMAIN_UNDELETED";
	case DNS_ERROR_DS_UNAVAILABLE :	    return "DNS_ERROR_DS_UNAVAILABLE";
	case DNS_ERROR_DS_ZONE_ALREADY_EXISTS : return "DNS_ERROR_DS_ZONE_ALREADY_EXISTS";
	case DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE : return "DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE";
	case DNS_INFO_AXFR_COMPLETE :	    return "DNS_INFO_AXFR_COMPLETE";
	case DNS_ERROR_AXFR :		    return "DNS_ERROR_AXFR";
	case DNS_INFO_ADDED_LOCAL_WINS :    return "DNS_INFO_ADDED_LOCAL_WINS";
	case DNS_STATUS_CONTINUE_NEEDED :   return "DNS_STATUS_CONTINUE_NEEDED";
	case DNS_ERROR_NO_TCPIP :	    return "DNS_ERROR_NO_TCPIP";
	case DNS_ERROR_NO_DNS_SERVERS :	    return "DNS_ERROR_NO_DNS_SERVERS";
	case DNS_ERROR_DP_DOES_NOT_EXIST :  return "DNS_ERROR_DP_DOES_NOT_EXIST";
	case DNS_ERROR_DP_ALREADY_EXISTS :  return "DNS_ERROR_DP_ALREADY_EXISTS";
	case DNS_ERROR_DP_NOT_ENLISTED :    return "DNS_ERROR_DP_NOT_ENLISTED";
	case DNS_ERROR_DP_ALREADY_ENLISTED : return "DNS_ERROR_DP_ALREADY_ENLISTED";
	case DNS_ERROR_DP_NOT_AVAILABLE :   return "DNS_ERROR_DP_NOT_AVAILABLE";
	case DNS_ERROR_DP_FSMO_ERROR :	    return "DNS_ERROR_DP_FSMO_ERROR";
	// WinSock Error Codes
	case WSAEINTR :			    return "WSAEINTR";
	case WSAEBADF :			    return "WSAEBADF";
	case WSAEACCES :		    return "WSAEACCES";
	case WSAEFAULT :		    return "WSAEFAULT";
	case WSAEINVAL :		    return "WSAEINVAL";
	case WSAEMFILE :		    return "WSAEMFILE";
	case WSAEWOULDBLOCK :		    return "WSAEWOULDBLOCK";
	case WSAEINPROGRESS :		    return "WSAEINPROGRESS";
	case WSAEALREADY :		    return "WSAEALREADY";
	case WSAENOTSOCK :		    return "WSAENOTSOCK";
	case WSAEDESTADDRREQ :		    return "WSAEDESTADDRREQ";
	case WSAEMSGSIZE :		    return "WSAEMSGSIZE";
	case WSAEPROTOTYPE :		    return "WSAEPROTOTYPE";
	case WSAENOPROTOOPT :		    return "WSAENOPROTOOPT";
	case WSAEPROTONOSUPPORT :	    return "WSAEPROTONOSUPPORT";
	case WSAESOCKTNOSUPPORT :	    return "WSAESOCKTNOSUPPORT";
	case WSAEOPNOTSUPP :		    return "WSAEOPNOTSUPP";
	case WSAEPFNOSUPPORT :		    return "WSAEPFNOSUPPORT";
	case WSAEAFNOSUPPORT :		    return "WSAEAFNOSUPPORT";
	case WSAEADDRINUSE :		    return "WSAEADDRINUSE";
	case WSAEADDRNOTAVAIL :		    return "WSAEADDRNOTAVAIL";
	case WSAENETDOWN :		    return "WSAENETDOWN";
	case WSAENETUNREACH :		    return "WSAENETUNREACH";
	case WSAENETRESET :		    return "WSAENETRESET";
	case WSAECONNABORTED :		    return "WSAECONNABORTED";
	case WSAECONNRESET :		    return "WSAECONNRESET";
	case WSAENOBUFS :		    return "WSAENOBUFS";
	case WSAEISCONN :		    return "WSAEISCONN";
	case WSAENOTCONN :		    return "WSAENOTCONN";
	case WSAESHUTDOWN :		    return "WSAESHUTDOWN";
	case WSAETOOMANYREFS :		    return "WSAETOOMANYREFS";
	case WSAETIMEDOUT :		    return "WSAETIMEDOUT";
	case WSAECONNREFUSED :		    return "WSAECONNREFUSED";
	case WSAELOOP :			    return "WSAELOOP";
	case WSAENAMETOOLONG :		    return "WSAENAMETOOLONG";
	case WSAEHOSTDOWN :		    return "WSAEHOSTDOWN";
	case WSAEHOSTUNREACH :		    return "WSAEHOSTUNREACH";
	case WSAENOTEMPTY :		    return "WSAENOTEMPTY";
	case WSAEPROCLIM :		    return "WSAEPROCLIM";
	case WSAEUSERS :		    return "WSAEUSERS";
	case WSAEDQUOT :		    return "WSAEDQUOT";
	case WSAESTALE :		    return "WSAESTALE";
	case WSAEREMOTE :		    return "WSAEREMOTE";
	case WSASYSNOTREADY :		    return "WSASYSNOTREADY";
	case WSAVERNOTSUPPORTED :	    return "WSAVERNOTSUPPORTED";
	case WSANOTINITIALISED :	    return "WSANOTINITIALISED";
	case WSAEDISCON :		    return "WSAEDISCON";
	case WSAENOMORE :		    return "WSAENOMORE";
	case WSAECANCELLED :		    return "WSAECANCELLED";
	case WSAEINVALIDPROCTABLE :	    return "WSAEINVALIDPROCTABLE";
	case WSAEINVALIDPROVIDER :	    return "WSAEINVALIDPROVIDER";
	case WSAEPROVIDERFAILEDINIT :	    return "WSAEPROVIDERFAILEDINIT";
	case WSASYSCALLFAILURE :	    return "WSASYSCALLFAILURE";
	case WSASERVICE_NOT_FOUND :	    return "WSASERVICE_NOT_FOUND";
	case WSATYPE_NOT_FOUND :	    return "WSATYPE_NOT_FOUND";
	case WSA_E_NO_MORE :		    return "WSA_E_NO_MORE";
	case WSA_E_CANCELLED :		    return "WSA_E_CANCELLED";
	case WSAEREFUSED :		    return "WSAEREFUSED";
	case WSAHOST_NOT_FOUND :	    return "WSAHOST_NOT_FOUND";
	case WSATRY_AGAIN :		    return "WSATRY_AGAIN";
	case WSANO_RECOVERY :		    return "WSANO_RECOVERY";
	case WSANO_DATA :		    return "WSANO_DATA";
	case WSA_QOS_RECEIVERS :	    return "WSA_QOS_RECEIVERS";
	case WSA_QOS_SENDERS :		    return "WSA_QOS_SENDERS";
	case WSA_QOS_NO_SENDERS :	    return "WSA_QOS_NO_SENDERS";
	case WSA_QOS_NO_RECEIVERS :	    return "WSA_QOS_NO_RECEIVERS";
	case WSA_QOS_REQUEST_CONFIRMED :    return "WSA_QOS_REQUEST_CONFIRMED";
	case WSA_QOS_ADMISSION_FAILURE :    return "WSA_QOS_ADMISSION_FAILURE";
	case WSA_QOS_POLICY_FAILURE :	    return "WSA_QOS_POLICY_FAILURE";
	case WSA_QOS_BAD_STYLE :	    return "WSA_QOS_BAD_STYLE";
	case WSA_QOS_BAD_OBJECT :	    return "WSA_QOS_BAD_OBJECT";
	case WSA_QOS_TRAFFIC_CTRL_ERROR :   return "WSA_QOS_TRAFFIC_CTRL_ERROR";
	case WSA_QOS_GENERIC_ERROR :	    return "WSA_QOS_GENERIC_ERROR";
	case WSA_QOS_ESERVICETYPE :	    return "WSA_QOS_ESERVICETYPE";
	case WSA_QOS_EFLOWSPEC :	    return "WSA_QOS_EFLOWSPEC";
	case WSA_QOS_EPROVSPECBUF :	    return "WSA_QOS_EPROVSPECBUF";
	case WSA_QOS_EFILTERSTYLE :	    return "WSA_QOS_EFILTERSTYLE";
	case WSA_QOS_EFILTERTYPE :	    return "WSA_QOS_EFILTERTYPE";
	case WSA_QOS_EFILTERCOUNT :	    return "WSA_QOS_EFILTERCOUNT";
	case WSA_QOS_EOBJLENGTH :	    return "WSA_QOS_EOBJLENGTH";
	case WSA_QOS_EFLOWCOUNT :	    return "WSA_QOS_EFLOWCOUNT";
	case WSA_QOS_EUNKOWNPSOBJ :	    return "WSA_QOS_EUNKOWNPSOBJ";
	case WSA_QOS_EPOLICYOBJ :	    return "WSA_QOS_EPOLICYOBJ";
	case WSA_QOS_EFLOWDESC :	    return "WSA_QOS_EFLOWDESC";
	case WSA_QOS_EPSFLOWSPEC :	    return "WSA_QOS_EPSFLOWSPEC";
	case WSA_QOS_EPSFILTERSPEC :	    return "WSA_QOS_EPSFILTERSPEC";
	case WSA_QOS_ESDMODEOBJ :	    return "WSA_QOS_ESDMODEOBJ";
	case WSA_QOS_ESHAPERATEOBJ :	    return "WSA_QOS_ESHAPERATEOBJ";
	case WSA_QOS_RESERVED_PETYPE :	    return "WSA_QOS_RESERVED_PETYPE";
	// Side By Side Error Codes
	case ERROR_SXS_SECTION_NOT_FOUND :  return "ERROR_SXS_SECTION_NOT_FOUND";
	case ERROR_SXS_CANT_GEN_ACTCTX :    return "ERROR_SXS_CANT_GEN_ACTCTX";
	case ERROR_SXS_INVALID_ACTCTXDATA_FORMAT : return "ERROR_SXS_INVALID_ACTCTXDATA_FORMAT";
	case ERROR_SXS_ASSEMBLY_NOT_FOUND : return "ERROR_SXS_ASSEMBLY_NOT_FOUND";
	case ERROR_SXS_MANIFEST_FORMAT_ERROR : return "ERROR_SXS_MANIFEST_FORMAT_ERROR";
	case ERROR_SXS_MANIFEST_PARSE_ERROR : return "ERROR_SXS_MANIFEST_PARSE_ERROR";
	case ERROR_SXS_ACTIVATION_CONTEXT_DISABLED : return "ERROR_SXS_ACTIVATION_CONTEXT_DISABLED";
	case ERROR_SXS_KEY_NOT_FOUND :	    return "ERROR_SXS_KEY_NOT_FOUND";
	case ERROR_SXS_VERSION_CONFLICT :   return "ERROR_SXS_VERSION_CONFLICT";
	case ERROR_SXS_WRONG_SECTION_TYPE : return "ERROR_SXS_WRONG_SECTION_TYPE";
	case ERROR_SXS_THREAD_QUERIES_DISABLED : return "ERROR_SXS_THREAD_QUERIES_DISABLED";
	case ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET : return "ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET";
	case ERROR_SXS_UNKNOWN_ENCODING_GROUP : return "ERROR_SXS_UNKNOWN_ENCODING_GROUP";
	case ERROR_SXS_UNKNOWN_ENCODING :   return "ERROR_SXS_UNKNOWN_ENCODING";
	case ERROR_SXS_INVALID_XML_NAMESPACE_URI : return "ERROR_SXS_INVALID_XML_NAMESPACE_URI";
	case ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED : return "ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED";
	case ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED : return "ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED";
	case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE : return "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE";
	case ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE : return "ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE";
	case ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE : return "ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE";
	case ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT : return "ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT";
	case ERROR_SXS_DUPLICATE_DLL_NAME : return "ERROR_SXS_DUPLICATE_DLL_NAME";
	case ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME : return "ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME";
	case ERROR_SXS_DUPLICATE_CLSID :    return "ERROR_SXS_DUPLICATE_CLSID";
	case ERROR_SXS_DUPLICATE_IID :	    return "ERROR_SXS_DUPLICATE_IID";
	case ERROR_SXS_DUPLICATE_TLBID :    return "ERROR_SXS_DUPLICATE_TLBID";
	case ERROR_SXS_DUPLICATE_PROGID :   return "ERROR_SXS_DUPLICATE_PROGID";
	case ERROR_SXS_DUPLICATE_ASSEMBLY_NAME : return "ERROR_SXS_DUPLICATE_ASSEMBLY_NAME";
	case ERROR_SXS_FILE_HASH_MISMATCH : return "ERROR_SXS_FILE_HASH_MISMATCH";
	case ERROR_SXS_POLICY_PARSE_ERROR : return "ERROR_SXS_POLICY_PARSE_ERROR";
	case ERROR_SXS_XML_E_MISSINGQUOTE : return "ERROR_SXS_XML_E_MISSINGQUOTE";
	case ERROR_SXS_XML_E_COMMENTSYNTAX : return "ERROR_SXS_XML_E_COMMENTSYNTAX";
	case ERROR_SXS_XML_E_BADSTARTNAMECHAR : return "ERROR_SXS_XML_E_BADSTARTNAMECHAR";
	case ERROR_SXS_XML_E_BADNAMECHAR :  return "ERROR_SXS_XML_E_BADNAMECHAR";
	case ERROR_SXS_XML_E_BADCHARINSTRING : return "ERROR_SXS_XML_E_BADCHARINSTRING";
	case ERROR_SXS_XML_E_XMLDECLSYNTAX : return "ERROR_SXS_XML_E_XMLDECLSYNTAX";
	case ERROR_SXS_XML_E_BADCHARDATA :  return "ERROR_SXS_XML_E_BADCHARDATA";
	case ERROR_SXS_XML_E_MISSINGWHITESPACE : return "ERROR_SXS_XML_E_MISSINGWHITESPACE";
	case ERROR_SXS_XML_E_EXPECTINGTAGEND : return "ERROR_SXS_XML_E_EXPECTINGTAGEND";
	case ERROR_SXS_XML_E_MISSINGSEMICOLON : return "ERROR_SXS_XML_E_MISSINGSEMICOLON";
	case ERROR_SXS_XML_E_UNBALANCEDPAREN : return "ERROR_SXS_XML_E_UNBALANCEDPAREN";
	case ERROR_SXS_XML_E_INTERNALERROR : return "ERROR_SXS_XML_E_INTERNALERROR";
	case ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE : return "ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE";
	case ERROR_SXS_XML_E_INCOMPLETE_ENCODING : return "ERROR_SXS_XML_E_INCOMPLETE_ENCODING";
	case ERROR_SXS_XML_E_MISSING_PAREN : return "ERROR_SXS_XML_E_MISSING_PAREN";
	case ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE : return "ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE";
	case ERROR_SXS_XML_E_MULTIPLE_COLONS : return "ERROR_SXS_XML_E_MULTIPLE_COLONS";
	case ERROR_SXS_XML_E_INVALID_DECIMAL : return "ERROR_SXS_XML_E_INVALID_DECIMAL";
	case ERROR_SXS_XML_E_INVALID_HEXIDECIMAL : return "ERROR_SXS_XML_E_INVALID_HEXIDECIMAL";
	case ERROR_SXS_XML_E_INVALID_UNICODE : return "ERROR_SXS_XML_E_INVALID_UNICODE";
	case ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK : return "ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK";
	case ERROR_SXS_XML_E_UNEXPECTEDENDTAG : return "ERROR_SXS_XML_E_UNEXPECTEDENDTAG";
	case ERROR_SXS_XML_E_UNCLOSEDTAG :  return "ERROR_SXS_XML_E_UNCLOSEDTAG";
	case ERROR_SXS_XML_E_DUPLICATEATTRIBUTE : return "ERROR_SXS_XML_E_DUPLICATEATTRIBUTE";
	case ERROR_SXS_XML_E_MULTIPLEROOTS : return "ERROR_SXS_XML_E_MULTIPLEROOTS";
	case ERROR_SXS_XML_E_INVALIDATROOTLEVEL : return "ERROR_SXS_XML_E_INVALIDATROOTLEVEL";
	case ERROR_SXS_XML_E_BADXMLDECL :   return "ERROR_SXS_XML_E_BADXMLDECL";
	case ERROR_SXS_XML_E_MISSINGROOT :  return "ERROR_SXS_XML_E_MISSINGROOT";
	case ERROR_SXS_XML_E_UNEXPECTEDEOF : return "ERROR_SXS_XML_E_UNEXPECTEDEOF";
	case ERROR_SXS_XML_E_BADPEREFINSUBSET : return "ERROR_SXS_XML_E_BADPEREFINSUBSET";
	case ERROR_SXS_XML_E_UNCLOSEDSTARTTAG : return "ERROR_SXS_XML_E_UNCLOSEDSTARTTAG";
	case ERROR_SXS_XML_E_UNCLOSEDENDTAG : return "ERROR_SXS_XML_E_UNCLOSEDENDTAG";
	case ERROR_SXS_XML_E_UNCLOSEDSTRING : return "ERROR_SXS_XML_E_UNCLOSEDSTRING";
	case ERROR_SXS_XML_E_UNCLOSEDCOMMENT : return "ERROR_SXS_XML_E_UNCLOSEDCOMMENT";
	case ERROR_SXS_XML_E_UNCLOSEDDECL : return "ERROR_SXS_XML_E_UNCLOSEDDECL";
	case ERROR_SXS_XML_E_UNCLOSEDCDATA : return "ERROR_SXS_XML_E_UNCLOSEDCDATA";
	case ERROR_SXS_XML_E_RESERVEDNAMESPACE : return "ERROR_SXS_XML_E_RESERVEDNAMESPACE";
	case ERROR_SXS_XML_E_INVALIDENCODING : return "ERROR_SXS_XML_E_INVALIDENCODING";
	case ERROR_SXS_XML_E_INVALIDSWITCH : return "ERROR_SXS_XML_E_INVALIDSWITCH";
	case ERROR_SXS_XML_E_BADXMLCASE :   return "ERROR_SXS_XML_E_BADXMLCASE";
	case ERROR_SXS_XML_E_INVALID_STANDALONE : return "ERROR_SXS_XML_E_INVALID_STANDALONE";
	case ERROR_SXS_XML_E_UNEXPECTED_STANDALONE : return "ERROR_SXS_XML_E_UNEXPECTED_STANDALONE";
	case ERROR_SXS_XML_E_INVALID_VERSION : return "ERROR_SXS_XML_E_INVALID_VERSION";
	case ERROR_SXS_XML_E_MISSINGEQUALS : return "ERROR_SXS_XML_E_MISSINGEQUALS";
	case ERROR_SXS_PROTECTION_RECOVERY_FAILED : return "ERROR_SXS_PROTECTION_RECOVERY_FAILED";
	case ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT : return "ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT";
	case ERROR_SXS_PROTECTION_CATALOG_NOT_VALID : return "ERROR_SXS_PROTECTION_CATALOG_NOT_VALID";
	case ERROR_SXS_UNTRANSLATABLE_HRESULT : return "ERROR_SXS_UNTRANSLATABLE_HRESULT";
	case ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING : return "ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING";
	case ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE : return "ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE";
	case ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME : return "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME";
	// IPSec Error codes
	case ERROR_IPSEC_QM_POLICY_EXISTS : return "ERROR_IPSEC_QM_POLICY_EXISTS";
	case ERROR_IPSEC_QM_POLICY_NOT_FOUND : return "ERROR_IPSEC_QM_POLICY_NOT_FOUND";
	case ERROR_IPSEC_QM_POLICY_IN_USE : return "ERROR_IPSEC_QM_POLICY_IN_USE";
	case ERROR_IPSEC_MM_POLICY_EXISTS : return "ERROR_IPSEC_MM_POLICY_EXISTS";
	case ERROR_IPSEC_MM_POLICY_NOT_FOUND : return "ERROR_IPSEC_MM_POLICY_NOT_FOUND";
	case ERROR_IPSEC_MM_POLICY_IN_USE : return "ERROR_IPSEC_MM_POLICY_IN_USE";
	case ERROR_IPSEC_MM_FILTER_EXISTS : return "ERROR_IPSEC_MM_FILTER_EXISTS";
	case ERROR_IPSEC_MM_FILTER_NOT_FOUND : return "ERROR_IPSEC_MM_FILTER_NOT_FOUND";
	case ERROR_IPSEC_TRANSPORT_FILTER_EXISTS : return "ERROR_IPSEC_TRANSPORT_FILTER_EXISTS";
	case ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND : return "ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND";
	case ERROR_IPSEC_MM_AUTH_EXISTS :   return "ERROR_IPSEC_MM_AUTH_EXISTS";
	case ERROR_IPSEC_MM_AUTH_NOT_FOUND : return "ERROR_IPSEC_MM_AUTH_NOT_FOUND";
	case ERROR_IPSEC_MM_AUTH_IN_USE :   return "ERROR_IPSEC_MM_AUTH_IN_USE";
	case ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND : return "ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND";
	case ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND : return "ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND";
	case ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND : return "ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND";
	case ERROR_IPSEC_TUNNEL_FILTER_EXISTS : return "ERROR_IPSEC_TUNNEL_FILTER_EXISTS";
	case ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND : return "ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND";
	case ERROR_IPSEC_MM_FILTER_PENDING_DELETION : return "ERROR_IPSEC_MM_FILTER_PENDING_DELETION";
	case ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION : return "ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION";
	case ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION : return "ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION";
	case ERROR_IPSEC_MM_POLICY_PENDING_DELETION : return "ERROR_IPSEC_MM_POLICY_PENDING_DELETION";
	case ERROR_IPSEC_MM_AUTH_PENDING_DELETION : return "ERROR_IPSEC_MM_AUTH_PENDING_DELETION";
	case ERROR_IPSEC_QM_POLICY_PENDING_DELETION : return "ERROR_IPSEC_QM_POLICY_PENDING_DELETION";
	case WARNING_IPSEC_MM_POLICY_PRUNED : return "WARNING_IPSEC_MM_POLICY_PRUNED";
	case WARNING_IPSEC_QM_POLICY_PRUNED : return "WARNING_IPSEC_QM_POLICY_PRUNED";
	case ERROR_IPSEC_IKE_NEG_STATUS_BEGIN : return "ERROR_IPSEC_IKE_NEG_STATUS_BEGIN";
	case ERROR_IPSEC_IKE_AUTH_FAIL :    return "ERROR_IPSEC_IKE_AUTH_FAIL";
	case ERROR_IPSEC_IKE_ATTRIB_FAIL :  return "ERROR_IPSEC_IKE_ATTRIB_FAIL";
	case ERROR_IPSEC_IKE_NEGOTIATION_PENDING : return "ERROR_IPSEC_IKE_NEGOTIATION_PENDING";
	case ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR : return "ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR";
	case ERROR_IPSEC_IKE_TIMED_OUT :    return "ERROR_IPSEC_IKE_TIMED_OUT";
	case ERROR_IPSEC_IKE_NO_CERT :	    return "ERROR_IPSEC_IKE_NO_CERT";
	case ERROR_IPSEC_IKE_SA_DELETED :   return "ERROR_IPSEC_IKE_SA_DELETED";
	case ERROR_IPSEC_IKE_SA_REAPED :    return "ERROR_IPSEC_IKE_SA_REAPED";
	case ERROR_IPSEC_IKE_MM_ACQUIRE_DROP : return "ERROR_IPSEC_IKE_MM_ACQUIRE_DROP";
	case ERROR_IPSEC_IKE_QM_ACQUIRE_DROP : return "ERROR_IPSEC_IKE_QM_ACQUIRE_DROP";
	case ERROR_IPSEC_IKE_QUEUE_DROP_MM : return "ERROR_IPSEC_IKE_QUEUE_DROP_MM";
	case ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM : return "ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM";
	case ERROR_IPSEC_IKE_DROP_NO_RESPONSE : return "ERROR_IPSEC_IKE_DROP_NO_RESPONSE";
	case ERROR_IPSEC_IKE_MM_DELAY_DROP : return "ERROR_IPSEC_IKE_MM_DELAY_DROP";
	case ERROR_IPSEC_IKE_QM_DELAY_DROP : return "ERROR_IPSEC_IKE_QM_DELAY_DROP";
	case ERROR_IPSEC_IKE_ERROR :	    return "ERROR_IPSEC_IKE_ERROR";
	case ERROR_IPSEC_IKE_CRL_FAILED :   return "ERROR_IPSEC_IKE_CRL_FAILED";
	case ERROR_IPSEC_IKE_INVALID_KEY_USAGE : return "ERROR_IPSEC_IKE_INVALID_KEY_USAGE";
	case ERROR_IPSEC_IKE_INVALID_CERT_TYPE : return "ERROR_IPSEC_IKE_INVALID_CERT_TYPE";
	case ERROR_IPSEC_IKE_NO_PRIVATE_KEY : return "ERROR_IPSEC_IKE_NO_PRIVATE_KEY";
	case ERROR_IPSEC_IKE_DH_FAIL :	    return "ERROR_IPSEC_IKE_DH_FAIL";
	case ERROR_IPSEC_IKE_INVALID_HEADER : return "ERROR_IPSEC_IKE_INVALID_HEADER";
	case ERROR_IPSEC_IKE_NO_POLICY :    return "ERROR_IPSEC_IKE_NO_POLICY";
	case ERROR_IPSEC_IKE_INVALID_SIGNATURE : return "ERROR_IPSEC_IKE_INVALID_SIGNATURE";
	case ERROR_IPSEC_IKE_KERBEROS_ERROR : return "ERROR_IPSEC_IKE_KERBEROS_ERROR";
	case ERROR_IPSEC_IKE_NO_PUBLIC_KEY : return "ERROR_IPSEC_IKE_NO_PUBLIC_KEY";
	case ERROR_IPSEC_IKE_PROCESS_ERR :  return "ERROR_IPSEC_IKE_PROCESS_ERR";
	case ERROR_IPSEC_IKE_PROCESS_ERR_SA : return "ERROR_IPSEC_IKE_PROCESS_ERR_SA";
	case ERROR_IPSEC_IKE_PROCESS_ERR_PROP : return "ERROR_IPSEC_IKE_PROCESS_ERR_PROP";
	case ERROR_IPSEC_IKE_PROCESS_ERR_TRANS : return "ERROR_IPSEC_IKE_PROCESS_ERR_TRANS";
	case ERROR_IPSEC_IKE_PROCESS_ERR_KE : return "ERROR_IPSEC_IKE_PROCESS_ERR_KE";
	case ERROR_IPSEC_IKE_PROCESS_ERR_ID : return "ERROR_IPSEC_IKE_PROCESS_ERR_ID";
	case ERROR_IPSEC_IKE_PROCESS_ERR_CERT : return "ERROR_IPSEC_IKE_PROCESS_ERR_CERT";
	case ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ : return "ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ";
	case ERROR_IPSEC_IKE_PROCESS_ERR_HASH : return "ERROR_IPSEC_IKE_PROCESS_ERR_HASH";
	case ERROR_IPSEC_IKE_PROCESS_ERR_SIG : return "ERROR_IPSEC_IKE_PROCESS_ERR_SIG";
	case ERROR_IPSEC_IKE_PROCESS_ERR_NONCE : return "ERROR_IPSEC_IKE_PROCESS_ERR_NONCE";
	case ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY : return "ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY";
	case ERROR_IPSEC_IKE_PROCESS_ERR_DELETE : return "ERROR_IPSEC_IKE_PROCESS_ERR_DELETE";
	case ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR : return "ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR";
	case ERROR_IPSEC_IKE_INVALID_PAYLOAD : return "ERROR_IPSEC_IKE_INVALID_PAYLOAD";
	case ERROR_IPSEC_IKE_LOAD_SOFT_SA : return "ERROR_IPSEC_IKE_LOAD_SOFT_SA";
	case ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN : return "ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN";
	case ERROR_IPSEC_IKE_INVALID_COOKIE : return "ERROR_IPSEC_IKE_INVALID_COOKIE";
	case ERROR_IPSEC_IKE_NO_PEER_CERT : return "ERROR_IPSEC_IKE_NO_PEER_CERT";
	case ERROR_IPSEC_IKE_PEER_CRL_FAILED : return "ERROR_IPSEC_IKE_PEER_CRL_FAILED";
	case ERROR_IPSEC_IKE_POLICY_CHANGE : return "ERROR_IPSEC_IKE_POLICY_CHANGE";
	case ERROR_IPSEC_IKE_NO_MM_POLICY : return "ERROR_IPSEC_IKE_NO_MM_POLICY";
	case ERROR_IPSEC_IKE_NOTCBPRIV :    return "ERROR_IPSEC_IKE_NOTCBPRIV";
	case ERROR_IPSEC_IKE_SECLOADFAIL :  return "ERROR_IPSEC_IKE_SECLOADFAIL";
	case ERROR_IPSEC_IKE_FAILSSPINIT :  return "ERROR_IPSEC_IKE_FAILSSPINIT";
	case ERROR_IPSEC_IKE_FAILQUERYSSP : return "ERROR_IPSEC_IKE_FAILQUERYSSP";
	case ERROR_IPSEC_IKE_SRVACQFAIL :   return "ERROR_IPSEC_IKE_SRVACQFAIL";
	case ERROR_IPSEC_IKE_SRVQUERYCRED : return "ERROR_IPSEC_IKE_SRVQUERYCRED";
	case ERROR_IPSEC_IKE_GETSPIFAIL :   return "ERROR_IPSEC_IKE_GETSPIFAIL";
	case ERROR_IPSEC_IKE_INVALID_FILTER : return "ERROR_IPSEC_IKE_INVALID_FILTER";
	case ERROR_IPSEC_IKE_OUT_OF_MEMORY : return "ERROR_IPSEC_IKE_OUT_OF_MEMORY";
	case ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED : return "ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED";
	case ERROR_IPSEC_IKE_INVALID_POLICY : return "ERROR_IPSEC_IKE_INVALID_POLICY";
	case ERROR_IPSEC_IKE_UNKNOWN_DOI :  return "ERROR_IPSEC_IKE_UNKNOWN_DOI";
	case ERROR_IPSEC_IKE_INVALID_SITUATION : return "ERROR_IPSEC_IKE_INVALID_SITUATION";
	case ERROR_IPSEC_IKE_DH_FAILURE :   return "ERROR_IPSEC_IKE_DH_FAILURE";
	case ERROR_IPSEC_IKE_INVALID_GROUP : return "ERROR_IPSEC_IKE_INVALID_GROUP";
	case ERROR_IPSEC_IKE_ENCRYPT :	    return "ERROR_IPSEC_IKE_ENCRYPT";
	case ERROR_IPSEC_IKE_DECRYPT :	    return "ERROR_IPSEC_IKE_DECRYPT";
	case ERROR_IPSEC_IKE_POLICY_MATCH : return "ERROR_IPSEC_IKE_POLICY_MATCH";
	case ERROR_IPSEC_IKE_UNSUPPORTED_ID : return "ERROR_IPSEC_IKE_UNSUPPORTED_ID";
	case ERROR_IPSEC_IKE_INVALID_HASH : return "ERROR_IPSEC_IKE_INVALID_HASH";
	case ERROR_IPSEC_IKE_INVALID_HASH_ALG : return "ERROR_IPSEC_IKE_INVALID_HASH_ALG";
	case ERROR_IPSEC_IKE_INVALID_HASH_SIZE : return "ERROR_IPSEC_IKE_INVALID_HASH_SIZE";
	case ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG : return "ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG";
	case ERROR_IPSEC_IKE_INVALID_AUTH_ALG : return "ERROR_IPSEC_IKE_INVALID_AUTH_ALG";
	case ERROR_IPSEC_IKE_INVALID_SIG :  return "ERROR_IPSEC_IKE_INVALID_SIG";
	case ERROR_IPSEC_IKE_LOAD_FAILED :  return "ERROR_IPSEC_IKE_LOAD_FAILED";
	case ERROR_IPSEC_IKE_RPC_DELETE :   return "ERROR_IPSEC_IKE_RPC_DELETE";
	case ERROR_IPSEC_IKE_BENIGN_REINIT : return "ERROR_IPSEC_IKE_BENIGN_REINIT";
	case ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY : return "ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY";
	case ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN : return "ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN";
	case ERROR_IPSEC_IKE_MM_LIMIT :	    return "ERROR_IPSEC_IKE_MM_LIMIT";
	case ERROR_IPSEC_IKE_NEGOTIATION_DISABLED : return "ERROR_IPSEC_IKE_NEGOTIATION_DISABLED";
	case ERROR_IPSEC_IKE_NEG_STATUS_END : return "ERROR_IPSEC_IKE_NEG_STATUS_END";
	DEFAULT_UNREACHABLE;
    }
}

/*
 *----------------------------------------------------------------------
 *
 * Exp_Win32ErrMsg --
 *
 *	Same as Tcl_ErrnoMsg(), but for windows error codes.
 *
 * Results:
 *      The message that is associated with the error code.  Not
 *	localized.
 *    
 * Side Effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

CONST char *
Exp_Win32ErrMsg TCL_VARARGS_DEF(DWORD, arg1)
{
    va_list argList;
    DWORD errorCode;
    CONST char *msg;

    errorCode = TCL_VARARGS_START(DWORD, arg1, argList);
    msg = Exp_Win32ErrMsgVA(errorCode, argList);
    va_end(argList);
    return msg;
}

/*
 *----------------------------------------------------------------------
 *
 * Exp_Win32ErrMsgVA --
 *
 *	Same as Exp_Win32ErrMsg, but takes a spread va_list.
 *
 * Results:
 *      The message that is associated with the error code.  Not
 *	localized.
 *    
 * Side Effects:
 *	caller is responsible for clearing the va_list.
 *
 *----------------------------------------------------------------------
 */

CONST char *
Exp_Win32ErrMsgVA (DWORD errorCode, va_list argList)
{
    ThreadSpecificData *tsdPtr = TCL_TSD_INIT(&dataKey);
    DWORD result;

    /*
     * If the "customer" bit is set, this function was called
     * by mistake.
     */

    if (errorCode & (0x1 << 29)) {
	return NULL;
    }

    result = FormatMessage (
	    FORMAT_MESSAGE_FROM_SYSTEM |
	    FORMAT_MESSAGE_MAX_WIDTH_MASK,
	    0L,
	    errorCode,
	    0,
	    tsdPtr->sysMsgSpace,
	    ERR_BUF_SIZE,
	    &argList);

    return (result ? tsdPtr->sysMsgSpace : NULL);
}

/*
 *----------------------------------------------------------------------
 *
 * Exp_Win32Error --
 *
 *	Same as Tcl_PosixError(), but for windows error codes.
 *
 * Results:
 *      The message that is associated with the error code.
 *    
 * Side Effects:
 *	sets $errorCode in the specified interpreter.
 *
 *----------------------------------------------------------------------
 */

CONST char *
Exp_Win32Error TCL_VARARGS_DEF(Tcl_Interp *, arg1)
{
    CONST char *id, *msg;
    va_list argList;
    Tcl_Interp *interp;
    DWORD err = GetLastError();

    interp = TCL_VARARGS_START(Tcl_Interp *, arg1, argList);
    id = Exp_Win32ErrId(err);
    msg = Exp_Win32ErrMsgVA(err, argList);
    va_end(argList);
    Tcl_SetErrorCode(interp, "WIN32", id, msg, 0L);
    return msg;
}

/*
 *----------------------------------------------------------------------
 *
 * ExpWinExpErrId --
 *
 *	Same as Tcl_ErrnoId(), but for expect specific error codes
 *	when run on the windows platform.
 *
 * Results:
 *      The symbolic name of the error code.
 *    
 * Comments:
 *	Must match expWinErr.h which is a build generated file!
 *
 * Side Effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

CONST char *
ExpWinErrId (DWORD errorCode)
{
    switch (errorCode) {
	case ERROR_EXP_WIN32_CANT_SPAWN_BATCH : return "ERROR_EXP_WIN32_CANT_SPAWN_BATCH";
	case ERROR_EXP_WIN32_CANT_SPAWN_DOS16 : return "ERROR_EXP_WIN32_CANT_SPAWN_DOS16";
	case ERROR_EXP_WIN32_CANT_SPAWN_NONCUI : return "ERROR_EXP_WIN32_CANT_SPAWN_NONCUI";
	case ERROR_EXP_WIN32_CANT_IPC :	return "ERROR_EXP_WIN32_CANT_IPC";
	case ERROR_EXP_WIN32_NO_BACKTRACE: return "ERROR_EXP_WIN32_NO_BACKTRACE";
	case ERROR_EXP_WIN32_BACKTRACE : return "ERROR_EXP_WIN32_BACKTRACE";
	case STATUS_EXP_WIN32_OUTPUT_DBGSTR : return "STATUS_EXP_WIN32_OUTPUT_DBGSTR";
	case STATUS_EXP_WIN32_LOADED_DLL : return "STATUS_EXP_WIN32_LOADED_DLL";
	case ERROR_EXP_WIN32_FATAL_RIP : return "ERROR_EXP_WIN32_FATAL_RIP";
	case ERROR_EXP_WIN32_NONFATAL_RIP : return "ERROR_EXP_WIN32_FATAL_RIP";
	case ERROR_EXP_WIN32_CANT_MAKE_SUB_MEM : return "ERROR_EXP_WIN32_CANT_MAKE_SUB_MEM";
	case ERROR_EXP_WIN32_CANT_READ_SUB_MEM : return "ERROR_EXP_WIN32_CANT_READ_SUB_MEM";
	DEFAULT_UNREACHABLE;
    }
}

/*
 *----------------------------------------------------------------------
 *
 * ExpWinErrMsg --
 *
 *	Same as Tcl_ErrnoMsg(), but for expect specific error codes
 *	on the windows platform.
 *
 * Results:
 *      The message that is associated with the error code.  Not
 *	localized.
 *    
 * Side Effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

CONST char *
ExpWinErrMsg TCL_VARARGS_DEF(DWORD, arg1)
{
    va_list argList;
    DWORD errorCode;
    CONST char *msg;

    errorCode = TCL_VARARGS_START(DWORD, arg1, argList);
    msg = Exp_Win32ErrMsgVA(errorCode, argList);
    va_end(argList);
    return msg;
}

/*
 *----------------------------------------------------------------------
 *
 * ExpWinExpErrMsgVA --
 *
 *	Same as ExpWinExpErrMsg, but takes a spread va_list.
 *
 * Results:
 *      The message that is associated with the error code.  Not
 *	localized.
 *    
 * Side Effects:
 *	caller is responsible for clearing the va_list.
 *
 *----------------------------------------------------------------------
 */

CONST char *
ExpWinErrMsgVA (DWORD errorCode, va_list argList)
{
    ThreadSpecificData *tsdPtr = TCL_TSD_INIT(&dataKey);
    DWORD result;

    /*
     * If the "customer" bit is *NOT* set, this function was called
     * by mistake.
     */

    if (!(errorCode & (0x1 << 29))) {
	return NULL;
    }

    result = FormatMessage (
	    FORMAT_MESSAGE_FROM_HMODULE |
	    FORMAT_MESSAGE_MAX_WIDTH_MASK,
	    expModule,
	    errorCode,
	    0,
	    tsdPtr->sysMsgSpace,
	    ERR_BUF_SIZE,
	    &argList);

    return (result ? tsdPtr->sysMsgSpace : NULL);
}

/*
 *----------------------------------------------------------------------
 *
 * ExpWinExpError --
 *
 *	Same as Tcl_PosixError(), but for expect specific error codes
 *	on the windows platform.
 *
 * Results:
 *      The message that is associated with the error code.
 *    
 * Side Effects:
 *	sets $errorCode in the specified interpreter.
 *
 *----------------------------------------------------------------------
 */

CONST char *
ExpWinError TCL_VARARGS_DEF(Tcl_Interp *, arg1)
{
    CONST char *id, *msg;
    va_list argList;
    Tcl_Interp *interp;
    DWORD err = GetLastError();

    interp = TCL_VARARGS_START(Tcl_Interp *, arg1, argList);

    /*
     * If the "customer" bit is set, this error is ours. else forward
     * it to the system.
     */
    if (err & (0x1 << 29)) {
	id = ExpWinErrId(err);
	msg = ExpWinErrMsgVA(err, argList);
	Tcl_SetErrorCode(interp, "EXPECT", id, msg, 0L);
    } else {
	id = Exp_Win32ErrId(err);
	msg = Exp_Win32ErrMsgVA(err, argList);
	Tcl_SetErrorCode(interp, "WIN32", id, msg, 0L);
    }
    va_end(argList);
    return msg;
}
