/* ----------------------------------------------------------------------------
 * expStubInit.c --
 *
 *	This file contains the initializers for the Expect stub vectors.
 *
 * ----------------------------------------------------------------------------
 *
 * Written by: Don Libes, libes@cme.nist.gov, NIST, 12/3/90
 * 
 * Design and implementation of this program was paid for by U.S. tax
 * dollars.  Therefore it is public domain.  However, the author and NIST
 * would appreciate credit if this program or parts of it are used.
 * 
 * Copyright (c) 1997 Mitel Corporation
 *	work by Gordon Chaffee <chaffee@bmrc.berkeley.edu> for the WinNT port.
 *
 * Copyright (c) 2001-2002 Telindustrie, LLC
 *	work by David Gravereaux <davygrvy@pobox.com> for any Win32 OS.
 *
 * ----------------------------------------------------------------------------
 * URLs:    http://expect.nist.gov/
 *	    http://expect.sf.net/
 *	    http://bmrc.berkeley.edu/people/chaffee/expectnt.html
 * ----------------------------------------------------------------------------
 * RCS: @(#) $Id: expStubInit.c,v 1.1.4.5 2002/03/11 06:52:53 davygrvy Exp $
 * ----------------------------------------------------------------------------
 */

#include "expInt.h"
#include "expPort.h"

/*
 * WARNING: The contents of this file are automatically generated by the
 * $(ROOT)/tools/genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the generic/exp.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

ExpIntStubs expIntStubs = {
    TCL_STUB_MAGIC,
    NULL,
    exp_parse_argv, /* 0 */
    exp_interpreter, /* 1 */
    NULL, /* 2 */
    exp_interpret_cmdfilename, /* 3 */
    exp_interpret_rcfiles, /* 4 */
    exp_cook, /* 5 */
    expCloseOnExec, /* 6 */
    exp_exit_handlers, /* 7 */
    exp_error, /* 8 */
    NULL, /* 9 */
    NULL, /* 10 */
    NULL, /* 11 */
    NULL, /* 12 */
    NULL, /* 13 */
    NULL, /* 14 */
    NULL, /* 15 */
    NULL, /* 16 */
    NULL, /* 17 */
    NULL, /* 18 */
    NULL, /* 19 */
    exp_get_var, /* 20 */
    exp_one_arg_braced, /* 21 */
    exp_eval_with_one_arg, /* 22 */
    NULL, /* 23 */
    exp_flageq_code, /* 24 */
    expAdjust, /* 25 */
    exp_buffer_shuffle, /* 26 */
    exp_close, /* 27 */
    exp_close_all, /* 28 */
    NULL, /* 29 */
    exp_trap_on, /* 30 */
    exp_trap_off, /* 31 */
    exp_strftime, /* 32 */
    exp_init_pty, /* 33 */
    exp_pty_exit, /* 34 */
    exp_init_tty, /* 35 */
    exp_init_stdio, /* 36 */
    exp_init_spawn_ids, /* 37 */
    exp_init_spawn_id_vars, /* 38 */
    exp_init_trap, /* 39 */
    NULL, /* 40 */
    exp_init_unit_random, /* 41 */
    exp_init_sig, /* 42 */
    expChanInit, /* 43 */
    expChannelCountGet, /* 44 */
    exp_tcl2_returnvalue, /* 45 */
    exp_2tcl_returnvalue, /* 46 */
    exp_rearm_sigchld, /* 47 */
    exp_string_to_signal, /* 48 */
    exp_new_i_complex, /* 49 */
    exp_new_i_simple, /* 50 */
    exp_new_state, /* 51 */
    exp_free_i, /* 52 */
    exp_free_state, /* 53 */
    exp_free_state_single, /* 54 */
    exp_i_update, /* 55 */
    exp_create_commands, /* 56 */
    exp_init_main_cmds, /* 57 */
    exp_init_expect_cmds, /* 58 */
    exp_init_most_cmds, /* 59 */
    exp_init_trap_cmds, /* 60 */
    NULL, /* 61 */
    exp_init_tty_cmds, /* 62 */
    expStateCheck, /* 63 */
    expStateCurrent, /* 64 */
    expStateFromChannelName, /* 65 */
    expStateFree, /* 66 */
    NULL, /* 67 */
    expWaitOnAny, /* 68 */
    expWaitOnOne, /* 69 */
    expExpectVarsInit, /* 70 */
    expStateAnyIs, /* 71 */
    expDevttyIs, /* 72 */
    expStdinOutIs, /* 73 */
    expStdinoutGet, /* 74 */
    expDevttyGet, /* 75 */
    expSizeGet, /* 76 */
    expSizeZero, /* 77 */
    exp_ecmd_remove_state_direct_and_indirect, /* 78 */
    expWriteChars, /* 79 */
    NULL, /* 80 */
    NULL, /* 81 */
    NULL, /* 82 */
    NULL, /* 83 */
    NULL, /* 84 */
    expErrorLog, /* 85 */
    expErrorLogU, /* 86 */
    expStdoutLog, /* 87 */
    expStdoutLogU, /* 88 */
    expDiagInit, /* 89 */
    expDiagChannelOpen, /* 90 */
    expDiagChannelGet, /* 91 */
    expDiagChannelClose, /* 92 */
    expDiagFilename, /* 93 */
    expDiagToStderrGet, /* 94 */
    expDiagToStderrSet, /* 95 */
    expDiagWriteBytes, /* 96 */
    expDiagWriteChars, /* 97 */
    expDiagWriteObj, /* 98 */
    expDiagLog, /* 99 */
    expDiagLogU, /* 100 */
    expPrintify, /* 101 */
    expPrintifyObj, /* 102 */
    expLogInit, /* 103 */
    expLogChannelOpen, /* 104 */
    expLogChannelGet, /* 105 */
    expLogChannelSet, /* 106 */
    expLogChannelClose, /* 107 */
    expLogFilenameGet, /* 108 */
    expLogAppendSet, /* 109 */
    expLogAppendGet, /* 110 */
    expLogLeaveOpenSet, /* 111 */
    expLogLeaveOpenGet, /* 112 */
    expLogAllSet, /* 113 */
    expLogAllGet, /* 114 */
    expLogToStdoutSet, /* 115 */
    expLogToStdoutGet, /* 116 */
    expLogDiagU, /* 117 */
    expWriteBytesAndLogIfTtyU, /* 118 */
    expLogUserGet, /* 119 */
    expLogUserSet, /* 120 */
    expLogInteractionU, /* 121 */
    NULL, /* 122 */
    NULL, /* 123 */
    NULL, /* 124 */
    exp_get_next_event, /* 125 */
    exp_get_next_event_info, /* 126 */
    exp_dsleep, /* 127 */
    exp_init_event, /* 128 */
    NULL, /* 129 */
    exp_event_disarm_bg, /* 130 */
    exp_event_disarm_fg, /* 131 */
    exp_arm_background_channelhandler, /* 132 */
    exp_disarm_background_channelhandler, /* 133 */
    exp_disarm_background_channelhandler_force, /* 134 */
    exp_unblock_background_channelhandler, /* 135 */
    exp_block_background_channelhandler, /* 136 */
    exp_background_channelhandler, /* 137 */
    NULL, /* 138 */
    NULL, /* 139 */
    exp_tty_set, /* 140 */
    exp_tty_cooked_echo, /* 141 */
    NULL, /* 142 */
    NULL, /* 143 */
    NULL, /* 144 */
    Exp_StringCaseMatch, /* 145 */
    NULL, /* 146 */
    NULL, /* 147 */
    NULL, /* 148 */
    NULL, /* 149 */
    NULL, /* 150 */
    expDiagLogPtrSet, /* 151 */
    expDiagLogPtr, /* 152 */
    expDiagLogPtrX, /* 153 */
    expDiagLogPtrStr, /* 154 */
    expDiagLogPtrStrStr, /* 155 */
    expErrnoMsgSet, /* 156 */
    expErrnoMsg, /* 157 */
    NULL, /* 158 */
    NULL, /* 159 */
    Exp_CreateExpChannel, /* 160 */
    Exp_CreatePairChannel, /* 161 */
};

ExpIntPlatStubs expIntPlatStubs = {
    TCL_STUB_MAGIC,
    NULL,
#ifdef __WIN32__
    ExpWinInit, /* 0 */
    ExpWinErrId, /* 1 */
    ExpWinErrMsg, /* 2 */
    ExpWinErrMsgVA, /* 3 */
    ExpWinError, /* 4 */
#endif /* __WIN32__ */
};

ExpPlatStubs expPlatStubs = {
    TCL_STUB_MAGIC,
    NULL,
#ifdef __WIN32__
    Exp_WinApplicationType, /* 0 */
    Exp_WinBuildCommandLine, /* 1 */
    Exp_Win32ErrId, /* 2 */
    Exp_Win32ErrMsg, /* 3 */
    Exp_Win32ErrMsgVA, /* 4 */
    Exp_Win32Error, /* 5 */
#endif /* __WIN32__ */
};

static ExpStubHooks expStubHooks = {
    &expPlatStubs,
    &expIntStubs,
    &expIntPlatStubs
};

ExpStubs expStubs = {
    TCL_STUB_MAGIC,
    &expStubHooks,
    Expect_Init, /* 0 */
    NULL, /* 1 */
    NULL, /* 2 */
    Exp_CloseObjCmd, /* 3 */
    Exp_DisconnectCmd, /* 4 */
    Exp_ExitCmd, /* 5 */
    Exp_ExpContinueCmd, /* 6 */
    Exp_ExpectObjCmd, /* 7 */
    Exp_ExpectGlobalObjCmd, /* 8 */
    Exp_ExpInternalCmd, /* 9 */
    Exp_ExpPidCmd, /* 10 */
    Exp_ExpVersionCmd, /* 11 */
    Exp_ForkCmd, /* 12 */
    Exp_GetpidDeprecatedCmd, /* 13 */
    NULL, /* 14 */
    Exp_InterpreterObjCmd, /* 15 */
    Exp_InterReturnObjCmd, /* 16 */
    Exp_KillCmd, /* 17 */
    Exp_LogFileCmd, /* 18 */
    Exp_LogUserCmd, /* 19 */
    Exp_MatchMaxCmd, /* 20 */
    Exp_OpenCmd, /* 21 */
    Exp_OverlayCmd, /* 22 */
    Exp_ParityCmd, /* 23 */
    Exp_Prompt1ObjCmd, /* 24 */
    Exp_Prompt2ObjCmd, /* 25 */
    Exp_RemoveNullsCmd, /* 26 */
    Exp_SendLogCmd, /* 27 */
    Exp_SendObjCmd, /* 28 */
    Exp_SleepCmd, /* 29 */
    Exp_SpawnObjCmd, /* 30 */
    Exp_StraceCmd, /* 31 */
    Exp_SttyCmd, /* 32 */
    Exp_SystemCmd, /* 33 */
    Exp_TimestampCmd, /* 34 */
    Exp_TrapCmd, /* 35 */
    Exp_WaitCmd, /* 36 */
    Exp_CloseOnEofCmd, /* 37 */
    NULL, /* 38 */
    NULL, /* 39 */
    Exp_CreateSpawnChannel, /* 40 */
};

/* !END!: Do not edit above this line. */
