/*
 * expIntDecls.h --
 *
 *	Declarations of functions in the platform independent internal
 *	Expect API.
 *
 * ----------------------------------------------------------------------------
 *
 * Written by: Don Libes, libes@cme.nist.gov, NIST, 12/3/90
 * 
 * Design and implementation of this program was paid for by U.S. tax
 * dollars.  Therefore it is public domain.  However, the author and NIST
 * would appreciate credit if this program or parts of it are used.
 * 
 * Copyright (c) 1997 Mitel Corporation
 *	work by Gordon Chaffee <chaffee@bmrc.berkeley.edu> for the WinNT port.
 *
 * Copyright (c) 2001-2002 Telindustrie, LLC
 *	work by David Gravereaux <davygrvy@pobox.com> for any Win32 OS.
 *
 * ----------------------------------------------------------------------------
 * URLs:    http://expect.nist.gov/
 *	    http://expect.sf.net/
 *	    http://bmrc.berkeley.edu/people/chaffee/expectnt.html
 * ----------------------------------------------------------------------------
 * RCS: @(#) $Id: expIntDecls.h,v 1.1.4.6 2002/06/18 23:13:42 davygrvy Exp $
 * ----------------------------------------------------------------------------
 */

#ifndef _EXPINTDECLS
#define _EXPINTDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the exp.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

#ifndef exp_parse_argv_TCL_DECLARED
#define exp_parse_argv_TCL_DECLARED
/* 0 */
TCL_EXTERN(void)	exp_parse_argv _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, CONST84 char * argv[]));
#endif
#ifndef exp_interpreter_TCL_DECLARED
#define exp_interpreter_TCL_DECLARED
/* 1 */
TCL_EXTERN(int)		exp_interpreter _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * eofObj));
#endif
/* Slot 2 is reserved */
#ifndef exp_interpret_cmdfilename_TCL_DECLARED
#define exp_interpret_cmdfilename_TCL_DECLARED
/* 3 */
TCL_EXTERN(int)		exp_interpret_cmdfilename _ANSI_ARGS_((
				Tcl_Interp * interp, CONST char * filename));
#endif
#ifndef exp_interpret_rcfiles_TCL_DECLARED
#define exp_interpret_rcfiles_TCL_DECLARED
/* 4 */
TCL_EXTERN(void)	exp_interpret_rcfiles _ANSI_ARGS_((
				Tcl_Interp * interp, int my_rc, int sys_rc));
#endif
#ifndef exp_cook_TCL_DECLARED
#define exp_cook_TCL_DECLARED
/* 5 */
TCL_EXTERN(CONST char *) exp_cook _ANSI_ARGS_((CONST char * s, int * len));
#endif
#ifndef expCloseOnExec_TCL_DECLARED
#define expCloseOnExec_TCL_DECLARED
/* 6 */
TCL_EXTERN(void)	expCloseOnExec _ANSI_ARGS_((int fd));
#endif
#ifndef exp_exit_handlers_TCL_DECLARED
#define exp_exit_handlers_TCL_DECLARED
/* 7 */
TCL_EXTERN(void)	exp_exit_handlers _ANSI_ARGS_((ClientData clientData));
#endif
#ifndef exp_error_TCL_DECLARED
#define exp_error_TCL_DECLARED
/* 8 */
TCL_EXTERN(void)	exp_error _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp));
#endif
/* Slot 9 is reserved */
/* Slot 10 is reserved */
/* Slot 11 is reserved */
/* Slot 12 is reserved */
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
#ifndef exp_get_var_TCL_DECLARED
#define exp_get_var_TCL_DECLARED
/* 20 */
TCL_EXTERN(CONST char *) exp_get_var _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * var));
#endif
#ifndef exp_one_arg_braced_TCL_DECLARED
#define exp_one_arg_braced_TCL_DECLARED
/* 21 */
TCL_EXTERN(int)		exp_one_arg_braced _ANSI_ARGS_((Tcl_Obj * objPtr));
#endif
#ifndef exp_eval_with_one_arg_TCL_DECLARED
#define exp_eval_with_one_arg_TCL_DECLARED
/* 22 */
TCL_EXTERN(int)		exp_eval_with_one_arg _ANSI_ARGS_((
				ClientData clientData, Tcl_Interp * interp, 
				struct Tcl_Obj * CONST objv[]));
#endif
/* Slot 23 is reserved */
#ifndef exp_flageq_code_TCL_DECLARED
#define exp_flageq_code_TCL_DECLARED
/* 24 */
TCL_EXTERN(int)		exp_flageq_code _ANSI_ARGS_((CONST char * flag, 
				CONST char * string, int minlen));
#endif
#ifndef expAdjust_TCL_DECLARED
#define expAdjust_TCL_DECLARED
/* 25 */
TCL_EXTERN(void)	expAdjust _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef exp_buffer_shuffle_TCL_DECLARED
#define exp_buffer_shuffle_TCL_DECLARED
/* 26 */
TCL_EXTERN(void)	exp_buffer_shuffle _ANSI_ARGS_((Tcl_Interp * interp, 
				ExpState * esPtr, int save_flags, 
				CONST char * array_name, 
				CONST char * caller_name));
#endif
#ifndef exp_close_TCL_DECLARED
#define exp_close_TCL_DECLARED
/* 27 */
TCL_EXTERN(int)		exp_close _ANSI_ARGS_((Tcl_Interp * interp, 
				ExpState * esPtr));
#endif
#ifndef exp_close_all_TCL_DECLARED
#define exp_close_all_TCL_DECLARED
/* 28 */
TCL_EXTERN(void)	exp_close_all _ANSI_ARGS_((Tcl_Interp * interp));
#endif
/* Slot 29 is reserved */
#ifndef exp_trap_on_TCL_DECLARED
#define exp_trap_on_TCL_DECLARED
/* 30 */
TCL_EXTERN(void)	exp_trap_on _ANSI_ARGS_((int master));
#endif
#ifndef exp_trap_off_TCL_DECLARED
#define exp_trap_off_TCL_DECLARED
/* 31 */
TCL_EXTERN(int)		exp_trap_off _ANSI_ARGS_((CONST char * name));
#endif
#ifndef exp_strftime_TCL_DECLARED
#define exp_strftime_TCL_DECLARED
/* 32 */
TCL_EXTERN(void)	exp_strftime _ANSI_ARGS_((CONST char * format, 
				CONST struct tm * timeptr, 
				Tcl_DString * dstring));
#endif
#ifndef exp_init_pty_TCL_DECLARED
#define exp_init_pty_TCL_DECLARED
/* 33 */
TCL_EXTERN(void)	exp_init_pty _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef exp_pty_exit_TCL_DECLARED
#define exp_pty_exit_TCL_DECLARED
/* 34 */
TCL_EXTERN(void)	exp_pty_exit _ANSI_ARGS_((void));
#endif
#ifndef exp_init_tty_TCL_DECLARED
#define exp_init_tty_TCL_DECLARED
/* 35 */
TCL_EXTERN(void)	exp_init_tty _ANSI_ARGS_((void));
#endif
#ifndef exp_init_stdio_TCL_DECLARED
#define exp_init_stdio_TCL_DECLARED
/* 36 */
TCL_EXTERN(void)	exp_init_stdio _ANSI_ARGS_((void));
#endif
#ifndef exp_init_spawn_ids_TCL_DECLARED
#define exp_init_spawn_ids_TCL_DECLARED
/* 37 */
TCL_EXTERN(void)	exp_init_spawn_ids _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef exp_init_spawn_id_vars_TCL_DECLARED
#define exp_init_spawn_id_vars_TCL_DECLARED
/* 38 */
TCL_EXTERN(void)	exp_init_spawn_id_vars _ANSI_ARGS_((
				Tcl_Interp * interp));
#endif
#ifndef exp_init_trap_TCL_DECLARED
#define exp_init_trap_TCL_DECLARED
/* 39 */
TCL_EXTERN(void)	exp_init_trap _ANSI_ARGS_((void));
#endif
/* Slot 40 is reserved */
#ifndef exp_init_unit_random_TCL_DECLARED
#define exp_init_unit_random_TCL_DECLARED
/* 41 */
TCL_EXTERN(void)	exp_init_unit_random _ANSI_ARGS_((void));
#endif
#ifndef exp_init_sig_TCL_DECLARED
#define exp_init_sig_TCL_DECLARED
/* 42 */
TCL_EXTERN(void)	exp_init_sig _ANSI_ARGS_((void));
#endif
#ifndef expChanInit_TCL_DECLARED
#define expChanInit_TCL_DECLARED
/* 43 */
TCL_EXTERN(void)	expChanInit _ANSI_ARGS_((void));
#endif
#ifndef expChannelCountGet_TCL_DECLARED
#define expChannelCountGet_TCL_DECLARED
/* 44 */
TCL_EXTERN(int)		expChannelCountGet _ANSI_ARGS_((void));
#endif
#ifndef exp_tcl2_returnvalue_TCL_DECLARED
#define exp_tcl2_returnvalue_TCL_DECLARED
/* 45 */
TCL_EXTERN(int)		exp_tcl2_returnvalue _ANSI_ARGS_((int x));
#endif
#ifndef exp_2tcl_returnvalue_TCL_DECLARED
#define exp_2tcl_returnvalue_TCL_DECLARED
/* 46 */
TCL_EXTERN(int)		exp_2tcl_returnvalue _ANSI_ARGS_((int x));
#endif
#ifndef exp_rearm_sigchld_TCL_DECLARED
#define exp_rearm_sigchld_TCL_DECLARED
/* 47 */
TCL_EXTERN(void)	exp_rearm_sigchld _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef exp_string_to_signal_TCL_DECLARED
#define exp_string_to_signal_TCL_DECLARED
/* 48 */
TCL_EXTERN(int)		exp_string_to_signal _ANSI_ARGS_((
				Tcl_Interp * interp, CONST char * s));
#endif
#ifndef exp_new_i_complex_TCL_DECLARED
#define exp_new_i_complex_TCL_DECLARED
/* 49 */
TCL_EXTERN(struct exp_i *) exp_new_i_complex _ANSI_ARGS_((
				Tcl_Interp * interp, CONST char * arg, 
				int duration, Tcl_VarTraceProc * updateproc));
#endif
#ifndef exp_new_i_simple_TCL_DECLARED
#define exp_new_i_simple_TCL_DECLARED
/* 50 */
TCL_EXTERN(struct exp_i *) exp_new_i_simple _ANSI_ARGS_((ExpState * esPtr, 
				int duration));
#endif
#ifndef exp_new_state_TCL_DECLARED
#define exp_new_state_TCL_DECLARED
/* 51 */
TCL_EXTERN(struct exp_state_list *) exp_new_state _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_free_i_TCL_DECLARED
#define exp_free_i_TCL_DECLARED
/* 52 */
TCL_EXTERN(void)	exp_free_i _ANSI_ARGS_((Tcl_Interp * interp, 
				struct exp_i * i, 
				Tcl_VarTraceProc * updateproc));
#endif
#ifndef exp_free_state_TCL_DECLARED
#define exp_free_state_TCL_DECLARED
/* 53 */
TCL_EXTERN(void)	exp_free_state _ANSI_ARGS_((
				struct exp_state_list * fd_first));
#endif
#ifndef exp_free_state_single_TCL_DECLARED
#define exp_free_state_single_TCL_DECLARED
/* 54 */
TCL_EXTERN(void)	exp_free_state_single _ANSI_ARGS_((
				struct exp_state_list * fd));
#endif
#ifndef exp_i_update_TCL_DECLARED
#define exp_i_update_TCL_DECLARED
/* 55 */
TCL_EXTERN(int)		exp_i_update _ANSI_ARGS_((Tcl_Interp * interp, 
				struct exp_i * i));
#endif
#ifndef exp_create_commands_TCL_DECLARED
#define exp_create_commands_TCL_DECLARED
/* 56 */
TCL_EXTERN(void)	exp_create_commands _ANSI_ARGS_((Tcl_Interp * interp, 
				struct exp_cmd_data * c));
#endif
#ifndef exp_init_main_cmds_TCL_DECLARED
#define exp_init_main_cmds_TCL_DECLARED
/* 57 */
TCL_EXTERN(void)	exp_init_main_cmds _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef exp_init_expect_cmds_TCL_DECLARED
#define exp_init_expect_cmds_TCL_DECLARED
/* 58 */
TCL_EXTERN(void)	exp_init_expect_cmds _ANSI_ARGS_((
				Tcl_Interp * interp));
#endif
#ifndef exp_init_most_cmds_TCL_DECLARED
#define exp_init_most_cmds_TCL_DECLARED
/* 59 */
TCL_EXTERN(void)	exp_init_most_cmds _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef exp_init_trap_cmds_TCL_DECLARED
#define exp_init_trap_cmds_TCL_DECLARED
/* 60 */
TCL_EXTERN(void)	exp_init_trap_cmds _ANSI_ARGS_((Tcl_Interp * interp));
#endif
/* Slot 61 is reserved */
#ifndef exp_init_tty_cmds_TCL_DECLARED
#define exp_init_tty_cmds_TCL_DECLARED
/* 62 */
TCL_EXTERN(void)	exp_init_tty_cmds _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef expStateCheck_TCL_DECLARED
#define expStateCheck_TCL_DECLARED
/* 63 */
TCL_EXTERN(ExpState *)	expStateCheck _ANSI_ARGS_((Tcl_Interp * interp, 
				ExpState * esPtr, int open, int adjust, 
				CONST char * msg));
#endif
#ifndef expStateCurrent_TCL_DECLARED
#define expStateCurrent_TCL_DECLARED
/* 64 */
TCL_EXTERN(ExpState *)	expStateCurrent _ANSI_ARGS_((Tcl_Interp * interp, 
				int opened, int adjust, int any));
#endif
#ifndef expStateFromChannelName_TCL_DECLARED
#define expStateFromChannelName_TCL_DECLARED
/* 65 */
TCL_EXTERN(ExpState *)	expStateFromChannelName _ANSI_ARGS_((
				Tcl_Interp * interp, CONST char * name, 
				int opened, int adjust, int any, 
				CONST char * msg));
#endif
#ifndef expStateFree_TCL_DECLARED
#define expStateFree_TCL_DECLARED
/* 66 */
TCL_EXTERN(void)	expStateFree _ANSI_ARGS_((ExpState * esPtr));
#endif
/* Slot 67 is reserved */
#ifndef expWaitOnAny_TCL_DECLARED
#define expWaitOnAny_TCL_DECLARED
/* 68 */
TCL_EXTERN(ExpState *)	expWaitOnAny _ANSI_ARGS_((void));
#endif
#ifndef expWaitOnOne_TCL_DECLARED
#define expWaitOnOne_TCL_DECLARED
/* 69 */
TCL_EXTERN(ExpState *)	expWaitOnOne _ANSI_ARGS_((void));
#endif
#ifndef expExpectVarsInit_TCL_DECLARED
#define expExpectVarsInit_TCL_DECLARED
/* 70 */
TCL_EXTERN(void)	expExpectVarsInit _ANSI_ARGS_((void));
#endif
#ifndef expStateAnyIs_TCL_DECLARED
#define expStateAnyIs_TCL_DECLARED
/* 71 */
TCL_EXTERN(int)		expStateAnyIs _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef expDevttyIs_TCL_DECLARED
#define expDevttyIs_TCL_DECLARED
/* 72 */
TCL_EXTERN(int)		expDevttyIs _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef expStdinOutIs_TCL_DECLARED
#define expStdinOutIs_TCL_DECLARED
/* 73 */
TCL_EXTERN(int)		expStdinOutIs _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef expStdinoutGet_TCL_DECLARED
#define expStdinoutGet_TCL_DECLARED
/* 74 */
TCL_EXTERN(ExpState *)	expStdinoutGet _ANSI_ARGS_((void));
#endif
#ifndef expDevttyGet_TCL_DECLARED
#define expDevttyGet_TCL_DECLARED
/* 75 */
TCL_EXTERN(ExpState *)	expDevttyGet _ANSI_ARGS_((void));
#endif
#ifndef expSizeGet_TCL_DECLARED
#define expSizeGet_TCL_DECLARED
/* 76 */
TCL_EXTERN(int)		expSizeGet _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef expSizeZero_TCL_DECLARED
#define expSizeZero_TCL_DECLARED
/* 77 */
TCL_EXTERN(int)		expSizeZero _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef exp_ecmd_remove_state_direct_and_indirect_TCL_DECLARED
#define exp_ecmd_remove_state_direct_and_indirect_TCL_DECLARED
/* 78 */
TCL_EXTERN(void)	exp_ecmd_remove_state_direct_and_indirect _ANSI_ARGS_((
				Tcl_Interp * interp, ExpState * esPtr));
#endif
#ifndef expWriteChars_TCL_DECLARED
#define expWriteChars_TCL_DECLARED
/* 79 */
TCL_EXTERN(int)		expWriteChars _ANSI_ARGS_((ExpState * esPtr,
				CONST char * str, int len));
#endif
/* Slot 80 is reserved */
/* Slot 81 is reserved */
/* Slot 82 is reserved */
/* Slot 83 is reserved */
/* Slot 84 is reserved */
#ifndef expErrorLog_TCL_DECLARED
#define expErrorLog_TCL_DECLARED
/* 85 */
TCL_EXTERN(void)	expErrorLog _ANSI_ARGS_(TCL_VARARGS(CONST char *,arg1));
#endif
#ifndef expErrorLogU_TCL_DECLARED
#define expErrorLogU_TCL_DECLARED
/* 86 */
TCL_EXTERN(void)	expErrorLogU _ANSI_ARGS_((CONST char * buf));
#endif
#ifndef expStdoutLog_TCL_DECLARED
#define expStdoutLog_TCL_DECLARED
/* 87 */
TCL_EXTERN(void)	expStdoutLog _ANSI_ARGS_(TCL_VARARGS(int,arg1));
#endif
#ifndef expStdoutLogU_TCL_DECLARED
#define expStdoutLogU_TCL_DECLARED
/* 88 */
TCL_EXTERN(void)	expStdoutLogU _ANSI_ARGS_((CONST char * buf, 
				int force_stdout));
#endif
#ifndef expDiagInit_TCL_DECLARED
#define expDiagInit_TCL_DECLARED
/* 89 */
TCL_EXTERN(void)	expDiagInit _ANSI_ARGS_((void));
#endif
#ifndef expDiagChannelOpen_TCL_DECLARED
#define expDiagChannelOpen_TCL_DECLARED
/* 90 */
TCL_EXTERN(int)		expDiagChannelOpen _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * filename));
#endif
#ifndef expDiagChannelGet_TCL_DECLARED
#define expDiagChannelGet_TCL_DECLARED
/* 91 */
TCL_EXTERN(Tcl_Channel)	 expDiagChannelGet _ANSI_ARGS_((void));
#endif
#ifndef expDiagChannelClose_TCL_DECLARED
#define expDiagChannelClose_TCL_DECLARED
/* 92 */
TCL_EXTERN(void)	expDiagChannelClose _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef expDiagFilename_TCL_DECLARED
#define expDiagFilename_TCL_DECLARED
/* 93 */
TCL_EXTERN(CONST char *) expDiagFilename _ANSI_ARGS_((void));
#endif
#ifndef expDiagToStderrGet_TCL_DECLARED
#define expDiagToStderrGet_TCL_DECLARED
/* 94 */
TCL_EXTERN(int)		expDiagToStderrGet _ANSI_ARGS_((void));
#endif
#ifndef expDiagToStderrSet_TCL_DECLARED
#define expDiagToStderrSet_TCL_DECLARED
/* 95 */
TCL_EXTERN(void)	expDiagToStderrSet _ANSI_ARGS_((int val));
#endif
#ifndef expDiagWriteBytes_TCL_DECLARED
#define expDiagWriteBytes_TCL_DECLARED
/* 96 */
TCL_EXTERN(void)	expDiagWriteBytes _ANSI_ARGS_((CONST char * str, 
				int len));
#endif
#ifndef expDiagWriteChars_TCL_DECLARED
#define expDiagWriteChars_TCL_DECLARED
/* 97 */
TCL_EXTERN(void)	expDiagWriteChars _ANSI_ARGS_((CONST char * str, 
				int len));
#endif
#ifndef expDiagWriteObj_TCL_DECLARED
#define expDiagWriteObj_TCL_DECLARED
/* 98 */
TCL_EXTERN(void)	expDiagWriteObj _ANSI_ARGS_((Tcl_Obj * obj));
#endif
#ifndef expDiagLog_TCL_DECLARED
#define expDiagLog_TCL_DECLARED
/* 99 */
TCL_EXTERN(void)	expDiagLog _ANSI_ARGS_(TCL_VARARGS(CONST char *,arg1));
#endif
#ifndef expDiagLogU_TCL_DECLARED
#define expDiagLogU_TCL_DECLARED
/* 100 */
TCL_EXTERN(void)	expDiagLogU _ANSI_ARGS_((CONST char * str));
#endif
#ifndef expPrintify_TCL_DECLARED
#define expPrintify_TCL_DECLARED
/* 101 */
TCL_EXTERN(CONST char *) expPrintify _ANSI_ARGS_((CONST char * s));
#endif
#ifndef expPrintifyObj_TCL_DECLARED
#define expPrintifyObj_TCL_DECLARED
/* 102 */
TCL_EXTERN(CONST char *) expPrintifyObj _ANSI_ARGS_((Tcl_Obj * obj));
#endif
#ifndef expLogInit_TCL_DECLARED
#define expLogInit_TCL_DECLARED
/* 103 */
TCL_EXTERN(void)	expLogInit _ANSI_ARGS_((void));
#endif
#ifndef expLogChannelOpen_TCL_DECLARED
#define expLogChannelOpen_TCL_DECLARED
/* 104 */
TCL_EXTERN(int)		expLogChannelOpen _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * filename, int append));
#endif
#ifndef expLogChannelGet_TCL_DECLARED
#define expLogChannelGet_TCL_DECLARED
/* 105 */
TCL_EXTERN(Tcl_Channel)	 expLogChannelGet _ANSI_ARGS_((void));
#endif
#ifndef expLogChannelSet_TCL_DECLARED
#define expLogChannelSet_TCL_DECLARED
/* 106 */
TCL_EXTERN(int)		expLogChannelSet _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * name));
#endif
#ifndef expLogChannelClose_TCL_DECLARED
#define expLogChannelClose_TCL_DECLARED
/* 107 */
TCL_EXTERN(void)	expLogChannelClose _ANSI_ARGS_((Tcl_Interp * interp));
#endif
#ifndef expLogFilenameGet_TCL_DECLARED
#define expLogFilenameGet_TCL_DECLARED
/* 108 */
TCL_EXTERN(char *)	expLogFilenameGet _ANSI_ARGS_((void));
#endif
#ifndef expLogAppendSet_TCL_DECLARED
#define expLogAppendSet_TCL_DECLARED
/* 109 */
TCL_EXTERN(void)	expLogAppendSet _ANSI_ARGS_((int app));
#endif
#ifndef expLogAppendGet_TCL_DECLARED
#define expLogAppendGet_TCL_DECLARED
/* 110 */
TCL_EXTERN(int)		expLogAppendGet _ANSI_ARGS_((void));
#endif
#ifndef expLogLeaveOpenSet_TCL_DECLARED
#define expLogLeaveOpenSet_TCL_DECLARED
/* 111 */
TCL_EXTERN(void)	expLogLeaveOpenSet _ANSI_ARGS_((int app));
#endif
#ifndef expLogLeaveOpenGet_TCL_DECLARED
#define expLogLeaveOpenGet_TCL_DECLARED
/* 112 */
TCL_EXTERN(int)		expLogLeaveOpenGet _ANSI_ARGS_((void));
#endif
#ifndef expLogAllSet_TCL_DECLARED
#define expLogAllSet_TCL_DECLARED
/* 113 */
TCL_EXTERN(void)	expLogAllSet _ANSI_ARGS_((int app));
#endif
#ifndef expLogAllGet_TCL_DECLARED
#define expLogAllGet_TCL_DECLARED
/* 114 */
TCL_EXTERN(int)		expLogAllGet _ANSI_ARGS_((void));
#endif
#ifndef expLogToStdoutSet_TCL_DECLARED
#define expLogToStdoutSet_TCL_DECLARED
/* 115 */
TCL_EXTERN(void)	expLogToStdoutSet _ANSI_ARGS_((int app));
#endif
#ifndef expLogToStdoutGet_TCL_DECLARED
#define expLogToStdoutGet_TCL_DECLARED
/* 116 */
TCL_EXTERN(int)		expLogToStdoutGet _ANSI_ARGS_((void));
#endif
#ifndef expLogDiagU_TCL_DECLARED
#define expLogDiagU_TCL_DECLARED
/* 117 */
TCL_EXTERN(void)	expLogDiagU _ANSI_ARGS_((CONST char * buf));
#endif
#ifndef expWriteBytesAndLogIfTtyU_TCL_DECLARED
#define expWriteBytesAndLogIfTtyU_TCL_DECLARED
/* 118 */
TCL_EXTERN(int)		expWriteBytesAndLogIfTtyU _ANSI_ARGS_((
				ExpState * esPtr, CONST char * buf, 
				int lenBytes));
#endif
#ifndef expLogUserGet_TCL_DECLARED
#define expLogUserGet_TCL_DECLARED
/* 119 */
TCL_EXTERN(int)		expLogUserGet _ANSI_ARGS_((void));
#endif
#ifndef expLogUserSet_TCL_DECLARED
#define expLogUserSet_TCL_DECLARED
/* 120 */
TCL_EXTERN(void)	expLogUserSet _ANSI_ARGS_((int logUser));
#endif
#ifndef expLogInteractionU_TCL_DECLARED
#define expLogInteractionU_TCL_DECLARED
/* 121 */
TCL_EXTERN(void)	expLogInteractionU _ANSI_ARGS_((ExpState * esPtr, 
				CONST char * buf));
#endif
/* Slot 122 is reserved */
/* Slot 123 is reserved */
/* Slot 124 is reserved */
#ifndef exp_get_next_event_TCL_DECLARED
#define exp_get_next_event_TCL_DECLARED
/* 125 */
TCL_EXTERN(int)		exp_get_next_event _ANSI_ARGS_((Tcl_Interp * interp, 
				ExpState ** esPtrs, int n, 
				ExpState ** esPtrOut, int timeout, int key));
#endif
#ifndef exp_get_next_event_info_TCL_DECLARED
#define exp_get_next_event_info_TCL_DECLARED
/* 126 */
TCL_EXTERN(int)		exp_get_next_event_info _ANSI_ARGS_((
				Tcl_Interp * interp, ExpState * esPtr));
#endif
#ifndef exp_dsleep_TCL_DECLARED
#define exp_dsleep_TCL_DECLARED
/* 127 */
TCL_EXTERN(int)		exp_dsleep _ANSI_ARGS_((Tcl_Interp * interp, 
				double sec));
#endif
#ifndef exp_init_event_TCL_DECLARED
#define exp_init_event_TCL_DECLARED
/* 128 */
TCL_EXTERN(void)	exp_init_event _ANSI_ARGS_((void));
#endif
/* Slot 129 is reserved */
#ifndef exp_event_disarm_bg_TCL_DECLARED
#define exp_event_disarm_bg_TCL_DECLARED
/* 130 */
TCL_EXTERN(void)	exp_event_disarm_bg _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef exp_event_disarm_fg_TCL_DECLARED
#define exp_event_disarm_fg_TCL_DECLARED
/* 131 */
TCL_EXTERN(void)	exp_event_disarm_fg _ANSI_ARGS_((ExpState * esPtr));
#endif
#ifndef exp_arm_background_channelhandler_TCL_DECLARED
#define exp_arm_background_channelhandler_TCL_DECLARED
/* 132 */
TCL_EXTERN(void)	exp_arm_background_channelhandler _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_disarm_background_channelhandler_TCL_DECLARED
#define exp_disarm_background_channelhandler_TCL_DECLARED
/* 133 */
TCL_EXTERN(void)	exp_disarm_background_channelhandler _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_disarm_background_channelhandler_force_TCL_DECLARED
#define exp_disarm_background_channelhandler_force_TCL_DECLARED
/* 134 */
TCL_EXTERN(void)	exp_disarm_background_channelhandler_force _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_unblock_background_channelhandler_TCL_DECLARED
#define exp_unblock_background_channelhandler_TCL_DECLARED
/* 135 */
TCL_EXTERN(void)	exp_unblock_background_channelhandler _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_block_background_channelhandler_TCL_DECLARED
#define exp_block_background_channelhandler_TCL_DECLARED
/* 136 */
TCL_EXTERN(void)	exp_block_background_channelhandler _ANSI_ARGS_((
				ExpState * esPtr));
#endif
#ifndef exp_background_channelhandler_TCL_DECLARED
#define exp_background_channelhandler_TCL_DECLARED
/* 137 */
TCL_EXTERN(void)	exp_background_channelhandler _ANSI_ARGS_((
				ClientData clientData, int mask));
#endif
/* Slot 138 is reserved */
/* Slot 139 is reserved */
#ifndef exp_tty_set_TCL_DECLARED
#define exp_tty_set_TCL_DECLARED
/* 140 */
TCL_EXTERN(void)	exp_tty_set _ANSI_ARGS_((Tcl_Interp * interp, 
				exp_tty * tty, int raw, int echo));
#endif
#ifndef exp_tty_cooked_echo_TCL_DECLARED
#define exp_tty_cooked_echo_TCL_DECLARED
/* 141 */
TCL_EXTERN(int)		exp_tty_cooked_echo _ANSI_ARGS_((Tcl_Interp * interp, 
				exp_tty * tty_old, int * was_raw, 
				int * was_echo));
#endif
/* Slot 142 is reserved */
/* Slot 143 is reserved */
/* Slot 144 is reserved */
#ifndef Exp_StringCaseMatch_TCL_DECLARED
#define Exp_StringCaseMatch_TCL_DECLARED
/* 145 */
TCL_EXTERN(int)		Exp_StringCaseMatch _ANSI_ARGS_((CONST char * string, 
				CONST char * pattern, int nocase, 
				int * offset));
#endif
/* Slot 146 is reserved */
/* Slot 147 is reserved */
/* Slot 148 is reserved */
/* Slot 149 is reserved */
/* Slot 150 is reserved */
#ifndef expDiagLogPtrSet_TCL_DECLARED
#define expDiagLogPtrSet_TCL_DECLARED
/* 151 */
TCL_EXTERN(void)	expDiagLogPtrSet _ANSI_ARGS_((expDiagLogProc * func));
#endif
#ifndef expDiagLogPtr_TCL_DECLARED
#define expDiagLogPtr_TCL_DECLARED
/* 152 */
TCL_EXTERN(void)	expDiagLogPtr _ANSI_ARGS_((CONST char * str));
#endif
#ifndef expDiagLogPtrX_TCL_DECLARED
#define expDiagLogPtrX_TCL_DECLARED
/* 153 */
TCL_EXTERN(void)	expDiagLogPtrX _ANSI_ARGS_((CONST char * fmt, 
				int num));
#endif
#ifndef expDiagLogPtrStr_TCL_DECLARED
#define expDiagLogPtrStr_TCL_DECLARED
/* 154 */
TCL_EXTERN(void)	expDiagLogPtrStr _ANSI_ARGS_((CONST char * fmt, 
				CONST char * str1));
#endif
#ifndef expDiagLogPtrStrStr_TCL_DECLARED
#define expDiagLogPtrStrStr_TCL_DECLARED
/* 155 */
TCL_EXTERN(void)	expDiagLogPtrStrStr _ANSI_ARGS_((CONST char * fmt, 
				CONST char * str1, CONST char * str2));
#endif
#ifndef expErrnoMsgSet_TCL_DECLARED
#define expErrnoMsgSet_TCL_DECLARED
/* 156 */
TCL_EXTERN(void)	expErrnoMsgSet _ANSI_ARGS_((
				expErrnoMsgProc * errMsgProc));
#endif
#ifndef expErrnoMsg_TCL_DECLARED
#define expErrnoMsg_TCL_DECLARED
/* 157 */
TCL_EXTERN(CONST char *) expErrnoMsg _ANSI_ARGS_((int posixErrCode));
#endif
/* Slot 158 is reserved */
/* Slot 159 is reserved */
#ifndef Exp_CreateExpChannel_TCL_DECLARED
#define Exp_CreateExpChannel_TCL_DECLARED
/* 160 */
TCL_EXTERN(Tcl_Channel)	 Exp_CreateExpChannel _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Channel chan, 
				int pid, Tcl_Pid tclPid, ExpState ** esOut));
#endif
#ifndef Exp_CreatePairChannel_TCL_DECLARED
#define Exp_CreatePairChannel_TCL_DECLARED
/* 161 */
TCL_EXTERN(Tcl_Channel)	 Exp_CreatePairChannel _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Channel chanIn, 
				Tcl_Channel chanOut, CONST char * chanName));
#endif

typedef struct ExpIntStubs {
    int magic;
    struct ExpIntStubHooks *hooks;

    void (*exp_parse_argv) _ANSI_ARGS_((Tcl_Interp * interp, int argc, CONST84 char * argv[])); /* 0 */
    int (*exp_interpreter) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * eofObj)); /* 1 */
    void *reserved2;
    int (*exp_interpret_cmdfilename) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * filename)); /* 3 */
    void (*exp_interpret_rcfiles) _ANSI_ARGS_((Tcl_Interp * interp, int my_rc, int sys_rc)); /* 4 */
    CONST char * (*exp_cook) _ANSI_ARGS_((CONST char * s, int * len)); /* 5 */
    void (*expCloseOnExec) _ANSI_ARGS_((int fd)); /* 6 */
    void (*exp_exit_handlers) _ANSI_ARGS_((ClientData clientData)); /* 7 */
    void (*exp_error) _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp)); /* 8 */
    void *reserved9;
    void *reserved10;
    void *reserved11;
    void *reserved12;
    void *reserved13;
    void *reserved14;
    void *reserved15;
    void *reserved16;
    void *reserved17;
    void *reserved18;
    void *reserved19;
    CONST char * (*exp_get_var) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * var)); /* 20 */
    int (*exp_one_arg_braced) _ANSI_ARGS_((Tcl_Obj * objPtr)); /* 21 */
    int (*exp_eval_with_one_arg) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, struct Tcl_Obj * CONST objv[])); /* 22 */
    void *reserved23;
    int (*exp_flageq_code) _ANSI_ARGS_((CONST char * flag, CONST char * string, int minlen)); /* 24 */
    void (*expAdjust) _ANSI_ARGS_((ExpState * esPtr)); /* 25 */
    void (*exp_buffer_shuffle) _ANSI_ARGS_((Tcl_Interp * interp, ExpState * esPtr, int save_flags, CONST char * array_name, CONST char * caller_name)); /* 26 */
    int (*exp_close) _ANSI_ARGS_((Tcl_Interp * interp, ExpState * esPtr)); /* 27 */
    void (*exp_close_all) _ANSI_ARGS_((Tcl_Interp * interp)); /* 28 */
    void *reserved29;
    void (*exp_trap_on) _ANSI_ARGS_((int master)); /* 30 */
    int (*exp_trap_off) _ANSI_ARGS_((CONST char * name)); /* 31 */
    void (*exp_strftime) _ANSI_ARGS_((CONST char * format, CONST struct tm * timeptr, Tcl_DString * dstring)); /* 32 */
    void (*exp_init_pty) _ANSI_ARGS_((Tcl_Interp * interp)); /* 33 */
    void (*exp_pty_exit) _ANSI_ARGS_((void)); /* 34 */
    void (*exp_init_tty) _ANSI_ARGS_((void)); /* 35 */
    void (*exp_init_stdio) _ANSI_ARGS_((void)); /* 36 */
    void (*exp_init_spawn_ids) _ANSI_ARGS_((Tcl_Interp * interp)); /* 37 */
    void (*exp_init_spawn_id_vars) _ANSI_ARGS_((Tcl_Interp * interp)); /* 38 */
    void (*exp_init_trap) _ANSI_ARGS_((void)); /* 39 */
    void *reserved40;
    void (*exp_init_unit_random) _ANSI_ARGS_((void)); /* 41 */
    void (*exp_init_sig) _ANSI_ARGS_((void)); /* 42 */
    void (*expChanInit) _ANSI_ARGS_((void)); /* 43 */
    int (*expChannelCountGet) _ANSI_ARGS_((void)); /* 44 */
    int (*exp_tcl2_returnvalue) _ANSI_ARGS_((int x)); /* 45 */
    int (*exp_2tcl_returnvalue) _ANSI_ARGS_((int x)); /* 46 */
    void (*exp_rearm_sigchld) _ANSI_ARGS_((Tcl_Interp * interp)); /* 47 */
    int (*exp_string_to_signal) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * s)); /* 48 */
    struct exp_i * (*exp_new_i_complex) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * arg, int duration, Tcl_VarTraceProc * updateproc)); /* 49 */
    struct exp_i * (*exp_new_i_simple) _ANSI_ARGS_((ExpState * esPtr, int duration)); /* 50 */
    struct exp_state_list * (*exp_new_state) _ANSI_ARGS_((ExpState * esPtr)); /* 51 */
    void (*exp_free_i) _ANSI_ARGS_((Tcl_Interp * interp, struct exp_i * i, Tcl_VarTraceProc * updateproc)); /* 52 */
    void (*exp_free_state) _ANSI_ARGS_((struct exp_state_list * fd_first)); /* 53 */
    void (*exp_free_state_single) _ANSI_ARGS_((struct exp_state_list * fd)); /* 54 */
    int (*exp_i_update) _ANSI_ARGS_((Tcl_Interp * interp, struct exp_i * i)); /* 55 */
    void (*exp_create_commands) _ANSI_ARGS_((Tcl_Interp * interp, struct exp_cmd_data * c)); /* 56 */
    void (*exp_init_main_cmds) _ANSI_ARGS_((Tcl_Interp * interp)); /* 57 */
    void (*exp_init_expect_cmds) _ANSI_ARGS_((Tcl_Interp * interp)); /* 58 */
    void (*exp_init_most_cmds) _ANSI_ARGS_((Tcl_Interp * interp)); /* 59 */
    void (*exp_init_trap_cmds) _ANSI_ARGS_((Tcl_Interp * interp)); /* 60 */
    void *reserved61;
    void (*exp_init_tty_cmds) _ANSI_ARGS_((Tcl_Interp * interp)); /* 62 */
    ExpState * (*expStateCheck) _ANSI_ARGS_((Tcl_Interp * interp, ExpState * esPtr, int open, int adjust, CONST char * msg)); /* 63 */
    ExpState * (*expStateCurrent) _ANSI_ARGS_((Tcl_Interp * interp, int opened, int adjust, int any)); /* 64 */
    ExpState * (*expStateFromChannelName) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * name, int opened, int adjust, int any, CONST char * msg)); /* 65 */
    void (*expStateFree) _ANSI_ARGS_((ExpState * esPtr)); /* 66 */
    void *reserved67;
    ExpState * (*expWaitOnAny) _ANSI_ARGS_((void)); /* 68 */
    ExpState * (*expWaitOnOne) _ANSI_ARGS_((void)); /* 69 */
    void (*expExpectVarsInit) _ANSI_ARGS_((void)); /* 70 */
    int (*expStateAnyIs) _ANSI_ARGS_((ExpState * esPtr)); /* 71 */
    int (*expDevttyIs) _ANSI_ARGS_((ExpState * esPtr)); /* 72 */
    int (*expStdinOutIs) _ANSI_ARGS_((ExpState * esPtr)); /* 73 */
    ExpState * (*expStdinoutGet) _ANSI_ARGS_((void)); /* 74 */
    ExpState * (*expDevttyGet) _ANSI_ARGS_((void)); /* 75 */
    int (*expSizeGet) _ANSI_ARGS_((ExpState * esPtr)); /* 76 */
    int (*expSizeZero) _ANSI_ARGS_((ExpState * esPtr)); /* 77 */
    void (*exp_ecmd_remove_state_direct_and_indirect) _ANSI_ARGS_((Tcl_Interp * interp, ExpState * esPtr)); /* 78 */
    void *reserved79;
    void *reserved80;
    void *reserved81;
    void *reserved82;
    void *reserved83;
    void *reserved84;
    void (*expErrorLog) _ANSI_ARGS_(TCL_VARARGS(CONST char *,arg1)); /* 85 */
    void (*expErrorLogU) _ANSI_ARGS_((CONST char * buf)); /* 86 */
    void (*expStdoutLog) _ANSI_ARGS_(TCL_VARARGS(int,arg1)); /* 87 */
    void (*expStdoutLogU) _ANSI_ARGS_((CONST char * buf, int force_stdout)); /* 88 */
    void (*expDiagInit) _ANSI_ARGS_((void)); /* 89 */
    int (*expDiagChannelOpen) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * filename)); /* 90 */
    Tcl_Channel (*expDiagChannelGet) _ANSI_ARGS_((void)); /* 91 */
    void (*expDiagChannelClose) _ANSI_ARGS_((Tcl_Interp * interp)); /* 92 */
    CONST char * (*expDiagFilename) _ANSI_ARGS_((void)); /* 93 */
    int (*expDiagToStderrGet) _ANSI_ARGS_((void)); /* 94 */
    void (*expDiagToStderrSet) _ANSI_ARGS_((int val)); /* 95 */
    void (*expDiagWriteBytes) _ANSI_ARGS_((CONST char * str, int len)); /* 96 */
    void (*expDiagWriteChars) _ANSI_ARGS_((CONST char * str, int len)); /* 97 */
    void (*expDiagWriteObj) _ANSI_ARGS_((Tcl_Obj * obj)); /* 98 */
    void (*expDiagLog) _ANSI_ARGS_(TCL_VARARGS(CONST char *,arg1)); /* 99 */
    void (*expDiagLogU) _ANSI_ARGS_((CONST char * str)); /* 100 */
    CONST char * (*expPrintify) _ANSI_ARGS_((CONST char * s)); /* 101 */
    CONST char * (*expPrintifyObj) _ANSI_ARGS_((Tcl_Obj * obj)); /* 102 */
    void (*expLogInit) _ANSI_ARGS_((void)); /* 103 */
    int (*expLogChannelOpen) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * filename, int append)); /* 104 */
    Tcl_Channel (*expLogChannelGet) _ANSI_ARGS_((void)); /* 105 */
    int (*expLogChannelSet) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * name)); /* 106 */
    void (*expLogChannelClose) _ANSI_ARGS_((Tcl_Interp * interp)); /* 107 */
    char * (*expLogFilenameGet) _ANSI_ARGS_((void)); /* 108 */
    void (*expLogAppendSet) _ANSI_ARGS_((int app)); /* 109 */
    int (*expLogAppendGet) _ANSI_ARGS_((void)); /* 110 */
    void (*expLogLeaveOpenSet) _ANSI_ARGS_((int app)); /* 111 */
    int (*expLogLeaveOpenGet) _ANSI_ARGS_((void)); /* 112 */
    void (*expLogAllSet) _ANSI_ARGS_((int app)); /* 113 */
    int (*expLogAllGet) _ANSI_ARGS_((void)); /* 114 */
    void (*expLogToStdoutSet) _ANSI_ARGS_((int app)); /* 115 */
    int (*expLogToStdoutGet) _ANSI_ARGS_((void)); /* 116 */
    void (*expLogDiagU) _ANSI_ARGS_((CONST char * buf)); /* 117 */
    int (*expWriteBytesAndLogIfTtyU) _ANSI_ARGS_((ExpState * esPtr, CONST char * buf, int lenBytes)); /* 118 */
    int (*expLogUserGet) _ANSI_ARGS_((void)); /* 119 */
    void (*expLogUserSet) _ANSI_ARGS_((int logUser)); /* 120 */
    void (*expLogInteractionU) _ANSI_ARGS_((ExpState * esPtr, CONST char * buf)); /* 121 */
    void *reserved122;
    void *reserved123;
    void *reserved124;
    int (*exp_get_next_event) _ANSI_ARGS_((Tcl_Interp * interp, ExpState ** esPtrs, int n, ExpState ** esPtrOut, int timeout, int key)); /* 125 */
    int (*exp_get_next_event_info) _ANSI_ARGS_((Tcl_Interp * interp, ExpState * esPtr)); /* 126 */
    int (*exp_dsleep) _ANSI_ARGS_((Tcl_Interp * interp, double sec)); /* 127 */
    void (*exp_init_event) _ANSI_ARGS_((void)); /* 128 */
    void *reserved129;
    void (*exp_event_disarm_bg) _ANSI_ARGS_((ExpState * esPtr)); /* 130 */
    void (*exp_event_disarm_fg) _ANSI_ARGS_((ExpState * esPtr)); /* 131 */
    void (*exp_arm_background_channelhandler) _ANSI_ARGS_((ExpState * esPtr)); /* 132 */
    void (*exp_disarm_background_channelhandler) _ANSI_ARGS_((ExpState * esPtr)); /* 133 */
    void (*exp_disarm_background_channelhandler_force) _ANSI_ARGS_((ExpState * esPtr)); /* 134 */
    void (*exp_unblock_background_channelhandler) _ANSI_ARGS_((ExpState * esPtr)); /* 135 */
    void (*exp_block_background_channelhandler) _ANSI_ARGS_((ExpState * esPtr)); /* 136 */
    void (*exp_background_channelhandler) _ANSI_ARGS_((ClientData clientData, int mask)); /* 137 */
    void *reserved138;
    void *reserved139;
    void (*exp_tty_set) _ANSI_ARGS_((Tcl_Interp * interp, exp_tty * tty, int raw, int echo)); /* 140 */
    int (*exp_tty_cooked_echo) _ANSI_ARGS_((Tcl_Interp * interp, exp_tty * tty_old, int * was_raw, int * was_echo)); /* 141 */
    void *reserved142;
    void *reserved143;
    void *reserved144;
    int (*exp_StringCaseMatch) _ANSI_ARGS_((CONST char * string, CONST char * pattern, int nocase, int * offset)); /* 145 */
    void *reserved146;
    void *reserved147;
    void *reserved148;
    void *reserved149;
    void *reserved150;
    void (*expDiagLogPtrSet) _ANSI_ARGS_((expDiagLogProc * func)); /* 151 */
    void (*expDiagLogPtr) _ANSI_ARGS_((CONST char * str)); /* 152 */
    void (*expDiagLogPtrX) _ANSI_ARGS_((CONST char * fmt, int num)); /* 153 */
    void (*expDiagLogPtrStr) _ANSI_ARGS_((CONST char * fmt, CONST char * str1)); /* 154 */
    void (*expDiagLogPtrStrStr) _ANSI_ARGS_((CONST char * fmt, CONST char * str1, CONST char * str2)); /* 155 */
    void (*expErrnoMsgSet) _ANSI_ARGS_((expErrnoMsgProc * errMsgProc)); /* 156 */
    CONST char * (*expErrnoMsg) _ANSI_ARGS_((int posixErrCode)); /* 157 */
    void *reserved158;
    void *reserved159;
    Tcl_Channel (*exp_CreateExpChannel) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan, int pid, Tcl_Pid tclPid, ExpState ** esOut)); /* 160 */
    Tcl_Channel (*exp_CreatePairChannel) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chanIn, Tcl_Channel chanOut, CONST char * chanName)); /* 161 */
} ExpIntStubs;
TCL_EXTERNC ExpIntStubs *expIntStubsPtr;

#if defined(USE_EXP_STUBS) && !defined(USE_EXP_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef exp_parse_argv
#define exp_parse_argv \
	(expIntStubsPtr->exp_parse_argv) /* 0 */
#endif
#ifndef exp_interpreter
#define exp_interpreter \
	(expIntStubsPtr->exp_interpreter) /* 1 */
#endif
/* Slot 2 is reserved */
#ifndef exp_interpret_cmdfilename
#define exp_interpret_cmdfilename \
	(expIntStubsPtr->exp_interpret_cmdfilename) /* 3 */
#endif
#ifndef exp_interpret_rcfiles
#define exp_interpret_rcfiles \
	(expIntStubsPtr->exp_interpret_rcfiles) /* 4 */
#endif
#ifndef exp_cook
#define exp_cook \
	(expIntStubsPtr->exp_cook) /* 5 */
#endif
#ifndef expCloseOnExec
#define expCloseOnExec \
	(expIntStubsPtr->expCloseOnExec) /* 6 */
#endif
#ifndef exp_exit_handlers
#define exp_exit_handlers \
	(expIntStubsPtr->exp_exit_handlers) /* 7 */
#endif
#ifndef exp_error
#define exp_error \
	(expIntStubsPtr->exp_error) /* 8 */
#endif
/* Slot 9 is reserved */
/* Slot 10 is reserved */
/* Slot 11 is reserved */
/* Slot 12 is reserved */
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
#ifndef exp_get_var
#define exp_get_var \
	(expIntStubsPtr->exp_get_var) /* 20 */
#endif
#ifndef exp_one_arg_braced
#define exp_one_arg_braced \
	(expIntStubsPtr->exp_one_arg_braced) /* 21 */
#endif
#ifndef exp_eval_with_one_arg
#define exp_eval_with_one_arg \
	(expIntStubsPtr->exp_eval_with_one_arg) /* 22 */
#endif
/* Slot 23 is reserved */
#ifndef exp_flageq_code
#define exp_flageq_code \
	(expIntStubsPtr->exp_flageq_code) /* 24 */
#endif
#ifndef expAdjust
#define expAdjust \
	(expIntStubsPtr->expAdjust) /* 25 */
#endif
#ifndef exp_buffer_shuffle
#define exp_buffer_shuffle \
	(expIntStubsPtr->exp_buffer_shuffle) /* 26 */
#endif
#ifndef exp_close
#define exp_close \
	(expIntStubsPtr->exp_close) /* 27 */
#endif
#ifndef exp_close_all
#define exp_close_all \
	(expIntStubsPtr->exp_close_all) /* 28 */
#endif
/* Slot 29 is reserved */
#ifndef exp_trap_on
#define exp_trap_on \
	(expIntStubsPtr->exp_trap_on) /* 30 */
#endif
#ifndef exp_trap_off
#define exp_trap_off \
	(expIntStubsPtr->exp_trap_off) /* 31 */
#endif
#ifndef exp_strftime
#define exp_strftime \
	(expIntStubsPtr->exp_strftime) /* 32 */
#endif
#ifndef exp_init_pty
#define exp_init_pty \
	(expIntStubsPtr->exp_init_pty) /* 33 */
#endif
#ifndef exp_pty_exit
#define exp_pty_exit \
	(expIntStubsPtr->exp_pty_exit) /* 34 */
#endif
#ifndef exp_init_tty
#define exp_init_tty \
	(expIntStubsPtr->exp_init_tty) /* 35 */
#endif
#ifndef exp_init_stdio
#define exp_init_stdio \
	(expIntStubsPtr->exp_init_stdio) /* 36 */
#endif
#ifndef exp_init_spawn_ids
#define exp_init_spawn_ids \
	(expIntStubsPtr->exp_init_spawn_ids) /* 37 */
#endif
#ifndef exp_init_spawn_id_vars
#define exp_init_spawn_id_vars \
	(expIntStubsPtr->exp_init_spawn_id_vars) /* 38 */
#endif
#ifndef exp_init_trap
#define exp_init_trap \
	(expIntStubsPtr->exp_init_trap) /* 39 */
#endif
/* Slot 40 is reserved */
#ifndef exp_init_unit_random
#define exp_init_unit_random \
	(expIntStubsPtr->exp_init_unit_random) /* 41 */
#endif
#ifndef exp_init_sig
#define exp_init_sig \
	(expIntStubsPtr->exp_init_sig) /* 42 */
#endif
#ifndef expChanInit
#define expChanInit \
	(expIntStubsPtr->expChanInit) /* 43 */
#endif
#ifndef expChannelCountGet
#define expChannelCountGet \
	(expIntStubsPtr->expChannelCountGet) /* 44 */
#endif
#ifndef exp_tcl2_returnvalue
#define exp_tcl2_returnvalue \
	(expIntStubsPtr->exp_tcl2_returnvalue) /* 45 */
#endif
#ifndef exp_2tcl_returnvalue
#define exp_2tcl_returnvalue \
	(expIntStubsPtr->exp_2tcl_returnvalue) /* 46 */
#endif
#ifndef exp_rearm_sigchld
#define exp_rearm_sigchld \
	(expIntStubsPtr->exp_rearm_sigchld) /* 47 */
#endif
#ifndef exp_string_to_signal
#define exp_string_to_signal \
	(expIntStubsPtr->exp_string_to_signal) /* 48 */
#endif
#ifndef exp_new_i_complex
#define exp_new_i_complex \
	(expIntStubsPtr->exp_new_i_complex) /* 49 */
#endif
#ifndef exp_new_i_simple
#define exp_new_i_simple \
	(expIntStubsPtr->exp_new_i_simple) /* 50 */
#endif
#ifndef exp_new_state
#define exp_new_state \
	(expIntStubsPtr->exp_new_state) /* 51 */
#endif
#ifndef exp_free_i
#define exp_free_i \
	(expIntStubsPtr->exp_free_i) /* 52 */
#endif
#ifndef exp_free_state
#define exp_free_state \
	(expIntStubsPtr->exp_free_state) /* 53 */
#endif
#ifndef exp_free_state_single
#define exp_free_state_single \
	(expIntStubsPtr->exp_free_state_single) /* 54 */
#endif
#ifndef exp_i_update
#define exp_i_update \
	(expIntStubsPtr->exp_i_update) /* 55 */
#endif
#ifndef exp_create_commands
#define exp_create_commands \
	(expIntStubsPtr->exp_create_commands) /* 56 */
#endif
#ifndef exp_init_main_cmds
#define exp_init_main_cmds \
	(expIntStubsPtr->exp_init_main_cmds) /* 57 */
#endif
#ifndef exp_init_expect_cmds
#define exp_init_expect_cmds \
	(expIntStubsPtr->exp_init_expect_cmds) /* 58 */
#endif
#ifndef exp_init_most_cmds
#define exp_init_most_cmds \
	(expIntStubsPtr->exp_init_most_cmds) /* 59 */
#endif
#ifndef exp_init_trap_cmds
#define exp_init_trap_cmds \
	(expIntStubsPtr->exp_init_trap_cmds) /* 60 */
#endif
/* Slot 61 is reserved */
#ifndef exp_init_tty_cmds
#define exp_init_tty_cmds \
	(expIntStubsPtr->exp_init_tty_cmds) /* 62 */
#endif
#ifndef expStateCheck
#define expStateCheck \
	(expIntStubsPtr->expStateCheck) /* 63 */
#endif
#ifndef expStateCurrent
#define expStateCurrent \
	(expIntStubsPtr->expStateCurrent) /* 64 */
#endif
#ifndef expStateFromChannelName
#define expStateFromChannelName \
	(expIntStubsPtr->expStateFromChannelName) /* 65 */
#endif
#ifndef expStateFree
#define expStateFree \
	(expIntStubsPtr->expStateFree) /* 66 */
#endif
/* Slot 67 is reserved */
#ifndef expWaitOnAny
#define expWaitOnAny \
	(expIntStubsPtr->expWaitOnAny) /* 68 */
#endif
#ifndef expWaitOnOne
#define expWaitOnOne \
	(expIntStubsPtr->expWaitOnOne) /* 69 */
#endif
#ifndef expExpectVarsInit
#define expExpectVarsInit \
	(expIntStubsPtr->expExpectVarsInit) /* 70 */
#endif
#ifndef expStateAnyIs
#define expStateAnyIs \
	(expIntStubsPtr->expStateAnyIs) /* 71 */
#endif
#ifndef expDevttyIs
#define expDevttyIs \
	(expIntStubsPtr->expDevttyIs) /* 72 */
#endif
#ifndef expStdinOutIs
#define expStdinOutIs \
	(expIntStubsPtr->expStdinOutIs) /* 73 */
#endif
#ifndef expStdinoutGet
#define expStdinoutGet \
	(expIntStubsPtr->expStdinoutGet) /* 74 */
#endif
#ifndef expDevttyGet
#define expDevttyGet \
	(expIntStubsPtr->expDevttyGet) /* 75 */
#endif
#ifndef expSizeGet
#define expSizeGet \
	(expIntStubsPtr->expSizeGet) /* 76 */
#endif
#ifndef expSizeZero
#define expSizeZero \
	(expIntStubsPtr->expSizeZero) /* 77 */
#endif
#ifndef exp_ecmd_remove_state_direct_and_indirect
#define exp_ecmd_remove_state_direct_and_indirect \
	(expIntStubsPtr->exp_ecmd_remove_state_direct_and_indirect) /* 78 */
#endif
/* Slot 79 is reserved */
/* Slot 80 is reserved */
/* Slot 81 is reserved */
/* Slot 82 is reserved */
/* Slot 83 is reserved */
/* Slot 84 is reserved */
#ifndef expErrorLog
#define expErrorLog \
	(expIntStubsPtr->expErrorLog) /* 85 */
#endif
#ifndef expErrorLogU
#define expErrorLogU \
	(expIntStubsPtr->expErrorLogU) /* 86 */
#endif
#ifndef expStdoutLog
#define expStdoutLog \
	(expIntStubsPtr->expStdoutLog) /* 87 */
#endif
#ifndef expStdoutLogU
#define expStdoutLogU \
	(expIntStubsPtr->expStdoutLogU) /* 88 */
#endif
#ifndef expDiagInit
#define expDiagInit \
	(expIntStubsPtr->expDiagInit) /* 89 */
#endif
#ifndef expDiagChannelOpen
#define expDiagChannelOpen \
	(expIntStubsPtr->expDiagChannelOpen) /* 90 */
#endif
#ifndef expDiagChannelGet
#define expDiagChannelGet \
	(expIntStubsPtr->expDiagChannelGet) /* 91 */
#endif
#ifndef expDiagChannelClose
#define expDiagChannelClose \
	(expIntStubsPtr->expDiagChannelClose) /* 92 */
#endif
#ifndef expDiagFilename
#define expDiagFilename \
	(expIntStubsPtr->expDiagFilename) /* 93 */
#endif
#ifndef expDiagToStderrGet
#define expDiagToStderrGet \
	(expIntStubsPtr->expDiagToStderrGet) /* 94 */
#endif
#ifndef expDiagToStderrSet
#define expDiagToStderrSet \
	(expIntStubsPtr->expDiagToStderrSet) /* 95 */
#endif
#ifndef expDiagWriteBytes
#define expDiagWriteBytes \
	(expIntStubsPtr->expDiagWriteBytes) /* 96 */
#endif
#ifndef expDiagWriteChars
#define expDiagWriteChars \
	(expIntStubsPtr->expDiagWriteChars) /* 97 */
#endif
#ifndef expDiagWriteObj
#define expDiagWriteObj \
	(expIntStubsPtr->expDiagWriteObj) /* 98 */
#endif
#ifndef expDiagLog
#define expDiagLog \
	(expIntStubsPtr->expDiagLog) /* 99 */
#endif
#ifndef expDiagLogU
#define expDiagLogU \
	(expIntStubsPtr->expDiagLogU) /* 100 */
#endif
#ifndef expPrintify
#define expPrintify \
	(expIntStubsPtr->expPrintify) /* 101 */
#endif
#ifndef expPrintifyObj
#define expPrintifyObj \
	(expIntStubsPtr->expPrintifyObj) /* 102 */
#endif
#ifndef expLogInit
#define expLogInit \
	(expIntStubsPtr->expLogInit) /* 103 */
#endif
#ifndef expLogChannelOpen
#define expLogChannelOpen \
	(expIntStubsPtr->expLogChannelOpen) /* 104 */
#endif
#ifndef expLogChannelGet
#define expLogChannelGet \
	(expIntStubsPtr->expLogChannelGet) /* 105 */
#endif
#ifndef expLogChannelSet
#define expLogChannelSet \
	(expIntStubsPtr->expLogChannelSet) /* 106 */
#endif
#ifndef expLogChannelClose
#define expLogChannelClose \
	(expIntStubsPtr->expLogChannelClose) /* 107 */
#endif
#ifndef expLogFilenameGet
#define expLogFilenameGet \
	(expIntStubsPtr->expLogFilenameGet) /* 108 */
#endif
#ifndef expLogAppendSet
#define expLogAppendSet \
	(expIntStubsPtr->expLogAppendSet) /* 109 */
#endif
#ifndef expLogAppendGet
#define expLogAppendGet \
	(expIntStubsPtr->expLogAppendGet) /* 110 */
#endif
#ifndef expLogLeaveOpenSet
#define expLogLeaveOpenSet \
	(expIntStubsPtr->expLogLeaveOpenSet) /* 111 */
#endif
#ifndef expLogLeaveOpenGet
#define expLogLeaveOpenGet \
	(expIntStubsPtr->expLogLeaveOpenGet) /* 112 */
#endif
#ifndef expLogAllSet
#define expLogAllSet \
	(expIntStubsPtr->expLogAllSet) /* 113 */
#endif
#ifndef expLogAllGet
#define expLogAllGet \
	(expIntStubsPtr->expLogAllGet) /* 114 */
#endif
#ifndef expLogToStdoutSet
#define expLogToStdoutSet \
	(expIntStubsPtr->expLogToStdoutSet) /* 115 */
#endif
#ifndef expLogToStdoutGet
#define expLogToStdoutGet \
	(expIntStubsPtr->expLogToStdoutGet) /* 116 */
#endif
#ifndef expLogDiagU
#define expLogDiagU \
	(expIntStubsPtr->expLogDiagU) /* 117 */
#endif
#ifndef expWriteBytesAndLogIfTtyU
#define expWriteBytesAndLogIfTtyU \
	(expIntStubsPtr->expWriteBytesAndLogIfTtyU) /* 118 */
#endif
#ifndef expLogUserGet
#define expLogUserGet \
	(expIntStubsPtr->expLogUserGet) /* 119 */
#endif
#ifndef expLogUserSet
#define expLogUserSet \
	(expIntStubsPtr->expLogUserSet) /* 120 */
#endif
#ifndef expLogInteractionU
#define expLogInteractionU \
	(expIntStubsPtr->expLogInteractionU) /* 121 */
#endif
/* Slot 122 is reserved */
/* Slot 123 is reserved */
/* Slot 124 is reserved */
#ifndef exp_get_next_event
#define exp_get_next_event \
	(expIntStubsPtr->exp_get_next_event) /* 125 */
#endif
#ifndef exp_get_next_event_info
#define exp_get_next_event_info \
	(expIntStubsPtr->exp_get_next_event_info) /* 126 */
#endif
#ifndef exp_dsleep
#define exp_dsleep \
	(expIntStubsPtr->exp_dsleep) /* 127 */
#endif
#ifndef exp_init_event
#define exp_init_event \
	(expIntStubsPtr->exp_init_event) /* 128 */
#endif
/* Slot 129 is reserved */
#ifndef exp_event_disarm_bg
#define exp_event_disarm_bg \
	(expIntStubsPtr->exp_event_disarm_bg) /* 130 */
#endif
#ifndef exp_event_disarm_fg
#define exp_event_disarm_fg \
	(expIntStubsPtr->exp_event_disarm_fg) /* 131 */
#endif
#ifndef exp_arm_background_channelhandler
#define exp_arm_background_channelhandler \
	(expIntStubsPtr->exp_arm_background_channelhandler) /* 132 */
#endif
#ifndef exp_disarm_background_channelhandler
#define exp_disarm_background_channelhandler \
	(expIntStubsPtr->exp_disarm_background_channelhandler) /* 133 */
#endif
#ifndef exp_disarm_background_channelhandler_force
#define exp_disarm_background_channelhandler_force \
	(expIntStubsPtr->exp_disarm_background_channelhandler_force) /* 134 */
#endif
#ifndef exp_unblock_background_channelhandler
#define exp_unblock_background_channelhandler \
	(expIntStubsPtr->exp_unblock_background_channelhandler) /* 135 */
#endif
#ifndef exp_block_background_channelhandler
#define exp_block_background_channelhandler \
	(expIntStubsPtr->exp_block_background_channelhandler) /* 136 */
#endif
#ifndef exp_background_channelhandler
#define exp_background_channelhandler \
	(expIntStubsPtr->exp_background_channelhandler) /* 137 */
#endif
/* Slot 138 is reserved */
/* Slot 139 is reserved */
#ifndef exp_tty_set
#define exp_tty_set \
	(expIntStubsPtr->exp_tty_set) /* 140 */
#endif
#ifndef exp_tty_cooked_echo
#define exp_tty_cooked_echo \
	(expIntStubsPtr->exp_tty_cooked_echo) /* 141 */
#endif
/* Slot 142 is reserved */
/* Slot 143 is reserved */
/* Slot 144 is reserved */
#ifndef Exp_StringCaseMatch
#define Exp_StringCaseMatch \
	(expIntStubsPtr->exp_StringCaseMatch) /* 145 */
#endif
/* Slot 146 is reserved */
/* Slot 147 is reserved */
/* Slot 148 is reserved */
/* Slot 149 is reserved */
/* Slot 150 is reserved */
#ifndef expDiagLogPtrSet
#define expDiagLogPtrSet \
	(expIntStubsPtr->expDiagLogPtrSet) /* 151 */
#endif
#ifndef expDiagLogPtr
#define expDiagLogPtr \
	(expIntStubsPtr->expDiagLogPtr) /* 152 */
#endif
#ifndef expDiagLogPtrX
#define expDiagLogPtrX \
	(expIntStubsPtr->expDiagLogPtrX) /* 153 */
#endif
#ifndef expDiagLogPtrStr
#define expDiagLogPtrStr \
	(expIntStubsPtr->expDiagLogPtrStr) /* 154 */
#endif
#ifndef expDiagLogPtrStrStr
#define expDiagLogPtrStrStr \
	(expIntStubsPtr->expDiagLogPtrStrStr) /* 155 */
#endif
#ifndef expErrnoMsgSet
#define expErrnoMsgSet \
	(expIntStubsPtr->expErrnoMsgSet) /* 156 */
#endif
#ifndef expErrnoMsg
#define expErrnoMsg \
	(expIntStubsPtr->expErrnoMsg) /* 157 */
#endif
/* Slot 158 is reserved */
/* Slot 159 is reserved */
#ifndef Exp_CreateExpChannel
#define Exp_CreateExpChannel \
	(expIntStubsPtr->exp_CreateExpChannel) /* 160 */
#endif
#ifndef Exp_CreatePairChannel
#define Exp_CreatePairChannel \
	(expIntStubsPtr->exp_CreatePairChannel) /* 161 */
#endif

#endif /* defined(USE_EXP_STUBS) && !defined(USE_EXP_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _EXPINTDECLS */
