unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,
  ListNav, ExtCtrls;

type

  TMyObject =  class(TObject)
      FInfo: string;
    public
      constructor Create(aNum: integer);
    property
      Info: string read FInfo write FInfo;
  End;

  TForm1 = class(TForm)
    Edit1: TEdit;
    ListNavigator1: TListNavigator;
    ListNavigator2: TListNavigator;
    ListNavigator3: TListNavigator;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure ListNavigator3Clicked(Sender: TObject;
      Button: TListNavigateBtn);
    procedure ListNavigator3Clicking(Sender: TObject;
      Button: TListNavigateBtn);
    procedure ListNavigator3CurrentChanged(Sender: TObject;
      Current: Integer);
  private
    { Private declarations }
  public
    List2: TList;
    List3: TList;
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  List2:= TList.Create;
  ListNavigator2.ListRef:= List2;
  List3:= TList.Create;
  ListNavigator3.ListRef:= List3;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  List2.Free;
  List3.Free;
end;

{ TMyObject }

constructor TMyObject.Create(aNum: integer);
begin
  FInfo:= IntToStr(aNum);
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  ListNavigator3.ObjectDataChanged;
end;

procedure TForm1.ListNavigator3Clicking(Sender: TObject;
  Button: TListNavigateBtn);
begin
  case Button of
      LNQB_ADD:
         Begin
           List3.Insert(ListNavigator3.Current + 1, TMYObject.Create(ListNavigator3.Current + 1));
         End;
      LNQB_Delete:
         Begin
           if MessageDlg('Are you sure to delete this item?',
               mtConfirmation, [mbYes, mbNo], 0) = mrNo then SysUtils.Abort;
         End;
   end; { case }
end;

procedure TForm1.ListNavigator3Clicked(Sender: TObject;
  Button: TListNavigateBtn);
begin
  case Button of
      LNQB_APPLY:
         TMyObject(List3.Items[ListNavigator3.Current]).Info:= Edit1.text;
   end;
end;

procedure TForm1.ListNavigator3CurrentChanged(Sender: TObject;
  Current: Integer);
begin
  if List3.Count > 0 then
  Begin
    Edit1.Enabled:= true;
    Edit1.text:= TMyObject(List3.Items[Current]).Info;
  End else
  Begin
    Edit1.Enabled:= false;;
    Edit1.text:= '';
  End;
end;

end.
