unit UplClassExt;
{$I '..\DSP.inc'}

interface
uses
  SysUtils,
  Windows,
  Messages,
  Classes,
  Controls,
  StdCtrls,
  ExtCtrls,
  Buttons,
  IniFiles,
{$IFDEF DSP_DATABASE}
  DB,
  DBTables,
{$ENDIF}
  UplClass,
  forms;

type

  TDSPCompilerEx = class;

  TUPLCheckBox = class(TCheckBox)
  private
    FDSPCompiler: TDSPCompilerEx;
  public
     procedure Click; override;
     property Compiler: TDSPCompilerEx  read FDSPCompiler write FDSPCompiler;
  end;

  TUPLEdit = class(TEdit)
  private
    FDSPCompiler: TDSPCompilerEx;
  public
     procedure Change; override;
     property Compiler: TDSPCompilerEx  read FDSPCompiler write FDSPCompiler;
  End;

  {************************************************************************}
  TDSPCompilerEx = class(TDSPCompilerBase)
   private
     // Supported declared as TCheckBox object, not a boolean type
     FSupported_CB: TUPLCheckBox;
     // available declared as TEdit object, not a string type
     FAvailable_Edit: TUPLEdit;
     FFindInDB_SB: TSpeedButton;
     FChanging : Boolean;
   public
     constructor Create(aCompilerName, aCompilerID: string); override;
     destructor Destroy; Override;
     function GetAvailable: String; override;
     procedure SetAvailable(const Value: String); override;
     function GetSupported: boolean; override;
     procedure SetSupported(const Value: boolean); override;
     function  Mark_Supported: string;
     function  Mark_Available(FileStatus: String): string;
     property  Supported_CB: TUPLCheckBox read FSupported_CB write FSupported_CB;
     property  FindInDB_SB: TSpeedButton read FFindInDB_SB write FFindInDB_SB;
     property  Available_Edit: TUPLEdit read FAvailable_Edit write FAvailable_Edit;
     property  Changing : Boolean read FChanging write FChanging;
   end;

  TDSPCompilerListEx = class(TDSPCompilerBaseList)
  public
     constructor Create; override;
     destructor Destroy; override;
     function  CreateCompiler( aCompilerName, aCompilerID: String): TDSPCompilerBase; override;
     function  GetBaseCompiler: string;
     function  GetBaseCompilerIdx: integer;
  End;

  TDSPAuthorEx = class(TDSPAuthor)
  public
    constructor Create; override;
    destructor Destroy; override;
  End;

  TDSPAuthorListEx = class(TDSPAuthorList)
  public
     constructor Create; override;
     destructor Destroy; override;
     function  CreateAuthor: TDSPAuthor; override;
  end;

  TDSPInfoClassEx = class(TDSPInfoClass)
   public
     Constructor Create; override;
     procedure   CreateAuthors; override;
     procedure   CreateCompilers; override;
     Destructor  Destroy; override;
     procedure   Reset;
   End;




implementation

uses
  UPL_Cons;



{*******************************************************************************}
{ TUPLSpeedButton }
procedure TUPLCheckBox.Click;
begin
  inherited Click;
  if not Assigned(Compiler) then raise Exception.Create('Compiler not Assigned!');
  if Compiler.Changing then Exit;
  Compiler.Changing := true;
  if Checked then
  Begin
    Compiler.Available_Edit.Visible:= false;
    Compiler.Available_Edit.Clear;
  End else
    Compiler.Available_Edit.Visible:= true;
  if Assigned(Compiler.FindInDB_SB) then
    Compiler.FindInDB_SB.Enabled:= not Checked;
  Compiler.Changing := false;
end;

{*******************************************************************************}
{ TUPLEdit }
procedure TUPLEdit.Change;
begin
  inherited Change;
  if not Assigned(Compiler) then raise Exception.Create('Compiler not Assigned!');
  if Compiler.Changing then Exit;
  Compiler.Changing := true;
  if Length(Text) > 0 then Compiler.Supported_CB.Enabled:= false
                      else Compiler.Supported_CB.Enabled:= true;
  Compiler.Changing := false;
end;





{*******************************************************************************}
{TDSPCompiler}

constructor TDSPCompilerEx.Create(aCompilerName, aCompilerID: string);
Begin
  Inherited Create(aCompilerName, aCompilerID);
  FSupported_CB := nil;
  FFindInDB_SB := nil;
  FAvailable_Edit := nil;
  FChanging := false;
End;

destructor TDSPCompilerEx.Destroy;
Begin
  FSupported_CB := nil;
  FFindInDB_SB := nil;
  FAvailable_Edit := nil;
  Inherited Destroy;
End;

function TDSPCompilerEx.GetAvailable: String;
begin
  result:= FAvailable_Edit.Text;
end;

function TDSPCompilerEx.GetSupported: boolean;
begin
  result:= FSupported_CB.Checked;
end;

procedure TDSPCompilerEx.SetAvailable(const Value: String);
begin
  FAvailable_Edit.Text:= Value;
end;

procedure TDSPCompilerEx.SetSupported(const Value: boolean);
begin
  FSupported_CB.Checked:= Value;
end;

function TDSPCompilerEx.Mark_Supported: string;
Begin
  if Supported then
    result:= '<IMG ALIGN=TOP SRC="gifs/' + CompilerID + '.gif">'
  else
    result:= '';
End;

function TDSPCompilerEx.Mark_Available(FileStatus: String): string;
var
  S: String;
Begin
  S:= '';
  if Available_edit.Visible and ( Length(Available_edit.Text) > 0 ) then
  Begin
    S:= S + '<A HREF="';
    if Pos(cUPL_URLIndicator, Available_Edit.Text) = 0 then
    Begin
    { Edit box doesn't contain complete URL  }
      S:= S + cUPL_SunSiteFTP;
      if Pos('/', Available_Edit.Text ) = 0 then
      Begin
        { we have only filename without directory, thus I assume the same file
          status as the current upload, if your file has other status than your
          current upload, you have to enter directory/filename in available EditBox }
        S:= S + CompilerID;
        S:= S + FileStatus + '/';
      End;
    End;
     S:= S + Available_Edit.Text;
     S:= S + '"><IMG ALIGN=TOP SRC="gifs/' + CompilerID + 'a.gif" BORDER=0></A>';
  End;
End;


function TDSPCompilerListEx.GetBaseCompiler: string;
var
  i: integer;
Begin
  result:= '';
  for i:= 0 to Items.Count - 1 do
  Begin
    if TDSPCompilerEx(Items[i]).Supported then
    Begin
      result:= TDSPCompilerEx(Items[i]).CompilerID;
      exit;
    End;
  End;
  raise Exception.Create('Unable to deduce base copiler');
End;

function TDSPCompilerListEx.GetBaseCompilerIdx: integer;
var
  i: integer;
Begin
  result:= -1;
  for i:= 0 to Items.Count - 1 do
  Begin
    if TDSPCompilerEx(Items[i]).Supported then
    Begin
      result:= i;
      exit;
    End;
  End;
  raise Exception.Create('Unable to deduce base copiler');
End;

{*******************************************************************************}
{ TDSPAuthorEx }
constructor TDSPAuthorEx.Create;
Begin
  inherited Create;
End;

destructor TDSPAuthorEx.Destroy;
Begin
  inherited Destroy;
End;

{*******************************************************************************}
{ TDSPAuthorListEx }
constructor TDSPAuthorListEx.Create;
Begin
  inherited Create;
End;

destructor TDSPAuthorListEx.Destroy;
Begin
  inherited Destroy;
End;

function TDSPAuthorListEx.CreateAuthor: TDSPAuthor;
begin
  //typecast to base object type
  result:= TDSPAuthor(TDSPAuthorEx.Create);
end;



{*******************************************************************************}
{ TDSPInfoClassEx }
constructor TDSPInfoClassEx.Create;
begin
  inherited Create;
end;

procedure  TDSPInfoClassEx.CreateAuthors;
Begin
  Authors:= TDSPAuthorListEx.Create;
End;

procedure  TDSPInfoClassEx.CreateCompilers;
Begin
  Compilers:= TDSPCompilerListEx.Create;
End;

destructor TDSPInfoClassEx.Destroy;
begin
  inherited Destroy;
end;

procedure TDSPInfoClassEx.Reset;
begin
  inherited Reset;
end;


{*******************************************************************************}
{ TDSPCompilerListEx }
constructor TDSPCompilerListEx.Create;
begin
  Inherited Create;
end;

function TDSPCompilerListEx.CreateCompiler(aCompilerName,
  aCompilerID: String): TDSPCompilerBase;
begin
  result:= TDSPCompilerEx.Create(aCompilerName, aCompilerID);
end;

destructor TDSPCompilerListEx.Destroy;
begin
  inherited Destroy;
end;

Begin
end.

