unit Upl_util;


interface
Uses WinProcs, WinTypes, SysUtils, Classes, inifiles,
  {$IFDEF WIN32}
    ShellAPI,
  {$ENDIF}
Dialogs;


function GetDirectory: String;
procedure DeleteFile(FName: string);
function StringsToString(S: TStrings): string;
procedure Execute_html_file(s: string);
procedure WriteToIniStringList(Ini: TIniFile; Cat: String; Lines: TStringList);
procedure ReadFromIniStringList(Ini: TIniFile; Cat: String; Lines: TStringList);
function  Get_URLFileNamePart(S: String): String;
function  StripSpaces(S: String): String;


implementation
uses upl_cons;


function GetDirectory: String;
var
  FN: array[0..255] of Char;
Begin
  GetModuleFileName(hInstance, @FN, SizeOf(FN));
  PChar(StrRScan(FN, '\')+ 1)^:=  chr(0);
  result:= StrPas(FN);
End;

procedure DeleteFile(FName: string);
var
  P: PChar;
  TOF: TOfStruct;
Begin
  GetMem(P, Length(FName) + 1);
  StrPCopy(P, FName);
  OpenFile(P, TOF, of_Delete);
  FreeMem(P, Length(FName) + 1);
End;

function StringsToString(S: TStrings): string;
var
  i: integer;
  NeedSpace: boolean;
Begin
  Result:= '';
  NeedSpace:= false;
  for i:= 0 to TStringList(S).Count - 1 do
  if Length(TStringList(S).Strings[i]) > 0 then
  Begin
    { add one space in place of CRLF if needed }
    if NeedSpace and ( TStringList(S).Strings[i][1] <> ' ' )
     then Result:= result + ' ' + TStringList(S).Strings[i]
     else Result:= result + TStringList(S).Strings[i];
    NeedSpace:= TStringList(S).Strings[i][Length(TStringList(S).Strings[i])] <> ' '
  End;
End;

procedure Execute_html_file(s: string);
{$IFNDEF WIN32}
var
   ini: TIniFile;
   browser: string;
{$ENDIF}
Begin
   {$IFDEF WIN32}
  ShellExecute(0, nil, PChar(S), nil, nil, sw_show);
   {$ELSE}
  ini:= TIniFile.Create('win.ini');
  try
    Browser:= Ini.ReadString('Extensions', 'HTM', '');
    if Length(Browser) = 0 then
      raise Exception.Create('HTM extension not defined');
    Delete(Browser, Pos(' ', Browser), Length(Browser) - Pos(' ', Browser) + 1);
    Browser:= Browser + ' ' + s + chr(0);
    WinExec(PChar(@Browser[1]), sw_Normal);
  finally
    Ini.Free;
  End;
   {$ENDIF}
End;


procedure WriteToIniStringList(Ini: TIniFile; Cat: String; Lines: TStringList);
var
  i: integer;
Begin
  Ini.WriteString(Cat, cUPL_count, IntToStr(Lines.Count));
  if Lines.Count > 0 then
  for i:= 0 to Lines.Count - 1 do
   Ini.WriteString(Cat, IntToStr(i+1), Lines[i]);
End;

procedure ReadFromIniStringList(Ini: TIniFile; Cat: String; Lines: TStringList);
var
  i, count: integer;
Begin
  count:= StrToInt(Ini.ReadString(Cat, cUPL_count, '0'));
  if Count > 0 then
  for i:= 1 to Count do
   Lines.Add(Ini.ReadString(Cat, IntToStr(i), ''));
End;

procedure DownloadFile(s: string);
{$IFNDEF WIN32}
var
   ini: TIniFile;
   browser: string;
{$ENDIF}
Begin
   {$IFDEF WIN32}
  ShellExecute(0, nil, PChar(S), nil, nil, sw_show);
   {$ELSE}
  ini:= TIniFile.Create('win.ini');
  try
    Browser:= Ini.ReadString('Extensions', 'HTM', '');
    if Length(Browser) = 0 then
      raise Exception.Create('HTM extension not defined');
    Delete(Browser, Pos(' ', Browser), Length(Browser) - Pos(' ', Browser) + 1);
    Browser:= Browser + ' ' + s + chr(0);
    WinExec(PChar(@Browser[1]), sw_Normal);
  finally
    Ini.Free;
  End;
   {$ENDIF}
End;

function Get_URLFileNamePart(S: String): String;
{  returns FileName part from file URL }
var
  i: integer;
Begin
  for i:= Length(S) downto 1 do
  Begin
    if S[i] = '/' then
    Begin
      result:= System.Copy(S, i + 1, Length(S) - i );
      exit;
    End;
  End;
  result:= S;
end;

function  StripSpaces(S: String): String;
var
  Sp2Pos: integer;
Begin
  If Length(S) = 0 then
  Begin
    Result:= '';
    Exit;
  End;
  Sp2Pos:= Pos('  ', S);
  while Sp2Pos > 0 do
  Begin
    Delete(S, Sp2Pos, 1);
    Sp2Pos:= Pos('  ', S);
  End;
  Result:= S;
End;


end.
