unit KA.Utilities.FloatTransparentPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Forms, Controls, ExtCtrls, Graphics, Dialogs, Types;

type
  TFloatTransparentPanel = class(TPanel)
  private
    { Private declarations }
    F_OnClose    : TNotifyEvent;
    F_Height     : Integer;
    F_Sizeable   : Boolean;
    F_CanRoll    : Boolean;
  protected
    { Protected declarations }
    procedure F_Set_Rolled(Value : Boolean);
    Procedure F_Set_Sizeable(Value:Boolean);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); Override;
    procedure WMCLOSEHandler(var Message: TMessage); message WM_CLOSE;
    procedure Loaded; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;override;
  published
    { Published declarations }
    property CanRoll  : Boolean      Read F_CanRoll   Write F_CanRoll;
    property Sizeable : Boolean      Read F_Sizeable  Write F_Set_Sizeable;
    property OnClose  : TNotifyEvent Read F_OnClose   Write F_OnClose;
  end;

procedure Register;

implementation
{$R 'KA.Utilities.FloatTransparentPanel.TFloatTransparentPanel.bmp'}

procedure Register;
begin
  RegisterComponents('KA', [TFloatTransparentPanel]);
end;

{ TFloatTransparentPanel }

constructor TFloatTransparentPanel.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle + [csAcceptsControls]-[csOpaque];
  F_OnClose    := Nil;
  Height       := Width;
  BorderStyle  := bsNone;
  BevelInner   := bvNone;
  BevelOuter   := bvLowered;
  F_Sizeable   := True;
  F_CanRoll    := True;
  F_Height     := Height;
  TabStop      := True;
end;

procedure TFloatTransparentPanel.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style   := Params.Style   Or WS_SYSMENU OR WS_SIZEBOX;
  Params.ExStyle := Params.ExStyle OR WS_EX_Transparent;
  Params.ExStyle := Params.ExStyle Or WS_EX_TOOLWINDOW;
end;


procedure TFloatTransparentPanel.Paint;
Const
  BoxW = 6;
  BoxH = 6;
Var
  X : Integer;
  Y : Integer;
  W : Integer;
  H : Integer;
begin
  Canvas.Brush.Style := bsClear;
  //Canvas.Brush.Color := clBlack;		
  Canvas.Pen.Color   := clBlack;
  //****************************************************************************
  X := BoxW Div 2;
  Y := BoxH Div 2;
  W := Width-BoxW DIV 2;
  H := Height-BoxH DIV 2;
  Canvas.Rectangle(Rect(X,Y,W,H)); 
  //****************************************************************************
  Canvas.Pen.Style   := psSolid;
  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := clBlack;
  //****************************************************************************
  X := (Width Div 2)-BoxW;
  Y := 0;
  W := X+BoxW;
  H := Y+BoxH;
  Canvas.Rectangle(Rect(X,Y,W,H));
  //****************************************************************************
  X := (Width Div 2)-BoxW;
  Y := (Height)-BoxH;
  W := X+BoxW;
  H := Y+BoxH;
  Canvas.Rectangle(Rect(X,Y,W,H));
  //****************************************************************************
  X := 0;
  Y := (Height DIV 2)-BoxH;
  W := X+BoxW;
  H := Y+BoxH;
  Canvas.Rectangle(Rect(X,Y,W,H));
  //****************************************************************************
  X := (Width)-BoxW;
  Y := (Height DIV 2)-BoxH;
  W := X+BoxW;
  H := Y+BoxH;
  Canvas.Rectangle(Rect(X,Y,W,H));
end;

procedure TFloatTransparentPanel.CreateWnd;
begin
  inherited;
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
end;

destructor TFloatTransparentPanel.Destroy;
begin

  inherited;
end;


Procedure TFloatTransparentPanel.F_Set_Sizeable(Value:Boolean);
Var
 Style : LongInt;
Begin
 if F_Sizeable = Value Then Exit;
 F_Sizeable := Value;
 Style := GetWindowLong(Handle,GWL_STYLE);
 if F_Sizeable Then
    Style := Style + WS_SIZEBOX
 Else
    Style := Style - WS_SIZEBOX;
 SetWindowLong(Handle,GWL_STYLE,Style);
End;

procedure TFloatTransparentPanel.F_Set_Rolled(Value: Boolean);
begin
 //*************************** READ ONLY
end;

procedure TFloatTransparentPanel.WMCLOSEHandler(var Message: TMessage);
begin
 if Assigned(F_OnClose) Then F_OnClose(Self);
end;

procedure TFloatTransparentPanel.Loaded;
begin
  inherited Loaded;
end;

procedure TFloatTransparentPanel.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X,Y);
  ReleaseCapture;
  Perform(WM_SysCommand,$F012,0);
end;
end.
