unit KA.Utilities.EventScrollBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms;

type
  TEventScrollBox = class(TScrollBox)
  private
    { Private declarations }
    F_OnScrollHorz : TNotifyEvent;
    F_OnScrollVert : TNotifyEvent;
    procedure WMHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure WMVScroll(var Message: TWMVScroll); message WM_VSCROLL;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    Property OnScrollHorz: TNotifyEvent Read F_OnScrollHorz Write F_OnScrollHorz;
    Property OnScrollVert: TNotifyEvent Read F_OnScrollVert Write F_OnScrollVert;
  end;

procedure Register;

implementation
{$R 'KA.Utilities.EventScrollBox.TEventScrollBox.bmp'}

procedure Register;
begin
  RegisterComponents('KA', [TEventScrollBox]);
end;

{ TEventScrollBox }

procedure TEventScrollBox.WMHScroll(var Message: TWMHScroll);
begin
  Inherited;
  if Assigned(F_OnScrollHorz) Then F_OnScrollHorz(Self);
end;

procedure TEventScrollBox.WMVScroll(var Message: TWMVScroll);
begin
  Inherited;
  if Assigned(F_OnScrollVert) Then F_OnScrollVert(Self);
end;

end.
