unit KA.Data.KaDao.KADaoReg;
interface
Uses
   Borland.Vcl.Classes,
   Borland.Vcl.Design.DesignIntf,
   Borland.Vcl.Design.DesignEditors;

{$R 'TKADaoDatabase.bmp'}
{$R 'TKADaoTable.bmp'}
{$R 'TKADAOEncrypter.bmp'}
{$R 'TKADaoConnectionCheck.bmp'}

Type
//******************************************************************************
//                           EDITOR DEFINITIONS - KADaoDatabase
//******************************************************************************
TDBDatabaseTypeEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Procedure SetValue(const Value: string); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TDBDatabaseNameEditor = class(TStringProperty)
    Public
      Procedure Edit;override;
      Procedure SetValue(const Value: string); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TDBSystemDatabaseNameEditor = class(TStringProperty)
    Public
      Procedure Edit;override;
      Procedure SetValue(const Value: string); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TDBEngineTypeEditor = class(TIntegerProperty)
    Public
     function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TDBDefaultCursorDriverTypeEditor = class(TIntegerProperty)
    Public
     function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;


TDBWorkspaceEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

//******************************************************************************
//                           EDITOR DEFINITIONS - KADaoTable
//******************************************************************************

TTableNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TIndexNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TTableTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TLockTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TSortByEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryDefParamsEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterFieldsEditor = class(TStringProperty)
    Public
     Procedure Edit;override;
     Function GetValue: string; override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TEncrypterEditor= class(TComponentProperty)
    Public
      procedure GetValues(Proc: TGetStrProc);override;
    End;
//******************************************************************************


procedure Register;

Implementation
Uses
     Borland.Vcl.SysUtils,
     Borland.Vcl.Forms,
     Borland.Vcl.Dialogs,
     Borland.Vcl.DB,
     Borland.Vcl.TypInfo,
     KA.Data.KaDao.DaoApi,
     KA.Data.KaDao.Database,
     KA.Data.KaDao.Table,
     KA.Data.KaDao.Encrypter,
     KA.Data.KaDao.SortByDialog,
     KA.Data.KaDao.MasterDetailFormUnit;

//******************************************************************************
//                           EDITOR CODE - KADaoDatabase
//******************************************************************************
//******************************************************** KADaoDatabase Editors
Procedure TDBDatabaseTypeEditor.GetValues( Proc: TGetStrProc);
Var
  DBase : TKADaoDatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoDatabase then
  Begin
    DBase := TKADaoDatabase(GetComponent(0));
    Try
      For X := 0 to DBase.FDBTypesList.Count-1 do Proc(DBase.FDBTypesList[X]);
    Finally
    End;
  End;
End;

Procedure TDBDatabaseTypeEditor.SetValue(const Value: string);
Begin
 if GetComponent(0) is TKADaoDatabase then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Function TDBDatabaseTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;


//************************************************************** Database Editor
Function TDBDatabaseNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TDBDatabaseNameEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoDatabase then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

procedure TDBDatabaseNameEditor.Edit;
var
   FileName : String;
   DBase    : TKADaoDatabase;
Begin
   DBase:=TKADaoDatabase(GetComponent(0));
   Filename := DBase.FChooseDatabase;
   if Filename <> '' then begin
      SetStrValue(Filename);
      Modified;
   end;
End;


//******************************************************* System Database Editor
Function TDBSystemDatabaseNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TDBSystemDatabaseNameEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoDatabase then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

procedure TDBSystemDatabaseNameEditor.Edit;
var
   DBase               : TKADaoDatabase;
   Filter              : String;
   DlgChooseDatabase   : TOpenDialog;
Begin
   DBase:=TKADaoDatabase(GetComponent(0));
   DlgChooseDatabase := TOpenDialog.Create(Nil);
   DlgChooseDatabase.FilterIndex:=1;
   DlgChooseDatabase.DefaultExt:='mdw';
   DlgChooseDatabase.InitialDir:= ExtractFilePath(DBase.SystemDatabase);
   DlgChooseDatabase.FileName  := ExtractFileName(DBase.SystemDatabase);
   if DlgChooseDatabase.FileName <> '' Then Filter := WideLowerCase(ExtractFileExt(DlgChooseDatabase.FileName));
   Borland.Delphi.System.Delete(Filter,1,1);
   DlgChooseDatabase.DefaultExt:= Filter;
   if WideLowerCase(ExtractFileExt(DlgChooseDatabase.FileName))='.mda' Then DlgChooseDatabase.FilterIndex:=1
   Else
     if WideLowerCase(ExtractFileExt(DlgChooseDatabase.FileName))='.mdw' Then DlgChooseDatabase.FilterIndex:=1
   Else
     if WideLowerCase(ExtractFileExt(DlgChooseDatabase.FileName))='.mdb' Then DlgChooseDatabase.FilterIndex:=2
   Else
     DlgChooseDatabase.FilterIndex:=3;
   Filter:='Microsoft Access security files (*.mda *.mdw)|*.mda;*.mdw';
   Filter:=Filter+'|Microsoft Access (*.mdb)|*.mdb';
   Filter:=Filter+'|All files (*.*)|*.*';
   DlgChooseDatabase.Title:='Choose System Database:';
   DlgChooseDatabase.Options:=[ofFileMustExist,ofPathMustExist,ofHideReadOnly];
   DlgChooseDatabase.Filter :=Filter;
   if DlgChooseDatabase.Execute then SetStrValue(DlgChooseDatabase.FileName);
   DlgChooseDatabase.Free;
   Modified;
End;


//*********************************************************** Engine Type Editor
Function TDBEngineTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TDBEngineTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoDatabase then
    Begin
      if TKADaoDatabase(GetComponent(0)).EngineType=KA.Data.KADao.DaoApi.dbUseODBC then
         Result:='dbUseODBC'
      Else
         Result:='dbUseJet';
    End;
End;

Procedure TDBEngineTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoDatabase then
     Begin
       Proc('dbUseODBC');
       Proc('dbUseJet');
     End;
End;


procedure TDBEngineTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoDatabase then
       Begin
       if Value='dbUseODBC' Then
          Dat:=KA.Data.KADao.DaoApi.dbUseODBC
       Else
          Dat:=KA.Data.KADao.DaoApi.dbUseJet;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;
//*************************************************** DefaultCursorDriver Editor
Function TDBDefaultCursorDriverTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TDBDefaultCursorDriverTypeEditor.GetValue: string;
Var
 DB : TKADaoDatabase;
Begin
 if GetComponent(0) is TKADaoDatabase then
    Begin
     DB := TKADaoDatabase(GetComponent(0));
     Result:='dbUseDefaultCursor';
     if DB.DefaultCursorDriver=KA.Data.KADao.DaoApi.dbUseDefaultCursor     then Result:='dbUseDefaultCursor'
     Else
     if DB.DefaultCursorDriver=KA.Data.KADao.DaoApi.dbUseODBCCursor        then Result:='dbUseODBCCursor'
     Else
     if DB.DefaultCursorDriver=KA.Data.KADao.DaoApi.dbUseServerCursor      then Result:='dbUseServerCursor'
     Else
     if DB.DefaultCursorDriver=KA.Data.KADao.DaoApi.dbUseClientBatchCursor then Result:='dbUseClientBatchCursor'
     Else
     if DB.DefaultCursorDriver=KA.Data.KADao.DaoApi.dbUseNoCursor          then Result:='dbUseNoCursor';
    End;
End;

Procedure TDBDefaultCursorDriverTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoDatabase then
     Begin
       Proc('dbUseDefaultCursor');
       Proc('dbUseODBCCursor');
       Proc('dbUseServerCursor');
       Proc('dbUseClientBatchCursor');
       Proc('dbUseNoCursor');
     End;
End;


procedure TDBDefaultCursorDriverTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoDatabase then
       Begin
       Dat:=KA.Data.KADao.DaoApi.dbUseDefaultCursor;
       if Value='dbUseDefaultCursor'     Then Dat:=KA.Data.KADao.DaoApi.dbUseDefaultCursor
       Else
       if Value='dbUseODBCCursor'        Then Dat:=KA.Data.KADao.DaoApi.dbUseODBCCursor
       Else
       if Value='dbUseServerCursor'      Then Dat:=KA.Data.KADao.DaoApi.dbUseServerCursor
       Else
       if Value='dbUseClientBatchCursor' Then Dat:=KA.Data.KADao.DaoApi.dbUseClientBatchCursor
       Else
       if Value='dbUseNoCursor'          Then Dat:=KA.Data.KADao.DaoApi.dbUseNoCursor;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;


//************************************************************* Workspase Editor
Procedure TDBWorkspaceEditor.GetValues( Proc: TGetStrProc);
Var
  DBase : TKADaoDatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoDatabase then
  Begin
    DBase := TKADaoDatabase(GetComponent(0));
    Try
      For X := 0 to DBase.CoreDBEngine.Workspaces.Count-1 do
          Begin
            if WideCompareText(DBase.CoreDBEngine.Workspaces.Item[TObject(X)].Name,'#Default Workspace#') <> 0 Then
               Proc(DBase.CoreDBEngine.Workspaces.Item[TObject(X)].Name);
          End;
    Finally
    End;
  End;
End;

Function TDBWorkspaceEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;


//******************************************************************************
//                           EDITOR CODE - KADaoTable
//******************************************************************************
//*********************************************************** KADaoTable Editors
//******************************************************************** TableName
Procedure TTableNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.Database) And (DTable.Database.Connected) Then
       Begin
        DBase:=DTable.Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.TableNames.Count-1 do Proc(DBase.TableNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TTableNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//******************************************************************** QueryName

Procedure TQueryNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase : TKADaodatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.Database) And (DTable.Database.Connected) Then
       Begin
        DBase:=DTable.Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.QueryDefNames.Count-1 do Proc(DBase.QueryDefNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TQueryNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//******************************************************************** IndexName
Procedure TIndexNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
  Count  : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.Database) And (DTable.Database.Connected)  Then
    if DTable.TableName <> '' Then
       Begin
        DBase:=DTable.Database;
        Try
          DBase.RefreshDefinitions;
          Count :=DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Count;
          For X := 0 to  Count-1 do
              Begin
                Proc(DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Item[TObject(X)].Name);
              End;
        Finally
        End;
       End;
  End;
End;


Function TIndexNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;

//******************************************************************************

Function TTableTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TTableTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).TableType=KA.Data.KADao.DaoApi.dbOpenTable       then Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).TableType=KA.Data.KADao.DaoApi.dbOpenDynaset     then Result:='DynasetTable';
      if TKADaoTable(GetComponent(0)).TableType=KA.Data.KADao.DaoApi.dbOpenDynamic     then Result:='DynamicTable';
      if TKADaoTable(GetComponent(0)).TableType=KA.Data.KADao.DaoApi.dbOpenSnapshot    then Result:='SnapshotTable';
      if TKADaoTable(GetComponent(0)).TableType=KA.Data.KADao.DaoApi.dbOpenForwardOnly then Result:='ForwardOnlyTable';
    End;
End;

Procedure TTableTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('StandardTable');
       Proc('DynasetTable');
       Proc('DynamicTable');
       Proc('SnapshotTable');
       Proc('ForwardOnlyTable');
     End;
End;


Procedure TTableTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=KA.Data.KADao.DaoApi.dbOpenTable;
       if Value='StandardTable'    Then Dat:=KA.Data.KADao.DaoApi.dbOpenTable;
       if Value='DynasetTable'     Then Dat:=KA.Data.KADao.DaoApi.dbOpenDynaset;
       if Value='DynamicTable'     Then Dat:=KA.Data.KADao.DaoApi.dbOpenDynamic;
       if Value='SnapshotTable'    Then Dat:=KA.Data.KADao.DaoApi.dbOpenSnapshot;
       if Value='ForwardOnlyTable' Then Dat:=KA.Data.KADao.DaoApi.dbOpenForwardOnly;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;

//******************************************************************************

Function TLockTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TLockTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).LockType=KA.Data.KADao.DAOApi.dbPessimistic       then Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).LockType=KA.Data.KADao.DAOApi.dbOptimistic        then Result:='dbOptimistic';
      if TKADaoTable(GetComponent(0)).LockType=KA.Data.KADao.DAOApi.dbOptimisticValue   then Result:='dbOptimisticValue';
      if TKADaoTable(GetComponent(0)).LockType=KA.Data.KADao.DAOApi.dbReadOnly          then Result:='dbReadOnly';
      if TKADaoTable(GetComponent(0)).LockType=KA.Data.KADao.DAOApi.dbOptimisticBatch   then Result:='dbOptimisticBatch';
    End;
End;

Procedure TLockTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('dbPessimistic');
       Proc('dbOptimistic');
       Proc('dbOptimisticValue');
       Proc('dbReadOnly');
       Proc('dbOptimisticBatch');
     End;
End;


Procedure TLockTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=KA.Data.KADao.DAOApi.dbPessimistic;
       if Value='dbPessimistic'     Then Dat:=KA.Data.KADao.DAOApi.dbPessimistic;
       if Value='dbOptimistic'      Then Dat:=KA.Data.KADao.DAOApi.dbOptimistic;
       if Value='dbOptimisticValue' Then Dat:=KA.Data.KADao.DAOApi.dbOptimisticValue;
       if Value='dbReadOnly'        Then Dat:=KA.Data.KADao.DAOApi.dbReadOnly;
       if Value='dbOptimisticBatch' Then Dat:=KA.Data.KADao.DAOApi.dbOptimisticBatch;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;


Function TSortByEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TSortByEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TSortByEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TSortByEditor.Edit;
Var
 DT:TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.Database) Then Exit;
    if NOT (DT.Database.Connected) Then Exit;
    if (DT.Active=False) And (Not (csLoading in DT.ComponentState)) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.SortedBy.Clear;
           DatabaseError(E2051);
           Exit;
         End;
       End;
    Application.CreateForm(TSortByDialog,SortDialog);
    if SortDialog.Execute(DT.SortFieldNames,DT.SortedBy,DT.UseBrackets) Then
       Begin
         DT.Sort;
         Modified;
       End;
    SortDialog.Free;
  End;
End;

Function TQueryDefParamsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TQueryDefParamsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TQueryDefParamsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TQueryDefParamsEditor.Edit;
Var
 DT      : TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if DT.PromptQueryDefParameters Then Modified;
  End;
End;


//******************************************************************************
Function TMasterFieldsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TMasterFieldsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TMasterFieldsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TMasterFieldsEditor.Edit;
Var
 MT,DT        : TKADaoTable;
 MF,DF,TF     : TStrings;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.Database) Then Exit;
    If Not (DT.Database.Connected) Then Exit;
    if Not Assigned(DT.MasterSource) Then
       Begin
        DT.FMaster.Clear;
        DT.FDetail.Clear;
        DT.MasterFields.Clear;
        DatabaseError(E2052);
        Exit;
       End;
    if NOT (DT.MasterSource.DataSet is TKADaoTable) Then
       Begin
        DT.FMaster.Clear;
        DT.FDetail.Clear;
        DT.MasterFields.Clear;
        DatabaseError(E2053);
        Exit;
       End;
    MT:=DT.MasterSource.DataSet As TKADaoTable;
    if (DT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.FMaster.Clear;
           DT.FDetail.Clear;
           DT.MasterFields.Clear;
           DatabaseError(E2054);
           Exit;
         End;
       End;
    if (MT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           MT.Active:=True;
           MT.Active:=False;
         Except
           DT.FMaster.Clear;
           DT.FDetail.Clear;
           DT.MasterFields.Clear;
           DatabaseError(E2055);
           Exit;
         End;
       End;
    MF     := TStringList.Create;
    DF     := TStringList.Create;
    TF     := TStringList.Create;
    MF.Assign(MT.FMDFieldNames);
    DF.Assign(DT.FMDFieldNames);
    TF.Assign(DT.MasterFields);
    Application.CreateForm(TMasterDetailForm,MasterDetailForm);
    if MasterDetailForm.Execute(DF,MF,TF) Then;
    MasterDetailForm.Free;
    DT.MasterFields:=TF;
    MF.Free;
    DF.Free;
    TF.Free;
    Modified;
  End;
End;

procedure TEncrypterEditor.GetValues(Proc: TGetStrProc);
Begin
 Designer.GetComponentNames(GetTypeData(TKADaoEncrypter.ClassInfo), Proc);
End;



//******************************************************************************
procedure Register;
begin
 RegisterPropertyEditor(TypeInfo(String),TKADaoDatabase,'DatabaseType',TDBDatabaseTypeEditor);
 RegisterPropertyEditor(TypeInfo(String),TKADaoDatabase,'Database',TDBDatabaseNameEditor);
 RegisterPropertyEditor(TypeInfo(String),TKADaoDatabase,'SystemDatabase',TDBSystemDatabaseNameEditor);
 RegisterPropertyEditor(TypeInfo(Integer),TKADaoDatabase, 'EngineType', TDBEngineTypeEditor);
 RegisterPropertyEditor(TypeInfo(Integer),TKADaoDatabase, 'DefaultCursorDriver', TDBDefaultCursorDriverTypeEditor);
 RegisterPropertyEditor(TypeInfo(String),TKADaoDatabase, 'Workspace', TDBWorkspaceEditor);
 //***************** KAAdoTable
 RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'TableName',TTableNameEditor);
 RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'QueryDefName',TQueryNameEditor);
 RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'IndexName',TIndexNameEditor);
 RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'TableType',TTableTypeEditor);
 RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'LockType',TLockTypeEditor);
 RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'SortedBy',TSortByEditor);
 RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'QueryDefParameters',TQueryDefParamsEditor);
 RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'MasterFields',TMasterFieldsEditor);
 RegisterPropertyEditor(TypeInfo(TComponent),TKADaoTable,'Encrypter',TEncrypterEditor);
end;

end.
